/*
 * Decompiled with CFR 0.152.
 */
package vlc.net.protocol.http;

import HTTPClient.HTTPConnection;
import HTTPClient.HTTPResponse;
import HTTPClient.ModuleException;
import HTTPClient.ParseException;
import HTTPClient.ProtocolNotSuppException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.zip.GZIPInputStream;
import org.ietf.uri.HttpResourceConnection;
import org.ietf.uri.URI;
import org.ietf.uri.URL;

public class HttpConnection
extends HttpResourceConnection {
    private static final String HEADER_0_KEY = "header_0";
    private static final String REDIRECT_MODULE = "HTTPClient.RedirectionModule";
    private static final String COOKIE_MODULE = "HTTPClient.CookieModule";
    private static final int DEFAULT_OUTPUT_SIZE = 1024;
    private static HashMap connections = new HashMap();
    private static Class redir_module_class;
    private static Class cookie_module_class;
    private HTTPConnection current_connection;
    private String resource;
    private HTTPResponse response;
    private ByteArrayOutputStream output_stream;
    private ArrayList header_keys = null;
    private HashMap header_map = null;

    public HttpConnection(String string, int n, String string2) throws MalformedURLException {
        super((URI)new URL("http", string, n, string2));
        this.resource = string2;
        String string3 = string + ':' + n;
        this.current_connection = (HTTPConnection)connections.get(string3);
        if (this.current_connection == null) {
            try {
                this.current_connection = new HTTPConnection("http", string, n);
                connections.put(string3, this.current_connection);
            }
            catch (ProtocolNotSuppException protocolNotSuppException) {
                throw new MalformedURLException(protocolNotSuppException.toString());
            }
        }
    }

    public void disconnect() {
        this.current_connection.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void connect() throws IOException {
        if (this.connected) {
            return;
        }
        Object object = this.current_connection;
        synchronized (object) {
            if (followRedirects) {
                this.current_connection.addModule(redir_module_class, -1);
            } else {
                this.current_connection.removeModule(redir_module_class);
            }
            try {
                if ("GET".equals(this.method)) {
                    this.response = this.current_connection.Get(this.resource);
                } else if ("POST".equals(this.method)) {
                    this.output_stream.flush();
                    byte[] byArray = this.output_stream.toByteArray();
                    this.response = this.current_connection.Post(this.resource, byArray);
                } else if ("HEAD".equals(this.method)) {
                    this.response = this.current_connection.Head(this.resource);
                } else if ("OPTIONS".equals(this.method)) {
                    this.response = this.current_connection.Options(this.resource);
                } else if ("PUT".equals(this.method)) {
                    this.output_stream.flush();
                    byte[] byArray = this.output_stream.toByteArray();
                    this.response = this.current_connection.Put(this.resource, byArray);
                } else if ("DELETE".equals(this.method)) {
                    this.response = this.current_connection.Delete(this.resource);
                } else if ("TRACE".equals(this.method)) {
                    this.response = this.current_connection.Trace(this.resource);
                }
            }
            catch (ModuleException moduleException) {
                throw new IOException(moduleException.toString());
            }
        }
        object = new StringBuffer("Connected to ");
        ((StringBuffer)object).append(((URL)this.uri).getHost());
        ((StringBuffer)object).append(':');
        ((StringBuffer)object).append(((URL)this.uri).getPort());
        this.notifyConnectionEstablished(((StringBuffer)object).toString());
        this.connected = true;
    }

    public int getResponseCode() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        int n = -1;
        try {
            n = this.response.getStatusCode();
        }
        catch (ModuleException moduleException) {
            throw new IOException(moduleException.toString());
        }
        return n;
    }

    public String getResponseMessage() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        String string = "Invalid HTTP response";
        try {
            string = this.response.getReasonLine();
        }
        catch (ModuleException moduleException) {
            throw new IOException(moduleException.toString());
        }
        return string;
    }

    public String getHeaderField(String string) {
        String string2 = null;
        try {
            if (!this.connected) {
                this.connect();
            }
            if (this.header_keys == null) {
                this.parseHeaders();
            }
            string2 = (String)this.header_map.get(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    public String getHeaderFieldKey(int n) {
        String string = null;
        if (this.header_keys == null) {
            this.parseHeaders();
        }
        if (n > 0 && n < this.header_keys.size()) {
            string = (String)this.header_keys.get(n);
        }
        return string;
    }

    public String getHeaderField(int n) {
        if (this.header_keys == null) {
            this.parseHeaders();
        }
        String string = null;
        if (n >= 0 && n < this.header_keys.size()) {
            Object e = this.header_keys.get(n);
            string = (String)this.header_map.get(e);
        }
        return string;
    }

    private void parseHeaders() {
        this.header_map = new HashMap();
        this.header_keys = new ArrayList();
        try {
            if (!this.connected) {
                this.connect();
            }
            this.header_keys.add(HEADER_0_KEY);
            StringBuffer stringBuffer = new StringBuffer(this.response.getVersion());
            stringBuffer.append(' ');
            stringBuffer.append(this.response.getStatusCode());
            stringBuffer.append(' ');
            stringBuffer.append(this.response.getReasonLine());
            this.header_map.put(HEADER_0_KEY, stringBuffer.toString());
            Enumeration enumeration = this.response.listHeaders();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this.header_keys.add(string);
                this.header_map.put(string, this.response.getHeader(string));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public InputStream getInputStream() throws IOException {
        int n;
        if (!this.connected) {
            this.connect();
        }
        if ((n = this.getResponseCode()) != 200) {
            throw new IOException("File not found. " + this.uri + "\n" + "Response code: " + n);
        }
        InputStream inputStream = null;
        try {
            inputStream = this.response.getInputStream();
            String string = this.getContentEncoding();
            if (string != null && string.equals("x-gzip")) {
                inputStream = new GZIPInputStream(inputStream);
            }
        }
        catch (ModuleException moduleException) {
            throw new IOException(moduleException.toString());
        }
        return inputStream;
    }

    public InputStream getErrorStream() {
        InputStream inputStream = null;
        try {
            if (this.connected && this.response.getStatusCode() >= 300 && this.getContentLength() > 0) {
                inputStream = this.response.getInputStream();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return inputStream;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.connected) {
            throw new IOException("The stream is currently open");
        }
        if (this.output_stream != null) {
            this.output_stream = new ByteArrayOutputStream(1024);
        }
        return this.output_stream;
    }

    public URI getURI() {
        URI uRI = null;
        if (this.connected) {
            try {
                java.net.URL uRL = this.response.getEffectiveURI().toURL();
                if (uRL != null) {
                    uRI = new URL(uRL);
                }
            }
            catch (Exception exception) {}
        } else {
            uRI = super.getURI();
        }
        return uRI;
    }

    public boolean usingProxy() {
        return this.current_connection.getProxyHost() != null;
    }

    static {
        try {
            redir_module_class = Class.forName(REDIRECT_MODULE);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            cookie_module_class = Class.forName(COOKIE_MODULE);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        ListIterator listIterator = nonProxiedHosts.listIterator();
        while (listIterator.hasNext()) {
            try {
                HTTPConnection.dontProxyFor((String)((String)listIterator.next()));
            }
            catch (ParseException parseException) {}
        }
        HTTPConnection.setProxyServer((String)proxyHost, (int)proxyPort);
    }
}

