/*
 * Decompiled with CFR 0.152.
 */
package vlc.net.protocol.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLDecoder;
import org.ietf.uri.ResourceConnection;
import org.ietf.uri.URI;
import org.ietf.uri.URIUtils;
import org.ietf.uri.URL;

public class FileResourceConnection
extends ResourceConnection {
    private File target_file;
    private InputStream input_stream;
    private FileOutputStream output_stream;
    private String content_type;
    protected String path;
    protected String query;
    protected String reference;

    protected FileResourceConnection(String string) throws MalformedURLException {
        super((URI)new URL("file://" + string));
        boolean bl;
        try {
            String[] stringArray = URIUtils.stripFile((String)URLDecoder.decode(string, "UTF-8"));
            this.path = stringArray[0];
            this.query = stringArray[1];
            this.reference = stringArray[2];
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new MalformedURLException("Invalid Encoding. Not UTF-8");
        }
        boolean bl2 = bl = System.getProperty("os.name").startsWith("Win") && System.getProperty("os.arch").equals("x86");
        if (bl) {
            this.path = this.path.replace('|', ':');
            if (this.path.charAt(0) == '/') {
                this.path = this.path.substring(1);
            }
        }
        this.target_file = new File(this.path);
    }

    public InputStream getInputStream() throws IOException {
        if (this.input_stream == null) {
            this.input_stream = new FileInputStream(this.target_file);
        }
        return this.input_stream;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.output_stream == null) {
            this.output_stream = new FileOutputStream(this.target_file);
        }
        return this.output_stream;
    }

    public String getContentType() {
        if (this.content_type == null) {
            this.content_type = FileResourceConnection.findContentType((String)this.target_file.getName());
        }
        return this.content_type;
    }

    public void connect() throws IOException {
        if (!this.target_file.exists()) {
            throw new FileNotFoundException("The file " + this.path + " does not exist");
        }
        this.notifyConnectionEstablished("File '" + this.path + "' ready");
    }

    public int getContentLength() {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {
            return -1;
        }
        return (int)this.target_file.length();
    }

    public long getLastModified() {
        return this.target_file.lastModified();
    }
}

