/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.ecmascript.x3d;

import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.Scriptable;
import org.web3d.util.HashSet;
import org.web3d.vrml.lang.BasicScene;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLExternProtoDeclare;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.scripting.ecmascript.builtin.AbstractScriptableObject;
import org.web3d.vrml.scripting.ecmascript.builtin.FieldDefinitionArray;
import org.web3d.vrml.scripting.ecmascript.builtin.MFString;
import org.web3d.vrml.scripting.ecmascript.builtin.SFNode;
import org.web3d.vrml.scripting.ecmascript.builtin.X3DFieldDefinition;
import org.web3d.vrml.scripting.ecmascript.x3d.X3DConstants;

public class ExternProtoDeclaration
extends AbstractScriptableObject {
    private static HashSet propertyNames = new HashSet();
    private static HashSet functionNames;
    private HashMap functionObjects;
    private final String name;
    private final MFString urls;
    private final FieldDefinitionArray fields;
    private VRMLExternProtoDeclare protoDecl;
    private BasicScene realScene;

    public ExternProtoDeclaration(VRMLExternProtoDeclare vRMLExternProtoDeclare, BasicScene basicScene) {
        super("ExternProtoDeclaration");
        this.protoDecl = vRMLExternProtoDeclare;
        this.realScene = basicScene;
        this.name = vRMLExternProtoDeclare.getVRMLNodeName();
        this.urls = new MFString(vRMLExternProtoDeclare.getUrl());
        this.urls.setReadOnly();
        List list = vRMLExternProtoDeclare.getAllFields();
        Iterator iterator = list.iterator();
        int n = 0;
        X3DFieldDefinition[] x3DFieldDefinitionArray = new X3DFieldDefinition[list.size()];
        while (iterator.hasNext()) {
            VRMLFieldDeclaration vRMLFieldDeclaration = (VRMLFieldDeclaration)iterator.next();
            x3DFieldDefinitionArray[n] = new X3DFieldDefinition(vRMLFieldDeclaration.getName(), vRMLFieldDeclaration.getAccessType(), vRMLFieldDeclaration.getFieldType());
            ++n;
        }
        this.fields = new FieldDefinitionArray(x3DFieldDefinitionArray);
        this.functionObjects = new HashMap();
    }

    public boolean has(String string, Scriptable scriptable) {
        return propertyNames.contains(string) || functionNames.contains(string);
    }

    public Object get(String string, Scriptable scriptable) {
        Object object = NOT_FOUND;
        if (propertyNames.contains(string)) {
            char c = string.charAt(0);
            block0 : switch (c) {
                case 'n': {
                    object = string;
                    break;
                }
                case 'f': {
                    object = this.fields;
                    break;
                }
                case 'i': {
                    object = Boolean.TRUE;
                    break;
                }
                case 'l': {
                    X3DConstants x3DConstants = new X3DConstants();
                    switch (this.protoDecl.getLoadState()) {
                        case 1: {
                            object = x3DConstants.get("NOT_STARTED_STATE", (Scriptable)this);
                            break block0;
                        }
                        case 2: {
                            object = x3DConstants.get("IN_PROGRESS_STATE", (Scriptable)this);
                            break block0;
                        }
                        case 4: {
                            object = x3DConstants.get("FAILED_STATE", (Scriptable)this);
                            break block0;
                        }
                        case 3: {
                            object = x3DConstants.get("COMPLETE_STATE", (Scriptable)this);
                        }
                    }
                }
            }
        } else if (functionNames.contains(string)) {
            object = this.locateFunction(string);
        }
        return object;
    }

    public void put(String string, Scriptable scriptable, Object object) {
        if (object instanceof Function) {
            this.functionObjects.put(string, object);
        }
    }

    public SFNode jsFunction_newInstance() {
        if (this.protoDecl == null) {
            return null;
        }
        VRMLNodeType vRMLNodeType = (VRMLNodeType)this.protoDecl.createNewInstance(this.realScene.getRootNode(), false);
        SFNode sFNode = new SFNode(vRMLNodeType);
        sFNode.setParentScope(this);
        return sFNode;
    }

    public void jsFunction_loadNow() {
        System.out.println("ExternProtoDeclaration.loadNow() not implemented yet");
    }

    private FunctionObject locateFunction(String string) {
        String string2 = "jsFunction_" + string;
        Method[] methodArray = FunctionObject.findMethods(this.getClass(), (String)string2);
        FunctionObject functionObject = new FunctionObject(string, (Member)methodArray[0], (Scriptable)this);
        this.functionObjects.put(string, functionObject);
        return functionObject;
    }

    static {
        propertyNames.add("name");
        propertyNames.add("fields");
        propertyNames.add("isExternProto");
        propertyNames.add("urls");
        propertyNames.add("loadState");
        functionNames = new HashSet();
        functionNames.add("newInstance");
        functionNames.add("loadNow");
    }
}

