/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.ecmascript.builtin;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.web3d.util.HashSet;
import org.web3d.vrml.scripting.ecmascript.builtin.FieldScriptableObject;

public class SFVec3d
extends FieldScriptableObject {
    private double x;
    private double y;
    private double z;
    private static HashSet propertyNames = new HashSet();
    private static HashSet functionNames;

    public SFVec3d() {
        super("SFVec3d");
    }

    public SFVec3d(float[] fArray) {
        this();
        if (fArray == null || fArray.length == 0) {
            return;
        }
        this.x = fArray[0];
        this.y = fArray[1];
        this.z = fArray[2];
    }

    public SFVec3d(double[] dArray) {
        this();
        if (dArray == null || dArray.length == 0) {
            return;
        }
        this.x = dArray[0];
        this.y = dArray[1];
        this.z = dArray[2];
    }

    public void jsConstructor(double d, double d2, double d3) {
        this.x = Double.isNaN(d) ? 0.0 : d;
        this.y = Double.isNaN(d2) ? 0.0 : d2;
        this.z = Double.isNaN(d3) ? 0.0 : d3;
    }

    public boolean has(int n, Scriptable scriptable) {
        return n >= 0 && n < 2;
    }

    public boolean has(String string, Scriptable scriptable) {
        boolean bl = false;
        bl = propertyNames.contains(string) ? true : super.has(string, scriptable);
        return bl;
    }

    public Object get(int n, Scriptable scriptable) {
        Object object = NOT_FOUND;
        switch (n) {
            case 0: {
                object = new Double(this.x);
                break;
            }
            case 1: {
                object = new Double(this.y);
                break;
            }
            case 2: {
                object = new Double(this.z);
            }
        }
        return object;
    }

    public Object get(String string, Scriptable scriptable) {
        Object object = null;
        if (propertyNames.contains(string)) {
            char c = string.charAt(0);
            double d = 0.0;
            switch (c) {
                case 'x': {
                    d = this.x;
                    break;
                }
                case 'y': {
                    d = this.y;
                    break;
                }
                case 'z': {
                    d = this.z;
                }
            }
            object = new Double(d);
        } else {
            object = super.get(string, scriptable);
            if (object == null && functionNames.contains(string)) {
                object = this.locateFunction(string);
            }
        }
        if (object == null) {
            object = NOT_FOUND;
        }
        return object;
    }

    public void put(int n, Scriptable scriptable, Object object) {
        Number number = (Number)object;
        switch (n) {
            case 0: {
                this.x = number.doubleValue();
                break;
            }
            case 1: {
                this.y = number.doubleValue();
                break;
            }
            case 2: {
                this.z = number.doubleValue();
            }
        }
        this.dataChanged = true;
    }

    public void put(String string, Scriptable scriptable, Object object) {
        if (propertyNames.contains(string)) {
            if (this.readOnly && !this.scriptField) {
                Context.reportError((String)"You are not allowed to directly set this field because the script is marked as read only (directOutput is set to FALSE)");
                return;
            }
            char c = string.charAt(0);
            double d = 0.0;
            if (object instanceof Number) {
                Number number = (Number)object;
                d = number.doubleValue();
            } else if (object instanceof String) {
                try {
                    d = Double.parseDouble((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    Context.reportRuntimeError((String)("Attempting to set a property that we have determined is a number but you passed to us as a String. The string you passed us was: " + object));
                    return;
                }
            } else {
                Context.reportRuntimeError((String)"The type passed to the underlying object is invalid ");
                return;
            }
            switch (c) {
                case 'x': {
                    this.x = d;
                    break;
                }
                case 'y': {
                    this.y = d;
                    break;
                }
                case 'z': {
                    this.z = d;
                }
            }
            this.dataChanged = true;
        } else if (object instanceof Function) {
            this.registerFunction(string, object);
        }
    }

    public SFVec3d jsFunction_add(Scriptable scriptable) {
        if (!(scriptable instanceof SFVec3d)) {
            Context.reportRuntimeError((String)"The type passed to the underlying object is invalid ");
        }
        SFVec3d sFVec3d = (SFVec3d)scriptable;
        SFVec3d sFVec3d2 = new SFVec3d();
        sFVec3d2.x = this.x + sFVec3d.x;
        sFVec3d2.y = this.y + sFVec3d.y;
        sFVec3d2.z = this.z + sFVec3d.z;
        return sFVec3d2;
    }

    public SFVec3d jsFunction_cross(Scriptable scriptable) {
        if (!(scriptable instanceof SFVec3d)) {
            Context.reportRuntimeError((String)"The type passed to the underlying object is invalid ");
        }
        SFVec3d sFVec3d = (SFVec3d)scriptable;
        SFVec3d sFVec3d2 = new SFVec3d();
        sFVec3d2.x = this.y * sFVec3d.z - this.z * sFVec3d.y;
        sFVec3d2.y = this.z * sFVec3d.x - this.x * sFVec3d.z;
        sFVec3d2.z = this.x * sFVec3d.y - this.y * sFVec3d.x;
        return sFVec3d2;
    }

    public SFVec3d jsFunction_divide(double d) {
        SFVec3d sFVec3d = new SFVec3d();
        sFVec3d.x = this.x / d;
        sFVec3d.y = this.y / d;
        sFVec3d.z = this.z / d;
        return sFVec3d;
    }

    public double jsFunction_dot(Scriptable scriptable) {
        if (!(scriptable instanceof SFVec3d)) {
            Context.reportRuntimeError((String)"The type passed to the underlying object is invalid ");
        }
        SFVec3d sFVec3d = (SFVec3d)scriptable;
        return this.x * sFVec3d.x + this.y * sFVec3d.y + this.z * sFVec3d.z;
    }

    public double jsFunction_length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public SFVec3d jsFunction_multiply(double d) {
        SFVec3d sFVec3d = new SFVec3d();
        sFVec3d.x = this.x * d;
        sFVec3d.y = this.y * d;
        sFVec3d.z = this.z * d;
        return sFVec3d;
    }

    public SFVec3d jsFunction_negate() {
        SFVec3d sFVec3d = new SFVec3d();
        sFVec3d.x = -this.x;
        sFVec3d.y = -this.y;
        sFVec3d.z = -this.z;
        return sFVec3d;
    }

    public SFVec3d jsFunction_normalize() {
        SFVec3d sFVec3d = new SFVec3d();
        double d = this.jsFunction_length();
        sFVec3d.x = this.x / d;
        sFVec3d.y = this.y / d;
        sFVec3d.z = this.z / d;
        return sFVec3d;
    }

    public SFVec3d jsFunction_subtract(Scriptable scriptable) {
        if (!(scriptable instanceof SFVec3d)) {
            Context.reportRuntimeError((String)"The type passed to the underlying object is invalid ");
        }
        SFVec3d sFVec3d = (SFVec3d)scriptable;
        SFVec3d sFVec3d2 = new SFVec3d();
        sFVec3d2.x = this.x - sFVec3d.x;
        sFVec3d2.y = this.y - sFVec3d.y;
        sFVec3d2.z = this.z - sFVec3d.z;
        return sFVec3d2;
    }

    public String jsFunction_toString() {
        return this.toString();
    }

    public boolean jsFunction_equals(Object object) {
        return this.equals(object);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.x);
        stringBuffer.append(' ');
        stringBuffer.append(this.y);
        stringBuffer.append(' ');
        stringBuffer.append(this.z);
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof SFVec3d)) {
            return false;
        }
        SFVec3d sFVec3d = (SFVec3d)object;
        return sFVec3d.x == this.x && sFVec3d.y == this.y && sFVec3d.z == this.z;
    }

    public void getRawData(float[] fArray) {
        fArray[0] = (float)this.x;
        fArray[1] = (float)this.y;
        fArray[2] = (float)this.z;
    }

    public void getRawData(double[] dArray) {
        dArray[0] = this.x;
        dArray[1] = this.y;
        dArray[2] = this.z;
    }

    public void setRawData(float[] fArray) {
        this.x = fArray[0];
        this.y = fArray[1];
        this.z = fArray[2];
    }

    public void setRawData(double[] dArray) {
        this.x = dArray[0];
        this.y = dArray[1];
        this.z = dArray[2];
    }

    public void setRawData(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    static {
        propertyNames.add("x");
        propertyNames.add("y");
        propertyNames.add("z");
        functionNames = new HashSet();
        functionNames.add("add");
        functionNames.add("cross");
        functionNames.add("divide");
        functionNames.add("dot");
        functionNames.add("length");
        functionNames.add("multiply");
        functionNames.add("negate");
        functionNames.add("normalize");
        functionNames.add("subtract");
        functionNames.add("toString");
        functionNames.add("equals");
    }
}

