/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.ecmascript.builtin;

import javax.vecmath.AxisAngle4d;
import javax.vecmath.Quat4d;
import javax.vecmath.Vector3f;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.web3d.util.HashSet;
import org.web3d.vrml.scripting.ecmascript.builtin.FieldScriptableObject;
import org.web3d.vrml.scripting.ecmascript.builtin.SFVec3f;

public class SFRotation
extends FieldScriptableObject {
    private double x;
    private double y;
    private double z;
    private double angle;
    private static HashSet propertyNames = new HashSet();
    private static HashSet functionNames;
    private static Object jsUndefined;

    public SFRotation() {
        super("SFRotation");
    }

    public SFRotation(float[] fArray) {
        this();
        if (fArray == null || fArray.length == 0) {
            return;
        }
        this.x = fArray[0];
        this.y = fArray[1];
        this.z = fArray[2];
        this.angle = fArray[3];
    }

    public void jsConstructor(Object object, Object object2, Object object3, Object object4) {
        if (object == jsUndefined) {
            this.x = 0.0;
            this.y = 1.0;
            this.z = 0.0;
            this.angle = 0.0;
        } else if (object != jsUndefined && object2 != jsUndefined && object3 != jsUndefined & object4 != jsUndefined) {
            this.x = ((Number)object).doubleValue();
            this.y = ((Number)object2).doubleValue();
            this.z = ((Number)object3).doubleValue();
            this.angle = ((Number)object4).doubleValue();
        } else {
            double[] dArray = new double[3];
            ((SFVec3f)object).getRawData(dArray);
            if (object2 instanceof SFVec3f) {
                double[] dArray2 = new double[3];
                ((SFVec3f)object2).getRawData(dArray2);
                Vector3f vector3f = new Vector3f((float)dArray[0], (float)dArray[1], (float)dArray[2]);
                Vector3f vector3f2 = new Vector3f((float)dArray2[0], (float)dArray2[1], (float)dArray2[2]);
                this.angle = vector3f.angle(vector3f2);
                vector3f.cross(vector3f, vector3f2);
                vector3f.normalize();
                this.x = Double.isNaN(vector3f.x) ? 0.0 : (double)vector3f.x;
                this.y = Double.isNaN(vector3f.y) ? 1.0 : (double)vector3f.y;
                this.z = Double.isNaN(vector3f.z) ? 0.0 : (double)vector3f.z;
            } else {
                this.x = dArray[0];
                this.y = dArray[1];
                this.z = dArray[2];
                this.angle = ((Number)object2).doubleValue();
            }
        }
    }

    public boolean has(int n, Scriptable scriptable) {
        return n >= 0 && n < 3;
    }

    public boolean has(String string, Scriptable scriptable) {
        boolean bl = false;
        bl = propertyNames.contains(string) ? true : super.has(string, scriptable);
        return bl;
    }

    public Object get(int n, Scriptable scriptable) {
        Object object = NOT_FOUND;
        switch (n) {
            case 0: {
                object = new Double(this.x);
                break;
            }
            case 1: {
                object = new Double(this.y);
                break;
            }
            case 2: {
                object = new Double(this.z);
                break;
            }
            case 3: {
                object = new Double(this.angle);
            }
        }
        return object;
    }

    public Object get(String string, Scriptable scriptable) {
        Object object = null;
        if (propertyNames.contains(string)) {
            char c = string.charAt(0);
            double d = 0.0;
            switch (c) {
                case 'x': {
                    d = this.x;
                    break;
                }
                case 'y': {
                    d = this.y;
                    break;
                }
                case 'z': {
                    d = this.z;
                    break;
                }
                case 'a': {
                    d = this.angle;
                }
            }
            object = new Double(d);
        } else {
            object = super.get(string, scriptable);
            if (object == null && functionNames.contains(string)) {
                object = this.locateFunction(string);
            }
        }
        if (object == null) {
            object = NOT_FOUND;
        }
        return object;
    }

    public void put(int n, Scriptable scriptable, Object object) {
        Number number = (Number)object;
        switch (n) {
            case 0: {
                this.x = number.doubleValue();
                break;
            }
            case 1: {
                this.y = number.doubleValue();
                break;
            }
            case 2: {
                this.z = number.doubleValue();
                break;
            }
            case 3: {
                this.angle = number.doubleValue();
            }
        }
        this.dataChanged = true;
    }

    public void put(String string, Scriptable scriptable, Object object) {
        if (propertyNames.contains(string)) {
            if (this.readOnly && !this.scriptField) {
                Context.reportError((String)"You are not allowed to directly set this field because the script is marked as read only (directOutput is set to FALSE)");
                return;
            }
            char c = string.charAt(0);
            double d = 0.0;
            if (object instanceof Number) {
                Number number = (Number)object;
                d = number.doubleValue();
            } else if (object instanceof String) {
                try {
                    d = Double.parseDouble((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    Context.reportRuntimeError((String)("Attempting to set a property that we have determined is a number but you passed to us as a String. The string you passed us was: " + object));
                    return;
                }
            } else {
                Context.reportRuntimeError((String)"The type passed to the underlying object is invalid ");
                return;
            }
            switch (c) {
                case 'x': {
                    this.x = d;
                    break;
                }
                case 'y': {
                    this.y = d;
                    break;
                }
                case 'z': {
                    this.z = d;
                    break;
                }
                case 'a': {
                    this.angle = d;
                }
            }
            this.dataChanged = true;
        } else if (object instanceof Function) {
            this.registerFunction(string, object);
        }
    }

    public SFVec3f jsFunction_getAxis() {
        SFVec3f sFVec3f = new SFVec3f();
        sFVec3f.setRawData(this.x, this.y, this.z);
        return sFVec3f;
    }

    public void jsFunction_setAxis(Scriptable scriptable) {
        if (!(scriptable instanceof SFVec3f)) {
            Context.reportRuntimeError((String)"The type passed to the underlying object is invalid ");
        }
        SFVec3f sFVec3f = (SFVec3f)scriptable;
        float[] fArray = new float[3];
        sFVec3f.getRawData(fArray);
        this.x = fArray[0];
        this.y = fArray[1];
        this.z = fArray[2];
    }

    public SFRotation jsFunction_inverse() {
        SFRotation sFRotation = new SFRotation();
        double d = 1.0 / Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z + this.angle * this.angle);
        sFRotation.x = -this.x / d;
        sFRotation.y = -this.y / d;
        sFRotation.z = -this.z / d;
        sFRotation.angle = this.angle / d;
        return sFRotation;
    }

    public SFRotation jsFunction_multiply(Scriptable scriptable) {
        if (!(scriptable instanceof SFRotation)) {
            Context.reportRuntimeError((String)"The type passed to the underlying object is invalid ");
        }
        SFRotation sFRotation = (SFRotation)scriptable;
        SFRotation sFRotation2 = new SFRotation();
        sFRotation2.x = this.angle * sFRotation.x + this.x * sFRotation.angle + this.y * sFRotation.z - this.z * sFRotation.y;
        sFRotation2.y = this.angle * sFRotation.y + this.y * sFRotation.angle + this.z * sFRotation.x - this.x * sFRotation.z;
        sFRotation2.z = this.angle * sFRotation.z + this.z * sFRotation.angle + this.x * sFRotation.y - this.y * sFRotation.x;
        sFRotation2.angle = this.angle * sFRotation.angle - this.x * sFRotation.x - this.y * sFRotation.y - this.z * sFRotation.z;
        return sFRotation2;
    }

    public SFVec3f jsFunction_multVec(Scriptable scriptable) {
        if (!(scriptable instanceof SFVec3f)) {
            Context.reportRuntimeError((String)"The type passed to the underlying object is invalid ");
        }
        SFVec3f sFVec3f = (SFVec3f)scriptable;
        double[] dArray = new double[9];
        double[] dArray2 = new double[3];
        sFVec3f.getRawData(dArray2);
        double d = this.x * this.x;
        double d2 = this.x * this.y;
        double d3 = this.x * this.z;
        double d4 = this.x * this.angle;
        double d5 = this.y * this.y;
        double d6 = this.y * this.z;
        double d7 = this.y * this.angle;
        double d8 = this.z * this.z;
        double d9 = this.z * this.angle;
        dArray[0] = 1.0 - 2.0 * (d5 + d8);
        dArray[1] = 2.0 * (d2 + d9);
        dArray[2] = 2.0 * (d3 - d7);
        dArray[3] = 2.0 * (d2 - d9);
        dArray[4] = 1.0 - 2.0 * (d + d8);
        dArray[5] = 2.0 * (d6 + d4);
        dArray[6] = 2.0 * (d3 + d7);
        dArray[7] = 2.0 * (d6 - d4);
        dArray[8] = 1.0 - 2.0 * (d + d5);
        double d10 = dArray[0] * dArray2[0] + dArray[1] * dArray2[1] + dArray[2] * dArray2[2];
        double d11 = dArray[3] * dArray2[0] + dArray[4] * dArray2[1] + dArray[5] * dArray2[2];
        double d12 = dArray[6] * dArray2[0] + dArray[7] * dArray2[1] + dArray[8] * dArray2[2];
        SFVec3f sFVec3f2 = new SFVec3f();
        sFVec3f2.setRawData(d10, d11, d12);
        return sFVec3f2;
    }

    public SFRotation jsFunction_slerp(Scriptable scriptable, double d) {
        if (!(scriptable instanceof SFRotation)) {
            Context.reportRuntimeError((String)"The type passed to the underlying object is invalid ");
        }
        SFRotation sFRotation = (SFRotation)scriptable;
        AxisAngle4d axisAngle4d = new AxisAngle4d(this.x, this.y, this.z, this.angle);
        Quat4d quat4d = new Quat4d();
        quat4d.set(axisAngle4d);
        double[] dArray = new double[4];
        sFRotation.getRawData(dArray);
        axisAngle4d = new AxisAngle4d(dArray[0], dArray[1], dArray[2], dArray[3]);
        Quat4d quat4d2 = new Quat4d();
        quat4d2.set(axisAngle4d);
        quat4d.interpolate(quat4d2, d);
        axisAngle4d.set(quat4d);
        SFRotation sFRotation2 = new SFRotation(new float[]{(float)axisAngle4d.x, (float)axisAngle4d.y, (float)axisAngle4d.z, (float)axisAngle4d.angle});
        return sFRotation2;
    }

    public String jsFunction_toString() {
        return this.toString();
    }

    public boolean jsFunction_equals(Object object) {
        return this.equals(object);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.x);
        stringBuffer.append(' ');
        stringBuffer.append(this.y);
        stringBuffer.append(' ');
        stringBuffer.append(this.z);
        stringBuffer.append(' ');
        stringBuffer.append(this.angle);
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof SFRotation)) {
            return false;
        }
        SFRotation sFRotation = (SFRotation)object;
        return sFRotation.x == this.x && sFRotation.y == this.y && sFRotation.z == this.z && sFRotation.angle == this.angle;
    }

    public void getRawData(float[] fArray) {
        fArray[0] = (float)this.x;
        fArray[1] = (float)this.y;
        fArray[2] = (float)this.z;
        fArray[3] = (float)this.angle;
    }

    public void getRawData(double[] dArray) {
        dArray[0] = this.x;
        dArray[1] = this.y;
        dArray[2] = this.z;
        dArray[3] = this.angle;
    }

    public void setRawData(float[] fArray) {
        this.x = fArray[0];
        this.y = fArray[1];
        this.z = fArray[2];
        this.angle = fArray[3];
    }

    public void setRawData(double[] dArray) {
        this.x = dArray[0];
        this.y = dArray[1];
        this.z = dArray[2];
        this.angle = dArray[3];
    }

    static {
        propertyNames.add("x");
        propertyNames.add("y");
        propertyNames.add("z");
        propertyNames.add("angle");
        functionNames = new HashSet();
        functionNames.add("getAxis");
        functionNames.add("setAxis");
        functionNames.add("inverse");
        functionNames.add("multiply");
        functionNames.add("multVec");
        functionNames.add("slerp");
        functionNames.add("toString");
        functionNames.add("equals");
        jsUndefined = Context.getUndefinedValue();
    }
}

