/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.ecmascript.builtin;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.web3d.util.ColorUtils;
import org.web3d.util.HashSet;
import org.web3d.vrml.scripting.ecmascript.builtin.FieldScriptableObject;

public class SFColorRGBA
extends FieldScriptableObject {
    private double red;
    private double green;
    private double blue;
    private double alpha;
    private static HashSet propertyNames = new HashSet();
    private static HashSet functionNames;

    public SFColorRGBA() {
        super("SFColorRGBA");
    }

    public SFColorRGBA(float[] fArray) {
        this();
        if (fArray == null || fArray.length == 0) {
            return;
        }
        this.red = fArray[0];
        this.green = fArray[1];
        this.blue = fArray[2];
        this.alpha = fArray[3];
    }

    public void jsConstructor(double d, double d2, double d3, double d4) {
        this.red = Double.isNaN(d) ? 0.0 : d;
        this.green = Double.isNaN(d2) ? 0.0 : d2;
        this.blue = Double.isNaN(d3) ? 0.0 : d3;
        this.alpha = Double.isNaN(d4) ? 0.0 : d4;
    }

    public boolean has(int n, Scriptable scriptable) {
        return n >= 0 && n < 3;
    }

    public boolean has(String string, Scriptable scriptable) {
        boolean bl = false;
        bl = propertyNames.contains(string) ? true : super.has(string, scriptable);
        return bl;
    }

    public Object get(int n, Scriptable scriptable) {
        Object object = NOT_FOUND;
        switch (n) {
            case 0: {
                object = new Double(this.red);
                break;
            }
            case 1: {
                object = new Double(this.green);
                break;
            }
            case 2: {
                object = new Double(this.blue);
                break;
            }
            case 3: {
                object = new Double(this.alpha);
            }
        }
        return object;
    }

    public Object get(String string, Scriptable scriptable) {
        Object object = null;
        if (propertyNames.contains(string)) {
            char c = string.charAt(0);
            double d = 0.0;
            switch (c) {
                case 'r': {
                    d = this.red;
                    break;
                }
                case 'g': {
                    d = this.green;
                    break;
                }
                case 'b': {
                    d = this.blue;
                    break;
                }
                case 'a': {
                    d = this.alpha;
                }
            }
            object = new Double(d);
        } else {
            object = super.get(string, scriptable);
            if (object == null && functionNames.contains(string)) {
                object = this.locateFunction(string);
            }
        }
        if (object == null) {
            object = NOT_FOUND;
        }
        return object;
    }

    public void put(int n, Scriptable scriptable, Object object) {
        Number number = (Number)object;
        switch (n) {
            case 0: {
                this.red = number.doubleValue();
                break;
            }
            case 1: {
                this.green = number.doubleValue();
                break;
            }
            case 2: {
                this.blue = number.doubleValue();
                break;
            }
            case 3: {
                this.alpha = number.doubleValue();
            }
        }
        this.dataChanged = true;
    }

    public void put(String string, Scriptable scriptable, Object object) {
        if (propertyNames.contains(string)) {
            if (this.readOnly && !this.scriptField) {
                Context.reportError((String)"You are not allowed to directly set this field because the script is marked as read only (directOutput is set to FALSE)");
                return;
            }
            char c = string.charAt(0);
            double d = 0.0;
            if (object instanceof Number) {
                Number number = (Number)object;
                d = number.doubleValue();
            } else if (object instanceof String) {
                try {
                    d = Double.parseDouble((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    Context.reportRuntimeError((String)("Attempting to set a property that we have determined is a number but you passed to us as a String. The string you passed us was: " + object));
                    return;
                }
            } else {
                Context.reportRuntimeError((String)"The type passed to the underlying object is invalid ");
                return;
            }
            switch (c) {
                case 'r': {
                    this.red = d;
                    break;
                }
                case 'g': {
                    this.green = d;
                    break;
                }
                case 'b': {
                    this.blue = d;
                    break;
                }
                case 'a': {
                    this.alpha = d;
                }
            }
            this.dataChanged = true;
        } else if (object instanceof Function) {
            this.registerFunction(string, object);
        }
    }

    public void jsFunction_setHSV(double d, double d2, double d3) {
        float[] fArray = new float[3];
        ColorUtils.convertHSVtoRGB((float)d, (float)d2, (float)d3, fArray);
        this.red = fArray[0];
        this.green = fArray[1];
        this.blue = fArray[2];
        this.dataChanged = true;
    }

    public Object jsFunction_getHSV() {
        float[] fArray = new float[3];
        ColorUtils.convertRGBtoHSV((float)this.red, (float)this.green, (float)this.blue, fArray);
        return fArray;
    }

    public String jsFunction_toString() {
        return this.toString();
    }

    public boolean jsFunction_equals(Object object) {
        return this.equals(object);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.red);
        stringBuffer.append(' ');
        stringBuffer.append(this.green);
        stringBuffer.append(' ');
        stringBuffer.append(this.blue);
        stringBuffer.append(' ');
        stringBuffer.append(this.alpha);
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof SFColorRGBA)) {
            return false;
        }
        SFColorRGBA sFColorRGBA = (SFColorRGBA)object;
        return sFColorRGBA.red == this.red && sFColorRGBA.green == this.green && sFColorRGBA.blue == this.blue && sFColorRGBA.alpha == this.alpha;
    }

    public void getRawData(float[] fArray) {
        fArray[0] = (float)this.red;
        fArray[1] = (float)this.green;
        fArray[2] = (float)this.blue;
        fArray[3] = (float)this.alpha;
    }

    public void setRawData(float[] fArray) {
        this.red = fArray[0];
        this.green = fArray[1];
        this.blue = fArray[2];
        this.alpha = fArray[3];
    }

    public void setRawData(double[] dArray) {
        this.red = dArray[0];
        this.green = dArray[1];
        this.blue = dArray[2];
        this.alpha = dArray[3];
    }

    static {
        propertyNames.add("r");
        propertyNames.add("g");
        propertyNames.add("b");
        propertyNames.add("a");
        functionNames = new HashSet();
        functionNames.add("setHSV");
        functionNames.add("getHSV");
        functionNames.add("toString");
        functionNames.add("equals");
    }
}

