/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.ecmascript.builtin;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.web3d.util.HashSet;
import org.web3d.vrml.scripting.ecmascript.builtin.FieldScriptableObject;
import org.web3d.vrml.scripting.ecmascript.builtin.SFRotation;
import org.web3d.vrml.scripting.ecmascript.builtin.SFVec3f;

public class Matrix4
extends FieldScriptableObject {
    private static HashSet functionNames;
    private static final double[] IDENTITY;
    private static final double[] DEFAULT_TRANSLATION;
    private static final double[] DEFAULT_ROTATION;
    private static final double[] DEFAULT_SCALE;
    private static final double[] DEFAULT_SCALE_ORIENT;
    private static final double[] DEFAULT_CENTER;
    private double[] matrix = new double[16];
    private double[] workMatrix = new double[16];
    private double[] workTranslation = new double[3];
    private double[] workRotation = new double[4];
    private double[] workScale = new double[3];
    private double[] workOrientation = new double[4];
    private double[] workCenter = new double[3];

    public Matrix4() {
        super("Matrix4");
    }

    public Matrix4(double[] dArray) {
        this();
        if (dArray == null) {
            return;
        }
        int n = dArray.length > 16 ? 16 : dArray.length;
        System.arraycopy(dArray, 0, this.matrix, 0, n);
    }

    public void jsConstructor(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14, double d15, double d16) {
        this.matrix[0] = Double.isNaN(d) ? 1.0 : d;
        this.matrix[1] = Double.isNaN(d2) ? 0.0 : d2;
        this.matrix[2] = Double.isNaN(d3) ? 0.0 : d3;
        this.matrix[3] = Double.isNaN(d4) ? 0.0 : d4;
        this.matrix[4] = Double.isNaN(d5) ? 0.0 : d5;
        this.matrix[5] = Double.isNaN(d6) ? 1.0 : d6;
        this.matrix[6] = Double.isNaN(d7) ? 0.0 : d7;
        this.matrix[7] = Double.isNaN(d8) ? 0.0 : d8;
        this.matrix[8] = Double.isNaN(d9) ? 0.0 : d9;
        this.matrix[9] = Double.isNaN(d10) ? 0.0 : d10;
        this.matrix[10] = Double.isNaN(d11) ? 1.0 : d11;
        this.matrix[11] = Double.isNaN(d12) ? 0.0 : d12;
        this.matrix[12] = Double.isNaN(d13) ? 0.0 : d13;
        this.matrix[13] = Double.isNaN(d14) ? 0.0 : d14;
        this.matrix[14] = Double.isNaN(d15) ? 0.0 : d15;
        this.matrix[15] = Double.isNaN(d16) ? 1.0 : d16;
    }

    public boolean has(int n, Scriptable scriptable) {
        return n >= 0 && n < 16;
    }

    public Object get(int n, Scriptable scriptable) {
        if (n < 0 && n > 15) {
            return NOT_FOUND;
        }
        return new Double(this.matrix[n]);
    }

    public Object get(String string, Scriptable scriptable) {
        Object object = super.get(string, scriptable);
        if (object == null && functionNames.contains(string)) {
            object = this.locateFunction(string);
        }
        if (object == null) {
            object = NOT_FOUND;
        }
        return object;
    }

    public void put(int n, Scriptable scriptable, Object object) {
        if (n < 0 && n > 15) {
            return;
        }
        Number number = (Number)object;
        this.matrix[n] = number.doubleValue();
    }

    public void put(String string, Scriptable scriptable, Object object) {
        if (object instanceof Function) {
            this.registerFunction(string, object);
        }
    }

    public void jsFunction_setTransform(Scriptable scriptable, Scriptable scriptable2, Scriptable scriptable3, Scriptable scriptable4, Scriptable scriptable5) {
        if (scriptable != null && !(scriptable instanceof SFVec3f)) {
            Context.reportRuntimeError((String)"The type passed to the underlying object is invalid ");
        }
        if (scriptable2 != null && !(scriptable2 instanceof SFRotation)) {
            Context.reportRuntimeError((String)"The type passed to the underlying object is invalid ");
        }
        if (scriptable3 != null && !(scriptable3 instanceof SFVec3f)) {
            Context.reportRuntimeError((String)"The type passed to the underlying object is invalid ");
        }
        if (scriptable4 != null && !(scriptable4 instanceof SFRotation)) {
            Context.reportRuntimeError((String)"The type passed to the underlying object is invalid ");
        }
        if (scriptable5 != null && !(scriptable5 instanceof SFVec3f)) {
            Context.reportRuntimeError((String)"The type passed to the underlying object is invalid ");
        }
        if (scriptable == null) {
            System.arraycopy(IDENTITY, 0, this.matrix, 0, 16);
            return;
        }
        this.manualSetup();
        ((SFVec3f)scriptable).getRawData(this.workTranslation);
        if (scriptable2 != null) {
            ((SFRotation)scriptable2).getRawData(this.workRotation);
        }
        if (scriptable3 != null) {
            ((SFVec3f)scriptable3).getRawData(this.workScale);
        }
        if (scriptable4 != null) {
            ((SFRotation)scriptable4).getRawData(this.workOrientation);
        }
        if (scriptable5 != null) {
            ((SFVec3f)scriptable5).getRawData(this.workCenter);
        }
        double d = this.workRotation[0] * this.workRotation[0];
        double d2 = this.workRotation[0] * this.workRotation[1];
        double d3 = this.workRotation[0] * this.workRotation[2];
        double d4 = this.workRotation[0] * this.workRotation[3];
        double d5 = this.workRotation[1] * this.workRotation[1];
        double d6 = this.workRotation[1] * this.workRotation[2];
        double d7 = this.workRotation[1] * this.workRotation[3];
        double d8 = this.workRotation[2] * this.workRotation[2];
        double d9 = this.workRotation[2] * this.workRotation[3];
        this.matrix[0] = this.workScale[0] + (1.0 - 2.0 * (d5 + d8));
        this.matrix[1] = 2.0 * (d2 + d9);
        this.matrix[2] = 2.0 * (d3 - d7);
        this.matrix[3] = 0.0;
        this.matrix[4] = 2.0 * (d2 - d9);
        this.matrix[5] = this.workScale[1] + (1.0 - 2.0 * (d + d8));
        this.matrix[6] = 2.0 * (d6 + d4);
        this.matrix[7] = 0.0;
        this.matrix[8] = 2.0 * (d3 + d7);
        this.matrix[9] = 2.0 * (d6 - d4);
        this.matrix[10] = this.workScale[2] + (1.0 - 2.0 * (d + d5));
        this.matrix[11] = 0.0;
        this.matrix[12] = this.workTranslation[0];
        this.matrix[13] = this.workTranslation[1];
        this.matrix[14] = this.workTranslation[2];
        this.matrix[15] = 1.0;
    }

    public void jsFunction_getTransform(Scriptable scriptable, Scriptable scriptable2, Scriptable scriptable3) {
        if (scriptable != null && !(scriptable instanceof SFVec3f)) {
            Context.reportRuntimeError((String)"The type passed to the underlying object is invalid ");
        }
        if (scriptable2 != null && !(scriptable2 instanceof SFRotation)) {
            Context.reportRuntimeError((String)"The type passed to the underlying object is invalid ");
        }
        if (scriptable3 != null && !(scriptable3 instanceof SFVec3f)) {
            Context.reportRuntimeError((String)"The type passed to the underlying object is invalid ");
        }
        SFVec3f sFVec3f = (SFVec3f)scriptable;
        SFRotation sFRotation = (SFRotation)scriptable2;
        SFVec3f sFVec3f2 = (SFVec3f)scriptable3;
        if (sFVec3f == null) {
            return;
        }
        this.workTranslation[0] = this.matrix[12];
        this.workTranslation[1] = this.matrix[13];
        this.workTranslation[2] = this.matrix[14];
        sFVec3f.setRawData(this.workTranslation);
        if (sFRotation == null) {
            return;
        }
        double d = 1.0 + this.matrix[0] + this.matrix[5] + this.matrix[10];
        if (d > 1.0E-8) {
            double d2 = Math.sqrt(d) * 2.0;
            double d3 = 1.0 / d2;
            this.workRotation[0] = (this.matrix[6] - this.matrix[9]) * d3;
            this.workRotation[1] = (this.matrix[8] - this.matrix[2]) * d3;
            this.workRotation[2] = (this.matrix[1] - this.matrix[4]) * d3;
            this.workRotation[3] = 0.25 * d2;
        } else if (this.matrix[0] > this.matrix[5] && this.matrix[0] > this.matrix[10]) {
            double d4 = Math.sqrt((1.0 + this.matrix[0] - this.matrix[5] - this.matrix[10]) * 2.0);
            double d5 = 1.0 / d4;
            this.workRotation[0] = 0.25 * d4;
            this.workRotation[1] = (this.matrix[1] + this.matrix[4]) * d5;
            this.workRotation[2] = (this.matrix[8] + this.matrix[2]) * d5;
            this.workRotation[3] = (this.matrix[6] - this.matrix[9]) * d5;
        } else if (this.matrix[5] > this.matrix[10]) {
            double d6 = Math.sqrt((1.0 + this.matrix[5] - this.matrix[0] - this.matrix[10]) * 2.0);
            double d7 = 1.0 / d6;
            this.workRotation[1] = (this.matrix[1] + this.matrix[4]) * d7;
            this.workRotation[0] = 0.25 * d6;
            this.workRotation[3] = (this.matrix[6] + this.matrix[9]) * d7;
            this.workRotation[2] = (this.matrix[8] - this.matrix[2]) * d7;
        } else {
            double d8 = Math.sqrt((1.0 + this.matrix[10] - this.matrix[0] - this.matrix[5]) * 2.0);
            double d9 = 1.0 / d8;
            this.workRotation[2] = (this.matrix[8] + this.matrix[2]) * d9;
            this.workRotation[3] = (this.matrix[6] + this.matrix[9]) * d9;
            this.workRotation[0] = 0.25 * d8;
            this.workRotation[1] = (this.matrix[1] - this.matrix[4]) * d9;
        }
        sFRotation.setRawData(this.workRotation);
        if (sFVec3f2 == null) {
            return;
        }
        this.workScale[0] = this.matrix[0];
        this.workScale[1] = this.matrix[5];
        this.workScale[2] = this.matrix[10];
        sFVec3f2.setRawData(this.workScale);
    }

    public Matrix4 jsFunction_inverse() {
        double[] dArray = new double[9];
        double d = this.determinant4x4(this.matrix, dArray);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < 16) {
            stringBuffer.append("| ");
            stringBuffer.append(this.matrix[n++]);
            stringBuffer.append(' ');
            stringBuffer.append(this.matrix[n++]);
            stringBuffer.append(' ');
            stringBuffer.append(this.matrix[n++]);
            stringBuffer.append(' ');
            stringBuffer.append(this.matrix[n++]);
            stringBuffer.append(" |\n");
        }
        System.out.println("preinverse: \n" + stringBuffer.toString());
        if (Math.abs(d) < 5.0E-4) {
            System.arraycopy(IDENTITY, 0, this.workMatrix, 0, 16);
        } else {
            for (n = 0; n < 4; ++n) {
                for (int i = 0; i < 4; ++i) {
                    int n2 = 1 - (n + i) % 2 * 2;
                    this.submatrix(this.matrix, n, i, dArray);
                    this.workMatrix[n + i * 4] = this.determinant3x3(dArray) * (double)n2 / d;
                }
            }
        }
        stringBuffer = new StringBuffer();
        n = 0;
        while (n < 16) {
            stringBuffer.append("| ");
            stringBuffer.append(this.workMatrix[n++]);
            stringBuffer.append(' ');
            stringBuffer.append(this.workMatrix[n++]);
            stringBuffer.append(' ');
            stringBuffer.append(this.workMatrix[n++]);
            stringBuffer.append(' ');
            stringBuffer.append(this.workMatrix[n++]);
            stringBuffer.append(" |\n");
        }
        return new Matrix4(this.workMatrix);
    }

    public Matrix4 jsFunction_transpose() {
        this.workMatrix[0] = this.matrix[0];
        this.workMatrix[1] = this.matrix[4];
        this.workMatrix[2] = this.matrix[8];
        this.workMatrix[3] = this.matrix[12];
        this.workMatrix[4] = this.matrix[1];
        this.workMatrix[5] = this.matrix[5];
        this.workMatrix[6] = this.matrix[9];
        this.workMatrix[7] = this.matrix[13];
        this.workMatrix[8] = this.matrix[2];
        this.workMatrix[9] = this.matrix[6];
        this.workMatrix[10] = this.matrix[10];
        this.workMatrix[11] = this.matrix[14];
        this.workMatrix[12] = this.matrix[3];
        this.workMatrix[13] = this.matrix[7];
        this.workMatrix[14] = this.matrix[11];
        this.workMatrix[15] = this.matrix[15];
        return new Matrix4(this.workMatrix);
    }

    public Matrix4 jsFunction_multLeft(Scriptable scriptable) {
        if (!(scriptable instanceof Matrix4)) {
            Context.reportRuntimeError((String)"The type passed to the underlying object is invalid ");
        }
        Matrix4 matrix4 = (Matrix4)scriptable;
        double[] dArray = matrix4.matrix;
        this.workMatrix[0] = dArray[0] * this.matrix[0] + dArray[1] * this.matrix[4] + dArray[2] * this.matrix[8] + dArray[3] * this.matrix[12];
        this.workMatrix[1] = dArray[0] * this.matrix[1] + dArray[1] * this.matrix[5] + dArray[2] * this.matrix[9] + dArray[3] * this.matrix[13];
        this.workMatrix[2] = dArray[0] * this.matrix[2] + dArray[1] * this.matrix[6] + dArray[2] * this.matrix[10] + dArray[3] * this.matrix[14];
        this.workMatrix[3] = dArray[0] * this.matrix[3] + dArray[1] * this.matrix[7] + dArray[2] * this.matrix[11] + dArray[3] * this.matrix[15];
        this.workMatrix[4] = dArray[4] * this.matrix[0] + dArray[5] * this.matrix[4] + dArray[6] * this.matrix[8] + dArray[7] * this.matrix[12];
        this.workMatrix[5] = dArray[4] * this.matrix[1] + dArray[5] * this.matrix[5] + dArray[6] * this.matrix[9] + dArray[7] * this.matrix[13];
        this.workMatrix[6] = dArray[4] * this.matrix[2] + dArray[5] * this.matrix[6] + dArray[6] * this.matrix[10] + dArray[7] * this.matrix[14];
        this.workMatrix[7] = dArray[4] * this.matrix[3] + dArray[5] * this.matrix[7] + dArray[6] * this.matrix[11] + dArray[7] * this.matrix[15];
        this.workMatrix[8] = dArray[8] * this.matrix[0] + dArray[9] * this.matrix[4] + dArray[10] * this.matrix[8] + dArray[11] * this.matrix[12];
        this.workMatrix[9] = dArray[8] * this.matrix[1] + dArray[9] * this.matrix[5] + dArray[10] * this.matrix[9] + dArray[11] * this.matrix[13];
        this.workMatrix[10] = dArray[8] * this.matrix[2] + dArray[9] * this.matrix[6] + dArray[10] * this.matrix[10] + dArray[11] * this.matrix[14];
        this.workMatrix[11] = dArray[8] * this.matrix[3] + dArray[9] * this.matrix[7] + dArray[10] * this.matrix[11] + dArray[11] * this.matrix[15];
        this.workMatrix[12] = dArray[12] * this.matrix[0] + dArray[13] * this.matrix[4] + dArray[14] * this.matrix[8] + dArray[15] * this.matrix[12];
        this.workMatrix[13] = dArray[12] * this.matrix[1] + dArray[13] * this.matrix[5] + dArray[14] * this.matrix[9] + dArray[15] * this.matrix[13];
        this.workMatrix[14] = dArray[12] * this.matrix[2] + dArray[13] * this.matrix[6] + dArray[14] * this.matrix[10] + dArray[15] * this.matrix[14];
        this.workMatrix[15] = dArray[12] * this.matrix[3] + dArray[13] * this.matrix[7] + dArray[14] * this.matrix[11] + dArray[15] * this.matrix[15];
        return new Matrix4(this.workMatrix);
    }

    public Matrix4 jsFunction_multRight(Scriptable scriptable) {
        if (!(scriptable instanceof Matrix4)) {
            Context.reportRuntimeError((String)"The type passed to the underlying object is invalid ");
        }
        Matrix4 matrix4 = (Matrix4)scriptable;
        double[] dArray = matrix4.matrix;
        this.workMatrix[0] = this.matrix[0] * dArray[0] + this.matrix[1] * dArray[4] + this.matrix[2] * dArray[8] + this.matrix[3] * dArray[12];
        this.workMatrix[1] = this.matrix[0] * dArray[1] + this.matrix[1] * dArray[5] + this.matrix[2] * dArray[9] + this.matrix[3] * dArray[13];
        this.workMatrix[2] = this.matrix[0] * dArray[2] + this.matrix[1] * dArray[6] + this.matrix[2] * dArray[10] + this.matrix[3] * dArray[14];
        this.workMatrix[3] = this.matrix[0] * dArray[3] + this.matrix[1] * dArray[7] + this.matrix[2] * dArray[11] + this.matrix[3] * dArray[15];
        this.workMatrix[4] = this.matrix[4] * dArray[0] + this.matrix[5] * dArray[4] + this.matrix[6] * dArray[8] + this.matrix[7] * dArray[12];
        this.workMatrix[5] = this.matrix[4] * dArray[1] + this.matrix[5] * dArray[5] + this.matrix[6] * dArray[9] + this.matrix[7] * dArray[13];
        this.workMatrix[6] = this.matrix[4] * dArray[2] + this.matrix[5] * dArray[6] + this.matrix[6] * dArray[10] + this.matrix[7] * dArray[14];
        this.workMatrix[7] = this.matrix[4] * dArray[3] + this.matrix[5] * dArray[7] + this.matrix[6] * dArray[11] + this.matrix[7] * dArray[15];
        this.workMatrix[8] = this.matrix[8] * dArray[0] + this.matrix[9] * dArray[4] + this.matrix[10] * dArray[8] + this.matrix[11] * dArray[12];
        this.workMatrix[9] = this.matrix[8] * dArray[1] + this.matrix[9] * dArray[5] + this.matrix[10] * dArray[9] + this.matrix[11] * dArray[13];
        this.workMatrix[10] = this.matrix[8] * dArray[2] + this.matrix[9] * dArray[6] + this.matrix[10] * dArray[10] + this.matrix[11] * dArray[14];
        this.workMatrix[11] = this.matrix[8] * dArray[3] + this.matrix[9] * dArray[7] + this.matrix[10] * dArray[11] + this.matrix[11] * dArray[15];
        this.workMatrix[12] = this.matrix[12] * dArray[0] + this.matrix[13] * dArray[4] + this.matrix[14] * dArray[8] + this.matrix[15] * dArray[12];
        this.workMatrix[13] = this.matrix[12] * dArray[1] + this.matrix[13] * dArray[5] + this.matrix[14] * dArray[9] + this.matrix[15] * dArray[13];
        this.workMatrix[14] = this.matrix[12] * dArray[2] + this.matrix[13] * dArray[6] + this.matrix[14] * dArray[10] + this.matrix[15] * dArray[14];
        this.workMatrix[15] = this.matrix[12] * dArray[3] + this.matrix[13] * dArray[7] + this.matrix[14] * dArray[11] + this.matrix[15] * dArray[15];
        return new Matrix4(this.workMatrix);
    }

    public SFVec3f jsFunction_multVecMatrix(Scriptable scriptable) {
        if (scriptable != null && !(scriptable instanceof SFVec3f)) {
            Context.reportRuntimeError((String)"The type passed to the underlying object is invalid ");
        }
        SFVec3f sFVec3f = (SFVec3f)scriptable;
        double[] dArray = this.workTranslation;
        double[] dArray2 = this.workScale;
        sFVec3f.getRawData(dArray);
        dArray2[0] = this.matrix[0] * dArray[0] + this.matrix[1] + this.matrix[2] + this.matrix[3];
        dArray2[1] = this.matrix[0] * dArray[1] + this.matrix[1] + this.matrix[2] + this.matrix[3];
        dArray2[2] = this.matrix[0] * dArray[2] + this.matrix[1] + this.matrix[2] + this.matrix[3];
        return new SFVec3f(dArray2);
    }

    public SFVec3f jsFunction_multMatrixVec(Scriptable scriptable) {
        if (scriptable != null && !(scriptable instanceof SFVec3f)) {
            Context.reportRuntimeError((String)"The type passed to the underlying object is invalid ");
        }
        SFVec3f sFVec3f = (SFVec3f)scriptable;
        double[] dArray = this.workTranslation;
        double[] dArray2 = this.workScale;
        sFVec3f.getRawData(dArray);
        dArray2[0] = this.matrix[0] * dArray[0] + this.matrix[1] * dArray[1] + this.matrix[2] * dArray[2] + this.matrix[3];
        dArray2[1] = this.matrix[4] * dArray[0] + this.matrix[5] * dArray[1] + this.matrix[6] * dArray[2] + this.matrix[7];
        dArray2[2] = this.matrix[8] * dArray[0] + this.matrix[9] * dArray[1] + this.matrix[10] * dArray[2] + this.matrix[11];
        return new SFVec3f(dArray2);
    }

    public String jsFunction_toString() {
        return this.toString();
    }

    public boolean jsFunction_equals(Object object) {
        return this.equals(object);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < 16) {
            stringBuffer.append("| ");
            stringBuffer.append(this.matrix[n++]);
            stringBuffer.append(' ');
            stringBuffer.append(this.matrix[n++]);
            stringBuffer.append(' ');
            stringBuffer.append(this.matrix[n++]);
            stringBuffer.append(' ');
            stringBuffer.append(this.matrix[n++]);
            stringBuffer.append(" |\n");
        }
        return stringBuffer.toString();
    }

    private void manualSetup() {
        this.workTranslation[0] = DEFAULT_TRANSLATION[0];
        this.workTranslation[1] = DEFAULT_TRANSLATION[1];
        this.workTranslation[2] = DEFAULT_TRANSLATION[2];
        this.workRotation[0] = DEFAULT_ROTATION[0];
        this.workRotation[1] = DEFAULT_ROTATION[1];
        this.workRotation[2] = DEFAULT_ROTATION[2];
        this.workRotation[3] = DEFAULT_ROTATION[3];
        this.workScale[0] = DEFAULT_SCALE[0];
        this.workScale[1] = DEFAULT_SCALE[1];
        this.workScale[2] = DEFAULT_SCALE[2];
        this.workOrientation[0] = DEFAULT_SCALE_ORIENT[0];
        this.workOrientation[1] = DEFAULT_SCALE_ORIENT[1];
        this.workOrientation[2] = DEFAULT_SCALE_ORIENT[2];
        this.workOrientation[3] = DEFAULT_SCALE_ORIENT[3];
        this.workCenter[0] = DEFAULT_CENTER[0];
        this.workCenter[1] = DEFAULT_CENTER[1];
        this.workCenter[2] = DEFAULT_CENTER[2];
    }

    private double determinant3x3(double[] dArray) {
        double d = dArray[0] * (dArray[4] * dArray[8] - dArray[7] * dArray[5]) - dArray[1] * (dArray[3] * dArray[8] - dArray[6] * dArray[5]) + dArray[2] * (dArray[3] * dArray[7] - dArray[6] * dArray[4]);
        return d;
    }

    private double determinant4x4(double[] dArray, double[] dArray2) {
        double d = 0.0;
        double d2 = 1.0;
        int n = 0;
        while (n < 4) {
            this.submatrix(dArray, 0, n, dArray2);
            double d3 = this.determinant3x3(dArray2);
            d += dArray[n] * d3 * d2;
            ++n;
            d2 *= -1.0;
        }
        return d;
    }

    private void submatrix(double[] dArray, int n, int n2, double[] dArray2) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                int n3 = i + (i >= n ? 1 : 0);
                int n4 = j + (j >= n2 ? 1 : 0);
                dArray2[i * 3 + j] = dArray[n3 * 4 + n4];
            }
        }
    }

    static {
        IDENTITY = new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0};
        DEFAULT_TRANSLATION = new double[]{0.0, 0.0, 0.0};
        DEFAULT_ROTATION = new double[]{0.0, 0.0, 1.0, 0.0};
        DEFAULT_SCALE = new double[]{1.0, 1.0, 1.0};
        DEFAULT_SCALE_ORIENT = new double[]{0.0, 0.0, 1.0, 0.0};
        DEFAULT_CENTER = new double[]{0.0, 0.0, 0.0};
        functionNames = new HashSet();
        functionNames.add("setTransform");
        functionNames.add("getTransform");
        functionNames.add("inverse");
        functionNames.add("transpose");
        functionNames.add("multLeft");
        functionNames.add("multRight");
        functionNames.add("multVecMatrix");
        functionNames.add("multMatrixVec");
        functionNames.add("toString");
    }
}

