/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.ecmascript.builtin;

import java.util.ArrayList;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.web3d.util.HashSet;
import org.web3d.vrml.scripting.ecmascript.builtin.FieldScriptableObject;
import org.web3d.vrml.scripting.ecmascript.builtin.ReusableInteger;
import org.web3d.vrml.scripting.ecmascript.builtin.SFVec2f;
import org.web3d.vrml.scripting.ecmascript.builtin.SFVec4f;

public class MFVec4f
extends FieldScriptableObject {
    private static final String OBJECT_NOT_VEC_MSG = "The object you attempted to assign was not an SFVec4f instance";
    private ArrayList valueList = new ArrayList();
    private ReusableInteger sizeInt = new ReusableInteger(0L);
    private float[] floatData;
    private float[] workArray;
    private static HashSet propertyNames = new HashSet();
    private static HashSet functionNames;
    private static Object jsUndefined;

    public MFVec4f() {
        super("MFVec4f");
    }

    public MFVec4f(float[] fArray, int n) {
        this();
        this.workArray = new float[4];
        int n2 = n / 4;
        float[] fArray2 = new float[4];
        if (n != 0) {
            this.floatData = new float[n];
            System.arraycopy(fArray, 0, this.floatData, 0, n);
            this.valueList.ensureCapacity(n2);
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                fArray2[0] = fArray[n3++];
                fArray2[1] = fArray[n3++];
                fArray2[2] = fArray[n3++];
                fArray2[3] = fArray[n3++];
                SFVec4f sFVec4f = new SFVec4f(fArray2);
                this.valueList.add(sFVec4f);
            }
        }
        this.sizeInt.setValue(n2);
    }

    public MFVec4f(Object[] objectArray) {
        this();
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == jsUndefined) continue;
            if (!(objectArray[i] instanceof SFVec4f)) {
                throw new IllegalArgumentException("Non SFVec4f given");
            }
            ++n;
            this.valueList.add(objectArray[i]);
        }
        this.sizeInt.setValue(n);
    }

    public static Scriptable jsConstructor(Context context, Object[] objectArray, Function function, boolean bl) {
        MFVec4f mFVec4f = new MFVec4f(objectArray);
        return mFVec4f;
    }

    public boolean has(int n, Scriptable scriptable) {
        return n >= 0;
    }

    public boolean has(String string, Scriptable scriptable) {
        boolean bl = false;
        bl = propertyNames.contains(string) ? true : super.has(string, scriptable);
        return bl;
    }

    public Object get(int n, Scriptable scriptable) {
        Object object = NOT_FOUND;
        if (n >= 0 && n < this.valueList.size()) {
            object = this.valueList.get(n);
            if (object == null) {
                int n2 = n * 4;
                this.workArray[0] = this.floatData[n2++];
                this.workArray[1] = this.floatData[n2++];
                this.workArray[2] = this.floatData[n2++];
                this.workArray[3] = this.floatData[n2];
                SFVec4f sFVec4f = new SFVec4f(this.workArray);
                sFVec4f.setParentScope(this);
                this.valueList.set(n, sFVec4f);
                object = sFVec4f;
            }
        } else if (n >= 0) {
            for (int i = this.valueList.size(); i <= n; ++i) {
                SFVec4f sFVec4f = new SFVec4f();
                sFVec4f.setParentScope(this);
                this.valueList.add(sFVec4f);
            }
            this.dataChanged = true;
            this.sizeInt.setValue(this.valueList.size());
            object = (SFVec4f)this.valueList.get(n);
        }
        return object;
    }

    public Object get(String string, Scriptable scriptable) {
        Object object = null;
        if (propertyNames.contains(string)) {
            object = this.sizeInt;
        } else {
            object = super.get(string, scriptable);
            if (object == null && functionNames.contains(string)) {
                object = this.locateFunction(string);
            }
        }
        if (object == null) {
            object = NOT_FOUND;
        }
        return object;
    }

    public void put(int n, Scriptable scriptable, Object object) {
        if (this.readOnly && !this.scriptField) {
            Context.reportError((String)"You are not allowed to directly set this field because the script is marked as read only (directOutput is set to FALSE)");
            return;
        }
        if (!(object instanceof SFVec4f)) {
            Context.reportError((String)OBJECT_NOT_VEC_MSG);
            return;
        }
        SFVec4f sFVec4f = (SFVec4f)object;
        if (sFVec4f.getParentScope() == null) {
            sFVec4f.setParentScope(this);
        }
        if (n >= this.valueList.size()) {
            int n2 = n - this.valueList.size();
            this.valueList.ensureCapacity(n + 1);
            for (int i = 0; i < n2; ++i) {
                this.valueList.add(new SFVec2f());
            }
            this.valueList.add(object);
            this.sizeInt.setValue(this.valueList.size());
        } else if (n >= 0) {
            this.valueList.set(n, object);
        }
        this.dataChanged = true;
    }

    public void put(String string, Scriptable scriptable, Object object) {
        if (object instanceof Function) {
            this.registerFunction(string, object);
        }
    }

    public String jsFunction_toString() {
        return this.toString();
    }

    public boolean jsFunction_equals(Object object) {
        return this.equals(object);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.valueList.size();
        for (int i = 0; i < n; ++i) {
            SFVec4f sFVec4f = (SFVec4f)this.valueList.get(i);
            stringBuffer.append(sFVec4f.toString());
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof MFVec4f)) {
            return false;
        }
        MFVec4f mFVec4f = (MFVec4f)object;
        int n = this.valueList.size();
        if (n != mFVec4f.valueList.size()) {
            return false;
        }
        return this.valueList.equals(mFVec4f.valueList);
    }

    public void updateRawData(float[] fArray, int n) {
        if (this.dataChanged) {
            return;
        }
        this.valueList.clear();
        int n2 = n / 4;
        float[] fArray2 = new float[4];
        if (n != 0) {
            this.floatData = new float[n];
            System.arraycopy(fArray, 0, this.floatData, 0, n);
            this.valueList.ensureCapacity(n2);
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                fArray2[0] = fArray[n3++];
                fArray2[1] = fArray[n3++];
                fArray2[2] = fArray[n3++];
                fArray2[3] = fArray[n3++];
                SFVec4f sFVec4f = new SFVec4f(fArray2);
                this.valueList.add(sFVec4f);
            }
        }
        this.sizeInt.setValue(n2);
    }

    public float[] getRawData() {
        int n = this.valueList.size();
        if (this.floatData == null || this.floatData.length != n * 4) {
            this.floatData = new float[n * 4];
        }
        int n2 = 0;
        if (this.workArray == null) {
            this.workArray = new float[4];
        }
        for (int i = 0; i < n; ++i) {
            SFVec4f sFVec4f = (SFVec4f)this.valueList.get(i);
            if (sFVec4f != null) {
                sFVec4f.getRawData(this.workArray);
                this.floatData[n2++] = this.workArray[0];
                this.floatData[n2++] = this.workArray[1];
                this.floatData[n2++] = this.workArray[2];
                this.floatData[n2++] = this.workArray[3];
                continue;
            }
            n2 += 4;
        }
        return this.floatData;
    }

    public void getRawData(float[] fArray) {
        int n = this.valueList.size();
        int n2 = 0;
        if (this.workArray == null) {
            this.workArray = new float[4];
        }
        for (int i = 0; i < n; ++i) {
            SFVec4f sFVec4f = (SFVec4f)this.valueList.get(i);
            if (sFVec4f != null) {
                sFVec4f.getRawData(this.workArray);
                this.floatData[n2++] = this.workArray[0];
                this.floatData[n2++] = this.workArray[1];
                this.floatData[n2++] = this.workArray[2];
                this.floatData[n2++] = this.workArray[3];
                continue;
            }
            n2 += 4;
        }
    }

    static {
        propertyNames.add("length");
        functionNames = new HashSet();
        functionNames.add("toString");
        functionNames.add("equals");
        jsUndefined = Context.getUndefinedValue();
    }
}

