/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.ecmascript.builtin;

import java.util.ArrayList;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.web3d.util.HashSet;
import org.web3d.vrml.scripting.ecmascript.builtin.FieldScriptableObject;
import org.web3d.vrml.scripting.ecmascript.builtin.ReusableInteger;
import org.web3d.vrml.scripting.ecmascript.builtin.SFVec4d;

public class MFVec4d
extends FieldScriptableObject {
    private static final String OBJECT_NOT_VEC_MSG = "The object you attempted to assign was not an SFVec4d instance";
    private ArrayList valueList = new ArrayList();
    private ReusableInteger sizeInt = new ReusableInteger(0L);
    private double[] floatData;
    private double[] workArray = new double[4];
    private static HashSet propertyNames = new HashSet();
    private static HashSet functionNames;
    private static Object jsUndefined;

    public MFVec4d() {
        super("MFVec4d");
    }

    public MFVec4d(double[] dArray, int n) {
        this();
        int n2 = n / 4;
        double[] dArray2 = new double[4];
        if (n != 0) {
            this.floatData = new double[n];
            System.arraycopy(dArray, 0, this.floatData, 0, n);
            this.valueList.ensureCapacity(n2);
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                dArray2[0] = dArray[n3++];
                dArray2[1] = dArray[n3++];
                dArray2[2] = dArray[n3++];
                dArray2[3] = dArray[n3++];
                SFVec4d sFVec4d = new SFVec4d(dArray2);
                this.valueList.add(sFVec4d);
            }
        }
        this.sizeInt.setValue(n2);
    }

    public MFVec4d(Object[] objectArray) {
        this();
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == jsUndefined) continue;
            if (!(objectArray[i] instanceof SFVec4d)) {
                throw new IllegalArgumentException("Non SFVec4d given");
            }
            ++n;
            this.valueList.add(objectArray[i]);
        }
        this.sizeInt.setValue(n);
    }

    public static Scriptable jsConstructor(Context context, Object[] objectArray, Function function, boolean bl) {
        MFVec4d mFVec4d = new MFVec4d(objectArray);
        return mFVec4d;
    }

    public boolean has(int n, Scriptable scriptable) {
        return n >= 0;
    }

    public boolean has(String string, Scriptable scriptable) {
        boolean bl = false;
        bl = propertyNames.contains(string) ? true : super.has(string, scriptable);
        return bl;
    }

    public Object get(int n, Scriptable scriptable) {
        Object object = NOT_FOUND;
        if (n >= 0 && n < this.valueList.size()) {
            object = this.valueList.get(n);
            if (object == null) {
                int n2 = n * 4;
                this.workArray[0] = this.floatData[n2++];
                this.workArray[1] = this.floatData[n2++];
                this.workArray[2] = this.floatData[n2++];
                this.workArray[3] = this.floatData[n2];
                SFVec4d sFVec4d = new SFVec4d(this.workArray);
                sFVec4d.setParentScope(this);
                this.valueList.set(n, sFVec4d);
                object = sFVec4d;
            }
        } else if (n >= 0) {
            for (int i = this.valueList.size(); i <= n; ++i) {
                SFVec4d sFVec4d = new SFVec4d();
                sFVec4d.setParentScope(this);
                this.valueList.add(sFVec4d);
            }
            this.dataChanged = true;
            this.sizeInt.setValue(this.valueList.size());
            object = (SFVec4d)this.valueList.get(n);
        }
        return object;
    }

    public Object get(String string, Scriptable scriptable) {
        Object object = null;
        if (propertyNames.contains(string)) {
            object = this.sizeInt;
        } else {
            object = super.get(string, scriptable);
            if (object == null && functionNames.contains(string)) {
                object = this.locateFunction(string);
            }
        }
        if (object == null) {
            object = NOT_FOUND;
        }
        return object;
    }

    public void put(int n, Scriptable scriptable, Object object) {
        if (this.readOnly && !this.scriptField) {
            Context.reportError((String)"You are not allowed to directly set this field because the script is marked as read only (directOutput is set to FALSE)");
            return;
        }
        if (!(object instanceof SFVec4d)) {
            Context.reportError((String)OBJECT_NOT_VEC_MSG);
            return;
        }
        SFVec4d sFVec4d = (SFVec4d)object;
        if (sFVec4d.getParentScope() == null) {
            sFVec4d.setParentScope(this);
        }
        if (n >= this.valueList.size()) {
            int n2 = n - this.valueList.size();
            this.valueList.ensureCapacity(n + 1);
            for (int i = 0; i < n2; ++i) {
                this.valueList.add(new SFVec4d());
            }
            this.valueList.add(object);
            this.sizeInt.setValue(this.valueList.size());
        } else if (n >= 0) {
            this.valueList.set(n, object);
        }
        this.dataChanged = true;
    }

    public void put(String string, Scriptable scriptable, Object object) {
        if (object instanceof Function) {
            this.registerFunction(string, object);
        }
    }

    public String jsFunction_toString() {
        return this.toString();
    }

    public boolean jsFunction_equals(Object object) {
        return this.equals(object);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.valueList.size();
        for (int i = 0; i < n; ++i) {
            SFVec4d sFVec4d = (SFVec4d)this.valueList.get(i);
            stringBuffer.append(sFVec4d.toString());
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof MFVec4d)) {
            return false;
        }
        MFVec4d mFVec4d = (MFVec4d)object;
        int n = this.valueList.size();
        if (n != mFVec4d.valueList.size()) {
            return false;
        }
        return this.valueList.equals(mFVec4d.valueList);
    }

    public void updateRawData(double[] dArray, int n) {
        if (this.dataChanged) {
            return;
        }
        this.valueList.clear();
        int n2 = n / 4;
        double[] dArray2 = new double[4];
        if (n != 0) {
            this.floatData = new double[n];
            System.arraycopy(dArray, 0, this.floatData, 0, n);
            this.valueList.ensureCapacity(n2);
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                dArray2[0] = dArray[n3++];
                dArray2[1] = dArray[n3++];
                dArray2[2] = dArray[n3++];
                dArray2[3] = dArray[n3++];
                SFVec4d sFVec4d = new SFVec4d(dArray2);
                this.valueList.add(sFVec4d);
            }
        }
        this.sizeInt.setValue(n2);
    }

    public double[] getRawData() {
        int n = this.valueList.size();
        if (this.floatData == null || this.floatData.length != n * 4) {
            this.floatData = new double[n * 4];
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            SFVec4d sFVec4d = (SFVec4d)this.valueList.get(i);
            if (sFVec4d != null) {
                sFVec4d.getRawData(this.workArray);
                this.floatData[n2++] = this.workArray[0];
                this.floatData[n2++] = this.workArray[1];
                this.floatData[n2++] = this.workArray[2];
                this.floatData[n2++] = this.workArray[3];
                continue;
            }
            n2 += 4;
        }
        return this.floatData;
    }

    public void getRawData(float[] fArray) {
        int n = this.valueList.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            SFVec4d sFVec4d = (SFVec4d)this.valueList.get(i);
            if (sFVec4d != null) {
                sFVec4d.getRawData(this.workArray);
                this.floatData[n2++] = this.workArray[0];
                this.floatData[n2++] = this.workArray[1];
                this.floatData[n2++] = this.workArray[2];
                this.floatData[n2++] = this.workArray[3];
                continue;
            }
            n2 += 4;
        }
    }

    public void getRawData(double[] dArray) {
        int n = this.valueList.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            SFVec4d sFVec4d = (SFVec4d)this.valueList.get(i);
            if (sFVec4d != null) {
                sFVec4d.getRawData(this.workArray);
                this.floatData[n2++] = this.workArray[0];
                this.floatData[n2++] = this.workArray[1];
                this.floatData[n2++] = this.workArray[2];
                this.floatData[n2++] = this.workArray[3];
                continue;
            }
            n2 += 4;
        }
    }

    static {
        propertyNames.add("length");
        functionNames = new HashSet();
        functionNames.add("toString");
        functionNames.add("equals");
        jsUndefined = Context.getUndefinedValue();
    }
}

