/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.ecmascript.builtin;

import java.util.ArrayList;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.web3d.util.HashSet;
import org.web3d.vrml.scripting.ecmascript.builtin.FieldScriptableObject;
import org.web3d.vrml.scripting.ecmascript.builtin.ReusableInteger;

public class MFString
extends FieldScriptableObject {
    private static final String OBJECT_NOT_STRING_MSG = "The object you attempted to assign was not a String instance";
    private ArrayList stringList;
    private ReusableInteger sizeInt = new ReusableInteger(0L);
    private static HashSet propertyNames = new HashSet();
    private static HashSet functionNames;
    private static Object jsUndefined;

    public MFString() {
        super("MFString");
        this.stringList = new ArrayList();
    }

    public MFString(String[] stringArray, int n) {
        this();
        if (n > 0) {
            this.stringList.ensureCapacity(n);
            for (int i = 0; i < n; ++i) {
                this.stringList.add(stringArray[i]);
            }
            this.sizeInt.setValue(n);
        } else {
            this.sizeInt.setValue(0L);
        }
    }

    public MFString(Object[] objectArray) {
        this();
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == jsUndefined) continue;
            Object object = !(objectArray[i] instanceof String) ? objectArray[i].toString() : objectArray[i];
            if (!(object instanceof String)) {
                throw new IllegalArgumentException("Non String given");
            }
            ++n;
            this.stringList.add(object);
        }
        this.sizeInt.setValue(n);
    }

    public static Scriptable jsConstructor(Context context, Object[] objectArray, Function function, boolean bl) {
        MFString mFString = new MFString(objectArray);
        return mFString;
    }

    public boolean has(int n, Scriptable scriptable) {
        return n >= 0;
    }

    public boolean has(String string, Scriptable scriptable) {
        boolean bl = false;
        bl = propertyNames.contains(string) ? true : super.has(string, scriptable);
        return bl;
    }

    public Object get(int n, Scriptable scriptable) {
        Object object = NOT_FOUND;
        if (n >= 0 && n < this.sizeInt.intValue()) {
            object = this.stringList.get(n);
        } else if (n >= 0) {
            for (int i = this.stringList.size(); i <= n; ++i) {
                String string = new String();
                this.stringList.add(string);
            }
            this.sizeInt.setValue(this.stringList.size());
            object = (String)this.stringList.get(n);
        }
        return object;
    }

    public Object get(String string, Scriptable scriptable) {
        Object object = null;
        if (propertyNames.contains(string)) {
            return this.sizeInt;
        }
        object = super.get(string, scriptable);
        if (object == null && functionNames.contains(string)) {
            object = this.locateFunction(string);
        }
        if (object == null) {
            object = NOT_FOUND;
        }
        return object;
    }

    public void put(int n, Scriptable scriptable, Object object) {
        if (this.readOnly && !this.scriptField) {
            Context.reportError((String)"You are not allowed to directly set this field because the script is marked as read only (directOutput is set to FALSE)");
            return;
        }
        if (!(object instanceof String)) {
            if (object instanceof Number) {
                object = object.toString();
            } else {
                Context.reportError((String)OBJECT_NOT_STRING_MSG);
                return;
            }
        }
        if (n >= this.sizeInt.intValue()) {
            int n2 = n - this.stringList.size();
            this.stringList.ensureCapacity(n + 1);
            for (int i = 0; i < n2; ++i) {
                this.stringList.add(new String());
            }
            this.stringList.add(object);
            this.sizeInt.setValue(this.stringList.size());
        } else if (n >= 0) {
            this.stringList.set(n, object);
        }
        this.dataChanged = true;
    }

    public void put(String string, Scriptable scriptable, Object object) {
        if (object instanceof Function) {
            this.registerFunction(string, object);
        }
    }

    public String jsFunction_toString() {
        return this.toString();
    }

    public boolean jsFunction_equals(Object object) {
        return this.equals(object);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.stringList.size();
        for (int i = 0; i < n; ++i) {
            String string = (String)this.stringList.get(i);
            stringBuffer.append('\"');
            stringBuffer.append(string);
            stringBuffer.append("\"\n");
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof MFString)) {
            return false;
        }
        MFString mFString = (MFString)object;
        int n = this.stringList.size();
        if (n != mFString.stringList.size()) {
            return false;
        }
        return this.stringList.equals(mFString.stringList);
    }

    public void updateRawData(String[] stringArray, int n) {
        if (this.dataChanged) {
            return;
        }
        this.stringList.clear();
        if (n != 0) {
            this.stringList.ensureCapacity(n);
            for (int i = 0; i < n; ++i) {
                this.stringList.add(stringArray[i]);
            }
        }
        this.sizeInt.setValue(n);
    }

    public String[] getRawData() {
        int n = this.sizeInt.intValue();
        String[] stringArray = new String[n];
        if (n != 0) {
            this.stringList.toArray(stringArray);
        }
        return stringArray;
    }

    static {
        propertyNames.add("length");
        functionNames = new HashSet();
        functionNames.add("toString");
        functionNames.add("equals");
        jsUndefined = Context.getUndefinedValue();
    }
}

