/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.ecmascript.builtin;

import java.util.ArrayList;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.web3d.util.HashSet;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.scripting.ecmascript.builtin.FieldScriptableObject;
import org.web3d.vrml.scripting.ecmascript.builtin.NodeFieldData;
import org.web3d.vrml.scripting.ecmascript.builtin.NodeFieldObject;
import org.web3d.vrml.scripting.ecmascript.builtin.ReusableInteger;
import org.web3d.vrml.scripting.ecmascript.builtin.SFNode;

public class MFNode
extends NodeFieldObject {
    private static final String OBJECT_NOT_NODE_MSG = "The object you attempted to assign was not an SFNode instance";
    private ArrayList<SFNode> nodeList = new ArrayList();
    private ReusableInteger sizeInt;
    private ArrayList<SFNode> changedNodes = new ArrayList();
    private boolean localChanges = false;
    private static HashSet propertyNames = new HashSet();
    private static HashSet functionNames;
    private static Object jsUndefined;

    public MFNode() {
        super("MFNode");
        this.sizeInt = new ReusableInteger(0L);
    }

    public MFNode(VRMLNodeType vRMLNodeType, int n, VRMLNodeType[] vRMLNodeTypeArray, int n2) {
        this();
        this.parentNode = vRMLNodeType;
        this.parentFieldIndex = n;
        if (n2 != 0) {
            this.nodeList.ensureCapacity(vRMLNodeTypeArray.length);
            for (int i = 0; i < n2; ++i) {
                if (vRMLNodeTypeArray[i] != null) {
                    SFNode sFNode = new SFNode(vRMLNodeType, n, vRMLNodeTypeArray[i]);
                    sFNode.setParentScope(this);
                    this.nodeList.add(sFNode);
                    continue;
                }
                this.nodeList.add(null);
            }
        }
        this.sizeInt.setValue(n2);
    }

    public MFNode(Object[] objectArray) {
        this();
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == jsUndefined) continue;
            if (!(objectArray[i] instanceof SFNode)) {
                throw new IllegalArgumentException("Non SFNode given");
            }
            SFNode sFNode = (SFNode)objectArray[i];
            if (sFNode.getParentScope() == null) {
                sFNode.setParentScope(this);
            }
            ++n;
            this.nodeList.add(sFNode);
        }
        this.sizeInt.setValue(n);
    }

    public static Scriptable jsConstructor(Context context, Object[] objectArray, Function function, boolean bl) {
        MFNode mFNode = new MFNode(objectArray);
        return mFNode;
    }

    public boolean has(int n, Scriptable scriptable) {
        return n >= 0;
    }

    public boolean has(String string, Scriptable scriptable) {
        boolean bl = false;
        bl = propertyNames.contains(string) ? true : super.has(string, scriptable);
        return bl;
    }

    public Object get(int n, Scriptable scriptable) {
        Object object = NOT_FOUND;
        if (n >= 0 && n < this.nodeList.size()) {
            object = this.nodeList.get(n);
            if (this.readOnly) {
                ((FieldScriptableObject)object).setReadOnly();
            }
        }
        return object;
    }

    public Object get(String string, Scriptable scriptable) {
        Object object = null;
        if (propertyNames.contains(string)) {
            object = this.sizeInt;
        } else {
            object = super.get(string, scriptable);
            if (object == null && functionNames.contains(string)) {
                object = this.locateFunction(string);
            }
        }
        if (object == null) {
            object = NOT_FOUND;
        }
        return object;
    }

    public void put(int n, Scriptable scriptable, Object object) {
        if (this.readOnly && !this.scriptField) {
            Context.reportError((String)"You are not allowed to directly set this field because the script is marked as read only (directOutput is set to FALSE)");
            return;
        }
        if (object != null && !(object instanceof SFNode)) {
            Context.reportError((String)OBJECT_NOT_NODE_MSG);
            return;
        }
        if (object != null) {
            SFNode sFNode = (SFNode)object;
            sFNode.setParentScope(this);
        }
        if (n >= this.nodeList.size()) {
            for (int i = this.nodeList.size(); i < n; ++i) {
                this.nodeList.add(null);
            }
            this.nodeList.add((SFNode)object);
            this.sizeInt.setValue(this.nodeList.size());
        } else if (n >= 0) {
            this.nodeList.set(n, (SFNode)object);
        }
        if (object instanceof NodeFieldObject) {
            ((NodeFieldObject)object).realize();
        }
        if (!this.changedNodes.contains(object)) {
            this.changedNodes.add((SFNode)object);
        }
        this.dataChanged = true;
        this.localChanges = true;
    }

    public void put(String string, Scriptable scriptable, Object object) {
        if (object instanceof Function) {
            this.registerFunction(string, object);
        }
    }

    public String jsFunction_toString() {
        return this.toString();
    }

    public boolean jsFunction_equals(Object object) {
        return this.equals(object);
    }

    public Object getChangedFields() {
        ArrayList<Object> arrayList;
        Object object;
        int n = this.changedNodes.size();
        if (n == 0) {
            return null;
        }
        ArrayList<Object> arrayList2 = null;
        if (n == 1) {
            object = this.changedNodes.get(0);
            if (object != null) {
                arrayList2 = ((SFNode)object).getChangedFields();
            }
        } else {
            for (int i = 0; i < n; ++i) {
                arrayList = this.changedNodes.get(i);
                Object object2 = null;
                if (arrayList != null) {
                    object2 = ((SFNode)((Object)arrayList)).getChangedFields();
                }
                if (object2 == null) continue;
                if (arrayList2 != null) {
                    ArrayList<Object> arrayList3;
                    if (arrayList2 instanceof ArrayList) {
                        arrayList3 = arrayList2;
                    } else {
                        arrayList3 = new ArrayList<Object>();
                        arrayList3.add(arrayList2);
                    }
                    if (object2 instanceof ArrayList) {
                        arrayList3.addAll((ArrayList)object2);
                    } else {
                        arrayList3.add(object2);
                    }
                    arrayList2 = arrayList3;
                    continue;
                }
                arrayList2 = object2;
            }
        }
        this.changedNodes.clear();
        if (this.localChanges) {
            object = new NodeFieldData();
            ((NodeFieldData)object).node = this.parentNode;
            ((NodeFieldData)object).fieldIndex = this.parentFieldIndex;
            ((NodeFieldData)object).value = this;
            this.localChanges = false;
            if (arrayList2 != null) {
                if (arrayList2 instanceof ArrayList) {
                    arrayList = arrayList2;
                } else {
                    arrayList = new ArrayList<Object>();
                    arrayList.add(arrayList2);
                }
                arrayList.add(object);
                arrayList2 = arrayList;
            } else {
                arrayList2 = object;
            }
        }
        return arrayList2;
    }

    public void realize() {
        for (int i = 0; i < this.nodeList.size(); ++i) {
            SFNode sFNode = this.nodeList.get(i);
            if (sFNode == null) continue;
            sFNode.realize();
        }
    }

    public boolean hasChanged() {
        boolean bl = super.hasChanged();
        int n = this.nodeList.size();
        for (int i = 0; i < n; ++i) {
            SFNode sFNode = this.nodeList.get(i);
            if (sFNode == null || !sFNode.hasChanged()) continue;
            if (!this.changedNodes.contains(sFNode)) {
                this.changedNodes.add(sFNode);
            }
            bl = true;
        }
        return bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[\n");
        int n = this.nodeList.size();
        for (int i = 0; i < n; ++i) {
            SFNode sFNode = this.nodeList.get(i);
            if (sFNode == null) {
                stringBuffer.append("NULL\n");
                continue;
            }
            stringBuffer.append(sFNode.toString());
            stringBuffer.append('\n');
        }
        stringBuffer.append(" ]\n");
        return stringBuffer.toString();
    }

    public boolean hasLocalChanges() {
        boolean bl = this.localChanges;
        this.localChanges = false;
        return bl;
    }

    public void updateRawData(VRMLNodeType[] vRMLNodeTypeArray, int n) {
        if (this.dataChanged) {
            return;
        }
        if (n != 0) {
            this.nodeList.clear();
            this.nodeList.ensureCapacity(n);
            for (int i = 0; i < n; ++i) {
                if (vRMLNodeTypeArray[i] != null) {
                    SFNode sFNode = new SFNode(this.parentNode, this.parentFieldIndex, vRMLNodeTypeArray[i]);
                    sFNode.setParentScope(this);
                    this.nodeList.add(sFNode);
                    continue;
                }
                this.nodeList.add(null);
            }
        }
        this.sizeInt.setValue(n);
    }

    public VRMLNodeType[] getRawData() {
        int n = this.nodeList.size();
        VRMLNodeType[] vRMLNodeTypeArray = new VRMLNodeType[n];
        for (int i = 0; i < n; ++i) {
            SFNode sFNode = this.nodeList.get(i);
            if (sFNode == null) continue;
            vRMLNodeTypeArray[i] = sFNode.getImplNode();
        }
        return vRMLNodeTypeArray;
    }

    static {
        propertyNames.add("length");
        functionNames = new HashSet();
        functionNames.add("toString");
        functionNames.add("equals");
        jsUndefined = Context.getUndefinedValue();
    }
}

