/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.ecmascript.builtin;

import java.util.ArrayList;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.web3d.util.HashSet;
import org.web3d.vrml.scripting.ecmascript.builtin.FieldScriptableObject;
import org.web3d.vrml.scripting.ecmascript.builtin.ReusableInteger;

public class MFInt32
extends FieldScriptableObject {
    private static final String OBJECT_NOT_Int32_MSG = "The object you attempted to assign was not a int instance";
    private ArrayList valueList;
    private ReusableInteger sizeInt = new ReusableInteger(0L);
    private static HashSet propertyNames = new HashSet();
    private static HashSet functionNames;
    private static Object jsUndefined;

    public MFInt32() {
        super("MFInt32");
        this.valueList = new ArrayList();
    }

    public MFInt32(int[] nArray, int n) {
        this();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                this.valueList.add(new ReusableInteger(nArray[i]));
            }
            this.sizeInt.setValue(n);
        } else {
            this.sizeInt.setValue(0L);
        }
    }

    public MFInt32(int[] nArray, int n, int n2) {
        this();
        if (nArray != null && n2 > 0) {
            for (int i = n; i < n2; ++i) {
                this.valueList.add(new ReusableInteger(nArray[i]));
            }
            this.sizeInt.setValue(nArray.length);
        } else {
            this.sizeInt.setValue(0L);
        }
    }

    public MFInt32(Object[] objectArray) {
        this();
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == jsUndefined) continue;
            if (!(objectArray[i] instanceof Number)) {
                throw new IllegalArgumentException("Non Int32 given");
            }
            ++n;
            this.valueList.add(new ReusableInteger(((Number)objectArray[i]).intValue()));
        }
        this.sizeInt.setValue(n);
    }

    public static Scriptable jsConstructor(Context context, Object[] objectArray, Function function, boolean bl) {
        MFInt32 mFInt32 = new MFInt32(objectArray);
        return mFInt32;
    }

    public boolean has(int n, Scriptable scriptable) {
        return n >= 0;
    }

    public boolean has(String string, Scriptable scriptable) {
        boolean bl = false;
        bl = propertyNames.contains(string) ? true : super.has(string, scriptable);
        return bl;
    }

    public Object get(int n, Scriptable scriptable) {
        Object object = NOT_FOUND;
        if (n >= 0 && n < this.valueList.size()) {
            object = (ReusableInteger)this.valueList.get(n);
        } else if (n >= 0) {
            for (int i = this.valueList.size(); i <= n; ++i) {
                ReusableInteger reusableInteger = new ReusableInteger(0L);
                if (i == n) {
                    object = reusableInteger;
                }
                this.valueList.add(reusableInteger);
            }
            this.sizeInt.setValue(this.valueList.size());
        }
        return object;
    }

    public Object get(String string, Scriptable scriptable) {
        Object object = null;
        if (propertyNames.contains(string)) {
            return this.sizeInt;
        }
        object = super.get(string, scriptable);
        if (object == null && functionNames.contains(string)) {
            object = this.locateFunction(string);
        }
        if (object == null) {
            object = NOT_FOUND;
        }
        return object;
    }

    public void put(int n, Scriptable scriptable, Object object) {
        if (this.readOnly && !this.scriptField) {
            Context.reportError((String)"You are not allowed to directly set this field because the script is marked as read only (directOutput is set to FALSE)");
            return;
        }
        if (!(object instanceof Number)) {
            Context.reportError((String)OBJECT_NOT_Int32_MSG);
            return;
        }
        Number number = (Number)object;
        ReusableInteger reusableInteger = new ReusableInteger(number.intValue());
        if (n >= this.valueList.size()) {
            this.valueList.add(reusableInteger);
            this.sizeInt.setValue(this.valueList.size());
        } else if (n >= 0) {
            this.valueList.set(n, reusableInteger);
        }
        this.dataChanged = true;
    }

    public void put(String string, Scriptable scriptable, Object object) {
        if (object instanceof Function) {
            this.registerFunction(string, object);
        }
    }

    public String jsFunction_toString() {
        return this.toString();
    }

    public boolean jsFunction_equals(Object object) {
        return this.equals(object);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.valueList.size();
        for (int i = 0; i < n; ++i) {
            ReusableInteger reusableInteger = (ReusableInteger)this.valueList.get(i);
            stringBuffer.append(reusableInteger);
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof MFInt32)) {
            return false;
        }
        MFInt32 mFInt32 = (MFInt32)object;
        int n = this.valueList.size();
        if (n != mFInt32.valueList.size()) {
            return false;
        }
        return this.valueList.equals(mFInt32.valueList);
    }

    public void updateRawData(int[] nArray, int n) {
        if (this.dataChanged) {
            return;
        }
        this.valueList.clear();
        for (int i = 0; i < n; ++i) {
            this.valueList.add(new ReusableInteger(nArray[i]));
        }
        this.sizeInt.setValue(n);
    }

    public int[] getRawData() {
        int[] nArray = new int[this.valueList.size()];
        for (int i = 0; i < this.valueList.size(); ++i) {
            nArray[i] = ((ReusableInteger)this.valueList.get(i)).intValue();
        }
        return nArray;
    }

    public void getRawData(int[] nArray) {
        for (int i = 0; i < this.valueList.size(); ++i) {
            nArray[i] = ((ReusableInteger)this.valueList.get(i)).intValue();
        }
    }

    static {
        propertyNames.add("length");
        functionNames = new HashSet();
        functionNames.add("toString");
        functionNames.add("equals");
        jsUndefined = Context.getUndefinedValue();
    }
}

