/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.ecmascript.builtin;

import java.util.ArrayList;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.web3d.util.HashSet;
import org.web3d.vrml.scripting.ecmascript.builtin.FieldScriptableObject;
import org.web3d.vrml.scripting.ecmascript.builtin.ReusableFloat;
import org.web3d.vrml.scripting.ecmascript.builtin.ReusableInteger;

public class MFFloat
extends FieldScriptableObject {
    private static final String OBJECT_NOT_FLOAT_MSG = "The object you attempted to assign was not a float instance";
    private ArrayList valueList;
    private ReusableInteger sizeInt = new ReusableInteger(0L);
    private static HashSet propertyNames = new HashSet();
    private static HashSet functionNames;
    private static Object jsUndefined;

    public MFFloat() {
        super("MFFloat");
        this.valueList = new ArrayList();
    }

    public MFFloat(float[] fArray, int n) {
        this();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                this.valueList.add(new ReusableFloat(fArray[i]));
            }
            this.sizeInt.setValue(n);
        } else {
            this.sizeInt.setValue(0L);
        }
    }

    public MFFloat(Object[] objectArray) {
        this();
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == jsUndefined) continue;
            if (!(objectArray[i] instanceof Number)) {
                throw new IllegalArgumentException("Non Float given");
            }
            ++n;
            this.valueList.add(new ReusableFloat(((Number)objectArray[i]).floatValue()));
        }
        this.sizeInt.setValue(n);
    }

    public static Scriptable jsConstructor(Context context, Object[] objectArray, Function function, boolean bl) {
        MFFloat mFFloat = new MFFloat(objectArray);
        return mFFloat;
    }

    public boolean has(int n, Scriptable scriptable) {
        return n >= 0;
    }

    public boolean has(String string, Scriptable scriptable) {
        boolean bl = false;
        bl = propertyNames.contains(string) ? true : super.has(string, scriptable);
        return bl;
    }

    public Object get(int n, Scriptable scriptable) {
        Object object = NOT_FOUND;
        if (n >= 0 && n < this.valueList.size()) {
            object = (ReusableFloat)this.valueList.get(n);
        } else if (n >= 0) {
            for (int i = this.valueList.size(); i <= n; ++i) {
                ReusableFloat reusableFloat = new ReusableFloat(0.0);
                if (i == n) {
                    object = reusableFloat;
                }
                this.valueList.add(reusableFloat);
            }
            this.sizeInt.setValue(this.valueList.size());
        }
        return object;
    }

    public Object get(String string, Scriptable scriptable) {
        Object object = null;
        if (propertyNames.contains(string)) {
            return this.sizeInt;
        }
        object = super.get(string, scriptable);
        if (object == null && functionNames.contains(string)) {
            object = this.locateFunction(string);
        }
        if (object == null) {
            object = NOT_FOUND;
        }
        return object;
    }

    public void put(int n, Scriptable scriptable, Object object) {
        if (this.readOnly && !this.scriptField) {
            Context.reportError((String)"You are not allowed to directly set this field because the script is marked as read only (directOutput is set to FALSE)");
            return;
        }
        if (!(object instanceof Number)) {
            Context.reportError((String)OBJECT_NOT_FLOAT_MSG);
            return;
        }
        Number number = (Number)object;
        ReusableFloat reusableFloat = new ReusableFloat(number.doubleValue());
        if (n >= this.valueList.size()) {
            this.valueList.add(reusableFloat);
            this.sizeInt.setValue(this.valueList.size());
        } else if (n >= 0) {
            this.valueList.set(n, reusableFloat);
        }
        this.dataChanged = true;
    }

    public void put(String string, Scriptable scriptable, Object object) {
        if (object instanceof Function) {
            this.registerFunction(string, object);
        }
    }

    public String jsFunction_toString() {
        return this.toString();
    }

    public boolean jsFunction_equals(Object object) {
        return this.equals(object);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.valueList.size();
        for (int i = 0; i < n; ++i) {
            ReusableFloat reusableFloat = (ReusableFloat)this.valueList.get(i);
            stringBuffer.append(reusableFloat);
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof MFFloat)) {
            return false;
        }
        MFFloat mFFloat = (MFFloat)object;
        int n = this.valueList.size();
        if (n != mFFloat.valueList.size()) {
            return false;
        }
        return this.valueList.equals(mFFloat.valueList);
    }

    public void updateRawData(float[] fArray, int n) {
        if (this.dataChanged) {
            return;
        }
        this.valueList.clear();
        for (int i = 0; i < n; ++i) {
            this.valueList.add(new ReusableFloat(fArray[i]));
        }
        this.sizeInt.setValue(n);
    }

    public float[] getRawData() {
        float[] fArray = new float[this.valueList.size()];
        for (int i = 0; i < this.valueList.size(); ++i) {
            fArray[i] = ((ReusableFloat)this.valueList.get(i)).floatValue();
        }
        return fArray;
    }

    public void getRawData(float[] fArray) {
        for (int i = 0; i < this.valueList.size(); ++i) {
            fArray[i] = ((ReusableFloat)this.valueList.get(i)).floatValue();
        }
    }

    static {
        propertyNames.add("length");
        functionNames = new HashSet();
        functionNames.add("toString");
        functionNames.add("equals");
        jsUndefined = Context.getUndefinedValue();
    }
}

