/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.ecmascript.builtin;

import java.util.ArrayList;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.web3d.util.HashSet;
import org.web3d.vrml.scripting.ecmascript.builtin.FieldScriptableObject;
import org.web3d.vrml.scripting.ecmascript.builtin.ReusableDouble;
import org.web3d.vrml.scripting.ecmascript.builtin.ReusableInteger;

public class MFDouble
extends FieldScriptableObject {
    private static final String OBJECT_NOT_FLOAT_MSG = "The object you attempted to assign was not a float instance";
    private ArrayList valueList;
    private ReusableInteger sizeInt = new ReusableInteger(0L);
    private static HashSet propertyNames = new HashSet();
    private static HashSet functionNames;
    private static Object jsUndefined;

    public MFDouble() {
        super("MFDouble");
        this.valueList = new ArrayList();
    }

    public MFDouble(float[] fArray, int n) {
        this();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                this.valueList.add(new ReusableDouble(fArray[i]));
            }
            this.sizeInt.setValue(n);
        } else {
            this.sizeInt.setValue(0L);
        }
    }

    public MFDouble(double[] dArray, int n) {
        this();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                this.valueList.add(new ReusableDouble(dArray[i]));
            }
            this.sizeInt.setValue(n);
        } else {
            this.sizeInt.setValue(0L);
        }
    }

    public MFDouble(Object[] objectArray) {
        this();
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == jsUndefined) continue;
            if (!(objectArray[i] instanceof Number)) {
                throw new IllegalArgumentException("Non Double given");
            }
            ++n;
            this.valueList.add(new ReusableDouble(((Number)objectArray[i]).floatValue()));
        }
        this.sizeInt.setValue(n);
    }

    public static Scriptable jsConstructor(Context context, Object[] objectArray, Function function, boolean bl) {
        MFDouble mFDouble = new MFDouble(objectArray);
        return mFDouble;
    }

    public boolean has(int n, Scriptable scriptable) {
        return n >= 0;
    }

    public boolean has(String string, Scriptable scriptable) {
        boolean bl = false;
        bl = propertyNames.contains(string) ? true : super.has(string, scriptable);
        return bl;
    }

    public Object get(int n, Scriptable scriptable) {
        Object object = NOT_FOUND;
        if (n >= 0 && n < this.valueList.size()) {
            object = (ReusableDouble)this.valueList.get(n);
        } else if (n >= 0) {
            for (int i = this.valueList.size(); i <= n; ++i) {
                ReusableDouble reusableDouble = new ReusableDouble(0.0);
                if (i == n) {
                    object = reusableDouble;
                }
                this.valueList.add(reusableDouble);
            }
            this.sizeInt.setValue(this.valueList.size());
        }
        return object;
    }

    public Object get(String string, Scriptable scriptable) {
        Object object = null;
        if (propertyNames.contains(string)) {
            return this.sizeInt;
        }
        object = super.get(string, scriptable);
        if (object == null && functionNames.contains(string)) {
            object = this.locateFunction(string);
        }
        if (object == null) {
            object = NOT_FOUND;
        }
        return object;
    }

    public void put(int n, Scriptable scriptable, Object object) {
        if (this.readOnly && !this.scriptField) {
            Context.reportError((String)"You are not allowed to directly set this field because the script is marked as read only (directOutput is set to FALSE)");
            return;
        }
        if (!(object instanceof Number)) {
            Context.reportError((String)OBJECT_NOT_FLOAT_MSG);
            return;
        }
        Number number = (Number)object;
        ReusableDouble reusableDouble = new ReusableDouble(number.doubleValue());
        if (n >= this.valueList.size()) {
            this.valueList.add(reusableDouble);
            this.sizeInt.setValue(this.valueList.size());
        } else if (n >= 0) {
            this.valueList.set(n, reusableDouble);
        }
        this.dataChanged = true;
    }

    public void put(String string, Scriptable scriptable, Object object) {
        if (object instanceof Function) {
            this.registerFunction(string, object);
        }
    }

    public String jsFunction_toString() {
        return this.toString();
    }

    public boolean jsFunction_equals(Object object) {
        return this.equals(object);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.valueList.size();
        for (int i = 0; i < n; ++i) {
            ReusableDouble reusableDouble = (ReusableDouble)this.valueList.get(i);
            stringBuffer.append(reusableDouble);
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof MFDouble)) {
            return false;
        }
        MFDouble mFDouble = (MFDouble)object;
        int n = this.valueList.size();
        if (n != mFDouble.valueList.size()) {
            return false;
        }
        return this.valueList.equals(mFDouble.valueList);
    }

    public void updateRawData(double[] dArray, int n) {
        if (this.dataChanged) {
            return;
        }
        this.valueList.clear();
        for (int i = 0; i < n; ++i) {
            this.valueList.add(new ReusableDouble(dArray[i]));
        }
        this.sizeInt.setValue(n);
    }

    public double[] getRawData() {
        double[] dArray = new double[this.valueList.size()];
        for (int i = 0; i < this.valueList.size(); ++i) {
            dArray[i] = ((ReusableDouble)this.valueList.get(i)).doubleValue();
        }
        return dArray;
    }

    public void getRawData(float[] fArray) {
        for (int i = 0; i < this.valueList.size(); ++i) {
            fArray[i] = ((ReusableDouble)this.valueList.get(i)).floatValue();
        }
    }

    public void getRawData(double[] dArray) {
        for (int i = 0; i < this.valueList.size(); ++i) {
            dArray[i] = ((ReusableDouble)this.valueList.get(i)).doubleValue();
        }
    }

    static {
        propertyNames.add("length");
        functionNames = new HashSet();
        functionNames.add("toString");
        functionNames.add("equals");
        jsUndefined = Context.getUndefinedValue();
    }
}

