/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.ecmascript.builtin;

import java.util.ArrayList;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.web3d.util.HashSet;
import org.web3d.vrml.scripting.ecmascript.builtin.FieldScriptableObject;
import org.web3d.vrml.scripting.ecmascript.builtin.ReusableInteger;
import org.web3d.vrml.scripting.ecmascript.builtin.SFColorRGBA;

public class MFColorRGBA
extends FieldScriptableObject {
    private static final String OBJECT_NOT_COLOR_MSG = "The object you attempted to assign was not an SFColorRGBA instance";
    private ArrayList valueList = new ArrayList();
    private ReusableInteger sizeInt = new ReusableInteger(0L);
    private float[] floatData;
    private float[] workArray;
    private static HashSet propertyNames = new HashSet();
    private static HashSet functionNames;
    private static Object jsUndefined;

    public MFColorRGBA() {
        super("MFColorRGBA");
    }

    public MFColorRGBA(float[] fArray, int n) {
        this();
        this.workArray = new float[4];
        int n2 = n / 4;
        if (n != 0) {
            this.floatData = new float[n];
            System.arraycopy(fArray, 0, this.floatData, 0, n);
            this.valueList.ensureCapacity(n2);
            for (int i = 0; i < n2; ++i) {
                this.valueList.add(null);
            }
        }
        this.sizeInt.setValue(n2);
    }

    public MFColorRGBA(Object[] objectArray) {
        this();
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == jsUndefined) continue;
            if (!(objectArray[i] instanceof SFColorRGBA)) {
                throw new IllegalArgumentException("Non SFColorRGBA given");
            }
            ++n;
            this.valueList.add(objectArray[i]);
        }
        this.sizeInt.setValue(n);
    }

    public static Scriptable jsConstructor(Context context, Object[] objectArray, Function function, boolean bl) {
        MFColorRGBA mFColorRGBA = new MFColorRGBA(objectArray);
        return mFColorRGBA;
    }

    public boolean has(int n, Scriptable scriptable) {
        return n >= 0;
    }

    public boolean has(String string, Scriptable scriptable) {
        boolean bl = false;
        bl = propertyNames.contains(string) ? true : super.has(string, scriptable);
        return bl;
    }

    public Object get(int n, Scriptable scriptable) {
        Object object = NOT_FOUND;
        if (n >= 0 && n < this.valueList.size()) {
            object = this.valueList.get(n);
            if (object == null) {
                int n2 = n * 3;
                this.workArray[0] = this.floatData[n2++];
                this.workArray[1] = this.floatData[n2++];
                this.workArray[2] = this.floatData[n2++];
                this.workArray[3] = this.floatData[n2];
                SFColorRGBA sFColorRGBA = new SFColorRGBA(this.workArray);
                sFColorRGBA.setParentScope(this);
                this.valueList.set(n, sFColorRGBA);
                object = sFColorRGBA;
            }
        } else if (n >= 0) {
            for (int i = this.valueList.size(); i <= n; ++i) {
                SFColorRGBA sFColorRGBA = new SFColorRGBA();
                sFColorRGBA.setParentScope(this);
                this.valueList.add(sFColorRGBA);
            }
            this.sizeInt.setValue(this.valueList.size());
            object = (SFColorRGBA)this.valueList.get(n);
        }
        return object;
    }

    public Object get(String string, Scriptable scriptable) {
        Object object = null;
        if (propertyNames.contains(string)) {
            object = this.sizeInt;
        } else {
            object = super.get(string, scriptable);
            if (object == null && functionNames.contains(string)) {
                object = this.locateFunction(string);
            }
        }
        if (object == null) {
            object = NOT_FOUND;
        }
        return object;
    }

    public void put(int n, Scriptable scriptable, Object object) {
        if (this.readOnly && !this.scriptField) {
            Context.reportError((String)"You are not allowed to directly set this field because the script is marked as read only (directOutput is set to FALSE)");
            return;
        }
        if (!(object instanceof SFColorRGBA)) {
            Context.reportError((String)OBJECT_NOT_COLOR_MSG);
            return;
        }
        SFColorRGBA sFColorRGBA = (SFColorRGBA)object;
        if (sFColorRGBA.getParentScope() == null) {
            sFColorRGBA.setParentScope(this);
        }
        if (n >= this.valueList.size()) {
            int n2 = n - this.valueList.size();
            this.valueList.ensureCapacity(n + 1);
            for (int i = 0; i < n2; ++i) {
                this.valueList.add(new SFColorRGBA());
            }
            this.valueList.add(object);
            this.sizeInt.setValue(this.valueList.size());
        } else if (n >= 0) {
            this.valueList.set(n, object);
        }
        this.dataChanged = true;
    }

    public void put(String string, Scriptable scriptable, Object object) {
        if (object instanceof Function) {
            this.registerFunction(string, object);
        }
    }

    public String jsFunction_toString() {
        return this.toString();
    }

    public boolean jsFunction_equals(Object object) {
        return this.equals(object);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.valueList.size();
        for (int i = 0; i < n; ++i) {
            SFColorRGBA sFColorRGBA = (SFColorRGBA)this.valueList.get(i);
            stringBuffer.append(sFColorRGBA.toString());
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof MFColorRGBA)) {
            return false;
        }
        MFColorRGBA mFColorRGBA = (MFColorRGBA)object;
        int n = this.valueList.size();
        if (n != mFColorRGBA.valueList.size()) {
            return false;
        }
        return this.valueList.equals(mFColorRGBA.valueList);
    }

    public void updateRawData(float[] fArray, int n) {
        if (this.dataChanged) {
            return;
        }
        int n2 = n / 4;
        this.valueList.clear();
        if (n != 0) {
            this.floatData = new float[n];
            System.arraycopy(fArray, 0, this.floatData, 0, n);
            this.valueList.ensureCapacity(n2);
            for (int i = 0; i < n2; ++i) {
                this.valueList.add(null);
            }
        }
        this.sizeInt.setValue(n2);
    }

    public float[] getRawData() {
        int n = this.valueList.size();
        if (this.floatData == null || this.floatData.length != n * 4) {
            this.floatData = new float[n * 4];
        }
        if (this.workArray == null) {
            this.workArray = new float[4];
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            SFColorRGBA sFColorRGBA = (SFColorRGBA)this.valueList.get(i);
            if (sFColorRGBA != null) {
                sFColorRGBA.getRawData(this.workArray);
                this.floatData[n2++] = this.workArray[0];
                this.floatData[n2++] = this.workArray[1];
                this.floatData[n2++] = this.workArray[2];
                this.floatData[n2++] = this.workArray[3];
                continue;
            }
            n2 += 4;
        }
        return this.floatData;
    }

    public void getRawData(float[] fArray) {
        int n = this.valueList.size();
        if (this.workArray == null) {
            this.workArray = new float[4];
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            SFColorRGBA sFColorRGBA = (SFColorRGBA)this.valueList.get(i);
            if (sFColorRGBA != null) {
                sFColorRGBA.getRawData(this.workArray);
                this.floatData[n2++] = this.workArray[0];
                this.floatData[n2++] = this.workArray[1];
                this.floatData[n2++] = this.workArray[2];
                this.floatData[n2++] = this.workArray[3];
                continue;
            }
            n2 += 4;
        }
    }

    static {
        propertyNames.add("length");
        functionNames = new HashSet();
        functionNames.add("toString");
        functionNames.add("equals");
        jsUndefined = Context.getUndefinedValue();
    }
}

