/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.ecmascript;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.lang.FieldException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLScriptNodeType;
import org.web3d.vrml.scripting.ScriptWrapper;
import org.web3d.vrml.scripting.ecmascript.JavascriptBrowser;
import org.web3d.vrml.scripting.ecmascript.JavascriptScriptContext;
import org.web3d.vrml.scripting.ecmascript.ReportAdapter;
import org.web3d.vrml.scripting.ecmascript.builtin.FieldFactory;
import org.web3d.vrml.scripting.ecmascript.builtin.FieldScriptableObject;
import org.web3d.vrml.scripting.ecmascript.builtin.MFColor;
import org.web3d.vrml.scripting.ecmascript.builtin.MFFloat;
import org.web3d.vrml.scripting.ecmascript.builtin.MFInt32;
import org.web3d.vrml.scripting.ecmascript.builtin.MFNode;
import org.web3d.vrml.scripting.ecmascript.builtin.MFRotation;
import org.web3d.vrml.scripting.ecmascript.builtin.MFString;
import org.web3d.vrml.scripting.ecmascript.builtin.MFTime;
import org.web3d.vrml.scripting.ecmascript.builtin.MFVec2f;
import org.web3d.vrml.scripting.ecmascript.builtin.MFVec3f;
import org.web3d.vrml.scripting.ecmascript.builtin.NodeFieldData;
import org.web3d.vrml.scripting.ecmascript.builtin.NodeFieldObject;
import org.web3d.vrml.scripting.ecmascript.builtin.SFColor;
import org.web3d.vrml.scripting.ecmascript.builtin.SFImage;
import org.web3d.vrml.scripting.ecmascript.builtin.SFNode;
import org.web3d.vrml.scripting.ecmascript.builtin.SFRotation;
import org.web3d.vrml.scripting.ecmascript.builtin.SFVec2f;
import org.web3d.vrml.scripting.ecmascript.builtin.SFVec3f;

class JavascriptScriptWrapper
implements ScriptWrapper {
    private static final String INTERNAL_SOURCE = "Inline script";
    private static final Object[] EMPTY_ARGS = new Object[0];
    private static final HashSet NON_USE_FIELDS = new HashSet();
    private Context context;
    private JavascriptScriptContext scope;
    private ReportAdapter externalReporter;
    private ErrorReporter errorReporter;
    private VRMLScriptNodeType scriptNode;
    private String sourceString;
    private String sourceUrl;
    private Object[] functionArgs;
    private HashMap eventOutMap;
    private HashMap nodeEventOuts;
    private String[] eventOutNames;
    private String[] nodeFieldNames;
    private boolean directOutput;
    private boolean initialized;
    private boolean hadInputEvent;
    private Function eventsProcessedFunction;
    private float[] float2;
    private float[] float3;
    private float[] float4;

    JavascriptScriptWrapper(String string, String string2, JavascriptBrowser javascriptBrowser, Scriptable scriptable, FieldFactory fieldFactory) {
        if (string == null || javascriptBrowser == null) {
            throw new IllegalArgumentException("Bad script init. Null node");
        }
        this.context = Context.enter();
        this.context.setOptimizationLevel(-1);
        Context.setCachingEnabled((boolean)true);
        this.context.setLanguageVersion(150);
        this.sourceString = string.trim();
        this.sourceUrl = string2 != null ? string2 : INTERNAL_SOURCE;
        this.float2 = new float[2];
        this.float3 = new float[3];
        this.float4 = new float[4];
        this.functionArgs = new Object[2];
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        this.scope = new JavascriptScriptContext(javascriptBrowser, scriptable, fieldFactory);
        this.scope.setParentScope(scriptable);
        this.scope.setErrorReporter(this.errorReporter);
        JavascriptScriptWrapper javascriptScriptWrapper = this;
        javascriptScriptWrapper.context.exit();
        this.context = null;
        this.initialized = false;
        this.hadInputEvent = false;
    }

    public void initialize(VRMLScriptNodeType vRMLScriptNodeType) {
        Object object;
        VRMLFieldData vRMLFieldData;
        this.scriptNode = vRMLScriptNodeType;
        int n = vRMLScriptNodeType.getFieldIndex("directOutput");
        try {
            vRMLFieldData = vRMLScriptNodeType.getFieldValue(n);
            this.directOutput = vRMLFieldData.booleanValue;
        }
        catch (InvalidFieldException invalidFieldException) {
            invalidFieldException.printStackTrace();
        }
        this.eventOutMap = new HashMap();
        this.nodeEventOuts = new HashMap();
        List list = vRMLScriptNodeType.getAllFields();
        Iterator iterator = list.iterator();
        HashMap hashMap = new HashMap();
        ArrayList<String> arrayList = new ArrayList<String>(list.size() - 3);
        Object object2 = null;
        while (iterator.hasNext()) {
            int n2;
            VRMLFieldDeclaration vRMLFieldDeclaration = (VRMLFieldDeclaration)iterator.next();
            String string = vRMLFieldDeclaration.getName();
            if (NON_USE_FIELDS.contains(string) || (n2 = vRMLFieldDeclaration.getAccessType()) == 1) continue;
            try {
                n = vRMLScriptNodeType.getFieldIndex(string);
                vRMLFieldData = vRMLScriptNodeType.getFieldValue(n);
                switch (vRMLFieldDeclaration.getFieldType()) {
                    case 1: {
                        if (vRMLFieldData == null) {
                            object2 = Boolean.TRUE;
                            break;
                        }
                        object2 = vRMLFieldData.booleanValue ? Boolean.TRUE : Boolean.FALSE;
                        break;
                    }
                    case 3: {
                        object2 = vRMLFieldData == null ? new Integer(0) : new Integer(vRMLFieldData.intValue);
                        break;
                    }
                    case 5: {
                        object2 = vRMLFieldData == null ? new Float(0.0f) : new Float(vRMLFieldData.floatValue);
                        break;
                    }
                    case 9: {
                        object2 = vRMLFieldData == null ? new Double(0.0) : new Double(vRMLFieldData.doubleValue);
                        break;
                    }
                    case 27: {
                        if (vRMLFieldData != null) {
                            object2 = vRMLFieldData.stringValue;
                        }
                        break;
                    }
                    case 21: {
                        float[] fArray = vRMLFieldData == null ? null : vRMLFieldData.floatArrayValue;
                        object2 = new SFColor(fArray);
                        fArray = null;
                        break;
                    }
                    case 19: {
                        float[] fArray = vRMLFieldData == null ? null : vRMLFieldData.floatArrayValue;
                        object2 = new SFRotation(fArray);
                        fArray = null;
                        break;
                    }
                    case 13: {
                        float[] fArray = vRMLFieldData == null ? null : vRMLFieldData.floatArrayValue;
                        object2 = new SFVec2f(fArray);
                        fArray = null;
                        break;
                    }
                    case 15: {
                        float[] fArray = vRMLFieldData == null ? null : vRMLFieldData.floatArrayValue;
                        object2 = new SFVec3f(fArray);
                        fArray = null;
                        break;
                    }
                    case 25: {
                        int[] nArray = vRMLFieldData == null ? null : vRMLFieldData.intArrayValue;
                        object2 = new SFImage(nArray, vRMLFieldData.numElements);
                        nArray = null;
                        break;
                    }
                    case 11: {
                        VRMLNodeType vRMLNodeType = vRMLFieldData == null ? null : (VRMLNodeType)vRMLFieldData.nodeValue;
                        object2 = vRMLNodeType != null ? new SFNode(vRMLNodeType) : new SFNode();
                        this.nodeEventOuts.put(string, object2);
                        vRMLNodeType = null;
                        break;
                    }
                    case 22: {
                        float[] fArray = vRMLFieldData == null ? null : vRMLFieldData.floatArrayValue;
                        object2 = new MFColor(fArray, vRMLFieldData.numElements * 3);
                        fArray = null;
                        break;
                    }
                    case 4: {
                        int[] nArray = vRMLFieldData == null ? null : vRMLFieldData.intArrayValue;
                        object2 = new MFInt32(nArray, vRMLFieldData.numElements);
                        nArray = null;
                        break;
                    }
                    case 6: {
                        float[] fArray = vRMLFieldData == null ? null : vRMLFieldData.floatArrayValue;
                        object2 = new MFFloat(fArray, vRMLFieldData.numElements);
                        fArray = null;
                        break;
                    }
                    case 10: {
                        double[] dArray = vRMLFieldData == null ? null : vRMLFieldData.doubleArrayValue;
                        object2 = new MFTime(dArray, vRMLFieldData.numElements);
                        dArray = null;
                        break;
                    }
                    case 28: {
                        String[] stringArray = vRMLFieldData == null ? null : vRMLFieldData.stringArrayValue;
                        object2 = new MFString(stringArray, vRMLFieldData.numElements);
                        stringArray = null;
                        break;
                    }
                    case 12: {
                        VRMLNodeType[] vRMLNodeTypeArray = vRMLFieldData == null ? null : (VRMLNodeType[])vRMLFieldData.nodeArrayValue;
                        object2 = new MFNode(vRMLScriptNodeType, n, vRMLNodeTypeArray, vRMLFieldData.numElements);
                        this.nodeEventOuts.put(string, object2);
                        vRMLNodeTypeArray = null;
                        break;
                    }
                    case 20: {
                        float[] fArray = vRMLFieldData == null ? null : vRMLFieldData.floatArrayValue;
                        object2 = new MFRotation(fArray, vRMLFieldData.numElements * 4);
                        fArray = null;
                        break;
                    }
                    case 14: {
                        float[] fArray = vRMLFieldData == null ? null : vRMLFieldData.floatArrayValue;
                        object2 = new MFVec2f(fArray, vRMLFieldData.numElements * 2);
                        fArray = null;
                        break;
                    }
                    case 16: {
                        float[] fArray = vRMLFieldData == null ? null : vRMLFieldData.floatArrayValue;
                        object2 = new MFVec3f(fArray, vRMLFieldData.numElements * 3);
                        fArray = null;
                        break;
                    }
                    default: {
                        object2 = null;
                        System.out.println("Unknown VRML97 field type " + vRMLFieldDeclaration.getFieldTypeString());
                        break;
                    }
                }
            }
            catch (InvalidFieldException invalidFieldException) {
                invalidFieldException.printStackTrace();
            }
            if (object2 == null) continue;
            if (!this.directOutput && n2 != 4 && object2 instanceof FieldScriptableObject) {
                object = (FieldScriptableObject)object2;
                ((FieldScriptableObject)object).setReadOnly();
                ((FieldScriptableObject)object).setScriptField();
            }
            if (n2 != 2) {
                this.eventOutMap.put(string, object2);
                this.scope.addEventOut(string, n, object2);
                arrayList.add(string);
                continue;
            }
            this.scope.addField(string, object2);
        }
        this.eventOutNames = new String[arrayList.size()];
        arrayList.toArray(this.eventOutNames);
        if (this.directOutput) {
            this.nodeFieldNames = new String[this.nodeEventOuts.size()];
            object = this.nodeEventOuts.keySet();
            object.toArray(this.nodeFieldNames);
        }
        this.initialized = true;
        this.enterContext();
        try {
            this.context.evaluateString((Scriptable)this.scope, this.sourceString, this.sourceUrl, 1, null);
            object = this.scope.get("initialize", (Scriptable)this.scope);
            if (object instanceof Function) {
                Function function = (Function)object;
                function.call(this.context, (Scriptable)this.scope, (Scriptable)this.scope, EMPTY_ARGS);
            }
            if ((object = this.scope.get("eventsProcessed", (Scriptable)this.scope)) instanceof Function) {
                this.eventsProcessedFunction = (Function)object;
            }
        }
        catch (JavaScriptException javaScriptException) {
            Context.reportError((String)javaScriptException.getMessage());
        }
        catch (EcmaError ecmaError) {
            Context.reportError((String)ecmaError.getMessage());
        }
        this.exitContext();
    }

    public boolean prepareEvents() {
        return false;
    }

    public void setTimestamp(double d) {
        this.functionArgs[1] = new Double(d);
    }

    public void queueEvent(int n, String string, int n2) {
        this.callScriptFunction(string, new Integer(n2));
    }

    public void queueEvent(int n, String string, int[] nArray, int n2) {
        FieldScriptableObject fieldScriptableObject = null;
        switch (n) {
            case 25: {
                fieldScriptableObject = new SFImage(nArray, n2);
                break;
            }
            case 4: {
                fieldScriptableObject = new MFInt32(nArray, n2);
                break;
            }
            default: {
                System.out.println("JS queueEvent(int[])");
                return;
            }
        }
        this.callScriptFunction(string, fieldScriptableObject);
    }

    public void queueEvent(int n, String string, long l) {
        this.callScriptFunction(string, new Long(l));
    }

    public void queueEvent(int n, String string, long[] lArray, int n2) {
        this.callScriptFunction(string, lArray);
    }

    public void queueEvent(int n, String string, boolean bl) {
        if (NON_USE_FIELDS.contains(string)) {
            return;
        }
        this.callScriptFunction(string, bl);
    }

    public void queueEvent(int n, String string, boolean[] blArray, int n2) {
        this.callScriptFunction(string, blArray);
    }

    public void queueEvent(int n, String string, float f) {
        this.callScriptFunction(string, new Double(f));
    }

    public void queueEvent(int n, String string, float[] fArray, int n2) {
        FieldScriptableObject fieldScriptableObject;
        switch (n) {
            case 21: {
                fieldScriptableObject = new SFColor(fArray);
                break;
            }
            case 19: {
                fieldScriptableObject = new SFRotation(fArray);
                break;
            }
            case 13: {
                fieldScriptableObject = new SFVec2f(fArray);
                break;
            }
            case 15: {
                fieldScriptableObject = new SFVec3f(fArray);
                break;
            }
            case 6: {
                fieldScriptableObject = new MFFloat(fArray, n2);
                break;
            }
            case 22: {
                fieldScriptableObject = new MFColor(fArray, n2);
                break;
            }
            case 20: {
                fieldScriptableObject = new MFRotation(fArray, n2);
                break;
            }
            case 14: {
                fieldScriptableObject = new MFVec2f(fArray, n2);
                break;
            }
            case 16: {
                fieldScriptableObject = new MFVec3f(fArray, n2);
                break;
            }
            default: {
                System.err.println("Invalid field queue type in float[]");
                return;
            }
        }
        this.callScriptFunction(string, fieldScriptableObject);
    }

    public void queueEvent(int n, String string, double d) {
        this.callScriptFunction(string, new Double(d));
    }

    public void queueEvent(int n, String string, double[] dArray, int n2) {
        Object object;
        switch (n) {
            case 10: {
                object = new MFTime(dArray, n2);
                break;
            }
            default: {
                object = dArray;
            }
        }
        this.callScriptFunction(string, object);
    }

    public void queueEvent(int n, String string, String string2) {
        if (NON_USE_FIELDS.contains(string)) {
            return;
        }
        this.callScriptFunction(string, string2);
    }

    public void queueEvent(int n, String string, String[] stringArray, int n2) {
        if (NON_USE_FIELDS.contains(string)) {
            return;
        }
        this.callScriptFunction(string, new MFString(stringArray, n2));
    }

    public void queueEvent(int n, String string, VRMLNodeType vRMLNodeType) {
        this.callScriptFunction(string, new SFNode(vRMLNodeType));
    }

    public void queueEvent(int n, String string, VRMLNodeType[] vRMLNodeTypeArray, int n2) {
        int n3 = this.scriptNode.getFieldIndex(string);
        this.callScriptFunction(string, new MFNode(this.scriptNode, n3, vRMLNodeTypeArray, n2));
    }

    public boolean sendEvents() {
        boolean bl = this.scope.hasAnyEventOutChanged();
        if (!this.directOutput) {
            return bl;
        }
        int n = this.nodeFieldNames.length;
        for (int i = 0; i < n; ++i) {
            Object object;
            NodeFieldData nodeFieldData;
            Object object2;
            NodeFieldObject nodeFieldObject = (NodeFieldObject)this.nodeEventOuts.get(this.nodeFieldNames[i]);
            Object object3 = this.scope.get(this.nodeFieldNames[i], (Scriptable)this.scope);
            if (object3 == Scriptable.NOT_FOUND) continue;
            if (object3 != nodeFieldObject) {
                nodeFieldObject = (NodeFieldObject)object3;
                this.eventOutMap.put(this.nodeFieldNames[i], nodeFieldObject);
                this.nodeEventOuts.put(this.nodeFieldNames[i], nodeFieldObject);
                bl = true;
            }
            if (nodeFieldObject == null || !nodeFieldObject.hasChanged() || (object2 = nodeFieldObject.getChangedFields()) == null) continue;
            if (object2 instanceof NodeFieldData) {
                nodeFieldData = (NodeFieldData)object2;
                try {
                    object = nodeFieldData.node;
                    int n2 = nodeFieldData.fieldIndex;
                    if (object == null) {
                        object = this.scriptNode;
                        n2 = this.scriptNode.getFieldIndex(this.nodeFieldNames[i]);
                    }
                    this.sendEvent((VRMLNodeType)object, n2, nodeFieldData.value);
                }
                catch (FieldException fieldException) {
                    String string = "Error processing output field " + this.nodeFieldNames[i] + ". Contained message: " + fieldException.getMessage();
                    Context.reportWarning((String)string);
                }
                continue;
            }
            if (object2 instanceof ArrayList) {
                object = (ArrayList)object2;
                int n3 = ((ArrayList)object).size();
                for (int j = 0; j < n3; ++j) {
                    nodeFieldData = (NodeFieldData)((ArrayList)object).get(j);
                    try {
                        VRMLNodeType vRMLNodeType = nodeFieldData.node;
                        int n4 = nodeFieldData.fieldIndex;
                        if (vRMLNodeType == null) {
                            vRMLNodeType = this.scriptNode;
                            n4 = this.scriptNode.getFieldIndex(this.nodeFieldNames[i]);
                        }
                        this.sendEvent(vRMLNodeType, n4, nodeFieldData.value);
                        continue;
                    }
                    catch (FieldException fieldException) {
                        String string = "Error processing output field " + this.nodeFieldNames[i] + ". Contained message: " + fieldException.getMessage();
                        Context.reportWarning((String)string);
                    }
                }
                continue;
            }
            try {
                object = this.scriptNode;
                int n5 = this.scriptNode.getFieldIndex(this.nodeFieldNames[i]);
                this.sendEvent((VRMLNodeType)object, n5, nodeFieldObject);
                continue;
            }
            catch (FieldException fieldException) {
                String string = "Error processing output field " + this.nodeFieldNames[i] + ". Contained message: " + fieldException.getMessage();
                Context.reportWarning((String)string);
            }
        }
        return bl;
    }

    public void updateEventOuts() {
        int n = this.eventOutNames.length;
        for (int i = 0; i < n; ++i) {
            if (!this.scope.hasEventOutChanged(this.eventOutNames[i])) continue;
            try {
                int n2 = this.scriptNode.getFieldIndex(this.eventOutNames[i]);
                Object object = this.scope.get(this.eventOutNames[i], (Scriptable)this.scope);
                this.sendEvent(this.scriptNode, n2, object);
                continue;
            }
            catch (FieldException fieldException) {
                Context.reportWarning((String)fieldException.getMessage());
            }
        }
    }

    public void eventsProcessed() {
        if (!this.initialized || this.eventsProcessedFunction == null || !this.hadInputEvent) {
            return;
        }
        this.enterContext();
        try {
            this.eventsProcessedFunction.call(this.context, (Scriptable)this.scope, (Scriptable)this.scope, EMPTY_ARGS);
        }
        catch (JavaScriptException javaScriptException) {
            Context.reportError((String)javaScriptException.getMessage());
        }
        catch (EcmaError ecmaError) {
            Context.reportError((String)ecmaError.getMessage());
        }
        this.hadInputEvent = false;
        this.exitContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.enterContext();
        try {
            Object object = this.scope.get("shutdown", (Scriptable)this.scope);
            if (object instanceof Function) {
                Function function = (Function)object;
                function.call(this.context, (Scriptable)this.scope, (Scriptable)this.scope, EMPTY_ARGS);
            }
        }
        catch (JavaScriptException javaScriptException) {
            Context.reportError((String)javaScriptException.getMessage());
        }
        catch (EcmaError ecmaError) {
            Context.reportError((String)ecmaError.getMessage());
        }
        finally {
            this.exitContext();
        }
    }

    private void callScriptFunction(String string, Object object) {
        if (!this.initialized) {
            return;
        }
        if (this.eventOutMap.containsKey(string)) {
            return;
        }
        if (object instanceof FieldScriptableObject) {
            ((FieldScriptableObject)object).setParentScope(this.scope);
        }
        this.enterContext();
        try {
            Object object2 = this.scope.get(string, (Scriptable)this.scope);
            if (object2 instanceof Function) {
                Function function = (Function)object2;
                this.functionArgs[0] = object;
                function.call(this.context, (Scriptable)this.scope, (Scriptable)this.scope, this.functionArgs);
                this.hadInputEvent = true;
            }
        }
        catch (JavaScriptException javaScriptException) {
            Context.reportError((String)(javaScriptException.getMessage() + " in function: " + string));
        }
        catch (EcmaError ecmaError) {
            Context.reportError((String)(ecmaError.getMessage() + " in function " + string));
        }
        this.exitContext();
    }

    void setErrorReporter(ReportAdapter reportAdapter) {
        this.externalReporter = reportAdapter;
        this.errorReporter = reportAdapter.getErrorReporter();
        if (this.errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
        this.scope.setErrorReporter(this.errorReporter);
    }

    private void sendEvent(VRMLNodeType vRMLNodeType, int n, Object object) throws FieldException {
        VRMLFieldDeclaration vRMLFieldDeclaration = vRMLNodeType.getFieldDeclaration(n);
        switch (vRMLFieldDeclaration.getFieldType()) {
            case 1: {
                if (!(object instanceof Boolean)) {
                    this.errorReporter.warningReport("Attempting to set invalid value type to SFBool field", null);
                    break;
                }
                vRMLNodeType.setValue(n, (Boolean)object);
                break;
            }
            case 3: {
                if (!(object instanceof Number)) {
                    this.errorReporter.warningReport("Attempting to set invalid value type to SFInt32 field", null);
                    break;
                }
                vRMLNodeType.setValue(n, ((Number)object).intValue());
                break;
            }
            case 5: {
                if (!(object instanceof Number)) {
                    this.errorReporter.warningReport("Attempting to set invalid value type to SFFloat field", null);
                    break;
                }
                vRMLNodeType.setValue(n, ((Number)object).floatValue());
                break;
            }
            case 9: {
                if (!(object instanceof Number)) {
                    this.errorReporter.warningReport("Attempting to set invalid value type to SFTime field", null);
                    break;
                }
                vRMLNodeType.setValue(n, ((Number)object).doubleValue());
                break;
            }
            case 27: {
                if (!(object instanceof String)) {
                    this.errorReporter.warningReport("Attempting to set invalid value type to SFString field", null);
                    break;
                }
                vRMLNodeType.setValue(n, (String)object);
                break;
            }
            case 21: {
                if (!(object instanceof SFColor)) {
                    this.errorReporter.warningReport("Attempting to set invalid value type to SFColor field", null);
                    break;
                }
                ((SFColor)object).getRawData(this.float3);
                vRMLNodeType.setValue(n, this.float3, 3);
                break;
            }
            case 19: {
                if (!(object instanceof SFRotation)) {
                    this.errorReporter.warningReport("Attempting to set invalid value type to SFRotation field", null);
                    break;
                }
                ((SFRotation)object).getRawData(this.float4);
                vRMLNodeType.setValue(n, this.float4, 4);
                break;
            }
            case 13: {
                if (!(object instanceof SFVec2f)) {
                    this.errorReporter.warningReport("Attempting to set invalid value type to SFVec2f field", null);
                    break;
                }
                ((SFVec2f)object).getRawData(this.float2);
                vRMLNodeType.setValue(n, this.float2, 2);
                break;
            }
            case 15: {
                if (!(object instanceof SFVec3f)) {
                    this.errorReporter.warningReport("Attempting to set invalid value type to SFVec3f field", null);
                    break;
                }
                ((SFVec3f)object).getRawData(this.float3);
                vRMLNodeType.setValue(n, this.float3, 3);
                break;
            }
            case 25: {
                if (!(object instanceof SFImage)) {
                    this.errorReporter.warningReport("Attempting to set invalid value type to SFImage field", null);
                    break;
                }
                int[] nArray = ((SFImage)object).getRawData();
                vRMLNodeType.setValue(n, nArray, nArray.length);
                break;
            }
            case 22: {
                if (!(object instanceof MFColor)) {
                    this.errorReporter.warningReport("Attempting to set invalid value type to MFColor field", null);
                    break;
                }
                float[] fArray = ((MFColor)object).getRawData();
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 4: {
                if (!(object instanceof MFInt32)) {
                    this.errorReporter.warningReport("Attempting to set invalid value type to MFInt32 field", null);
                    break;
                }
                int[] nArray = ((MFInt32)object).getRawData();
                vRMLNodeType.setValue(n, nArray, nArray.length);
                break;
            }
            case 6: {
                if (!(object instanceof MFFloat)) {
                    this.errorReporter.warningReport("Attempting to set invalid value type to MFFloat field", null);
                    break;
                }
                float[] fArray = ((MFFloat)object).getRawData();
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 10: {
                if (!(object instanceof MFTime)) {
                    this.errorReporter.warningReport("Attempting to set invalid value type to MFTime field", null);
                    break;
                }
                double[] dArray = ((MFTime)object).getRawData();
                vRMLNodeType.setValue(n, dArray, dArray.length);
                break;
            }
            case 28: {
                if (!(object instanceof MFString)) {
                    this.errorReporter.warningReport("Attempting to set invalid value type to MFString field", null);
                    break;
                }
                String[] stringArray = ((MFString)object).getRawData();
                vRMLNodeType.setValue(n, stringArray, stringArray.length);
                break;
            }
            case 20: {
                if (!(object instanceof MFRotation)) {
                    this.errorReporter.warningReport("Attempting to set invalid value type to MFRotation field", null);
                    break;
                }
                float[] fArray = ((MFRotation)object).getRawData();
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 14: {
                if (!(object instanceof MFVec2f)) {
                    this.errorReporter.warningReport("Attempting to set invalid value type to MFVec2f field", null);
                    break;
                }
                float[] fArray = ((MFVec2f)object).getRawData();
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 16: {
                if (!(object instanceof MFVec3f)) {
                    this.errorReporter.warningReport("Attempting to set invalid value type to MFVec3f field", null);
                    break;
                }
                float[] fArray = ((MFVec3f)object).getRawData();
                vRMLNodeType.setValue(n, fArray, fArray.length);
                break;
            }
            case 11: {
                if (object != null && !(object instanceof SFNode)) {
                    this.errorReporter.warningReport("Attempting to set invalid value type to SFNode field", null);
                    break;
                }
                if (object != null) {
                    vRMLNodeType.setValue(n, ((SFNode)object).getImplNode());
                    break;
                }
                vRMLNodeType.setValue(n, (VRMLNodeType)null);
                break;
            }
            case 12: {
                if (object != null && !(object instanceof MFNode)) {
                    this.errorReporter.warningReport("Attempting to set invalid value type to MFNode field", null);
                    break;
                }
                if (object != null) {
                    VRMLNodeType[] vRMLNodeTypeArray = ((MFNode)object).getRawData();
                    vRMLNodeType.setValue(n, vRMLNodeTypeArray, vRMLNodeTypeArray.length);
                    break;
                }
                vRMLNodeType.setValue(n, (VRMLNodeType[])null, 0);
                break;
            }
        }
    }

    private void enterContext() {
        this.context = Context.enter();
        this.context.setOptimizationLevel(-1);
        org.mozilla.javascript.ErrorReporter errorReporter = this.context.getErrorReporter();
        if (!(errorReporter instanceof ReportAdapter) && this.externalReporter != null) {
            this.context.setErrorReporter((org.mozilla.javascript.ErrorReporter)this.externalReporter);
        }
    }

    private void exitContext() {
        JavascriptScriptWrapper javascriptScriptWrapper = this;
        javascriptScriptWrapper.context.exit();
        this.context = null;
    }

    static {
        NON_USE_FIELDS.add("url");
        NON_USE_FIELDS.add("mustEvaluate");
        NON_USE_FIELDS.add("directOutput");
    }
}

