/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.ecmascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.PropertyException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.web3d.browser.BrowserCore;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.lang.VRMLExecutionSpace;
import org.web3d.vrml.nodes.FrameStateManager;
import org.web3d.vrml.scripting.InvalidScriptContentException;
import org.web3d.vrml.scripting.ScriptEngine;
import org.web3d.vrml.scripting.ScriptWrapper;
import org.web3d.vrml.scripting.ecmascript.Global;
import org.web3d.vrml.scripting.ecmascript.JavascriptBrowser;
import org.web3d.vrml.scripting.ecmascript.JavascriptBrowserFactory;
import org.web3d.vrml.scripting.ecmascript.JavascriptScriptWrapper;
import org.web3d.vrml.scripting.ecmascript.ReportAdapter;
import org.web3d.vrml.scripting.ecmascript.builtin.ECMAFieldFactory;
import org.web3d.vrml.scripting.ecmascript.builtin.FieldFactory;
import org.web3d.vrml.scripting.ecmascript.builtin.MFColor;
import org.web3d.vrml.scripting.ecmascript.builtin.MFFloat;
import org.web3d.vrml.scripting.ecmascript.builtin.MFInt32;
import org.web3d.vrml.scripting.ecmascript.builtin.MFNode;
import org.web3d.vrml.scripting.ecmascript.builtin.MFRotation;
import org.web3d.vrml.scripting.ecmascript.builtin.MFString;
import org.web3d.vrml.scripting.ecmascript.builtin.MFTime;
import org.web3d.vrml.scripting.ecmascript.builtin.MFVec2f;
import org.web3d.vrml.scripting.ecmascript.builtin.MFVec3f;
import org.web3d.vrml.scripting.ecmascript.builtin.SFColor;
import org.web3d.vrml.scripting.ecmascript.builtin.SFImage;
import org.web3d.vrml.scripting.ecmascript.builtin.SFNode;
import org.web3d.vrml.scripting.ecmascript.builtin.SFRotation;
import org.web3d.vrml.scripting.ecmascript.builtin.SFVec2f;
import org.web3d.vrml.scripting.ecmascript.builtin.SFVec3f;
import org.web3d.vrml.scripting.ecmascript.builtin.VrmlMatrix;
import org.xj3d.core.eventmodel.RouteManager;
import org.xj3d.core.loading.WorldLoaderManager;

public class JavascriptScriptEngine
implements ScriptEngine {
    private static final String[] MIME_TYPES = new String[]{"application/x-javascript", "application/javascript", "application/x-ecmascript", "application/ecmascript"};
    private JavascriptBrowserFactory browserFactory;
    private FieldFactory fieldFactory;
    private Scriptable globalScope;
    private ReportAdapter errorHandler;
    private ErrorReporter errorReporter;
    private Global global;

    public JavascriptScriptEngine(BrowserCore browserCore, RouteManager routeManager, FrameStateManager frameStateManager, WorldLoaderManager worldLoaderManager) {
        if (browserCore == null) {
            throw new IllegalArgumentException("BrowserCore is null");
        }
        if (worldLoaderManager == null) {
            throw new IllegalArgumentException("WorldLoadManager is null");
        }
        if (frameStateManager == null) {
            throw new IllegalArgumentException("FrameStateManager is null");
        }
        if (routeManager == null) {
            throw new IllegalArgumentException("Routemanager is null");
        }
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        this.browserFactory = new JavascriptBrowserFactory(browserCore, routeManager, frameStateManager, worldLoaderManager);
        this.browserFactory.setErrorReporter(this.errorReporter);
    }

    public int getSupportedSpecificationVersion() {
        return 2;
    }

    public String[] getSupportedContentTypes() {
        return MIME_TYPES;
    }

    public synchronized ScriptWrapper buildWrapper(VRMLExecutionSpace vRMLExecutionSpace, String string, Object object) throws InvalidScriptContentException {
        if (!(object instanceof String)) {
            throw new InvalidScriptContentException("Not a javascript script");
        }
        if (this.globalScope == null) {
            this.setupRhino();
        }
        JavascriptBrowser javascriptBrowser = this.browserFactory.getBrowser(vRMLExecutionSpace);
        javascriptBrowser.setErrorReporter(this.errorReporter);
        String string2 = (String)object;
        JavascriptScriptWrapper javascriptScriptWrapper = new JavascriptScriptWrapper(string2, null, javascriptBrowser, this.globalScope, this.fieldFactory);
        javascriptScriptWrapper.setErrorReporter(this.errorHandler);
        return javascriptScriptWrapper;
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
        if (this.errorHandler != null) {
            this.errorHandler.setReporter(this.errorReporter);
        }
        this.browserFactory.setErrorReporter(this.errorReporter);
    }

    private void setupRhino() {
        Object[] objectArray;
        this.errorHandler = new ReportAdapter();
        this.errorHandler.setReporter(this.errorReporter);
        this.fieldFactory = new ECMAFieldFactory();
        Context context = Context.enter();
        this.global = new Global();
        if (this.errorReporter != null) {
            this.global.setErrorReporter(this.errorReporter);
        }
        this.globalScope = context.initStandardObjects((ScriptableObject)this.global);
        try {
            objectArray = new String[]{"print"};
            this.global.defineFunctionProperties((String[])objectArray, Global.class, 2);
        }
        catch (PropertyException propertyException) {
            throw new Error(propertyException.getMessage());
        }
        objectArray = new Class[]{SFColor.class, SFRotation.class, SFVec2f.class, SFVec3f.class, SFImage.class, SFNode.class, MFColor.class, MFInt32.class, MFFloat.class, MFTime.class, MFVec2f.class, MFVec3f.class, MFString.class, MFRotation.class, MFNode.class, VrmlMatrix.class};
        for (int i = 0; i < objectArray.length; ++i) {
            try {
                ScriptableObject.defineClass((Scriptable)this.globalScope, (Class)objectArray[i]);
                continue;
            }
            catch (Exception exception) {
                StringBuffer stringBuffer = new StringBuffer("Error loading class ");
                stringBuffer.append(((Class)objectArray[i]).getName());
                stringBuffer.append('\n');
                stringBuffer.append(exception.getMessage());
                Context.reportWarning((String)stringBuffer.toString());
            }
        }
        context.setErrorReporter((org.mozilla.javascript.ErrorReporter)this.errorHandler);
        context.exit();
    }
}

