/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.ecmascript;

import java.util.WeakHashMap;
import org.web3d.browser.BrowserCore;
import org.web3d.browser.BrowserCoreListener;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.lang.VRMLExecutionSpace;
import org.web3d.vrml.nodes.FrameStateManager;
import org.web3d.vrml.nodes.VRMLScene;
import org.web3d.vrml.scripting.ecmascript.x3d.Browser;
import org.xj3d.core.eventmodel.RouteManager;
import org.xj3d.core.eventmodel.ViewpointManager;
import org.xj3d.core.loading.WorldLoaderManager;

class ECMABrowserFactory
implements BrowserCoreListener {
    private ErrorReporter errorReporter;
    private BrowserCore core;
    private RouteManager routeManager;
    private ViewpointManager viewpointManager;
    private FrameStateManager stateManager;
    private WorldLoaderManager loadManager;
    private WeakHashMap browsers;

    ECMABrowserFactory(BrowserCore browserCore, ViewpointManager viewpointManager, RouteManager routeManager, FrameStateManager frameStateManager, WorldLoaderManager worldLoaderManager) {
        this.core = browserCore;
        this.routeManager = routeManager;
        this.loadManager = worldLoaderManager;
        this.stateManager = frameStateManager;
        this.viewpointManager = viewpointManager;
        this.core.addCoreListener(this);
        this.browsers = new WeakHashMap();
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
    }

    public Browser getBrowser(VRMLExecutionSpace vRMLExecutionSpace) {
        Browser browser = (Browser)this.browsers.get(vRMLExecutionSpace);
        if (browser == null) {
            browser = new Browser(vRMLExecutionSpace, this.core, this.viewpointManager, this.routeManager, this.stateManager, this.loadManager);
            browser.setErrorReporter(this.errorReporter);
            this.browsers.put(vRMLExecutionSpace, browser);
        }
        return browser;
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }

    public void browserInitialized(VRMLScene vRMLScene) {
    }

    public void urlLoadFailed(String string) {
    }

    public void browserShutdown() {
        this.browsers.clear();
    }

    public void browserDisposed() {
        this.browsers.clear();
    }
}

