/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.export;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.web3d.util.ErrorReporter;
import org.web3d.util.IntHashMap;
import org.web3d.vrml.export.BaseRetainedExporter;
import org.web3d.vrml.lang.ComponentInfo;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.ROUTE;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLExecutionSpace;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.lang.VRMLNode;
import org.web3d.vrml.lang.VRMLNodeTemplate;
import org.web3d.vrml.nodes.ImportNodeProxy;
import org.web3d.vrml.nodes.SceneGraphTraversalSimpleObserver;
import org.web3d.vrml.nodes.SceneGraphTraverser;
import org.web3d.vrml.nodes.VRMLExternalNodeType;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLGroupingNodeType;
import org.web3d.vrml.nodes.VRMLMultiExternalNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLScene;
import org.web3d.vrml.nodes.VRMLSingleExternalNodeType;
import org.web3d.vrml.nodes.VRMLWorldRootNodeType;
import org.web3d.vrml.nodes.proto.AbstractProto;
import org.web3d.vrml.nodes.proto.ExternalPrototypeDecl;
import org.web3d.vrml.nodes.proto.ProtoInstancePlaceHolder;
import org.web3d.vrml.nodes.proto.PrototypeDecl;
import org.web3d.vrml.renderer.CRExternPrototypeDecl;
import org.web3d.vrml.renderer.CRProtoInstance;
import org.web3d.vrml.renderer.common.nodes.AbstractDynamicFieldNode;
import org.web3d.vrml.sav.SAVException;

public class X3DClassicRetainedExporter
extends BaseRetainedExporter
implements SceneGraphTraversalSimpleObserver {
    private static String INDENT_STRING = "   ";
    private int indent;
    private String indentString;
    private IntHashMap indentMap;
    private HashSet usedNodes;
    private PrintWriter p;
    private HashSet protoDeclSet;
    private SceneGraphTraverser traverser;
    private VRMLWorldRootNodeType root;

    public X3DClassicRetainedExporter(OutputStream outputStream, int n, int n2, ErrorReporter errorReporter) {
        super(n, n2, errorReporter, -1);
        this.p = new PrintWriter(outputStream, true);
        this.init();
    }

    public X3DClassicRetainedExporter(OutputStream outputStream, int n, int n2, ErrorReporter errorReporter, int n3) {
        super(n, n2, errorReporter, n3);
        this.p = new PrintWriter(outputStream, true);
        this.init();
    }

    private void init() {
        this.usedNodes = new HashSet();
        this.indentString = "";
        this.indentMap = new IntHashMap();
        this.protoDeclSet = new HashSet();
        this.traverser = new SceneGraphTraverser();
    }

    public void writeScene(VRMLScene vRMLScene) {
        this.usedNodes.clear();
        Map map = vRMLScene.getDEFNodes();
        this.currentDefMap = new HashMap(map.size());
        this.reverseMap(map, this.currentDefMap);
        Map map2 = this.currentDefMap;
        ArrayList arrayList = vRMLScene.getNodeTemplates();
        Iterator iterator = arrayList.iterator();
        this.root = (VRMLWorldRootNodeType)vRMLScene.getRootNode();
        this.traverser.setObserver(this);
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof ExternalPrototypeDecl) {
                this.printExternalPrototypeDecl((CRExternPrototypeDecl)e);
                continue;
            }
            this.printPrototypeDecl((PrototypeDecl)e);
        }
        this.currentDefMap = map2;
        this.traverse(this.root, true);
        this.printImports(vRMLScene.getImports());
        ArrayList arrayList2 = vRMLScene.getRoutes();
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            this.printROUTE((ROUTE)arrayList2.get(i), this.currentDefMap);
        }
        this.printExports(vRMLScene.getExports());
        this.p.flush();
    }

    public void endDocument() throws SAVException, VRMLException {
        if (!this.processingDocument) {
            return;
        }
        this.processingDocument = false;
        super.endDocument();
        this.writeScene(this.scene);
    }

    public void printHeader(int n, int n2) {
        this.p.print("#X3D V");
        this.p.print(n);
        this.p.print(".");
        this.p.print(n2);
        this.p.println(" utf8");
        this.p.println();
    }

    public void printProfile(String string) {
        this.p.print("PROFILE ");
        this.p.println(string);
        this.p.println();
    }

    public void printComponents(ComponentInfo[] componentInfoArray) {
        int n = componentInfoArray.length;
        for (int i = 0; i < n; ++i) {
            this.p.print("COMPONENT ");
            this.p.print(componentInfoArray[i].getName());
            this.p.print(":");
            this.p.println(componentInfoArray[i].getLevel());
        }
        if (n > 0) {
            this.p.println();
        }
    }

    public void printMetaData(Map map) {
        Map.Entry[] entryArray = new Map.Entry[map.size()];
        map.entrySet().toArray(entryArray);
        int n = entryArray.length;
        for (int i = 0; i < n; ++i) {
            String string = (String)entryArray[i].getKey();
            String string2 = (String)entryArray[i].getValue();
            string = string.replace("\\", "\\\\");
            string2 = string2.replace("\\", "\\\\");
            this.p.println("META \"" + string + "\" \"" + string2 + "\"");
        }
        if (n > 0) {
            this.p.println();
        }
    }

    public void printROUTE(ROUTE rOUTE, Map map) {
        VRMLNode vRMLNode = rOUTE.getSourceNode();
        VRMLNode vRMLNode2 = rOUTE.getDestinationNode();
        String string = (String)map.get(vRMLNode);
        String string2 = vRMLNode2 instanceof ImportNodeProxy ? ((ImportNodeProxy)vRMLNode2).getImportedName() : (String)map.get(vRMLNode2);
        string = vRMLNode instanceof ImportNodeProxy ? ((ImportNodeProxy)vRMLNode).getImportedName() : (String)map.get(vRMLNode);
        VRMLFieldDeclaration vRMLFieldDeclaration = vRMLNode.getFieldDeclaration(rOUTE.getSourceIndex());
        VRMLFieldDeclaration vRMLFieldDeclaration2 = vRMLNode2.getFieldDeclaration(rOUTE.getDestinationIndex());
        this.p.print(this.indentString);
        this.p.print("ROUTE ");
        this.p.print(string);
        this.p.print(".");
        this.p.print(vRMLFieldDeclaration.getName());
        this.p.print(" TO ");
        this.p.print(string2);
        this.p.print(".");
        this.p.println(vRMLFieldDeclaration2.getName());
    }

    public void printExports(Map map) {
        Map.Entry[] entryArray = new Map.Entry[map.size()];
        map.entrySet().toArray(entryArray);
        for (int i = 0; i < entryArray.length; ++i) {
            String string = (String)entryArray[i].getValue();
            String string2 = (String)entryArray[i].getKey();
            this.p.print(this.indentString);
            this.p.print("EXPORT ");
            this.p.print(string);
            if (string2 != null && !string.equals(string2)) {
                this.p.print(" AS ");
                this.p.println(string2);
                continue;
            }
            this.p.println();
        }
    }

    public void printImports(Map map) {
        Map.Entry[] entryArray = new Map.Entry[map.size()];
        map.entrySet().toArray(entryArray);
        for (int i = 0; i < entryArray.length; ++i) {
            String string = (String)entryArray[i].getKey();
            Object v = entryArray[i].getValue();
            if (v instanceof String[]) {
                String[] stringArray = (String[])entryArray[i].getValue();
                this.p.print(this.indentString);
                this.p.print("IMPORT ");
                this.p.print(stringArray[0]);
                this.p.print(".");
                this.p.print(stringArray[1]);
                this.p.print(" AS ");
                this.p.println(string);
                continue;
            }
            ImportNodeProxy importNodeProxy = (ImportNodeProxy)v;
            this.p.print(this.indentString);
            this.p.print("IMPORT ");
            this.p.print(importNodeProxy.getInlineDEFName());
            this.p.print(".");
            this.p.print(importNodeProxy.getExportedName());
            this.p.print(" AS ");
            this.p.println(importNodeProxy.getImportedName());
        }
    }

    public void traverse(VRMLNode vRMLNode, boolean bl) {
        if (vRMLNode == null) {
            return;
        }
        if (bl) {
            this.recurseSimpleSceneGraphChild((VRMLNodeType)vRMLNode);
        } else {
            this.processSimpleNode(null, -1, (VRMLNodeType)vRMLNode);
        }
    }

    private void processSimpleNode(VRMLNodeType vRMLNodeType, int n, VRMLNodeType vRMLNodeType2) {
        boolean bl = this.usedNodes.contains(vRMLNodeType2);
        if (!bl) {
            this.usedNodes.add(vRMLNodeType2);
        }
        this.indentUp();
        if (bl) {
            String string = (String)this.currentDefMap.get(vRMLNodeType2);
            if (string == null) {
                this.errorReporter.warningReport("Can't find DEF for: " + vRMLNodeType2, null);
                this.printDefMap(this.currentDefMap);
            }
            this.p.print("USE ");
            this.p.println(string);
            this.indentDown();
        } else {
            this.printStartNode(vRMLNodeType2, bl, this.currentDefMap, this.currentIsMap);
            this.recurseSimpleSceneGraphChild(vRMLNodeType2);
            this.indentDown();
            this.printEndNode(vRMLNodeType2);
        }
    }

    private void recurseSimpleSceneGraphChild(VRMLNodeType vRMLNodeType) {
        int[] nArray = vRMLNodeType.getNodeFieldIndices();
        if (nArray == null || nArray.length == 0) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        int n = vRMLNodeType.getFieldIndex("metadata");
        if (vRMLNodeType instanceof AbstractDynamicFieldNode) {
            bl = true;
        }
        boolean bl3 = this.indent > 0;
        for (int i = 0; i < nArray.length; ++i) {
            int n2;
            VRMLFieldData vRMLFieldData;
            bl2 = false;
            try {
                vRMLFieldData = vRMLNodeType.getFieldValue(nArray[i]);
            }
            catch (InvalidFieldException invalidFieldException) {
                continue;
            }
            if (bl && i == n) {
                if (vRMLFieldData.nodeValue == null) continue;
                bl = false;
            }
            if (vRMLFieldData.dataType == 13) {
                if (bl3) {
                    VRMLFieldDeclaration vRMLFieldDeclaration = vRMLNodeType.getFieldDeclaration(nArray[i]);
                    this.p.print(this.indentString);
                    if (bl) {
                        n2 = vRMLFieldDeclaration.getAccessType();
                        if (n2 == 2 || n2 == 3) {
                            bl2 = true;
                        }
                        this.printDeclNoValue(vRMLFieldDeclaration);
                        this.p.print(vRMLFieldDeclaration.getName());
                        if (bl2) {
                            this.p.print(" [");
                        }
                    } else if (vRMLFieldData.numElements != 0) {
                        this.p.print(vRMLFieldDeclaration.getName());
                        this.p.print(" [");
                    }
                }
                for (int j = 0; j < vRMLFieldData.numElements; ++j) {
                    if (vRMLFieldData.nodeArrayValue[j] == null || this.convertOldContent && vRMLFieldData.nodeArrayValue[j].getVRMLNodeName().equals("GeoOrigin") && !vRMLNodeType.getFieldDeclaration(nArray[i]).getName().equals("geoOrigin")) continue;
                    this.processSimpleNode(vRMLNodeType, nArray[i], (VRMLNodeType)vRMLFieldData.nodeArrayValue[j]);
                }
                if (bl) {
                    if (bl2) {
                        this.p.println("]");
                        continue;
                    }
                    this.p.println();
                    continue;
                }
                if (!bl3) continue;
                if (vRMLFieldData.numElements != 0) {
                    this.p.print(this.indentString);
                    this.p.println("]");
                    continue;
                }
                this.p.println();
                continue;
            }
            if (vRMLFieldData.nodeValue == null && !bl) continue;
            if (bl3) {
                VRMLFieldDeclaration vRMLFieldDeclaration = vRMLNodeType.getFieldDeclaration(nArray[i]);
                this.p.print(this.indentString);
                if (bl) {
                    this.printDeclNoValue(vRMLFieldDeclaration);
                    n2 = vRMLFieldDeclaration.getAccessType();
                    if (n2 == 2 || n2 == 3) {
                        bl2 = true;
                    }
                }
                this.p.print(vRMLFieldDeclaration.getName());
                this.p.print(" ");
                if (vRMLFieldData.nodeValue == null && bl) {
                    if (bl2) {
                        this.p.println("NULL");
                        continue;
                    }
                    this.p.println();
                    continue;
                }
            }
            this.processSimpleNode(vRMLNodeType, nArray[i], (VRMLNodeType)vRMLFieldData.nodeValue);
            if (!bl3 || bl) continue;
            this.p.println();
        }
    }

    public void printStartScriptNode(AbstractDynamicFieldNode abstractDynamicFieldNode, boolean bl, Map map, Map map2) {
        List list = abstractDynamicFieldNode.getAllFields();
        Iterator iterator = list.iterator();
        int n = abstractDynamicFieldNode.getFieldIndex("mustEvaluate");
        int n2 = abstractDynamicFieldNode.getFieldIndex("directOutput");
        int n3 = abstractDynamicFieldNode.getFieldIndex("url");
        int n4 = abstractDynamicFieldNode.getFieldIndex("metadata");
        while (iterator.hasNext()) {
            VRMLFieldData vRMLFieldData;
            VRMLFieldDeclaration vRMLFieldDeclaration = (VRMLFieldDeclaration)iterator.next();
            if (vRMLFieldDeclaration == null) continue;
            int n5 = abstractDynamicFieldNode.getFieldIndex(vRMLFieldDeclaration.getName());
            try {
                vRMLFieldData = abstractDynamicFieldNode.getFieldValue(n5);
            }
            catch (Exception exception) {
                this.errorReporter.errorReport("Can't get field: " + vRMLFieldDeclaration.getName() + " for: " + abstractDynamicFieldNode, null);
                continue;
            }
            if (n5 == n4) continue;
            if (n5 == n) {
                if (!vRMLFieldData.booleanValue) continue;
                this.p.print(this.indentString);
                this.p.print(vRMLFieldDeclaration.getName());
                this.p.print(" ");
                this.printFieldValue((VRMLNodeType)abstractDynamicFieldNode, vRMLFieldData, vRMLFieldDeclaration);
                continue;
            }
            if (n5 == n2) {
                if (!vRMLFieldData.booleanValue) continue;
                this.p.print(this.indentString);
                this.p.print(vRMLFieldDeclaration.getName());
                this.p.print(" ");
                this.printFieldValue((VRMLNodeType)abstractDynamicFieldNode, vRMLFieldData, vRMLFieldDeclaration);
                continue;
            }
            if (n5 == n3) continue;
            this.printScriptFieldDecl((VRMLNodeType)abstractDynamicFieldNode, vRMLFieldDeclaration, n5, vRMLFieldData, map, this.currentIsMap);
        }
        this.indentDown();
    }

    public void printStartNode(VRMLNodeType vRMLNodeType, boolean bl, Map map, Map map2) {
        Object object;
        int n;
        Object object2;
        Object object3;
        String string = (String)map.get(vRMLNodeType);
        if (string != null) {
            this.p.print("DEF ");
            this.p.print(string);
            this.p.print(" ");
        }
        String string2 = vRMLNodeType.getVRMLNodeName();
        if (this.convertOldContent && (object3 = (String)this.oldProtos.get(string2)) != null) {
            string2 = object3;
        }
        this.p.print(string2);
        this.p.println(" {");
        this.indentUp();
        if (vRMLNodeType instanceof AbstractDynamicFieldNode) {
            this.printStartScriptNode((AbstractDynamicFieldNode)vRMLNodeType, bl, map, map2);
            return;
        }
        object3 = (VRMLNodeType)this.defaultNodes.get(string2);
        if (object3 == null && !(vRMLNodeType instanceof CRProtoInstance)) {
            object3 = (VRMLNodeType)this.nodeFactory.createVRMLNode(string2, false);
            if (object3 == null) {
                this.errorReporter.errorReport("Could not create node: " + string2, null);
            }
            this.defaultNodes.put(string2, object3);
        }
        int n2 = vRMLNodeType.getNumFields();
        boolean bl2 = false;
        boolean bl3 = false;
        HashSet<Integer> hashSet = null;
        String string3 = null;
        if (vRMLNodeType instanceof VRMLExternalNodeType) {
            bl3 = true;
            string3 = ((VRMLExternalNodeType)((Object)vRMLNodeType)).getWorldUrl();
            hashSet = new HashSet<Integer>();
            if (vRMLNodeType instanceof VRMLSingleExternalNodeType) {
                hashSet.add(new Integer(vRMLNodeType.getFieldIndex("url")));
            } else {
                object2 = ((VRMLMultiExternalNodeType)((Object)vRMLNodeType)).getUrlFieldIndexes();
                for (n = 0; n < ((Object)object2).length; ++n) {
                    hashSet.add(new Integer((int)object2[n]));
                }
            }
        }
        if (this.upgrading && string2.equals("Inline")) {
            bl2 = true;
        }
        object2 = new ArrayList();
        if (vRMLNodeType instanceof AbstractProto) {
            List list = ((AbstractProto)((Object)vRMLNodeType)).getAllFields();
            object = list.iterator();
            while (object.hasNext()) {
                object2.add(object.next());
            }
        } else {
            for (n = 0; n < n2; ++n) {
                object = vRMLNodeType.getFieldDeclaration(n);
                object2.add(object);
            }
        }
        Iterator iterator = object2.iterator();
        int n3 = 0;
        while (iterator.hasNext()) {
            int n4;
            String[] stringArray;
            VRMLFieldData vRMLFieldData;
            String string4;
            VRMLFieldDeclaration vRMLFieldDeclaration = (VRMLFieldDeclaration)iterator.next();
            VRMLFieldDeclaration vRMLFieldDeclaration2 = null;
            if (vRMLFieldDeclaration == null) continue;
            String string5 = vRMLFieldDeclaration.getName();
            int n5 = vRMLNodeType.getFieldIndex(string5);
            if (object3 != null) {
                n3 = object3.getFieldIndex(string5);
                vRMLFieldDeclaration2 = object3.getFieldDeclaration(n3);
            }
            if ((string4 = this.findIS(vRMLNodeType, n5, map2)) != null) {
                this.p.print(this.indentString);
                this.p.print(vRMLFieldDeclaration.getName());
                this.p.print(" IS ");
                this.p.println(string4);
                continue;
            }
            int n6 = vRMLFieldDeclaration.getAccessType();
            if (n6 == 1 || n6 == 4) continue;
            try {
                vRMLFieldData = vRMLNodeType.getFieldValue(n5);
            }
            catch (Exception exception) {
                continue;
            }
            if (object3 != null && this.isDefault(vRMLNodeType, vRMLFieldDeclaration, n3, vRMLFieldData, (VRMLNodeType)object3) || vRMLNodeType instanceof CRProtoInstance && (stringArray = (String[])vRMLNodeType).isDefaultValue(n5) || vRMLFieldData.dataType == 7 || vRMLFieldData.dataType == 13) continue;
            if (bl3 && hashSet.contains(new Integer(n5)) && (stringArray = vRMLFieldData.stringArrayValue) != null && string3 != null) {
                for (n4 = 0; n4 < stringArray.length; ++n4) {
                    if (stringArray[n4] == null || !stringArray[n4].startsWith(string3)) continue;
                    stringArray[n4] = stringArray[n4].substring(string3.length());
                }
                vRMLFieldData.stringArrayValue = stringArray;
            }
            if (bl2 && vRMLFieldDeclaration.getName().equals("url") && (stringArray = vRMLFieldData.stringArrayValue) != null) {
                for (n4 = 0; n4 < stringArray.length; ++n4) {
                    int n7 = stringArray[n4].indexOf(".wrl");
                    if (n7 < 0) continue;
                    stringArray[n4] = stringArray[n4].substring(0, n7);
                    stringArray[n4] = stringArray[n4] + ".x3dv";
                }
                vRMLFieldData.stringArrayValue = stringArray;
            }
            this.p.print(this.indentString);
            this.p.print(vRMLFieldDeclaration.getName());
            this.p.print(" ");
            this.printFieldValue(vRMLNodeType, vRMLFieldData, vRMLFieldDeclaration);
        }
        this.indentDown();
    }

    public void printEndNode(VRMLNodeType vRMLNodeType) {
        if (vRMLNodeType instanceof AbstractDynamicFieldNode) {
            this.indentUp();
            int n = vRMLNodeType.getFieldIndex("url");
            VRMLFieldDeclaration vRMLFieldDeclaration = vRMLNodeType.getFieldDeclaration(n);
            VRMLFieldData vRMLFieldData = null;
            try {
                vRMLFieldData = vRMLNodeType.getFieldValue(n);
            }
            catch (Exception exception) {
                StringBuffer stringBuffer = new StringBuffer("Can't get field: ");
                stringBuffer.append(vRMLFieldDeclaration.getName());
                stringBuffer.append(" for: ");
                stringBuffer.append(vRMLNodeType);
                stringBuffer.append(" named: ");
                stringBuffer.append(vRMLNodeType.getVRMLNodeName());
                stringBuffer.append("\nIndex: ");
                stringBuffer.append(n);
                this.errorReporter.errorReport(stringBuffer.toString(), null);
            }
            this.p.print(this.indentString);
            this.p.print(vRMLFieldDeclaration.getName());
            this.p.print(" ");
            if (this.upgrading) {
                String[] stringArray = new String[vRMLFieldData.stringArrayValue.length];
                boolean bl = false;
                int n2 = stringArray.length;
                for (int i = 0; i < n2; ++i) {
                    stringArray[i] = vRMLFieldData.stringArrayValue[i];
                    if (!bl && (stringArray[i].startsWith("javascript:") || stringArray[i].startsWith("vrmlscript:"))) {
                        stringArray[i] = "ecmascript:" + stringArray[i].substring(11);
                        bl = true;
                    }
                    int n3 = this.scriptPatterns.length;
                    for (int j = 0; j < n3; ++j) {
                        stringArray[i] = this.scriptPatterns[j].matcher(stringArray[i]).replaceAll(this.scriptReplacements[j]);
                    }
                }
                vRMLFieldData.stringArrayValue = stringArray;
            }
            this.printFieldValue(vRMLNodeType, vRMLFieldData, vRMLFieldDeclaration);
            this.indentDown();
        }
        this.p.print(this.indentString);
        this.p.println("}");
    }

    public void observedNode(VRMLNodeType vRMLNodeType, VRMLNodeType vRMLNodeType2, int n, boolean bl) {
        if (vRMLNodeType2 instanceof ProtoInstancePlaceHolder) {
            this.protoDeclSet.add(((ProtoInstancePlaceHolder)vRMLNodeType2).getProtoDefinition());
        }
    }

    public void printPrototypeDecl(PrototypeDecl prototypeDecl) {
        int n;
        this.currentDefMap = new HashMap();
        Map map = this.currentDefMap;
        this.reverseMap(prototypeDecl.getDEFMap(), this.currentDefMap);
        this.currentIsMap = prototypeDecl.getISMaps();
        this.currentPrototypeDecl = prototypeDecl;
        VRMLGroupingNodeType vRMLGroupingNodeType = prototypeDecl.getBodyGroup();
        VRMLNodeType[] vRMLNodeTypeArray = vRMLGroupingNodeType.getChildren();
        String string = prototypeDecl.getVRMLNodeName();
        VRMLNode vRMLNode = this.protoCreator.newInstance((VRMLNodeTemplate)prototypeDecl, (VRMLExecutionSpace)this.root, this.majorVersion, this.minorVersion, false);
        this.defaultNodes.put(prototypeDecl.getVRMLNodeName(), vRMLNode);
        if (this.convertOldContent && this.oldProtos.get(string) != null) {
            return;
        }
        this.p.print(this.indentString);
        this.p.print("PROTO ");
        this.p.print(string);
        this.p.println(" [");
        this.indentUp();
        List list = prototypeDecl.getAllFields();
        for (VRMLFieldDeclaration vRMLFieldDeclaration : list) {
            boolean bl;
            int n2 = prototypeDecl.getFieldIndex(vRMLFieldDeclaration.getName());
            VRMLFieldData vRMLFieldData = null;
            int n3 = vRMLFieldDeclaration.getAccessType();
            if (n3 != 1 && n3 != 4) {
                vRMLFieldData = prototypeDecl.getFieldValue(n2);
                bl = true;
            } else {
                bl = false;
            }
            if (vRMLFieldDeclaration.getName().equals("metadata") && (vRMLFieldData == null || vRMLFieldData.nodeValue == null)) continue;
            this.printProtoFieldDecl(vRMLFieldDeclaration, n2, vRMLFieldData, this.currentDefMap, this.currentIsMap, bl);
        }
        this.indentDown();
        this.p.print(this.indentString);
        this.p.println("] {");
        this.indentUp();
        this.protoDeclSet.clear();
        for (int i = 0; i < vRMLNodeTypeArray.length; ++i) {
            this.traverser.reset();
            this.traverser.traverseGraph(vRMLNodeTypeArray[i]);
        }
        PrototypeDecl[] prototypeDeclArray = new PrototypeDecl[this.protoDeclSet.size()];
        this.protoDeclSet.toArray(prototypeDeclArray);
        for (n = 0; n < prototypeDeclArray.length; ++n) {
            this.printPrototypeDecl(prototypeDeclArray[n]);
        }
        this.currentDefMap = map;
        this.currentIsMap = prototypeDecl.getISMaps();
        this.currentPrototypeDecl = prototypeDecl;
        for (n = 0; n < vRMLNodeTypeArray.length; ++n) {
            this.p.print(this.indentString);
            this.traverse(vRMLNodeTypeArray[n], false);
        }
        this.printImports(prototypeDecl.getImportDecls());
        Set set = prototypeDecl.getRouteDecls();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            this.printROUTE((ROUTE)iterator.next(), this.currentDefMap);
        }
        this.indentDown();
        this.p.print(this.indentString);
        this.p.println("}");
    }

    public void printExternalPrototypeDecl(CRExternPrototypeDecl cRExternPrototypeDecl) {
        String[] stringArray2;
        this.currentDefMap = new HashMap();
        String string = cRExternPrototypeDecl.getVRMLNodeName();
        if (this.convertOldContent && this.oldProtos.get(string) != null) {
            return;
        }
        this.p.print(this.indentString);
        this.p.print("EXTERNPROTO ");
        this.p.print(string);
        this.p.println(" [");
        this.indentUp();
        List list = cRExternPrototypeDecl.getAllFields();
        for (String[] stringArray2 : list) {
            int n = cRExternPrototypeDecl.getFieldIndex(stringArray2.getName());
            Object var7_7 = null;
            if (stringArray2.getName().equals("metadata")) continue;
            this.printProtoFieldDecl((VRMLFieldDeclaration)stringArray2, n, null, this.currentDefMap, this.currentIsMap, false);
        }
        this.indentDown();
        this.p.print(this.indentString);
        this.p.print("] ");
        stringArray2 = (String[])this.epToUrl.get(cRExternPrototypeDecl.getVRMLNodeName());
        this.p.print("[");
        int n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            this.p.print("\"");
            if (this.upgrading) {
                int n2 = stringArray2[i].indexOf(".wrl");
                int n3 = stringArray2[i].indexOf("#");
                if (n2 >= 0) {
                    String string2 = stringArray2[i];
                    stringArray2[i] = stringArray2[i].substring(0, n2);
                    stringArray2[i] = stringArray2[i] + ".x3dv";
                    if (n3 > 0) {
                        String string3 = string2.substring(n3);
                        stringArray2[i] = stringArray2[i] + string3;
                    }
                }
            }
            this.p.print(stringArray2[i]);
            this.p.print("\"");
            if (i == n - 1) continue;
            this.p.println();
        }
        this.p.println("]\n");
    }

    private boolean isMFField(VRMLFieldDeclaration vRMLFieldDeclaration) {
        int n = vRMLFieldDeclaration.getFieldType();
        return n % 2 == 0;
    }

    private void indentUp() {
        ++this.indent;
        this.indentString = (String)this.indentMap.get(this.indent);
        if (this.indentString == null) {
            StringBuffer stringBuffer = new StringBuffer(this.indent * INDENT_STRING.length());
            for (int i = 0; i < this.indent; ++i) {
                stringBuffer.append(INDENT_STRING);
            }
            this.indentString = stringBuffer.toString();
            this.indentMap.put(this.indent, this.indentString);
        }
    }

    private void indentDown() {
        --this.indent;
        this.indentString = (String)this.indentMap.get(this.indent);
        if (this.indentString == null) {
            StringBuffer stringBuffer = new StringBuffer(this.indent * INDENT_STRING.length());
            for (int i = 0; i < this.indent; ++i) {
                stringBuffer.append(INDENT_STRING);
            }
            this.indentString = stringBuffer.toString();
        }
    }

    private void printProtoFieldDecl(VRMLFieldDeclaration vRMLFieldDeclaration, int n, VRMLFieldData vRMLFieldData, Map map, Map map2, boolean bl) {
        this.p.print(this.indentString);
        int n2 = vRMLFieldDeclaration.getAccessType();
        switch (n2) {
            case 2: {
                this.p.print("initializeOnly ");
                break;
            }
            case 3: {
                this.p.print("inputOutput ");
                break;
            }
            case 1: {
                this.p.print("inputOnly ");
                break;
            }
            case 4: {
                this.p.print("outputOnly ");
                break;
            }
            default: {
                this.errorReporter.errorReport("Unknown field type in X3DClassicExporter: " + n2, null);
            }
        }
        this.p.print(vRMLFieldDeclaration.getFieldTypeString());
        this.p.print(" ");
        this.p.print(vRMLFieldDeclaration.getName());
        this.p.print(" ");
        if (vRMLFieldData != null) {
            switch (vRMLFieldData.dataType) {
                case 7: {
                    VRMLNode vRMLNode = vRMLFieldData.nodeValue;
                    if (vRMLNode == null) {
                        this.p.println(" NULL");
                        break;
                    }
                    this.traverse(vRMLNode, false);
                    break;
                }
                case 13: {
                    this.p.println("[");
                    VRMLNode[] vRMLNodeArray = vRMLFieldData.nodeArrayValue;
                    int n3 = vRMLNodeArray.length;
                    this.indentUp();
                    for (int i = 0; i < n3; ++i) {
                        this.p.print(this.indentString);
                        this.traverse(vRMLNodeArray[i], false);
                    }
                    this.indentDown();
                    this.p.print(this.indentString);
                    this.p.println("]");
                    break;
                }
                default: {
                    this.printFieldValue(null, vRMLFieldData, vRMLFieldDeclaration);
                    break;
                }
            }
        } else {
            if (bl) {
                this.printFieldValue(null, vRMLFieldData, vRMLFieldDeclaration);
            }
            this.p.println();
        }
    }

    private void printDeclNoValue(VRMLFieldDeclaration vRMLFieldDeclaration) {
        int n = vRMLFieldDeclaration.getAccessType();
        switch (n) {
            case 2: {
                this.p.print("initializeOnly ");
                break;
            }
            case 3: {
                this.p.print("inputOutput ");
                break;
            }
            case 1: {
                this.p.print("inputOnly ");
                break;
            }
            case 4: {
                this.p.print("outputOnly ");
                break;
            }
            default: {
                this.errorReporter.errorReport("Unknown field type in X3DClassicExporter: " + n, null);
            }
        }
        this.p.print(vRMLFieldDeclaration.getFieldTypeString());
        this.p.print(" ");
    }

    private void printScriptFieldDecl(VRMLNodeType vRMLNodeType, VRMLFieldDeclaration vRMLFieldDeclaration, int n, VRMLFieldData vRMLFieldData, Map map, Map map2) {
        String string = this.findIS(vRMLNodeType, n, map2);
        if (string == null && vRMLFieldData != null && (vRMLFieldData.dataType == 7 || vRMLFieldData.dataType == 13)) {
            return;
        }
        this.p.print(this.indentString);
        this.printDeclNoValue(vRMLFieldDeclaration);
        if (string != null) {
            this.p.print(vRMLFieldDeclaration.getName());
            this.p.print(" ");
            this.p.print("IS ");
            this.p.println(string);
            return;
        }
        int n2 = vRMLFieldDeclaration.getAccessType();
        if (n2 == 1 || n2 == 4) {
            this.p.println(vRMLFieldDeclaration.getName());
            return;
        }
        if (vRMLFieldData != null) {
            switch (vRMLFieldData.dataType) {
                case 7: {
                    break;
                }
                case 13: {
                    break;
                }
                default: {
                    this.p.print(vRMLFieldDeclaration.getName());
                    this.p.print(" ");
                    this.printFieldValue(vRMLNodeType, vRMLFieldData, vRMLFieldDeclaration);
                    this.p.println();
                }
            }
        }
    }

    private boolean isDefault(VRMLNodeType vRMLNodeType, VRMLFieldDeclaration vRMLFieldDeclaration, int n, VRMLFieldData vRMLFieldData, VRMLNodeType vRMLNodeType2) {
        VRMLFieldData vRMLFieldData2;
        try {
            vRMLFieldData2 = vRMLNodeType2.getFieldValue(n);
        }
        catch (Exception exception) {
            StringBuffer stringBuffer = new StringBuffer("Can't get field: ");
            stringBuffer.append(vRMLFieldDeclaration.getName());
            stringBuffer.append(" for: ");
            stringBuffer.append(vRMLNodeType);
            stringBuffer.append(" named: ");
            stringBuffer.append(vRMLNodeType.getVRMLNodeName());
            stringBuffer.append("\nIndex: ");
            stringBuffer.append(n);
            this.errorReporter.errorReport(stringBuffer.toString(), null);
            return false;
        }
        if (vRMLFieldData == null) {
            return true;
        }
        boolean bl = true;
        block1 : switch (vRMLFieldData.dataType) {
            case 1: {
                if (vRMLFieldData2.booleanValue == vRMLFieldData.booleanValue) break;
                bl = false;
                break;
            }
            case 2: {
                if (vRMLFieldData2.intValue == vRMLFieldData.intValue) break;
                bl = false;
                break;
            }
            case 3: {
                if (vRMLFieldData2.longValue == vRMLFieldData.longValue) break;
                bl = false;
                break;
            }
            case 4: {
                if (vRMLFieldData2.floatValue == vRMLFieldData.floatValue) break;
                bl = false;
                break;
            }
            case 5: {
                if (vRMLFieldData2.doubleValue == vRMLFieldData.doubleValue) break;
                bl = false;
                break;
            }
            case 6: {
                if (vRMLFieldData2.stringValue == vRMLFieldData.stringValue) break;
                bl = false;
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                if (vRMLFieldData2.booleanArrayValue == null && vRMLFieldData.booleanArrayValue == null) break;
                if (vRMLFieldData2.booleanArrayValue == null || vRMLFieldData.booleanArrayValue == null) {
                    bl = false;
                    break;
                }
                if (vRMLFieldData2.booleanArrayValue.length != vRMLFieldData.booleanArrayValue.length) {
                    bl = false;
                    break;
                }
                int n2 = vRMLFieldData2.booleanArrayValue.length;
                for (int i = 0; i < n2; ++i) {
                    if (vRMLFieldData2.booleanArrayValue[i] == vRMLFieldData.booleanArrayValue[i]) continue;
                    bl = false;
                    break block1;
                }
                break;
            }
            case 9: {
                if (vRMLFieldData2.intArrayValue == null && vRMLFieldData.intArrayValue == null) break;
                if (vRMLFieldData2.intArrayValue == null || vRMLFieldData.intArrayValue == null) {
                    bl = false;
                    break;
                }
                if (vRMLFieldData2.intArrayValue.length != vRMLFieldData.intArrayValue.length) {
                    bl = false;
                    break;
                }
                int n3 = vRMLFieldData2.intArrayValue.length;
                for (int i = 0; i < n3; ++i) {
                    if (vRMLFieldData2.intArrayValue[i] == vRMLFieldData.intArrayValue[i]) continue;
                    bl = false;
                    break block1;
                }
                break;
            }
            case 10: {
                if (vRMLFieldData2.longArrayValue == null && vRMLFieldData.longArrayValue == null) break;
                if (vRMLFieldData2.longArrayValue == null || vRMLFieldData.longArrayValue == null) {
                    bl = false;
                    break;
                }
                if (vRMLFieldData2.longArrayValue.length != vRMLFieldData.longArrayValue.length) {
                    bl = false;
                    break;
                }
                int n4 = vRMLFieldData2.longArrayValue.length;
                for (int i = 0; i < n4; ++i) {
                    if (vRMLFieldData2.longArrayValue[i] == vRMLFieldData.longArrayValue[i]) continue;
                    bl = false;
                    break block1;
                }
                break;
            }
            case 11: {
                if (vRMLFieldData2.floatArrayValue == null && vRMLFieldData.floatArrayValue == null) break;
                if (vRMLFieldData2.floatArrayValue == null || vRMLFieldData.floatArrayValue == null) {
                    bl = false;
                    break;
                }
                if (vRMLFieldData2.floatArrayValue.length != vRMLFieldData.floatArrayValue.length) {
                    bl = false;
                    break;
                }
                int n5 = vRMLFieldData2.floatArrayValue.length;
                for (int i = 0; i < n5; ++i) {
                    if (vRMLFieldData2.floatArrayValue[i] == vRMLFieldData.floatArrayValue[i]) continue;
                    bl = false;
                    break block1;
                }
                break;
            }
            case 12: {
                if (vRMLFieldData2.doubleArrayValue == null && vRMLFieldData.doubleArrayValue == null) break;
                if (vRMLFieldData2.doubleArrayValue == null || vRMLFieldData.doubleArrayValue == null) {
                    bl = false;
                    break;
                }
                if (vRMLFieldData2.doubleArrayValue.length != vRMLFieldData.doubleArrayValue.length) {
                    bl = false;
                    break;
                }
                int n6 = vRMLFieldData2.doubleArrayValue.length;
                for (int i = 0; i < n6; ++i) {
                    if (vRMLFieldData2.doubleArrayValue[i] == vRMLFieldData.doubleArrayValue[i]) continue;
                    bl = false;
                    break block1;
                }
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                if (vRMLFieldData2.stringArrayValue == null && vRMLFieldData.stringArrayValue == null) break;
                if (vRMLFieldData2.stringArrayValue == null || vRMLFieldData.stringArrayValue == null) {
                    bl = false;
                    break;
                }
                if (vRMLFieldData2.stringArrayValue.length != vRMLFieldData.stringArrayValue.length) {
                    bl = false;
                    break;
                }
                int n7 = vRMLFieldData2.stringArrayValue.length;
                for (int i = 0; i < n7; ++i) {
                    if (vRMLFieldData2.stringArrayValue[i] == null && vRMLFieldData.stringArrayValue[i] == null) continue;
                    if (vRMLFieldData2.stringArrayValue[i] == null || vRMLFieldData.stringArrayValue[i] == null) {
                        bl = false;
                        break block1;
                    }
                    if (vRMLFieldData2.stringArrayValue[i].equals(vRMLFieldData.stringArrayValue[i])) continue;
                    bl = false;
                    break block1;
                }
                break;
            }
        }
        return bl;
    }

    private void printFieldValue(VRMLNodeType vRMLNodeType, VRMLFieldData vRMLFieldData, VRMLFieldDeclaration vRMLFieldDeclaration) {
        String string;
        Integer n;
        if (vRMLFieldData == null) {
            int n2 = vRMLFieldDeclaration.getFieldType();
            if (n2 % 2 == 0) {
                this.p.print("[ ]");
            } else if (n2 == 11) {
                this.p.print("NULL");
            } else if (n2 == 27) {
                this.p.print("\"\"");
            } else {
                this.errorReporter.warningReport("Empty value field for: " + vRMLFieldDeclaration, null);
            }
            return;
        }
        if (this.convertOldContent && vRMLNodeType != null && (n = (Integer)this.fieldRemap.get(string = vRMLNodeType.getVRMLNodeName() + "." + vRMLFieldDeclaration.getName())) != null) {
            int n3 = n;
            this.convertFieldData(n3, vRMLFieldData, vRMLFieldDeclaration);
        }
        switch (vRMLFieldData.dataType) {
            case 13: {
                break;
            }
            case 7: {
                break;
            }
            case 1: {
                if (vRMLFieldData.booleanValue) {
                    this.p.println("TRUE");
                    break;
                }
                this.p.println("FALSE");
                break;
            }
            case 2: {
                this.p.println(vRMLFieldData.intValue);
                break;
            }
            case 3: {
                this.p.println(vRMLFieldData.longValue);
                break;
            }
            case 4: {
                this.p.println(vRMLFieldData.floatValue);
                break;
            }
            case 5: {
                this.p.println(vRMLFieldData.doubleValue);
                break;
            }
            case 6: {
                if (vRMLFieldData.stringValue == null) {
                    this.p.println("\"\"");
                    break;
                }
                this.p.print("\"");
                this.p.print(vRMLFieldData.stringValue);
                this.p.println("\"");
                break;
            }
            case 8: {
                if (vRMLFieldData.booleanArrayValue == null) break;
                this.p.print("[");
                int n4 = vRMLFieldData.numElements;
                for (int i = 0; i < n4; ++i) {
                    if (i == n4 - 1) {
                        if (vRMLFieldData.booleanArrayValue[i]) {
                            this.p.print("TRUE");
                            continue;
                        }
                        this.p.print("FALSE");
                        continue;
                    }
                    if (vRMLFieldData.booleanArrayValue[i]) {
                        this.p.print("TRUE,");
                        continue;
                    }
                    this.p.print("FALSE,");
                }
                this.p.println("]");
                break;
            }
            case 9: {
                if (vRMLFieldData.intArrayValue == null) break;
                this.p.print("[");
                int n5 = vRMLFieldData.numElements;
                for (int i = 0; i < n5; ++i) {
                    if (i == n5 - 1) {
                        this.p.print(vRMLFieldData.intArrayValue[i]);
                        continue;
                    }
                    this.p.print(vRMLFieldData.intArrayValue[i]);
                    this.p.print(" ");
                }
                this.p.println("]");
                break;
            }
            case 10: {
                if (vRMLFieldData.longArrayValue == null) break;
                this.p.print("[");
                int n6 = vRMLFieldData.numElements;
                for (int i = 0; i < n6; ++i) {
                    if (i == n6 - 1) {
                        this.p.print(vRMLFieldData.longArrayValue[i]);
                        continue;
                    }
                    this.p.print(vRMLFieldData.longArrayValue[i]);
                    this.p.print(" ");
                }
                this.p.println("]");
                break;
            }
            case 11: {
                if (vRMLFieldData.floatArrayValue == null) break;
                boolean bl = this.isMFField(vRMLFieldDeclaration);
                if (bl) {
                    this.p.print("[");
                    int n7 = vRMLFieldData.numElements;
                    if (n7 > 0) {
                        int n8 = vRMLFieldData.floatArrayValue.length / n7;
                        int n9 = 0;
                        for (int i = 0; i < n7; ++i) {
                            for (int j = 0; j < n8; ++j) {
                                this.p.print(vRMLFieldData.floatArrayValue[n9++]);
                                if (j == n8 - 1) continue;
                                this.p.print(" ");
                            }
                            if (i == n7 - 1) continue;
                            this.p.print(" ,");
                        }
                    }
                    this.p.println("]");
                    break;
                }
                int n10 = vRMLFieldData.floatArrayValue.length;
                for (int i = 0; i < n10; ++i) {
                    this.p.print(vRMLFieldData.floatArrayValue[i]);
                    if (i == n10 - 1) continue;
                    this.p.print(" ");
                }
                this.p.println();
                break;
            }
            case 12: {
                if (vRMLFieldData.doubleArrayValue == null) break;
                boolean bl = this.isMFField(vRMLFieldDeclaration);
                if (bl) {
                    this.p.print("[");
                    int n11 = vRMLFieldData.numElements;
                    if (n11 > 0) {
                        int n12 = vRMLFieldData.doubleArrayValue.length / n11;
                        int n13 = 0;
                        for (int i = 0; i < n11; ++i) {
                            for (int j = 0; j < n12; ++j) {
                                this.p.print(vRMLFieldData.doubleArrayValue[n13++]);
                                if (j == n12 - 1) continue;
                                this.p.print(" ");
                            }
                            if (i == n11 - 1) continue;
                            this.p.print(" ,");
                        }
                    }
                    this.p.println("]");
                    break;
                }
                int n14 = vRMLFieldData.doubleArrayValue.length;
                for (int i = 0; i < n14; ++i) {
                    this.p.print(vRMLFieldData.doubleArrayValue[i]);
                    if (i == n14 - 1) continue;
                    this.p.print(" ");
                }
                this.p.println();
                break;
            }
            case 14: {
                if (vRMLFieldData.stringArrayValue == null) break;
                this.p.print("[");
                int n15 = vRMLFieldData.numElements;
                for (int i = 0; i < n15; ++i) {
                    if (i == n15 - 1) {
                        this.p.print("\"");
                        this.p.print(vRMLFieldData.stringArrayValue[i]);
                        this.p.print("\"");
                        continue;
                    }
                    this.p.print("\"");
                    this.p.print(vRMLFieldData.stringArrayValue[i]);
                    this.p.print("\",");
                }
                this.p.println("]");
                break;
            }
            default: {
                this.errorReporter.messageReport("Unhandled case in switch printFieldValue");
            }
        }
    }
}

