/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.parser.x3d;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.web3d.parser.x3d.ParseException;
import org.web3d.parser.x3d.X3DBinaryParser;
import org.web3d.parser.x3d.X3DRelaxedParser;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.parser.BaseReader;
import org.web3d.vrml.parser.VRMLParserUtils;
import org.web3d.vrml.sav.ContentHandler;
import org.web3d.vrml.sav.InputSource;
import org.web3d.vrml.sav.Locator;
import org.web3d.vrml.sav.ProtoHandler;
import org.web3d.vrml.sav.RouteHandler;
import org.web3d.vrml.sav.SAVException;
import org.web3d.vrml.sav.SAVNotSupportedException;
import org.web3d.vrml.sav.ScriptHandler;
import org.web3d.vrml.sav.VRMLParseException;
import org.web3d.x3d.jaxp.X3DEntityResolver;
import org.web3d.x3d.jaxp.X3DErrorHandler;
import org.web3d.x3d.jaxp.X3DSAVAdapter;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class X3DReader
extends BaseReader {
    private static final String NAMESPACE_PROP = "useNamespaces";
    private static final String LEXICAL_HANDLER_PROP = "http://xml.org/sax/properties/lexical-handler";
    private X3DRelaxedParser relaxedParser;
    private X3DBinaryParser binaryParser;
    private SAXParserFactory parserFactory;
    private X3DSAVAdapter adapter;
    private X3DEntityResolver resolver;
    private X3DErrorHandler x3dErrors;

    public X3DReader() {
        this.properties.put(NAMESPACE_PROP, Boolean.FALSE);
        try {
            this.parserFactory = SAXParserFactory.newInstance();
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            throw new org.web3d.vrml.parser.FactoryConfigurationError("No SAX parser defined");
        }
        this.adapter = new X3DSAVAdapter();
        this.x3dErrors = new X3DErrorHandler();
        this.resolver = new X3DEntityResolver();
    }

    public void parse(final InputSource inputSource) throws IOException, VRMLException {
        block25: {
            Object object;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            PushbackInputStream pushbackInputStream = null;
            String string = inputSource.getURL();
            String string2 = null;
            if (string != null && string.endsWith(".x3db")) {
                string2 = "model/x3d+binary";
            }
            try {
                object = (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        return inputSource.getByteStream();
                    }
                });
                pushbackInputStream = new PushbackInputStream((InputStream)object);
            }
            catch (PrivilegedActionException privilegedActionException) {
                String string3 = "IO Error while attempting to access file " + inputSource.getURL();
                IOException iOException = new IOException(string3);
                iOException.initCause(privilegedActionException.getException());
                throw iOException;
            }
            if (string2 != null && string2.equals("model/x3d+binary")) {
                bl3 = true;
            } else {
                int n = 0;
                block13: while (!bl) {
                    n = pushbackInputStream.read();
                    switch (n) {
                        case 224: {
                            bl3 = true;
                            bl = true;
                            continue block13;
                        }
                        case 60: {
                            bl2 = true;
                            bl = true;
                            continue block13;
                        }
                        case 35: {
                            bl2 = false;
                            bl = true;
                            continue block13;
                        }
                        case 9: 
                        case 10: 
                        case 13: 
                        case 32: {
                            continue block13;
                        }
                    }
                    bl = true;
                }
                if (n != -1) {
                    pushbackInputStream.unread(n);
                }
            }
            object = (String)this.properties.get("conformance");
            if (bl2) {
                Object object2;
                boolean bl4 = ((String)object).equals("weak");
                Boolean bl5 = (Boolean)this.properties.get(NAMESPACE_PROP);
                this.parserFactory.setValidating(!bl4);
                this.parserFactory.setNamespaceAware(bl5);
                XMLReader xMLReader = null;
                try {
                    object2 = this.parserFactory.newSAXParser();
                    this.adapter.setLoadState(inputSource.getBaseURL(), inputSource.getURL(), false);
                    xMLReader = ((SAXParser)object2).getXMLReader();
                    xMLReader.setContentHandler(this.adapter);
                    xMLReader.setProperty(LEXICAL_HANDLER_PROP, this.adapter);
                    xMLReader.setErrorHandler(this.x3dErrors);
                    xMLReader.setEntityResolver(this.resolver);
                }
                catch (Exception exception) {
                    throw new IOException("Unable to configure factory as required");
                }
                object2 = new org.xml.sax.InputSource();
                ((org.xml.sax.InputSource)object2).setByteStream(pushbackInputStream);
                ((org.xml.sax.InputSource)object2).setEncoding(inputSource.getEncoding());
                try {
                    xMLReader.parse((org.xml.sax.InputSource)object2);
                }
                catch (SAXException sAXException) {
                    Exception exception = sAXException.getException();
                    if (exception != null) {
                        this.errorReporter.errorReport("Error parsing XML", exception);
                        break block25;
                    }
                    this.errorReporter.errorReport("Error parsing XML", sAXException);
                }
                catch (VRMLException vRMLException) {
                    this.errorReporter.errorReport("Error parsing XML", vRMLException);
                }
            } else {
                String string4 = inputSource.getBaseURL();
                String string5 = inputSource.getURL();
                if (string5 == null) {
                    string5 = "Unknown URL source. Base URL is " + string4;
                }
                if (((String)object).equals("weak")) {
                    this.parseVRMLWeakly(pushbackInputStream, bl3, string4, string5);
                } else if (((String)object).equals("strict")) {
                    this.parseVRMLStrictly(pushbackInputStream, bl3, string4, string5);
                }
            }
        }
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        super.setErrorReporter(errorReporter);
        this.x3dErrors.setErrorReporter(errorReporter);
    }

    public void setContentHandler(ContentHandler contentHandler) {
        super.setContentHandler(contentHandler);
        this.adapter.setContentHandler(contentHandler);
    }

    public void setScriptHandler(ScriptHandler scriptHandler) {
        super.setScriptHandler(scriptHandler);
        this.adapter.setScriptHandler(scriptHandler);
    }

    public void setProtoHandler(ProtoHandler protoHandler) {
        super.setProtoHandler(protoHandler);
        this.adapter.setProtoHandler(protoHandler);
    }

    public void setRouteHandler(RouteHandler routeHandler) {
        super.setRouteHandler(routeHandler);
        this.adapter.setRouteHandler(routeHandler);
    }

    private void parseVRMLWeakly(InputStream inputStream, boolean bl, String string, String string2) throws IOException, VRMLException {
        String[] stringArray = null;
        boolean bl2 = false;
        if (bl) {
            bl2 = true;
        } else if (!this.ignoreHeader) {
            stringArray = VRMLParserUtils.parseFileHeader(inputStream);
            if (stringArray.length != 4) {
                throw new VRMLParseException(1, 1, "Header missing #X3D statement.  File: " + string2);
            }
            if (!stringArray[0].equals("#X3D")) {
                throw new VRMLParseException(1, 1, "Invalid header. Not a X3D file.  File: " + string2);
            }
            if (stringArray[1] == null || !stringArray[1].equals("V3.0") && !stringArray[1].equals("V3.1") && !stringArray[1].equals("V3.2")) {
                throw new VRMLParseException(1, 1, "Unsupported version " + stringArray[1]);
            }
            if (stringArray[2] == null || !stringArray[2].equals("utf8")) {
                throw new VRMLParseException(1, 1, "Unsupported encoding " + stringArray[2]);
            }
        } else {
            stringArray = new String[4];
            stringArray[0] = "#X3D";
            stringArray[1] = "V3.2";
            stringArray[2] = "utf8";
        }
        Locator locator = null;
        if (bl2) {
            if (this.binaryParser == null) {
                this.binaryParser = new X3DBinaryParser(inputStream);
                this.binaryParser.initialize();
            } else {
                this.binaryParser.ReInit(inputStream);
            }
            this.binaryParser.setContentHandler(this.contentHandler);
            this.binaryParser.setRouteHandler(this.routeHandler);
            this.binaryParser.setScriptHandler(this.scriptHandler);
            this.binaryParser.setProtoHandler(this.protoHandler);
            this.binaryParser.setErrorReporter(this.errorReporter);
            this.binaryParser.setDocumentUrl(string2);
            locator = this.binaryParser.getDocumentLocator();
        } else {
            if (this.relaxedParser == null) {
                this.relaxedParser = new X3DRelaxedParser(inputStream);
                this.relaxedParser.initialize();
            } else {
                this.relaxedParser.ReInit(inputStream);
            }
            this.relaxedParser.setContentHandler(this.contentHandler);
            this.relaxedParser.setRouteHandler(this.routeHandler);
            this.relaxedParser.setScriptHandler(this.scriptHandler);
            this.relaxedParser.setProtoHandler(this.protoHandler);
            this.relaxedParser.setErrorReporter(this.errorReporter);
            this.relaxedParser.setDocumentUrl(string2);
            locator = this.relaxedParser.getDocumentLocator();
        }
        try {
            if (bl2) {
                this.binaryParser.Scene();
            } else {
                if (this.contentHandler != null) {
                    this.contentHandler.setDocumentLocator(locator);
                    this.contentHandler.startDocument(string2, string, stringArray[2], stringArray[0], stringArray[1], stringArray[3]);
                }
                this.relaxedParser.Scene();
                if (this.contentHandler != null) {
                    this.contentHandler.endDocument();
                }
            }
        }
        catch (ParseException parseException) {
            VRMLParseException vRMLParseException = new VRMLParseException(locator.getLineNumber(), locator.getColumnNumber(), "Error in file: " + string2 + "\n" + parseException.getMessage());
            throw vRMLParseException;
        }
    }

    private void parseVRMLStrictly(InputStream inputStream, boolean bl, String string, String string2) throws IOException, SAVException {
        throw new SAVNotSupportedException("Strict parsing not implemented yet");
    }
}

