/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.parser.x3d;

import com.sun.xml.fastinfoset.sax.SAXDocumentParser;
import com.sun.xml.fastinfoset.vocab.ParserVocabulary;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import org.jvnet.fastinfoset.sax.EncodingAlgorithmContentHandler;
import org.jvnet.fastinfoset.sax.PrimitiveTypeContentHandler;
import org.web3d.parser.x3d.ByteEncodingAlgorithm;
import org.web3d.parser.x3d.DeltazlibIntArrayAlgorithm;
import org.web3d.parser.x3d.FastInfosetElementReader;
import org.web3d.parser.x3d.ParseException;
import org.web3d.parser.x3d.QuantizedzlibFloatArrayAlgorithm;
import org.web3d.parser.x3d.X3DBinaryVocabulary;
import org.web3d.parser.x3d.X3DRelaxedParserConstants;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.sav.BinaryContentHandler;
import org.web3d.vrml.sav.ContentHandler;
import org.web3d.vrml.sav.ErrorHandler;
import org.web3d.vrml.sav.Locator;
import org.web3d.vrml.sav.ProtoHandler;
import org.web3d.vrml.sav.RouteHandler;
import org.web3d.vrml.sav.ScriptHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class X3DBinaryParser
implements X3DRelaxedParserConstants {
    protected static final int BYTE_ALGORITHM_ID = 32;
    protected static final int DELTA_ZLIB_INT_ARRAY_ALGORITHM_ID = 33;
    protected static final int QUANTIZED_ZLIB_FLOAT_ARRAY_ALGORITHM_ID = 34;
    protected static final String EXTERNAL_VOCABULARY_URI_STRING = "urn:external-vocabulary";
    private static final String PARSE_MSG = "Parsing error: ";
    private static final String PROFILE_MSG = "PROFILE declaration error: ";
    private static final String COMPONENT_MSG = "COMPONENT declaration error: ";
    private static final String META_MSG = "META declaration error: ";
    private static final int DEFAULT_ARRAY_SIZE = 4096;
    private static final int DEFAULT_ARRAY_INC = 1024;
    private FastInfosetElementReader fer;
    private SAXDocumentParser fr;
    private X3DBinaryVocabulary vocab;
    private String documentURL;
    private BinaryContentHandler contentHandler;
    private RouteHandler routeHandler;
    private ScriptHandler scriptHandler;
    private ProtoHandler protoHandler;
    private ErrorReporter errorHandler;
    private Locator locator;
    private InputStream is;
    private Reader reader;

    public X3DBinaryParser(InputStream inputStream, ContentHandler contentHandler, RouteHandler routeHandler, ScriptHandler scriptHandler, ProtoHandler protoHandler, ErrorHandler errorHandler) {
        this.locator = new VRMLRelaxedLocator();
        this.contentHandler = (BinaryContentHandler)contentHandler;
        this.routeHandler = routeHandler;
        this.scriptHandler = scriptHandler;
        this.protoHandler = protoHandler;
        this.errorHandler = errorHandler;
        this.ReInit(inputStream);
    }

    public X3DBinaryParser(Reader reader, ContentHandler contentHandler, RouteHandler routeHandler, ScriptHandler scriptHandler, ProtoHandler protoHandler, ErrorHandler errorHandler) {
        this.locator = new VRMLRelaxedLocator();
        this.contentHandler = (BinaryContentHandler)contentHandler;
        this.routeHandler = routeHandler;
        this.scriptHandler = scriptHandler;
        this.protoHandler = protoHandler;
        this.errorHandler = errorHandler;
        this.ReInit(reader);
    }

    public X3DBinaryParser(InputStream inputStream) {
        this.is = new BufferedInputStream(inputStream);
    }

    public X3DBinaryParser(Reader reader) {
    }

    public void ReInit(Reader reader) {
        this.fer = new FastInfosetElementReader();
        this.fr = this.getSAXParser();
        this.fer.setContentHandler(this.contentHandler);
        this.fer.setProtoHandler(this.protoHandler);
        this.fer.setScriptHandler(this.scriptHandler);
        this.fer.setRouteHandler(this.routeHandler);
        this.fer.setErrorReporter(this.errorHandler);
        this.fr.setContentHandler((org.xml.sax.ContentHandler)this.fer);
        this.fr.setLexicalHandler((LexicalHandler)this.fer);
    }

    public void ReInit(InputStream inputStream) {
        this.reader = new InputStreamReader(inputStream);
        this.fer = new FastInfosetElementReader();
        this.fr = this.getSAXParser();
        this.fer.setContentHandler(this.contentHandler);
        this.fer.setProtoHandler(this.protoHandler);
        this.fer.setScriptHandler(this.scriptHandler);
        this.fer.setRouteHandler(this.routeHandler);
        this.fer.setErrorReporter(this.errorHandler);
        this.fr.setContentHandler((org.xml.sax.ContentHandler)this.fer);
        this.fr.setLexicalHandler((LexicalHandler)this.fer);
    }

    public void initialize() {
        if (this.locator == null) {
            this.locator = new VRMLRelaxedLocator();
        }
        this.fer = new FastInfosetElementReader();
        this.fr = this.getSAXParser();
        this.fer.setContentHandler(this.contentHandler);
        this.fer.setProtoHandler(this.protoHandler);
        this.fer.setScriptHandler(this.scriptHandler);
        this.fer.setRouteHandler(this.routeHandler);
        this.fer.setErrorReporter(this.errorHandler);
        this.fr.setContentHandler((org.xml.sax.ContentHandler)this.fer);
        this.fr.setLexicalHandler((LexicalHandler)this.fer);
    }

    public void setDocumentUrl(String string) {
        this.documentURL = string;
    }

    public Locator getDocumentLocator() {
        if (this.locator == null) {
            this.locator = new VRMLRelaxedLocator();
        }
        return this.locator;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        if (contentHandler instanceof BinaryContentHandler) {
            this.contentHandler = (BinaryContentHandler)contentHandler;
            this.fer.setContentHandler(this.contentHandler);
        } else {
            this.errorHandler.messageReport("Inavlid ContentHandler provided, must be a BinaryContentHandler");
        }
    }

    public void setRouteHandler(RouteHandler routeHandler) {
        this.routeHandler = routeHandler;
        this.fer.setRouteHandler(routeHandler);
    }

    public void setScriptHandler(ScriptHandler scriptHandler) {
        this.scriptHandler = scriptHandler;
        this.fer.setScriptHandler(scriptHandler);
    }

    public void setProtoHandler(ProtoHandler protoHandler) {
        this.protoHandler = protoHandler;
        this.fer.setProtoHandler(protoHandler);
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
        if (errorHandler != null) {
            errorHandler.setDocumentLocator(this.getDocumentLocator());
        }
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        if (errorReporter instanceof ErrorHandler) {
            this.setErrorHandler((ErrorHandler)errorReporter);
        } else {
            this.errorHandler = errorReporter;
        }
    }

    private void convertException(VRMLException vRMLException) throws ParseException {
        boolean bl = false;
        if (vRMLException instanceof InvalidFieldException || vRMLException instanceof InvalidFieldValueException) {
            if (this.errorHandler != null) {
                try {
                    this.errorHandler.warningReport(PARSE_MSG, vRMLException);
                    bl = true;
                }
                catch (VRMLException vRMLException2) {
                    vRMLException = vRMLException2;
                }
            }
        } else if (this.errorHandler != null) {
            try {
                this.errorHandler.errorReport(PARSE_MSG, vRMLException);
                bl = true;
            }
            catch (VRMLException vRMLException3) {
                vRMLException = vRMLException3;
            }
        }
        if (!bl) {
            StringBuffer stringBuffer = new StringBuffer("There's an error in the file:\n");
            stringBuffer.append(this.documentURL);
            stringBuffer.append('\n');
            String string = vRMLException.getMessage();
            if (string == null) {
                string = vRMLException.getClass().getName();
            }
            stringBuffer.append(string);
            stringBuffer.append('\n');
            throw new ParseException(stringBuffer.toString());
        }
    }

    public void Scene() throws ParseException {
        try {
            InputSource inputSource = new InputSource(this.is);
            this.fr.parse(inputSource);
        }
        catch (IOException iOException) {
            ParseException parseException = new ParseException("Binary IO Error: " + iOException.getMessage());
            parseException.initCause(iOException);
            throw parseException;
        }
        catch (SAXException sAXException) {
            ParseException parseException = new ParseException("Binary Parsing Error: " + sAXException.getMessage());
            parseException.initCause(sAXException);
            throw parseException;
        }
    }

    private SAXDocumentParser getSAXParser() {
        SAXDocumentParser sAXDocumentParser = new SAXDocumentParser();
        try {
            sAXDocumentParser.setProperty("http://jvnet.org/fastinfoset/parser/properties/buffer-size", (Object)new Integer(25000000));
        }
        catch (Exception exception) {
            this.errorHandler.warningReport("Couldn't set octet buffer size", null);
        }
        ParserVocabulary parserVocabulary = new ParserVocabulary();
        parserVocabulary.encodingAlgorithm.add("http://www.web3d.org/binary/BYTE");
        parserVocabulary.encodingAlgorithm.add("encoder://web3d.org/DeltazlibIntArrayEncoder");
        parserVocabulary.encodingAlgorithm.add("encoder://web3d.org/QuantizedzlibFloatArrayEncoder");
        HashMap<String, ParserVocabulary> hashMap = new HashMap<String, ParserVocabulary>();
        hashMap.put(EXTERNAL_VOCABULARY_URI_STRING, X3DBinaryVocabulary.parserVoc);
        try {
            sAXDocumentParser.setProperty("http://jvnet.org/fastinfoset/parser/properties/external-vocabularies", hashMap);
        }
        catch (SAXException sAXException) {
            this.errorHandler.errorReport("Can't setup external vocabulary?", sAXException);
        }
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        hashMap2.put("http://www.web3d.org/binary/BYTE", new ByteEncodingAlgorithm());
        hashMap2.put("encoder://web3d.org/DeltazlibIntArrayEncoder", new DeltazlibIntArrayAlgorithm());
        hashMap2.put("encoder://web3d.org/QuantizedzlibFloatArrayEncoder", new QuantizedzlibFloatArrayAlgorithm());
        sAXDocumentParser.setRegisteredEncodingAlgorithms(hashMap2);
        sAXDocumentParser.setPrimitiveTypeContentHandler((PrimitiveTypeContentHandler)this.fer);
        sAXDocumentParser.setEncodingAlgorithmContentHandler((EncodingAlgorithmContentHandler)this.fer);
        return sAXDocumentParser;
    }

    private class VRMLRelaxedLocator
    implements Locator {
        private VRMLRelaxedLocator() {
        }

        public int getColumnNumber() {
            return 0;
        }

        public int getLineNumber() {
            return 0;
        }
    }
}

