/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.parser;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.web3d.parser.x3d.ParseException;
import org.web3d.parser.x3d.X3DBinaryParser;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.parser.BaseReader;
import org.web3d.vrml.sav.InputSource;
import org.web3d.vrml.sav.Locator;
import org.web3d.vrml.sav.SAVException;
import org.web3d.vrml.sav.SAVNotSupportedException;
import org.web3d.vrml.sav.VRMLParseException;

class BinaryReader
extends BaseReader {
    private X3DBinaryParser binary03;

    BinaryReader() {
    }

    public void parse(final InputSource inputSource) throws IOException, VRMLException {
        InputStream inputStream = null;
        String string = inputSource.getURL();
        try {
            inputStream = (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return inputSource.getByteStream();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            String string2 = "IO Error while attempting to access file " + inputSource.getURL();
            IOException iOException = new IOException(string2);
            iOException.initCause(privilegedActionException.getException());
            throw iOException;
        }
        String string3 = (String)this.properties.get("conformance");
        String string4 = inputSource.getBaseURL();
        String string5 = inputSource.getURL();
        if (string5 == null) {
            string5 = "Unknown URL source. Base URL is " + string4;
        }
        if (string3.equals("weak")) {
            this.parseVRMLWeakly(inputStream, string4, string5);
        } else if (string3.equals("strict")) {
            this.parseVRMLStrictly(inputStream, string4, string5);
        }
    }

    private void parseVRMLWeakly(InputStream inputStream, String string, String string2) throws IOException, VRMLException {
        if (this.binary03 == null) {
            this.binary03 = new X3DBinaryParser(inputStream);
            this.binary03.initialize();
        } else {
            this.binary03.ReInit(inputStream);
        }
        this.binary03.setContentHandler(this.contentHandler);
        this.binary03.setRouteHandler(this.routeHandler);
        this.binary03.setScriptHandler(this.scriptHandler);
        this.binary03.setProtoHandler(this.protoHandler);
        this.binary03.setErrorReporter(this.errorReporter);
        this.binary03.setDocumentUrl(string2);
        Locator locator = this.binary03.getDocumentLocator();
        try {
            this.binary03.Scene();
        }
        catch (ParseException parseException) {
            VRMLParseException vRMLParseException = new VRMLParseException(locator.getLineNumber(), locator.getColumnNumber(), "Error in file: " + string2 + "\n" + parseException.getMessage());
            throw vRMLParseException;
        }
    }

    protected void parseVRMLStrictly(InputStream inputStream, String string, String string2) throws IOException, SAVException {
        throw new SAVNotSupportedException("Strict parsing not implemented yet");
    }
}

