/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.aviatrix3d.util;

import org.j3d.aviatrix3d.Group;
import org.j3d.aviatrix3d.Layer;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.j3d.aviatrix3d.SharedNode;
import org.j3d.aviatrix3d.SimpleScene;
import org.j3d.aviatrix3d.rendering.CustomRenderable;
import org.j3d.renderer.aviatrix3d.util.SceneGraphTraversalObserver;
import org.j3d.util.DefaultErrorReporter;
import org.j3d.util.ErrorReporter;
import org.j3d.util.HashSet;

public class SceneGraphTraverser {
    private boolean inUse = false;
    private HashSet nodeRefs = new HashSet();
    private SceneGraphTraversalObserver observer;
    private ErrorReporter errorReporter = DefaultErrorReporter.getDefaultReporter();

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter == null ? DefaultErrorReporter.getDefaultReporter() : errorReporter;
    }

    public void setObserver(SceneGraphTraversalObserver sceneGraphTraversalObserver) {
        this.observer = sceneGraphTraversalObserver;
    }

    public void traverseGraph(SceneGraphObject sceneGraphObject) throws IllegalStateException {
        this.traverseGraph(null, sceneGraphObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void traverseGraph(SceneGraphObject sceneGraphObject, SceneGraphObject sceneGraphObject2) throws IllegalStateException {
        if (this.inUse) {
            throw new IllegalStateException("Currently traversing");
        }
        if (this.observer == null || sceneGraphObject2 == null) {
            return;
        }
        this.inUse = true;
        try {
            this.processSimpleNode(sceneGraphObject, sceneGraphObject2, 0);
        }
        finally {
            this.inUse = false;
        }
    }

    public void reset() {
        this.nodeRefs.clear();
    }

    private void recurseSceneGraphChild(SceneGraphObject sceneGraphObject, int n) {
        if (sceneGraphObject instanceof Group) {
            int n2 = n + 1;
            Group group = (Group)sceneGraphObject;
            int n3 = group.numChildren();
            for (int i = 0; i < n3; ++i) {
                this.processSimpleNode(sceneGraphObject, group.getChild(i), n2);
            }
        } else if (!(sceneGraphObject instanceof Layer)) {
            if (sceneGraphObject instanceof SimpleScene) {
                SimpleScene simpleScene = (SimpleScene)sceneGraphObject;
                this.processSimpleNode(sceneGraphObject, simpleScene.getRenderedGeometry(), n + 1);
            } else if (!(sceneGraphObject instanceof CustomRenderable) && sceneGraphObject instanceof SharedNode) {
                SharedNode sharedNode = (SharedNode)sceneGraphObject;
                this.processSimpleNode(sceneGraphObject, sharedNode.getChild(), n + 1);
            }
        }
    }

    private void processSimpleNode(SceneGraphObject sceneGraphObject, SceneGraphObject sceneGraphObject2, int n) {
        boolean bl = this.nodeRefs.contains((Object)sceneGraphObject2);
        if (!bl) {
            this.nodeRefs.add((Object)sceneGraphObject2);
        }
        try {
            this.observer.observedNode(sceneGraphObject, sceneGraphObject2, bl, n);
        }
        catch (Exception exception) {
            this.errorReporter.warningReport("Traversal error ", exception);
        }
        this.recurseSceneGraphChild(sceneGraphObject2, n++);
    }
}

