/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.aviatrix3d.util;

import javax.vecmath.Matrix4f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import org.j3d.aviatrix3d.QuadArray;
import org.j3d.aviatrix3d.TriangleArray;
import org.j3d.aviatrix3d.TriangleFanArray;
import org.j3d.aviatrix3d.TriangleStripArray;
import org.j3d.aviatrix3d.VertexGeometry;
import org.j3d.geom.GeometryData;
import org.j3d.geom.IntersectionUtils;
import org.j3d.util.MatrixUtils;

public class AVIntersectionUtils
extends IntersectionUtils {
    private Matrix4f reverseTx = new Matrix4f();
    private Point3d tmpOrigin = new Point3d();
    private Point3d tmpPoint = new Point3d();
    private Vector3d tmpDirection = new Vector3d();
    private float[] p1 = new float[3];
    private float[] p2 = new float[3];
    private float[] dataOut = new float[12];
    private MatrixUtils matrixUtils = new MatrixUtils();

    public boolean rayUnknownGeometry(Point3f point3f, Vector3f vector3f, float f, VertexGeometry vertexGeometry, Matrix4f matrix4f, Point3f point3f2, boolean bl) {
        boolean bl2 = false;
        this.matrixUtils.inverse(matrix4f, this.reverseTx);
        this.transform((Tuple3f)point3f, this.reverseTx, (Tuple3d)this.pickStart);
        this.transformNormal((Tuple3f)vector3f, this.reverseTx, (Tuple3d)this.pickDir);
        this.p1[0] = (float)this.pickStart.x;
        this.p1[1] = (float)this.pickStart.y;
        this.p1[2] = (float)this.pickStart.z;
        this.p2[0] = (float)this.pickDir.x;
        this.p2[1] = (float)this.pickDir.y;
        this.p2[2] = (float)this.pickDir.z;
        bl2 = vertexGeometry.pickLineRay(this.p1, this.p2, bl, this.dataOut, 0);
        point3f2.x = this.dataOut[0];
        point3f2.y = this.dataOut[1];
        point3f2.z = this.dataOut[2];
        if (bl2) {
            matrix4f.transform(point3f2);
        }
        return bl2;
    }

    public boolean rayUnknownGeometry(Point3f point3f, Vector3f vector3f, float f, VertexGeometry vertexGeometry, Point3f point3f2, boolean bl) {
        boolean bl2 = false;
        this.p1[0] = point3f.x;
        this.p1[1] = point3f.y;
        this.p1[2] = point3f.z;
        this.p2[0] = vector3f.x;
        this.p2[1] = vector3f.y;
        this.p2[2] = vector3f.z;
        bl2 = vertexGeometry.pickLineRay(this.p1, this.p2, bl, this.dataOut, 0);
        point3f2.x = this.dataOut[0];
        point3f2.y = this.dataOut[1];
        point3f2.z = this.dataOut[2];
        return bl2;
    }

    public boolean rayUnknownGeometry(Point3f point3f, Vector3f vector3f, float f, GeometryData geometryData, Matrix4f matrix4f, Point3f point3f2, boolean bl) {
        this.tmpOrigin.x = point3f.x;
        this.tmpOrigin.y = point3f.y;
        this.tmpOrigin.z = point3f.z;
        this.tmpDirection.x = vector3f.x;
        this.tmpDirection.y = vector3f.y;
        this.tmpDirection.z = vector3f.z;
        boolean bl2 = this.rayUnknownGeometry(this.tmpOrigin, this.tmpDirection, f, geometryData, matrix4f, this.tmpPoint, bl);
        point3f2.x = (float)this.tmpPoint.x;
        point3f2.y = (float)this.tmpPoint.y;
        point3f2.z = (float)this.tmpPoint.z;
        return bl2;
    }

    public boolean rayUnknownGeometry(Point3d point3d, Vector3d vector3d, float f, GeometryData geometryData, Matrix4f matrix4f, Point3d point3d2, boolean bl) {
        boolean bl2 = false;
        this.matrixUtils.inverse(matrix4f, this.reverseTx);
        this.transform((Tuple3d)point3d, this.reverseTx, (Tuple3d)this.pickStart);
        this.transformNormal((Tuple3d)vector3d, this.reverseTx, (Tuple3d)this.pickDir);
        switch (geometryData.geometryType) {
            case 1: {
                bl2 = this.rayTriangleArray(this.pickStart, this.pickDir, f, geometryData.coordinates, geometryData.vertexCount / 3, point3d2, bl);
                break;
            }
            case 2: {
                bl2 = this.rayQuadArray(this.pickStart, this.pickDir, f, geometryData.coordinates, geometryData.vertexCount / 4, point3d2, bl);
                break;
            }
            case 3: {
                bl2 = this.rayTriangleStripArray(this.pickStart, this.pickDir, f, geometryData.coordinates, geometryData.stripCounts, geometryData.numStrips, point3d2, bl);
                break;
            }
            case 4: {
                bl2 = this.rayTriangleFanArray(this.pickStart, this.pickDir, f, geometryData.coordinates, geometryData.stripCounts, geometryData.numStrips, point3d2, bl);
                break;
            }
            case 5: {
                bl2 = this.rayIndexedQuadArray(this.pickStart, this.pickDir, f, geometryData.coordinates, geometryData.indexes, geometryData.indexesCount, point3d2, bl);
                break;
            }
            case 6: {
                bl2 = this.rayIndexedTriangleArray(this.pickStart, this.pickDir, f, geometryData.coordinates, geometryData.indexes, geometryData.indexesCount, point3d2, bl);
            }
        }
        if (bl2) {
            this.transform((Tuple3d)point3d2, matrix4f);
        }
        return bl2;
    }

    public boolean rayUnknownGeometry(Point3d point3d, Vector3d vector3d, float f, VertexGeometry vertexGeometry, Matrix4f matrix4f, Point3d point3d2, boolean bl) {
        Object object = vertexGeometry.getUserData();
        if (object instanceof GeometryData) {
            return this.rayUnknownGeometry(point3d, vector3d, f, (GeometryData)object, matrix4f, point3d2, bl);
        }
        if (vertexGeometry instanceof TriangleArray) {
            return this.rayTriangleArray(point3d, vector3d, f, (TriangleArray)vertexGeometry, matrix4f, point3d2, bl);
        }
        if (vertexGeometry instanceof QuadArray) {
            return this.rayQuadArray(point3d, vector3d, f, (QuadArray)vertexGeometry, matrix4f, point3d2, bl);
        }
        if (vertexGeometry instanceof TriangleStripArray) {
            return this.rayTriangleStripArray(point3d, vector3d, f, (TriangleStripArray)vertexGeometry, matrix4f, point3d2, bl);
        }
        if (vertexGeometry instanceof TriangleFanArray) {
            return this.rayTriangleFanArray(point3d, vector3d, f, (TriangleFanArray)vertexGeometry, matrix4f, point3d2, bl);
        }
        return false;
    }

    public boolean rayTriangleArray(Point3d point3d, Vector3d vector3d, float f, TriangleArray triangleArray, Matrix4f matrix4f, Point3d point3d2, boolean bl) {
        int n = triangleArray.getValidVertexCount();
        if (this.workingCoords == null || this.workingCoords.length != n * 3) {
            this.workingCoords = new float[n * 3];
        }
        triangleArray.getVertices(this.workingCoords);
        this.matrixUtils.inverse(matrix4f, this.reverseTx);
        this.transform((Tuple3d)point3d, this.reverseTx, (Tuple3d)this.pickStart);
        this.transformNormal((Tuple3d)vector3d, this.reverseTx, (Tuple3d)this.pickDir);
        boolean bl2 = this.rayTriangleArray(this.pickStart, this.pickDir, f, this.workingCoords, n / 3, point3d2, bl);
        if (bl2) {
            this.transform((Tuple3d)point3d2, matrix4f);
        }
        return bl2;
    }

    public boolean rayQuadArray(Point3d point3d, Vector3d vector3d, float f, QuadArray quadArray, Matrix4f matrix4f, Point3d point3d2, boolean bl) {
        int n = quadArray.getValidVertexCount();
        if (this.workingCoords == null || this.workingCoords.length != n * 3) {
            this.workingCoords = new float[n * 4];
        }
        quadArray.getVertices(this.workingCoords);
        this.matrixUtils.inverse(matrix4f, this.reverseTx);
        this.transform((Tuple3d)point3d, this.reverseTx, (Tuple3d)this.pickStart);
        this.transformNormal((Tuple3d)vector3d, this.reverseTx, (Tuple3d)this.pickDir);
        boolean bl2 = this.rayTriangleArray(this.pickStart, this.pickDir, f, this.workingCoords, n / 4, point3d2, bl);
        if (bl2) {
            this.transform((Tuple3d)point3d2, matrix4f);
        }
        return bl2;
    }

    public boolean rayTriangleStripArray(Point3d point3d, Vector3d vector3d, float f, TriangleStripArray triangleStripArray, Matrix4f matrix4f, Point3d point3d2, boolean bl) {
        int n = triangleStripArray.getValidVertexCount();
        int n2 = triangleStripArray.getValidStripCount();
        if (this.workingCoords == null || this.workingCoords.length != n * 3) {
            this.workingCoords = new float[n * 3];
        }
        if (this.workingStrips == null || this.workingStrips.length != n2) {
            this.workingStrips = new int[n2];
        }
        triangleStripArray.getVertices(this.workingCoords);
        triangleStripArray.getStripCount(this.workingStrips);
        this.matrixUtils.inverse(matrix4f, this.reverseTx);
        this.transform((Tuple3d)point3d, this.reverseTx, (Tuple3d)this.pickStart);
        this.transformNormal((Tuple3d)vector3d, this.reverseTx, (Tuple3d)this.pickDir);
        boolean bl2 = this.rayTriangleStripArray(this.pickStart, this.pickDir, f, this.workingCoords, this.workingStrips, n2, point3d2, bl);
        if (bl2 && !bl) {
            this.transform((Tuple3d)point3d2, matrix4f);
        }
        return bl2;
    }

    public boolean rayTriangleFanArray(Point3d point3d, Vector3d vector3d, float f, TriangleFanArray triangleFanArray, Matrix4f matrix4f, Point3d point3d2, boolean bl) {
        int n = triangleFanArray.getValidVertexCount();
        int n2 = triangleFanArray.getValidFanCount();
        if (this.workingCoords == null || this.workingCoords.length != n * 3) {
            this.workingCoords = new float[n * 3];
        }
        if (this.workingStrips == null || this.workingStrips.length != n2) {
            this.workingStrips = new int[n2];
        }
        triangleFanArray.getVertices(this.workingCoords);
        triangleFanArray.getFanCount(this.workingStrips);
        this.matrixUtils.inverse(matrix4f, this.reverseTx);
        this.transform((Tuple3d)point3d, this.reverseTx, (Tuple3d)this.pickStart);
        this.transformNormal((Tuple3d)vector3d, this.reverseTx, (Tuple3d)this.pickDir);
        boolean bl2 = this.rayTriangleFanArray(this.pickStart, this.pickDir, f, this.workingCoords, this.workingStrips, n2, point3d2, bl);
        if (bl2 && !bl) {
            this.transform((Tuple3d)point3d2, matrix4f);
        }
        return bl2;
    }

    private void transform(Tuple3d tuple3d, Matrix4f matrix4f) {
        float f = (float)tuple3d.x;
        float f2 = (float)tuple3d.y;
        float f3 = (float)tuple3d.z;
        tuple3d.x = matrix4f.m00 * f + matrix4f.m01 * f2 + matrix4f.m02 * f3 + matrix4f.m03;
        tuple3d.y = matrix4f.m10 * f + matrix4f.m11 * f2 + matrix4f.m12 * f3 + matrix4f.m13;
        tuple3d.z = matrix4f.m20 * f + matrix4f.m21 * f2 + matrix4f.m22 * f3 + matrix4f.m23;
    }

    private void transform(Tuple3f tuple3f, Matrix4f matrix4f) {
        float f = tuple3f.x;
        float f2 = tuple3f.y;
        float f3 = tuple3f.z;
        tuple3f.x = matrix4f.m00 * f + matrix4f.m01 * f2 + matrix4f.m02 * f3 + matrix4f.m03;
        tuple3f.y = matrix4f.m10 * f + matrix4f.m11 * f2 + matrix4f.m12 * f3 + matrix4f.m13;
        tuple3f.z = matrix4f.m20 * f + matrix4f.m21 * f2 + matrix4f.m22 * f3 + matrix4f.m23;
    }

    private void transform(Tuple3d tuple3d, Matrix4f matrix4f, Tuple3d tuple3d2) {
        float f = (float)tuple3d.x;
        float f2 = (float)tuple3d.y;
        float f3 = (float)tuple3d.z;
        tuple3d2.x = matrix4f.m00 * f + matrix4f.m01 * f2 + matrix4f.m02 * f3 + matrix4f.m03;
        tuple3d2.y = matrix4f.m10 * f + matrix4f.m11 * f2 + matrix4f.m12 * f3 + matrix4f.m13;
        tuple3d2.z = matrix4f.m20 * f + matrix4f.m21 * f2 + matrix4f.m22 * f3 + matrix4f.m23;
    }

    private void transform(Tuple3f tuple3f, Matrix4f matrix4f, Tuple3d tuple3d) {
        float f = tuple3f.x;
        float f2 = tuple3f.y;
        float f3 = tuple3f.z;
        tuple3d.x = matrix4f.m00 * f + matrix4f.m01 * f2 + matrix4f.m02 * f3 + matrix4f.m03;
        tuple3d.y = matrix4f.m10 * f + matrix4f.m11 * f2 + matrix4f.m12 * f3 + matrix4f.m13;
        tuple3d.z = matrix4f.m20 * f + matrix4f.m21 * f2 + matrix4f.m22 * f3 + matrix4f.m23;
    }

    private void transformNormal(Tuple3d tuple3d, Matrix4f matrix4f, Tuple3d tuple3d2) {
        float f = (float)tuple3d.x;
        float f2 = (float)tuple3d.y;
        float f3 = (float)tuple3d.z;
        tuple3d2.x = matrix4f.m00 * f + matrix4f.m01 * f2 + matrix4f.m02 * f3;
        tuple3d2.y = matrix4f.m10 * f + matrix4f.m11 * f2 + matrix4f.m12 * f3;
        tuple3d2.z = matrix4f.m20 * f + matrix4f.m21 * f2 + matrix4f.m22 * f3;
    }

    private void transformNormal(Tuple3f tuple3f, Matrix4f matrix4f, Tuple3d tuple3d) {
        float f = tuple3f.x;
        float f2 = tuple3f.y;
        float f3 = tuple3f.z;
        tuple3d.x = matrix4f.m00 * f + matrix4f.m01 * f2 + matrix4f.m02 * f3;
        tuple3d.y = matrix4f.m10 * f + matrix4f.m11 * f2 + matrix4f.m12 * f3;
        tuple3d.z = matrix4f.m20 * f + matrix4f.m21 * f2 + matrix4f.m22 * f3;
    }
}

