/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.aviatrix3d.texture;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.HashMap;
import org.j3d.aviatrix3d.Texture;
import org.j3d.aviatrix3d.TextureComponent;
import org.j3d.renderer.aviatrix3d.texture.AbstractTextureCache;

class WeakRefTextureCache
extends AbstractTextureCache {
    private HashMap textureMap = new HashMap();
    private HashMap componentMap = new HashMap();

    WeakRefTextureCache() {
    }

    public Texture fetchTexture(String string) throws IOException {
        Texture texture = this.getTexture(string);
        if (texture == null) {
            System.out.println("Creating textures not supported in WeakRefTextureCache");
        }
        return texture;
    }

    public Texture fetchTexture(URL uRL) throws IOException {
        String string = uRL.toExternalForm();
        Texture texture = this.getTexture(string);
        if (texture == null) {
            System.out.println("Creating textures not supported in WeakRefTextureCache");
        }
        return texture;
    }

    public TextureComponent fetchTextureComponent(String string) throws IOException {
        TextureComponent textureComponent = this.getTextureComponent(string);
        if (textureComponent == null) {
            System.out.println("Creating texture components not supported in WeakRefTextureCache");
        }
        return textureComponent;
    }

    public TextureComponent fetchTextureComponent(URL uRL) throws IOException {
        String string = uRL.toExternalForm();
        TextureComponent textureComponent = this.getTextureComponent(string);
        if (textureComponent == null) {
            System.out.println("Creating texture components not supported in WeakRefTextureCache");
        }
        return textureComponent;
    }

    public void releaseTexture(String string) {
        this.textureMap.remove(string);
        this.componentMap.remove(string);
    }

    public void releaseTexture(URL uRL) {
        String string = uRL.toExternalForm();
        this.textureMap.remove(string);
        this.componentMap.remove(string);
    }

    public void clearAll() {
        this.textureMap.clear();
        this.componentMap.clear();
    }

    public boolean checkTexture(String string) {
        boolean bl = false;
        WeakReference weakReference = (WeakReference)this.textureMap.get(string);
        if (weakReference != null) {
            Texture texture = (Texture)weakReference.get();
            if (texture != null) {
                bl = true;
            } else {
                this.textureMap.remove(string);
            }
        }
        return bl;
    }

    public boolean checkTextureComponent(String string) {
        boolean bl = false;
        WeakReference weakReference = (WeakReference)this.componentMap.get(string);
        if (weakReference != null) {
            TextureComponent textureComponent = (TextureComponent)weakReference.get();
            if (textureComponent != null) {
                bl = true;
            } else {
                this.componentMap.remove(string);
            }
        }
        return bl;
    }

    public void registerTexture(Texture texture, String string) {
        WeakReference<Texture> weakReference = new WeakReference<Texture>(texture);
        this.textureMap.put(string, weakReference);
    }

    public void registerTextureComponent(TextureComponent textureComponent, String string) {
        WeakReference<TextureComponent> weakReference = new WeakReference<TextureComponent>(textureComponent);
        this.componentMap.put(string, weakReference);
    }

    private Texture getTexture(String string) {
        WeakReference weakReference = (WeakReference)this.textureMap.get(string);
        if (weakReference == null) {
            return null;
        }
        Texture texture = (Texture)weakReference.get();
        if (texture == null) {
            this.textureMap.remove(string);
        }
        return texture;
    }

    private TextureComponent getTextureComponent(String string) {
        WeakReference weakReference = (WeakReference)this.componentMap.get(string);
        if (weakReference == null) {
            return null;
        }
        TextureComponent textureComponent = (TextureComponent)weakReference.get();
        if (textureComponent == null) {
            this.componentMap.remove(string);
        }
        return textureComponent;
    }
}

