/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.aviatrix3d.texture;

import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageProducer;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import org.j3d.aviatrix3d.ImageTextureComponent2D;
import org.j3d.aviatrix3d.Texture2D;
import org.j3d.aviatrix3d.TextureComponent;
import org.j3d.aviatrix3d.TextureComponent2D;
import org.j3d.aviatrix3d.TextureSource;
import org.j3d.util.ImageUtils;

public class TextureCreateUtils {
    private static final double LOG_2 = Math.log(2.0);

    public Texture2D createTexture2D(RenderedImage renderedImage) {
        int n = renderedImage.getWidth();
        int n2 = renderedImage.getHeight();
        n = this.nearestPowerTwo(n, true);
        n2 = this.nearestPowerTwo(n2, true);
        RenderedImage renderedImage2 = this.scaleTexture(renderedImage, n, n2);
        TextureSource[] textureSourceArray = new TextureComponent2D[]{this.create2DTextureComponent(renderedImage2)};
        Texture2D texture2D = new Texture2D();
        texture2D.setSources(0, this.getTextureFormat(textureSourceArray[0]), textureSourceArray, 1);
        return texture2D;
    }

    public int getTextureFormat(TextureComponent textureComponent) {
        int n = 6408;
        switch (textureComponent.getFormat(0)) {
            case 6: {
                n = 32841;
                break;
            }
            case 5: {
                n = 6410;
                break;
            }
            case 1: 
            case 3: {
                n = 6407;
                break;
            }
            case 2: 
            case 4: {
                n = 6408;
            }
        }
        return n;
    }

    public RenderedImage scaleTexture(RenderedImage renderedImage, int n, int n2) {
        int n3 = renderedImage.getWidth();
        int n4 = renderedImage.getHeight();
        if (n3 == n && n4 == n2) {
            return renderedImage;
        }
        float f = (float)n / (float)n3;
        float f2 = (float)n2 / (float)n4;
        AffineTransform affineTransform = AffineTransform.getScaleInstance(f, f2);
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 2);
        RenderedImage renderedImage2 = renderedImage;
        if (renderedImage instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)renderedImage;
            ColorModel colorModel = bufferedImage.getColorModel();
            renderedImage2 = colorModel.hasAlpha() ? affineTransformOp.filter((BufferedImage)renderedImage, null) : affineTransformOp.filter((BufferedImage)renderedImage, null);
        } else {
            System.out.println("Can't rescale RenderedImage.");
        }
        return renderedImage2;
    }

    public TextureComponent2D create2DTextureComponent(Object object) {
        if (!(object instanceof ImageProducer || object instanceof BufferedImage || object instanceof Image)) {
            throw new IllegalArgumentException("Not a valid image type " + object);
        }
        BufferedImage bufferedImage = null;
        bufferedImage = object instanceof ImageProducer ? ImageUtils.createBufferedImage((ImageProducer)((ImageProducer)object)) : (object instanceof BufferedImage ? (BufferedImage)object : ImageUtils.createBufferedImage((Image)((Image)object)));
        int n = bufferedImage.getWidth(null);
        int n2 = bufferedImage.getHeight(null);
        int n3 = this.nearestPowerTwo(n, true);
        int n4 = this.nearestPowerTwo(n2, true);
        if (n3 != n || n4 != n2) {
            System.out.println("Rescaling image to " + n3 + "x" + n4);
            bufferedImage = (BufferedImage)this.scaleTexture(bufferedImage, n3, n4);
        }
        ColorModel colorModel = bufferedImage.getColorModel();
        boolean bl = colorModel.hasAlpha();
        int n5 = 2;
        switch (bufferedImage.getType()) {
            case 1: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 12: {
                n5 = 1;
                break;
            }
            case 0: 
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                n5 = 2;
                break;
            }
            case 10: 
            case 11: {
                n5 = 6;
                break;
            }
            case 13: {
                n5 = bl ? 2 : 1;
            }
        }
        ImageTextureComponent2D imageTextureComponent2D = new ImageTextureComponent2D(n5, n3, n4, bufferedImage);
        return imageTextureComponent2D;
    }

    public int nearestPowerTwo(int n, boolean bl) {
        int n2 = bl ? (int)Math.ceil(Math.log(n) / LOG_2) : (int)Math.floor(Math.log(n) / LOG_2);
        return (int)Math.pow(2.0, n2);
    }

    public BufferedImage createNormalMap(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        int n;
        int n2;
        BufferedImage bufferedImage3 = null;
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        if (bufferedImage2 == null || bufferedImage2.getHeight() != n4 || bufferedImage2.getWidth() != n3 || bufferedImage2.getType() != 1) {
            bufferedImage3 = new BufferedImage(n3, n4, 1);
        }
        Raster raster = bufferedImage.getData();
        float[][] fArray = new float[n4][n3];
        boolean bl = false;
        for (n2 = 0; n2 < n4; ++n2) {
            for (n = 0; n < n3; ++n) {
                fArray[n2][n] = (float)raster.getSample(n, n2, 0) * 0.0039215f;
            }
        }
        for (n2 = 0; n2 < n4; ++n2) {
            for (n = 0; n < n3; ++n) {
                float f = -fArray[(n2 + 1) % n4][(n - 1 + n3) % n3];
                f += fArray[(n2 + 1) % n4][n % n3] * -2.0f;
                f += -fArray[(n2 + 1) % n4][(n + 1) % n3];
                f += fArray[(n2 - 1 + n4) % n4][(n - 1 + n3) % n3];
                f += fArray[(n2 - 1 + n4) % n4][n % n3] * 2.0f;
                f += fArray[(n2 - 1 + n4) % n4][(n + 1) % n3];
                float f2 = -fArray[(n2 - 1 + n4) % n4][(n - 1 + n3) % n3];
                f2 += fArray[n2 % n4][(n - 1 + n3) % n3] * -2.0f;
                f2 += -fArray[(n2 + 1) % n4][(n - 1 + n3) % n3];
                f2 += fArray[(n2 - 1 + n4) % n4][(n + 1) % n3];
                f2 += fArray[n2 % n4][(n + 1) % n3] * 2.0f;
                float f3 = 1.0f / (float)Math.sqrt((f2 += fArray[(n2 + 1) % n4][(n + 1) % n3]) * f2 + f * f + 1.0f);
                f2 = -f2 * f3;
                f = -f * f3;
                float f4 = f3;
                int n5 = (int)((f2 + 1.0f) / 2.0f * 255.0f) << 16 | (int)((f + 1.0f) / 2.0f * 255.0f) << 8 | (int)((f4 + 1.0f) / 2.0f * 255.0f);
                bufferedImage3.setRGB(n, n2, n5);
            }
        }
        return bufferedImage3;
    }
}

