/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.aviatrix3d.texture;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import org.j3d.aviatrix3d.Texture;
import org.j3d.aviatrix3d.TextureComponent;
import org.j3d.renderer.aviatrix3d.texture.AbstractTextureCache;
import org.j3d.util.Queue;

class LRUTextureCache
extends AbstractTextureCache {
    private static final int DEFAULT_CACHE_SIZE = 20;
    public static final String DEFAULT_SIZE_PROP = "org.j3d.texture.LRUSize";
    private HashMap textureMap = new HashMap();
    private HashMap componentMap = new HashMap();
    private final int maxCacheSize;
    private Queue textureQueue = new Queue();
    private Queue componentQueue = new Queue();

    LRUTextureCache() {
        String string = System.getProperty(DEFAULT_SIZE_PROP);
        if (string != null) {
            int n = 20;
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.maxCacheSize = n;
        } else {
            this.maxCacheSize = 20;
        }
    }

    public Texture fetchTexture(String string) throws IOException {
        Texture texture = (Texture)this.textureMap.get(string);
        if (texture == null) {
            System.out.println("Creating textures not supported in LRUTextureCache");
        } else {
            this.textureQueue.remove((Object)string);
            this.textureQueue.add((Object)string);
        }
        return texture;
    }

    public Texture fetchTexture(URL uRL) throws IOException {
        String string = uRL.toExternalForm();
        Texture texture = (Texture)this.textureMap.get(string);
        if (texture == null) {
            System.out.println("Creating textures not supported in LRUTextureCache");
        } else {
            this.textureQueue.remove((Object)string);
            this.textureQueue.add((Object)string);
        }
        return texture;
    }

    public TextureComponent fetchTextureComponent(String string) throws IOException {
        TextureComponent textureComponent = (TextureComponent)this.componentMap.get(string);
        if (textureComponent == null) {
            System.out.println("Creating texture components not supported in LRUTextureCache");
        } else {
            this.componentQueue.remove((Object)string);
            this.componentQueue.add((Object)string);
        }
        return textureComponent;
    }

    public TextureComponent fetchTextureComponent(URL uRL) throws IOException {
        String string = uRL.toExternalForm();
        TextureComponent textureComponent = (TextureComponent)this.componentMap.get(string);
        if (textureComponent == null) {
            System.out.println("Creating texture components not supported in LRUTextureCache");
        } else {
            this.componentQueue.remove((Object)string);
            this.componentQueue.add((Object)string);
        }
        return textureComponent;
    }

    public void releaseTexture(String string) {
        this.textureMap.remove(string);
        this.componentMap.remove(string);
        this.textureQueue.remove((Object)string);
        this.componentQueue.remove((Object)string);
    }

    public void releaseTexture(URL uRL) {
        String string = uRL.toExternalForm();
        this.textureMap.remove(string);
        this.componentMap.remove(string);
        this.textureQueue.remove((Object)string);
        this.componentQueue.remove((Object)string);
    }

    public void clearAll() {
        this.textureMap.clear();
        this.componentMap.clear();
        this.textureQueue.clear();
        this.componentQueue.clear();
    }

    public boolean checkTexture(String string) {
        return this.textureMap.containsKey(string);
    }

    public boolean checkTextureComponent(String string) {
        return this.componentMap.containsKey(string);
    }

    public void registerTexture(Texture texture, String string) {
        this.textureMap.put(string, texture);
    }

    public void registerTextureComponent(TextureComponent textureComponent, String string) {
        this.componentMap.put(string, textureComponent);
    }

    private void addTexture(String string, Texture texture) {
        this.textureQueue.add((Object)string);
        this.textureMap.put(string, texture);
        if (this.textureQueue.size() > this.maxCacheSize) {
            Object object = this.textureQueue.getNext();
            this.textureMap.remove(string);
        }
    }

    private void addTextureComponent(String string, TextureComponent textureComponent) {
        this.componentQueue.add((Object)string);
        this.componentMap.put(string, textureComponent);
        if (this.componentQueue.size() > this.maxCacheSize) {
            Object object = this.componentQueue.getNext();
            this.componentMap.remove(string);
        }
    }
}

