/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.aviatrix3d.texture;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import org.j3d.aviatrix3d.Texture;
import org.j3d.aviatrix3d.TextureComponent;
import org.j3d.renderer.aviatrix3d.texture.AbstractTextureCache;

class FixedTextureCache
extends AbstractTextureCache {
    private HashMap textureMap = new HashMap();
    private HashMap componentMap = new HashMap();

    FixedTextureCache() {
    }

    public Texture fetchTexture(String string) throws IOException {
        Texture texture = (Texture)this.textureMap.get(string);
        if (texture == null) {
            System.out.println("Creating textures not supported in FixedTextureCache");
        }
        return texture;
    }

    public Texture fetchTexture(URL uRL) throws IOException {
        String string = uRL.toExternalForm();
        Texture texture = (Texture)this.textureMap.get(string);
        if (texture == null) {
            System.out.println("Creating textures not supported in FixedTextureCache");
        }
        return texture;
    }

    public TextureComponent fetchTextureComponent(String string) throws IOException {
        TextureComponent textureComponent = (TextureComponent)this.componentMap.get(string);
        if (textureComponent == null) {
            textureComponent = this.load2DImage(string);
            this.componentMap.put(string, textureComponent);
        }
        return textureComponent;
    }

    public TextureComponent fetchTextureComponent(URL uRL) throws IOException {
        String string = uRL.toExternalForm();
        TextureComponent textureComponent = (TextureComponent)this.componentMap.get(string);
        if (textureComponent == null) {
            System.out.println("Creating texture components not supported in FixedTextureCache");
        }
        return textureComponent;
    }

    public void releaseTexture(String string) {
        this.textureMap.remove(string);
        this.componentMap.remove(string);
    }

    public void releaseTexture(URL uRL) {
        String string = uRL.toExternalForm();
        this.textureMap.remove(string);
        this.componentMap.remove(string);
    }

    public void clearAll() {
        this.textureMap.clear();
        this.componentMap.clear();
    }

    public boolean checkTexture(String string) {
        return this.textureMap.containsKey(string);
    }

    public boolean checkTextureComponent(String string) {
        return this.componentMap.containsKey(string);
    }

    public void registerTexture(Texture texture, String string) {
        this.textureMap.put(string, texture);
    }

    public void registerTextureComponent(TextureComponent textureComponent, String string) {
        this.componentMap.put(string, textureComponent);
    }
}

