/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.aviatrix3d.swt.draw2d;

import org.eclipse.draw2d.IFigure;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsListenerMulticaster;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsResizeListener;
import org.j3d.opengl.swt.draw2d.GLFigureSizeListener;
import org.j3d.util.DefaultErrorReporter;
import org.j3d.util.ErrorReporter;

class FigureResizeHandler
implements GLFigureSizeListener {
    private static final String SIZE_ERROR_MSG = "Error sending size changed notification to: ";
    private GraphicsResizeListener listeners;
    private ErrorReporter errorReporter = DefaultErrorReporter.getDefaultReporter();

    FigureResizeHandler() {
    }

    public void figureSizeChanged(IFigure iFigure, int n, int n2) {
        this.fireResizeNotification(n, n2);
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter == null ? DefaultErrorReporter.getDefaultReporter() : errorReporter;
    }

    public void addGraphicsResizeListener(GraphicsResizeListener graphicsResizeListener) {
        this.listeners = GraphicsListenerMulticaster.add(this.listeners, graphicsResizeListener);
    }

    public void removeGraphicsResizeListener(GraphicsResizeListener graphicsResizeListener) {
        this.listeners = GraphicsListenerMulticaster.remove(this.listeners, graphicsResizeListener);
    }

    private void fireResizeNotification(int n, int n2) {
        if (this.listeners != null) {
            try {
                this.listeners.graphicsDeviceResized(0, 0, n, n2);
            }
            catch (Exception exception) {
                this.errorReporter.errorReport(SIZE_ERROR_MSG + this.listeners, exception);
            }
        }
    }
}

