/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.aviatrix3d.pipeline;

import javax.media.opengl.GL;
import javax.vecmath.Matrix4f;
import org.j3d.aviatrix3d.rendering.AppearanceRenderable;
import org.j3d.aviatrix3d.rendering.GeometryRenderable;
import org.j3d.aviatrix3d.rendering.ShapeRenderable;

class DebugShapeRenderable
implements ShapeRenderable,
GeometryRenderable {
    private float[] minBounds;
    private float[] maxBounds;
    private float[] minBox;
    private float[] maxBox;
    private boolean showParent;

    DebugShapeRenderable(boolean bl, float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, Matrix4f matrix4f) {
        this.showParent = bl;
        this.minBounds = new float[3];
        this.maxBounds = new float[3];
        this.minBounds[0] = fArray[0];
        this.minBounds[1] = fArray[1];
        this.minBounds[2] = fArray[2];
        this.maxBounds[0] = fArray2[0];
        this.maxBounds[1] = fArray2[1];
        this.maxBounds[2] = fArray2[2];
        if (this.showParent) {
            this.minBox = new float[3];
            this.maxBox = new float[3];
            float f = fArray3[0] - fArray4[0];
            float f2 = fArray3[1] - fArray4[1];
            float f3 = fArray3[2] - fArray4[2];
            this.minBox[0] = matrix4f.m00 * f + matrix4f.m01 * f2 + matrix4f.m02 * f3 + matrix4f.m03;
            this.minBox[1] = matrix4f.m10 * f + matrix4f.m11 * f2 + matrix4f.m12 * f3 + matrix4f.m13;
            this.minBox[2] = matrix4f.m20 * f + matrix4f.m21 * f2 + matrix4f.m22 * f3 + matrix4f.m23;
            f = fArray3[0] + fArray4[0];
            f2 = fArray3[1] + fArray4[1];
            f3 = fArray3[2] + fArray4[2];
            this.maxBox[0] = matrix4f.m00 * f + matrix4f.m01 * f2 + matrix4f.m02 * f3 + matrix4f.m03;
            this.maxBox[1] = matrix4f.m10 * f + matrix4f.m11 * f2 + matrix4f.m12 * f3 + matrix4f.m13;
            this.maxBox[2] = matrix4f.m20 * f + matrix4f.m21 * f2 + matrix4f.m22 * f3 + matrix4f.m23;
        }
    }

    public boolean isVisible() {
        return true;
    }

    public boolean is2D() {
        return false;
    }

    public GeometryRenderable getGeometryRenderable() {
        return this;
    }

    public AppearanceRenderable getAppearanceRenderable() {
        return null;
    }

    public boolean hasTransparency() {
        return false;
    }

    public void render(GL gL) {
        gL.glBegin(1);
        gL.glColor3f(0.0f, 0.0f, 1.0f);
        gL.glVertex3f(this.minBounds[0], this.minBounds[1], this.minBounds[2]);
        gL.glVertex3f(this.minBounds[0], this.minBounds[1], this.maxBounds[2]);
        gL.glVertex3f(this.minBounds[0], this.minBounds[1], this.minBounds[2]);
        gL.glVertex3f(this.minBounds[0], this.maxBounds[1], this.minBounds[2]);
        gL.glVertex3f(this.minBounds[0], this.minBounds[1], this.minBounds[2]);
        gL.glVertex3f(this.maxBounds[0], this.minBounds[1], this.minBounds[2]);
        gL.glVertex3f(this.maxBounds[0], this.maxBounds[1], this.maxBounds[2]);
        gL.glVertex3f(this.maxBounds[0], this.maxBounds[1], this.minBounds[2]);
        gL.glVertex3f(this.maxBounds[0], this.maxBounds[1], this.maxBounds[2]);
        gL.glVertex3f(this.maxBounds[0], this.minBounds[1], this.maxBounds[2]);
        gL.glVertex3f(this.maxBounds[0], this.maxBounds[1], this.maxBounds[2]);
        gL.glVertex3f(this.minBounds[0], this.maxBounds[1], this.maxBounds[2]);
        gL.glVertex3f(this.minBounds[0], this.minBounds[1], this.maxBounds[2]);
        gL.glVertex3f(this.minBounds[0], this.maxBounds[1], this.maxBounds[2]);
        gL.glVertex3f(this.minBounds[0], this.minBounds[1], this.maxBounds[2]);
        gL.glVertex3f(this.maxBounds[0], this.minBounds[1], this.maxBounds[2]);
        gL.glVertex3f(this.minBounds[0], this.maxBounds[1], this.maxBounds[2]);
        gL.glVertex3f(this.minBounds[0], this.maxBounds[1], this.minBounds[2]);
        gL.glVertex3f(this.maxBounds[0], this.maxBounds[1], this.minBounds[2]);
        gL.glVertex3f(this.minBounds[0], this.maxBounds[1], this.minBounds[2]);
        gL.glVertex3f(this.maxBounds[0], this.maxBounds[1], this.minBounds[2]);
        gL.glVertex3f(this.maxBounds[0], this.minBounds[1], this.minBounds[2]);
        gL.glVertex3f(this.maxBounds[0], this.minBounds[1], this.minBounds[2]);
        gL.glVertex3f(this.maxBounds[0], this.minBounds[1], this.maxBounds[2]);
        gL.glEnd();
        if (this.showParent) {
            gL.glPopMatrix();
            gL.glBegin(1);
            gL.glColor3f(1.0f, 0.0f, 1.0f);
            gL.glVertex3f(this.minBox[0], this.minBox[1], this.minBox[2]);
            gL.glVertex3f(this.minBox[0], this.minBox[1], this.maxBox[2]);
            gL.glVertex3f(this.minBox[0], this.minBox[1], this.minBox[2]);
            gL.glVertex3f(this.minBox[0], this.maxBox[1], this.minBox[2]);
            gL.glVertex3f(this.minBox[0], this.minBox[1], this.minBox[2]);
            gL.glVertex3f(this.maxBox[0], this.minBox[1], this.minBox[2]);
            gL.glVertex3f(this.maxBox[0], this.maxBox[1], this.maxBox[2]);
            gL.glVertex3f(this.maxBox[0], this.maxBox[1], this.minBox[2]);
            gL.glVertex3f(this.maxBox[0], this.maxBox[1], this.maxBox[2]);
            gL.glVertex3f(this.maxBox[0], this.minBox[1], this.maxBox[2]);
            gL.glVertex3f(this.maxBox[0], this.maxBox[1], this.maxBox[2]);
            gL.glVertex3f(this.minBox[0], this.maxBox[1], this.maxBox[2]);
            gL.glVertex3f(this.minBox[0], this.minBox[1], this.maxBox[2]);
            gL.glVertex3f(this.minBox[0], this.maxBox[1], this.maxBox[2]);
            gL.glVertex3f(this.minBox[0], this.minBox[1], this.maxBox[2]);
            gL.glVertex3f(this.maxBox[0], this.minBox[1], this.maxBox[2]);
            gL.glVertex3f(this.minBox[0], this.maxBox[1], this.maxBox[2]);
            gL.glVertex3f(this.minBox[0], this.maxBox[1], this.minBox[2]);
            gL.glVertex3f(this.maxBox[0], this.maxBox[1], this.minBox[2]);
            gL.glVertex3f(this.minBox[0], this.maxBox[1], this.minBox[2]);
            gL.glVertex3f(this.maxBox[0], this.maxBox[1], this.minBox[2]);
            gL.glVertex3f(this.maxBox[0], this.minBox[1], this.minBox[2]);
            gL.glVertex3f(this.maxBox[0], this.minBox[1], this.minBox[2]);
            gL.glVertex3f(this.maxBox[0], this.minBox[1], this.maxBox[2]);
            gL.glEnd();
            gL.glPushMatrix();
        }
    }

    public int compareTo(Object object) throws ClassCastException {
        DebugShapeRenderable debugShapeRenderable = (DebugShapeRenderable)object;
        float[] fArray = this.minBounds;
        float[] fArray2 = debugShapeRenderable.minBounds;
        if (fArray[0] < fArray2[0]) {
            return -1;
        }
        if (fArray[0] > fArray2[0]) {
            return 1;
        }
        if (fArray[1] < fArray2[1]) {
            return -1;
        }
        if (fArray[1] > fArray2[1]) {
            return 1;
        }
        if (fArray[2] < fArray2[2]) {
            return -1;
        }
        if (fArray[2] > fArray2[2]) {
            return 1;
        }
        if (fArray[3] < fArray2[3]) {
            return -1;
        }
        if (fArray[3] > fArray2[3]) {
            return 1;
        }
        fArray = this.maxBounds;
        fArray2 = debugShapeRenderable.maxBounds;
        if (fArray[0] < fArray2[0]) {
            return -1;
        }
        if (fArray[0] > fArray2[0]) {
            return 1;
        }
        if (fArray[1] < fArray2[1]) {
            return -1;
        }
        if (fArray[1] > fArray2[1]) {
            return 1;
        }
        if (fArray[2] < fArray2[2]) {
            return -1;
        }
        if (fArray[2] > fArray2[2]) {
            return 1;
        }
        if (fArray[3] < fArray2[3]) {
            return -1;
        }
        if (fArray[3] > fArray2[3]) {
            return 1;
        }
        return 0;
    }
}

