/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.aviatrix3d.pipeline;

import javax.media.opengl.GL;
import org.j3d.aviatrix3d.rendering.AppearanceRenderable;
import org.j3d.aviatrix3d.rendering.GeometryRenderable;
import org.j3d.aviatrix3d.rendering.ShapeRenderable;

class DebugFrustumRenderable
implements ShapeRenderable,
GeometryRenderable {
    private float[] frustumPoints;
    private float fieldOfView;
    private float aspectRatio;

    DebugFrustumRenderable(float f, float f2, double[] dArray) {
        this.fieldOfView = f;
        this.aspectRatio = f2;
        this.frustumPoints = new float[6];
        this.frustumPoints[0] = (float)dArray[0];
        this.frustumPoints[1] = (float)dArray[1];
        this.frustumPoints[2] = (float)dArray[2];
        this.frustumPoints[3] = (float)dArray[3];
        this.frustumPoints[4] = (float)dArray[4];
        this.frustumPoints[5] = (float)dArray[5];
    }

    public boolean isVisible() {
        return true;
    }

    public boolean is2D() {
        return false;
    }

    public GeometryRenderable getGeometryRenderable() {
        return this;
    }

    public AppearanceRenderable getAppearanceRenderable() {
        return null;
    }

    public boolean hasTransparency() {
        return false;
    }

    public void render(GL gL) {
        float f = this.frustumPoints[0];
        float f2 = this.frustumPoints[1];
        float f3 = this.frustumPoints[2];
        float f4 = this.frustumPoints[3];
        float f5 = this.frustumPoints[4];
        float f6 = this.frustumPoints[5];
        gL.glBegin(1);
        gL.glColor3f(0.0f, 1.0f, 1.0f);
        gL.glVertex3f(f, f4, f5);
        gL.glVertex3f(f2, f4, f5);
        gL.glVertex3f(f, f3, f5);
        gL.glVertex3f(f2, f3, f5);
        gL.glVertex3f(f, f4, f5);
        gL.glVertex3f(f, f3, f5);
        gL.glVertex3f(f2, f4, f5);
        gL.glVertex3f(f2, f3, f5);
        float f7 = (float)(Math.tan((double)this.fieldOfView * 0.5) * (double)f6);
        float f8 = -f7;
        float f9 = f7 * this.aspectRatio;
        float f10 = -f9;
        gL.glVertex3f(f10, f7, f6);
        gL.glVertex3f(f9, f7, f6);
        gL.glVertex3f(f10, f8, f6);
        gL.glVertex3f(f9, f8, f6);
        gL.glVertex3f(f10, f7, f6);
        gL.glVertex3f(f10, f8, f6);
        gL.glVertex3f(f9, f7, f6);
        gL.glVertex3f(f9, f8, f6);
        gL.glVertex3f(f, f4, f5);
        gL.glVertex3f(f10, f7, f6);
        gL.glVertex3f(f2, f4, f5);
        gL.glVertex3f(f9, f7, f6);
        gL.glVertex3f(f, f3, f5);
        gL.glVertex3f(f10, f8, f6);
        gL.glVertex3f(f2, f3, f5);
        gL.glVertex3f(f9, f8, f6);
        gL.glVertex3f(f, f4, f5);
        gL.glVertex3f(f10, f7, f6);
        gL.glVertex3f(f, f3, f5);
        gL.glVertex3f(f10, f8, f6);
        gL.glVertex3f(f2, f4, f5);
        gL.glVertex3f(f9, f7, f6);
        gL.glVertex3f(f2, f3, f5);
        gL.glVertex3f(f9, f8, f6);
        gL.glEnd();
    }

    public int compareTo(Object object) throws ClassCastException {
        DebugFrustumRenderable debugFrustumRenderable = (DebugFrustumRenderable)object;
        if (object == this) {
            return 0;
        }
        return -1;
    }
}

