/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.aviatrix3d.pipeline;

import javax.vecmath.Matrix4f;
import javax.vecmath.Point4f;
import javax.vecmath.Vector4f;
import org.j3d.aviatrix3d.BoundingBox;
import org.j3d.aviatrix3d.pipeline.graphics.BaseCullStage;
import org.j3d.aviatrix3d.pipeline.graphics.BufferDetails;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsEnvironmentData;
import org.j3d.aviatrix3d.pipeline.graphics.MultipassDetails;
import org.j3d.aviatrix3d.pipeline.graphics.SceneRenderBucket;
import org.j3d.aviatrix3d.pipeline.graphics.ViewportLayerCollection;
import org.j3d.aviatrix3d.pipeline.graphics.VisualDetails;
import org.j3d.aviatrix3d.rendering.BoundingVolume;
import org.j3d.aviatrix3d.rendering.Cullable;
import org.j3d.aviatrix3d.rendering.EffectRenderable;
import org.j3d.aviatrix3d.rendering.GroupCullable;
import org.j3d.aviatrix3d.rendering.LeafCullable;
import org.j3d.aviatrix3d.rendering.RenderPassCullable;
import org.j3d.aviatrix3d.rendering.Renderable;
import org.j3d.aviatrix3d.rendering.SceneCullable;
import org.j3d.aviatrix3d.rendering.ShapeRenderable;
import org.j3d.aviatrix3d.rendering.SingleCullable;
import org.j3d.aviatrix3d.rendering.TransformCullable;
import org.j3d.aviatrix3d.rendering.ViewEnvironmentCullable;
import org.j3d.renderer.aviatrix3d.pipeline.DebugFrustumRenderable;
import org.j3d.renderer.aviatrix3d.pipeline.DebugGroupRenderable;
import org.j3d.renderer.aviatrix3d.pipeline.DebugShapeRenderable;

public class DebugFrustumCullStage
extends BaseCullStage {
    private static final String SHARED_VP_MSG = "The path from the root of the scene graph to the viewpoint contains a SharedGroupCullable instance. This is not permitted.";
    private static final String SHARED_BG_MSG = "The path from the root of the scene graph to the background contains a SharedGroupCullable instance. This is not permitted.";
    private double[] viewFrustum;
    private Matrix4f viewMatrix = new Matrix4f();
    private Point4f[] frustumPoints;
    private Vector4f[] frustumPlanes;
    private Matrix4f prjMatrix = new Matrix4f();
    private float[] t1;
    private float[] t2;
    private float[] c1;
    private float[] c2;
    private float fieldOfView;
    private float aspectRatio;
    private boolean globalViewpoint;

    public DebugFrustumCullStage(boolean bl) {
        this(1, bl);
    }

    public DebugFrustumCullStage(int n, boolean bl) {
        super(n);
        int n2;
        this.frustumPoints = new Point4f[8];
        for (n2 = 0; n2 < 8; ++n2) {
            this.frustumPoints[n2] = new Point4f();
        }
        this.frustumPlanes = new Vector4f[6];
        for (n2 = 0; n2 < 6; ++n2) {
            this.frustumPlanes[n2] = new Vector4f();
        }
        this.t1 = new float[3];
        this.t2 = new float[3];
        this.c1 = new float[3];
        this.c2 = new float[3];
        this.globalViewpoint = bl;
    }

    protected void cullScene(RenderPassCullable renderPassCullable, int n, int n2, int n3, int n4) {
        this.lastLight = 0;
        this.lastClip = 0;
        this.lastTxStack = 0;
        this.lastFogStack = 0;
        this.activeParent = null;
        SceneRenderBucket sceneRenderBucket = this.outputLayers[n][n2].viewports[n3].scenes[n4];
        this.workCullList = sceneRenderBucket.nodes;
        this.validSceneParents[0][0] = null;
        this.validSceneParents[0][1] = null;
        Cullable cullable = renderPassCullable.getRootCullable();
        sceneRenderBucket.data.layerId = n2;
        sceneRenderBucket.data.subLayerId = n4;
        if (this.terminate) {
            return;
        }
        if (cullable instanceof TransformCullable) {
            ((TransformCullable)cullable).getTransform(this.transformStack[0]);
        } else {
            this.transformStack[0].setIdentity();
        }
        this.workCullList[0].renderable = new DebugFrustumRenderable(this.fieldOfView, this.aspectRatio, sceneRenderBucket.data.viewFrustum);
        this.matrixUtils.inverse(sceneRenderBucket.data.viewTransform, this.viewMatrix2);
        this.workCullList[0].transform.set(this.viewMatrix2);
        this.workCullList[0].numLights = 0;
        this.workCullList[0].numClipPlanes = 0;
        if (cullable instanceof GroupCullable) {
            this.viewFrustum = sceneRenderBucket.data.viewFrustum;
            this.viewMatrix.set(sceneRenderBucket.data.viewTransform);
            this.updateFrustum(sceneRenderBucket.data);
            sceneRenderBucket.numNodes = this.findAllNodes((GroupCullable)cullable, false, false, 1);
            sceneRenderBucket.nodes = this.workCullList;
            ++this.lastOutputList;
        } else if (cullable instanceof SingleCullable) {
            this.viewFrustum = sceneRenderBucket.data.viewFrustum;
            this.viewMatrix.set(sceneRenderBucket.data.viewTransform);
            this.updateFrustum(sceneRenderBucket.data);
            sceneRenderBucket.numNodes = this.findNextNode((SingleCullable)cullable, false, false, 1);
            sceneRenderBucket.nodes = this.workCullList;
            ++this.lastOutputList;
        } else if (cullable instanceof LeafCullable) {
            LeafCullable leafCullable = (LeafCullable)cullable;
            if (leafCullable.getCullableType() != 4) {
                return;
            }
            Renderable renderable = leafCullable.getRenderable();
            if (renderable instanceof ShapeRenderable && ((ShapeRenderable)renderable).is2D()) {
                this.workCullList[1].transform.setIdentity();
                BoundingVolume boundingVolume = leafCullable.getBounds();
                boundingVolume.getExtents(this.t1, this.t2);
                boundingVolume.getCenter(this.c1);
                ((BoundingBox)boundingVolume).getSize(this.c2);
                renderable = new DebugShapeRenderable(false, this.t1, this.t2, this.c1, this.c2, this.workCullList[1].transform);
                if (this.checkOffscreens) {
                    this.checkForOffscreens((ShapeRenderable)renderable);
                }
                this.workCullList[1].renderable = renderable;
                this.workCullList[1].transform.setIdentity();
                this.workCullList[1].numLights = 0;
                this.workCullList[1].numClipPlanes = 0;
                sceneRenderBucket.numNodes = 2;
                sceneRenderBucket.nodes = this.workCullList;
                ++this.lastOutputList;
            }
        }
        if (this.globalViewpoint) {
            this.viewMatrix.rotX(-1.5707964f);
            this.viewMatrix.m03 = 0.0f;
            this.viewMatrix.m13 = 100.0f;
            this.viewMatrix.m23 = 0.0f;
            this.viewMatrix.m33 = 1.0f;
            this.matrixUtils.inverse(this.viewMatrix, this.viewMatrix2);
            sceneRenderBucket.data.cameraTransform[0] = this.viewMatrix2.m00;
            sceneRenderBucket.data.cameraTransform[1] = this.viewMatrix2.m10;
            sceneRenderBucket.data.cameraTransform[2] = this.viewMatrix2.m20;
            sceneRenderBucket.data.cameraTransform[3] = this.viewMatrix2.m30;
            sceneRenderBucket.data.cameraTransform[4] = this.viewMatrix2.m01;
            sceneRenderBucket.data.cameraTransform[5] = this.viewMatrix2.m11;
            sceneRenderBucket.data.cameraTransform[6] = this.viewMatrix2.m21;
            sceneRenderBucket.data.cameraTransform[7] = this.viewMatrix2.m31;
            sceneRenderBucket.data.cameraTransform[8] = this.viewMatrix2.m02;
            sceneRenderBucket.data.cameraTransform[9] = this.viewMatrix2.m12;
            sceneRenderBucket.data.cameraTransform[10] = this.viewMatrix2.m22;
            sceneRenderBucket.data.cameraTransform[11] = this.viewMatrix2.m32;
            sceneRenderBucket.data.cameraTransform[12] = this.viewMatrix2.m03;
            sceneRenderBucket.data.cameraTransform[13] = this.viewMatrix2.m13;
            sceneRenderBucket.data.cameraTransform[14] = this.viewMatrix2.m23;
            sceneRenderBucket.data.cameraTransform[15] = this.viewMatrix2.m33;
        }
    }

    protected void cullScene2D(RenderPassCullable renderPassCullable, int n, int n2, int n3, int n4) {
        this.lastLight = 0;
        this.lastClip = 0;
        this.lastTxStack = 0;
        this.lastFogStack = 0;
        this.activeParent = null;
        SceneRenderBucket sceneRenderBucket = this.outputLayers[n][n2].viewports[n3].scenes[n4];
        this.workCullList = sceneRenderBucket.nodes;
        this.validSceneParents[0][0] = null;
        this.validSceneParents[0][1] = null;
        Cullable cullable = renderPassCullable.getRootCullable();
        sceneRenderBucket.data.layerId = n2;
        sceneRenderBucket.data.subLayerId = n4;
        if (this.terminate) {
            return;
        }
        if (cullable instanceof TransformCullable) {
            ((TransformCullable)cullable).getTransform(this.transformStack[0]);
        } else {
            this.transformStack[0].setIdentity();
        }
        this.workCullList[0].renderable = new DebugFrustumRenderable(this.fieldOfView, this.aspectRatio, sceneRenderBucket.data.viewFrustum);
        this.workCullList[0].transform.set(sceneRenderBucket.data.viewTransform);
        this.workCullList[0].numLights = 0;
        this.workCullList[0].numClipPlanes = 0;
        if (cullable instanceof GroupCullable) {
            this.viewFrustum = sceneRenderBucket.data.viewFrustum;
            this.viewMatrix.set(sceneRenderBucket.data.viewTransform);
            this.updateFrustum(sceneRenderBucket.data);
            sceneRenderBucket.numNodes = this.findAllNodes((GroupCullable)cullable, false, false, 1);
            sceneRenderBucket.nodes = this.workCullList;
            ++this.lastOutputList;
        } else if (cullable instanceof SingleCullable) {
            this.viewFrustum = sceneRenderBucket.data.viewFrustum;
            this.viewMatrix.set(sceneRenderBucket.data.viewTransform);
            this.updateFrustum(sceneRenderBucket.data);
            sceneRenderBucket.numNodes = this.findNextNode((SingleCullable)cullable, false, false, 1);
            sceneRenderBucket.nodes = this.workCullList;
            ++this.lastOutputList;
        } else if (cullable instanceof LeafCullable) {
            LeafCullable leafCullable = (LeafCullable)cullable;
            if (leafCullable.getCullableType() != 4) {
                return;
            }
            Renderable renderable = leafCullable.getRenderable();
            if (renderable instanceof ShapeRenderable && ((ShapeRenderable)renderable).is2D()) {
                this.workCullList[1].transform.setIdentity();
                BoundingVolume boundingVolume = leafCullable.getBounds();
                boundingVolume.getExtents(this.t1, this.t2);
                boundingVolume.getCenter(this.c1);
                ((BoundingBox)boundingVolume).getSize(this.c2);
                renderable = new DebugShapeRenderable(false, this.t1, this.t2, this.c1, this.c2, this.workCullList[1].transform);
                if (this.checkOffscreens) {
                    this.checkForOffscreens((ShapeRenderable)renderable);
                }
                this.workCullList[1].renderable = renderable;
                this.workCullList[1].transform.setIdentity();
                this.workCullList[1].numLights = 0;
                this.workCullList[1].numClipPlanes = 0;
                sceneRenderBucket.numNodes = 2;
                sceneRenderBucket.nodes = this.workCullList;
                ++this.lastOutputList;
            }
        }
    }

    protected void cullRenderPass(RenderPassCullable renderPassCullable, int n, int n2, int n3, int n4, int n5) {
        this.lastLight = 0;
        this.lastClip = 0;
        this.lastTxStack = 0;
        this.lastFogStack = 0;
        this.activeParent = null;
        ViewportLayerCollection viewportLayerCollection = this.outputLayers[n2][n3].viewports[n4];
        MultipassDetails multipassDetails = viewportLayerCollection.multipass[viewportLayerCollection.numMultipass].mainScene;
        this.workCullList = multipassDetails.nodes[n];
        this.validSceneParents[0][0] = null;
        this.validSceneParents[0][1] = null;
        Cullable cullable = renderPassCullable.getRootCullable();
        this.fillRenderPassEnvData(renderPassCullable, multipassDetails.data[n], multipassDetails.buffers[n]);
        multipassDetails.data[n].layerId = n3;
        multipassDetails.data[n].subLayerId = n5;
        if (this.terminate) {
            return;
        }
        if (cullable instanceof TransformCullable) {
            ((TransformCullable)cullable).getTransform(this.transformStack[0]);
        } else {
            this.transformStack[0].setIdentity();
        }
        this.workCullList[0].renderable = new DebugFrustumRenderable(this.fieldOfView, this.aspectRatio, multipassDetails.data[n].viewFrustum);
        this.workCullList[0].transform.set(multipassDetails.data[n].viewTransform);
        this.workCullList[0].numLights = 0;
        this.workCullList[0].numClipPlanes = 0;
        if (cullable instanceof GroupCullable) {
            this.viewFrustum = multipassDetails.data[n].viewFrustum;
            this.viewMatrix.set(multipassDetails.data[n].viewTransform);
            this.updateFrustum(multipassDetails.data[n]);
            multipassDetails.numNodes[n] = this.findAllNodes((GroupCullable)cullable, false, false, 1);
            multipassDetails.nodes[n] = this.workCullList;
            ++this.lastOutputList;
        } else if (cullable instanceof SingleCullable) {
            this.viewFrustum = multipassDetails.data[n].viewFrustum;
            this.viewMatrix.set(multipassDetails.data[n].viewTransform);
            this.updateFrustum(multipassDetails.data[n]);
            multipassDetails.numNodes[n] = this.findNextNode((SingleCullable)cullable, false, false, 1);
            multipassDetails.nodes[n] = this.workCullList;
            ++this.lastOutputList;
        } else if (cullable instanceof LeafCullable) {
            LeafCullable leafCullable = (LeafCullable)cullable;
            if (leafCullable.getCullableType() != 4) {
                return;
            }
            Renderable renderable = leafCullable.getRenderable();
            if (renderable instanceof ShapeRenderable && ((ShapeRenderable)renderable).is2D()) {
                this.workCullList[1].transform.setIdentity();
                BoundingVolume boundingVolume = leafCullable.getBounds();
                boundingVolume.getExtents(this.t1, this.t2);
                boundingVolume.getCenter(this.c1);
                ((BoundingBox)boundingVolume).getSize(this.c2);
                renderable = new DebugShapeRenderable(false, this.t1, this.t2, this.c1, this.c2, this.workCullList[1].transform);
                if (this.checkOffscreens) {
                    this.checkForOffscreens((ShapeRenderable)renderable);
                }
                this.workCullList[1].renderable = renderable;
                this.workCullList[1].transform.setIdentity();
                this.workCullList[1].numLights = 0;
                this.workCullList[1].numClipPlanes = 0;
                multipassDetails.numNodes[n] = 2;
                multipassDetails.nodes[n] = this.workCullList;
                ++this.lastOutputList;
            }
        }
    }

    protected void fillSingleEnvData(SceneCullable sceneCullable, GraphicsEnvironmentData graphicsEnvironmentData) {
        super.fillSingleEnvData(sceneCullable, graphicsEnvironmentData);
        ViewEnvironmentCullable viewEnvironmentCullable = sceneCullable.getViewCullable();
        this.fieldOfView = (float)viewEnvironmentCullable.getFieldOfView();
        int[] nArray = viewEnvironmentCullable.getViewportDimensions();
        this.aspectRatio = (float)nArray[2] / (float)nArray[3];
    }

    protected void fillMultipassEnvData(SceneCullable sceneCullable, GraphicsEnvironmentData graphicsEnvironmentData) {
        super.fillMultipassEnvData(sceneCullable, graphicsEnvironmentData);
        ViewEnvironmentCullable viewEnvironmentCullable = sceneCullable.getViewCullable();
        this.fieldOfView = (float)viewEnvironmentCullable.getFieldOfView();
        int[] nArray = viewEnvironmentCullable.getViewportDimensions();
        this.aspectRatio = (float)nArray[2] / (float)nArray[3];
    }

    protected void fillRenderPassEnvData(RenderPassCullable renderPassCullable, GraphicsEnvironmentData graphicsEnvironmentData, BufferDetails bufferDetails) {
        super.fillRenderPassEnvData(renderPassCullable, graphicsEnvironmentData, bufferDetails);
        ViewEnvironmentCullable viewEnvironmentCullable = renderPassCullable.getViewCullable();
        this.fieldOfView = (float)viewEnvironmentCullable.getFieldOfView();
        int[] nArray = viewEnvironmentCullable.getViewportDimensions();
        this.aspectRatio = (float)nArray[2] / (float)nArray[3];
    }

    private int findAllNodes(GroupCullable groupCullable, boolean bl, boolean bl2, int n) {
        Object object;
        Renderable renderable;
        Object object2;
        int n2;
        if (this.terminate) {
            return 0;
        }
        BoundingVolume boundingVolume = groupCullable.getBounds();
        boolean bl3 = false;
        int n3 = bl2 ? this.lastTxStack - 1 : this.lastTxStack;
        Matrix4f matrix4f = this.transformStack[n3];
        int n4 = n;
        if (!bl) {
            int n5 = boundingVolume.checkIntersectionFrustum(this.frustumPlanes, matrix4f);
            boundingVolume.getCenter(this.c1);
            if (boundingVolume instanceof BoundingBox) {
                ((BoundingBox)boundingVolume).getSize(this.c2);
            } else {
                this.c2[0] = 0.0f;
                this.c2[1] = 0.0f;
                this.c2[2] = 0.0f;
            }
            boundingVolume.getExtents(this.t1, this.t2);
            this.resizeCullList(n);
            switch (n5) {
                case 0: {
                    this.workCullList[n].renderable = new DebugGroupRenderable(true, false, this.t1, this.t2, this.c1, this.c2, matrix4f);
                    this.workCullList[n].localFog = null;
                    this.workCullList[n].transform = matrix4f;
                    this.workCullList[n].numLights = 0;
                    this.workCullList[n].numClipPlanes = 0;
                    return n + 1;
                }
                case 2: {
                    bl3 = true;
                    this.workCullList[n].renderable = new DebugGroupRenderable(false, false, this.t1, this.t2, this.c1, this.c2, matrix4f);
                    this.workCullList[n].localFog = null;
                    this.workCullList[n].transform = matrix4f;
                    this.workCullList[n].numLights = 0;
                    this.workCullList[n].numClipPlanes = 0;
                    ++n4;
                    break;
                }
                case 1: {
                    this.workCullList[n].renderable = new DebugGroupRenderable(false, true, this.t1, this.t2, this.c1, this.c2, matrix4f);
                    this.workCullList[n].localFog = null;
                    this.workCullList[n].transform = matrix4f;
                    this.workCullList[n].numLights = 0;
                    this.workCullList[n].numClipPlanes = 0;
                    ++n4;
                }
            }
        }
        Cullable[] cullableArray = groupCullable.getCullableChildren();
        int n6 = groupCullable.numCullableChildren();
        int n7 = 0;
        int n8 = 0;
        boolean bl4 = false;
        block10: for (n2 = 0; n2 < n6 && !this.terminate; ++n2) {
            LeafCullable leafCullable;
            if (!(cullableArray[n2] instanceof LeafCullable) || !((object2 = (leafCullable = (LeafCullable)cullableArray[n2]).getRenderable()) instanceof EffectRenderable) || !(renderable = (EffectRenderable)object2).isEnabled()) continue;
            switch (leafCullable.getCullableType()) {
                case 2: {
                    this.resizeLightList();
                    this.lightList[this.lastLight] = renderable;
                    object = this.transformStack[this.lastTxStack];
                    this.lightTxList[this.lastLight][0] = ((Matrix4f)object).m00;
                    this.lightTxList[this.lastLight][1] = ((Matrix4f)object).m10;
                    this.lightTxList[this.lastLight][2] = ((Matrix4f)object).m20;
                    this.lightTxList[this.lastLight][3] = ((Matrix4f)object).m30;
                    this.lightTxList[this.lastLight][4] = ((Matrix4f)object).m01;
                    this.lightTxList[this.lastLight][5] = ((Matrix4f)object).m11;
                    this.lightTxList[this.lastLight][6] = ((Matrix4f)object).m21;
                    this.lightTxList[this.lastLight][7] = ((Matrix4f)object).m31;
                    this.lightTxList[this.lastLight][8] = ((Matrix4f)object).m02;
                    this.lightTxList[this.lastLight][9] = ((Matrix4f)object).m12;
                    this.lightTxList[this.lastLight][10] = ((Matrix4f)object).m22;
                    this.lightTxList[this.lastLight][11] = ((Matrix4f)object).m32;
                    this.lightTxList[this.lastLight][12] = ((Matrix4f)object).m03;
                    this.lightTxList[this.lastLight][13] = ((Matrix4f)object).m13;
                    this.lightTxList[this.lastLight][14] = ((Matrix4f)object).m23;
                    this.lightTxList[this.lastLight][15] = ((Matrix4f)object).m33;
                    ++this.lastLight;
                    ++n7;
                    continue block10;
                }
                case 3: {
                    this.resizeClipList();
                    this.clipList[this.lastClip] = renderable;
                    object = this.transformStack[this.lastTxStack];
                    this.clipTxList[this.lastClip][0] = ((Matrix4f)object).m00;
                    this.clipTxList[this.lastClip][1] = ((Matrix4f)object).m10;
                    this.clipTxList[this.lastClip][2] = ((Matrix4f)object).m20;
                    this.clipTxList[this.lastClip][3] = ((Matrix4f)object).m30;
                    this.clipTxList[this.lastClip][4] = ((Matrix4f)object).m01;
                    this.clipTxList[this.lastClip][5] = ((Matrix4f)object).m11;
                    this.clipTxList[this.lastClip][6] = ((Matrix4f)object).m21;
                    this.clipTxList[this.lastClip][7] = ((Matrix4f)object).m31;
                    this.clipTxList[this.lastClip][8] = ((Matrix4f)object).m02;
                    this.clipTxList[this.lastClip][9] = ((Matrix4f)object).m12;
                    this.clipTxList[this.lastClip][10] = ((Matrix4f)object).m22;
                    this.clipTxList[this.lastClip][11] = ((Matrix4f)object).m32;
                    this.clipTxList[this.lastClip][12] = ((Matrix4f)object).m03;
                    this.clipTxList[this.lastClip][13] = ((Matrix4f)object).m13;
                    this.clipTxList[this.lastClip][14] = ((Matrix4f)object).m23;
                    this.clipTxList[this.lastClip][15] = ((Matrix4f)object).m33;
                    ++this.lastClip;
                    ++n8;
                    continue block10;
                }
                case 1: {
                    if (renderable.isGlobalOnly() || bl4) continue block10;
                    this.resizeFogStack();
                    bl4 = true;
                    ++this.lastFogStack;
                    this.fogStack[this.lastFogStack] = renderable;
                }
            }
        }
        for (n2 = 0; n2 < n6 && !this.terminate; ++n2) {
            boolean bl5 = cullableArray[n2] instanceof TransformCullable;
            if (bl5) {
                this.resizeStack();
                object2 = (TransformCullable)cullableArray[n2];
                object2.getTransform(this.transformStack[this.lastTxStack + 1]);
                this.transformStack[this.lastTxStack + 1].mul(this.transformStack[this.lastTxStack], this.transformStack[this.lastTxStack + 1]);
                ++this.lastTxStack;
            }
            if (cullableArray[n2] instanceof GroupCullable) {
                n4 = this.findAllNodes((GroupCullable)cullableArray[n2], bl3, bl5, n4);
            } else if (cullableArray[n2] instanceof LeafCullable) {
                object2 = (LeafCullable)cullableArray[n2];
                if (object2.getCullableType() == 4 && (renderable = object2.getRenderable()) instanceof ShapeRenderable && ((ShapeRenderable)renderable).isVisible()) {
                    int n9;
                    int n10;
                    VisualDetails[] visualDetailsArray;
                    int n11;
                    boundingVolume.getCenter(this.c1);
                    ((BoundingBox)boundingVolume).getSize(this.c2);
                    object = object2.getBounds();
                    ((BoundingVolume)object).getExtents(this.t1, this.t2);
                    renderable = new DebugShapeRenderable(false, this.t1, this.t2, this.c1, this.c2, matrix4f);
                    if (this.checkOffscreens) {
                        this.checkForOffscreens((ShapeRenderable)((Object)cullableArray[n2]));
                    }
                    this.resizeCullList(n4);
                    this.workCullList[n4].renderable = renderable;
                    this.workCullList[n4].localFog = this.fogStack[this.lastFogStack];
                    Matrix4f matrix4f2 = this.transformStack[this.lastTxStack];
                    this.workCullList[n4].transform.set(matrix4f2);
                    int n12 = n11 = this.workCullList[n4].lights == null ? 0 : this.workCullList[n4].lights.length;
                    if (n11 < this.lastLight) {
                        visualDetailsArray = new VisualDetails[this.lastLight];
                        if (n11 != 0) {
                            System.arraycopy(this.workCullList[n4].lights, 0, visualDetailsArray, 0, n11);
                        }
                        for (n10 = n11; n10 < this.lastLight; ++n10) {
                            visualDetailsArray[n10] = new VisualDetails();
                        }
                        this.workCullList[n4].lights = visualDetailsArray;
                    }
                    visualDetailsArray = this.workCullList[n4].lights;
                    this.workCullList[n4].numLights = this.lastLight;
                    for (n10 = 0; n10 < this.lastLight; ++n10) {
                        visualDetailsArray[n10].update(this.lightList[n10], this.lightTxList[n10]);
                    }
                    int n13 = n11 = this.workCullList[n4].clipPlanes == null ? 0 : this.workCullList[n4].clipPlanes.length;
                    if (n11 < this.lastClip) {
                        VisualDetails[] visualDetailsArray2 = new VisualDetails[this.lastClip];
                        if (n11 != 0) {
                            System.arraycopy(this.workCullList[n4].clipPlanes, 0, visualDetailsArray2, 0, n11);
                        }
                        for (n9 = n11; n9 < this.lastClip; ++n9) {
                            visualDetailsArray2[n9] = new VisualDetails();
                        }
                        this.workCullList[n4].clipPlanes = visualDetailsArray2;
                    }
                    VisualDetails[] visualDetailsArray3 = this.workCullList[n4].clipPlanes;
                    this.workCullList[n4].numClipPlanes = this.lastClip;
                    for (n9 = 0; n9 < this.lastClip; ++n9) {
                        visualDetailsArray3[n9].update(this.clipList[n9], this.clipTxList[n9]);
                    }
                    ++n4;
                }
            } else if (cullableArray[n2] instanceof SingleCullable) {
                n4 = this.findNextNode((SingleCullable)cullableArray[n2], bl3, false, n4);
            }
            if (!bl5) continue;
            --this.lastTxStack;
        }
        this.lastLight -= n7;
        this.lastClip -= n8;
        if (bl4) {
            this.fogStack[this.lastFogStack] = null;
            --this.lastFogStack;
        }
        return n4;
    }

    private int findNextNode(SingleCullable singleCullable, boolean bl, boolean bl2, int n) {
        Renderable renderable;
        Cullable cullable;
        if (this.terminate) {
            return 0;
        }
        int n2 = n;
        Cullable cullable2 = singleCullable.getCullableChild();
        while (cullable2 != null && cullable2 instanceof SingleCullable) {
            cullable2 = ((SingleCullable)cullable2).getCullableChild();
        }
        boolean bl3 = cullable2 instanceof TransformCullable;
        if (bl3) {
            this.resizeStack();
            cullable = (TransformCullable)cullable2;
            cullable.getTransform(this.transformStack[this.lastTxStack + 1]);
            this.transformStack[this.lastTxStack + 1].mul(this.transformStack[this.lastTxStack], this.transformStack[this.lastTxStack + 1]);
            ++this.lastTxStack;
        }
        if (cullable2 instanceof GroupCullable) {
            n2 = this.findAllNodes((GroupCullable)cullable2, bl, bl3, n2);
        } else if (cullable2 instanceof LeafCullable && (cullable = (LeafCullable)cullable2).getCullableType() == 4 && (renderable = cullable.getRenderable()) instanceof ShapeRenderable && ((ShapeRenderable)renderable).isVisible()) {
            int n3;
            int n4;
            VisualDetails[] visualDetailsArray;
            int n5;
            BoundingVolume boundingVolume = cullable.getBounds();
            boundingVolume.getExtents(this.t1, this.t2);
            boundingVolume.getCenter(this.c1);
            ((BoundingBox)boundingVolume).getSize(this.c2);
            renderable = new DebugShapeRenderable(false, this.t1, this.t2, this.c1, this.c2, this.transformStack[this.lastTxStack]);
            if (this.checkOffscreens) {
                this.checkForOffscreens((ShapeRenderable)((Object)cullable2));
            }
            this.resizeCullList(n);
            this.workCullList[n].renderable = renderable;
            this.workCullList[n2].localFog = this.fogStack[this.lastFogStack];
            Matrix4f matrix4f = this.transformStack[this.lastTxStack];
            this.workCullList[n].transform.set(matrix4f);
            int n6 = n5 = this.workCullList[n].lights == null ? 0 : this.workCullList[n].lights.length;
            if (n5 < this.lastLight) {
                visualDetailsArray = new VisualDetails[this.lastLight];
                if (n5 != 0) {
                    System.arraycopy(this.workCullList[n].lights, 0, visualDetailsArray, 0, n5);
                }
                for (n4 = n5; n4 < this.lastLight; ++n4) {
                    visualDetailsArray[n4] = new VisualDetails();
                }
                this.workCullList[n].lights = visualDetailsArray;
            }
            visualDetailsArray = this.workCullList[n].lights;
            this.workCullList[n].numLights = this.lastLight;
            for (n4 = 0; n4 < this.lastLight; ++n4) {
                visualDetailsArray[n4].update(this.lightList[n4], this.lightTxList[n4]);
            }
            int n7 = n5 = this.workCullList[n].clipPlanes == null ? 0 : this.workCullList[n].clipPlanes.length;
            if (n5 < this.lastClip) {
                VisualDetails[] visualDetailsArray2 = new VisualDetails[this.lastClip];
                if (n5 != 0) {
                    System.arraycopy(this.workCullList[n].clipPlanes, 0, visualDetailsArray2, 0, n5);
                }
                for (n3 = n5; n3 < this.lastClip; ++n3) {
                    visualDetailsArray2[n3] = new VisualDetails();
                }
                this.workCullList[n].clipPlanes = visualDetailsArray2;
            }
            VisualDetails[] visualDetailsArray3 = this.workCullList[n].clipPlanes;
            this.workCullList[n].numClipPlanes = this.lastClip;
            for (n3 = 0; n3 < this.lastClip; ++n3) {
                visualDetailsArray3[n3].update(this.clipList[n3], this.clipTxList[n3]);
            }
            ++n;
            ++n2;
        }
        if (bl3) {
            --this.lastTxStack;
        }
        return n2;
    }

    private void updateFrustum(GraphicsEnvironmentData graphicsEnvironmentData) {
        float f = (float)this.viewFrustum[0];
        float f2 = (float)this.viewFrustum[1];
        float f3 = (float)this.viewFrustum[2];
        float f4 = (float)this.viewFrustum[3];
        float f5 = (float)this.viewFrustum[4];
        float f6 = (float)this.viewFrustum[5];
        float f7 = 2.0f * f5 / (f2 - f);
        float f8 = 2.0f * f5 / (f4 - f3);
        float f9 = (f2 + f) / (f2 - f);
        float f10 = (f4 + f3) / (f4 - f3);
        float f11 = -(f6 + f5) / (f6 - f5);
        float f12 = -(2.0f * f6 * f5) / (f6 - f5);
        this.prjMatrix.m00 = f7;
        this.prjMatrix.m01 = 0.0f;
        this.prjMatrix.m02 = f9;
        this.prjMatrix.m03 = 0.0f;
        this.prjMatrix.m10 = 0.0f;
        this.prjMatrix.m11 = f8;
        this.prjMatrix.m12 = f10;
        this.prjMatrix.m13 = 0.0f;
        this.prjMatrix.m20 = 0.0f;
        this.prjMatrix.m21 = 0.0f;
        this.prjMatrix.m22 = f11;
        this.prjMatrix.m23 = f12;
        this.prjMatrix.m30 = 0.0f;
        this.prjMatrix.m31 = 0.0f;
        this.prjMatrix.m32 = -1.0f;
        this.prjMatrix.m33 = 0.0f;
        this.matrixUtils.inverse(this.viewMatrix, this.viewMatrix);
        this.viewMatrix.mul(this.prjMatrix, this.viewMatrix);
        this.prjMatrix.m00 = this.viewMatrix.m00;
        this.prjMatrix.m01 = this.viewMatrix.m10;
        this.prjMatrix.m02 = this.viewMatrix.m20;
        this.prjMatrix.m03 = this.viewMatrix.m30;
        this.prjMatrix.m10 = this.viewMatrix.m01;
        this.prjMatrix.m11 = this.viewMatrix.m11;
        this.prjMatrix.m12 = this.viewMatrix.m21;
        this.prjMatrix.m13 = this.viewMatrix.m31;
        this.prjMatrix.m20 = this.viewMatrix.m02;
        this.prjMatrix.m21 = this.viewMatrix.m12;
        this.prjMatrix.m22 = this.viewMatrix.m22;
        this.prjMatrix.m23 = this.viewMatrix.m32;
        this.prjMatrix.m30 = this.viewMatrix.m03;
        this.prjMatrix.m31 = this.viewMatrix.m13;
        this.prjMatrix.m32 = this.viewMatrix.m23;
        this.prjMatrix.m33 = this.viewMatrix.m33;
        f7 = this.prjMatrix.m03 - this.prjMatrix.m00;
        f8 = this.prjMatrix.m13 - this.prjMatrix.m10;
        float f13 = this.prjMatrix.m23 - this.prjMatrix.m20;
        float f14 = this.prjMatrix.m33 - this.prjMatrix.m30;
        float f15 = 1.0f / (float)Math.sqrt(f7 * f7 + f8 * f8 + f13 * f13);
        this.frustumPlanes[0].x = f7 * f15;
        this.frustumPlanes[0].y = f8 * f15;
        this.frustumPlanes[0].z = f13 * f15;
        this.frustumPlanes[0].w = f14 * f15;
        f7 = this.prjMatrix.m03 + this.prjMatrix.m00;
        f8 = this.prjMatrix.m13 + this.prjMatrix.m10;
        f13 = this.prjMatrix.m23 + this.prjMatrix.m20;
        f14 = this.prjMatrix.m33 + this.prjMatrix.m30;
        f15 = 1.0f / (float)Math.sqrt(f7 * f7 + f8 * f8 + f13 * f13);
        this.frustumPlanes[1].x = f7 * f15;
        this.frustumPlanes[1].y = f8 * f15;
        this.frustumPlanes[1].z = f13 * f15;
        this.frustumPlanes[1].w = f14 * f15;
        f7 = this.prjMatrix.m03 + this.prjMatrix.m01;
        f8 = this.prjMatrix.m13 + this.prjMatrix.m11;
        f13 = this.prjMatrix.m23 + this.prjMatrix.m21;
        f14 = this.prjMatrix.m33 + this.prjMatrix.m31;
        f15 = 1.0f / (float)Math.sqrt(f7 * f7 + f8 * f8 + f13 * f13);
        this.frustumPlanes[2].x = f7 * f15;
        this.frustumPlanes[2].y = f8 * f15;
        this.frustumPlanes[2].z = f13 * f15;
        this.frustumPlanes[2].w = f14 * f15;
        f7 = this.prjMatrix.m03 - this.prjMatrix.m01;
        f8 = this.prjMatrix.m13 - this.prjMatrix.m11;
        f13 = this.prjMatrix.m23 - this.prjMatrix.m21;
        f14 = this.prjMatrix.m33 - this.prjMatrix.m31;
        f15 = 1.0f / (float)Math.sqrt(f7 * f7 + f8 * f8 + f13 * f13);
        this.frustumPlanes[3].x = f7 * f15;
        this.frustumPlanes[3].y = f8 * f15;
        this.frustumPlanes[3].z = f13 * f15;
        this.frustumPlanes[3].w = f14 * f15;
        f7 = this.prjMatrix.m03 - this.prjMatrix.m02;
        f8 = this.prjMatrix.m13 - this.prjMatrix.m12;
        f13 = this.prjMatrix.m23 - this.prjMatrix.m22;
        f14 = this.prjMatrix.m33 - this.prjMatrix.m32;
        f15 = 1.0f / (float)Math.sqrt(f7 * f7 + f8 * f8 + f13 * f13);
        this.frustumPlanes[4].x = f7 * f15;
        this.frustumPlanes[4].y = f8 * f15;
        this.frustumPlanes[4].z = f13 * f15;
        this.frustumPlanes[4].w = f14 * f15;
        f7 = this.prjMatrix.m03 + this.prjMatrix.m02;
        f8 = this.prjMatrix.m13 + this.prjMatrix.m12;
        f13 = this.prjMatrix.m23 + this.prjMatrix.m22;
        f14 = this.prjMatrix.m33 + this.prjMatrix.m32;
        f15 = 1.0f / (float)Math.sqrt(f7 * f7 + f8 * f8 + f13 * f13);
        this.frustumPlanes[5].x = f7 * f15;
        this.frustumPlanes[5].y = f8 * f15;
        this.frustumPlanes[5].z = f13 * f15;
        this.frustumPlanes[5].w = f14 * f15;
    }
}

