/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.aviatrix3d.nodes;

import javax.media.opengl.GL;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.picking.NotPickableException;
import org.j3d.renderer.aviatrix3d.nodes.BufferGeometry;

public class TriangleFanArray
extends BufferGeometry {
    private static final String MIN_COUNT_MSG = "A fan with less than 3 vertices is specified at index ";
    private static final String TOTAL_COUNT_MSG = "The total requested indexes in the fan is greater than the number of valid vertices provided.";
    private int[] fanCounts;
    private int numFans;

    public TriangleFanArray() {
        this.initPolygonDetails(3);
    }

    public void render(GL gL) {
        if (this.numFans == 0 || (this.vertexFormat & 7) == 0) {
            return;
        }
        this.setVertexState(gL);
        int n = 0;
        for (int i = 0; i < this.numFans; ++i) {
            gL.glDrawArrays(6, n, this.fanCounts[i]);
            n += this.fanCounts[i];
        }
        this.clearVertexState(gL);
    }

    protected boolean isVisible() {
        return super.isVisible() && this.numFans != 0;
    }

    public boolean pickLineSegment(float[] fArray, float[] fArray2, boolean bl, float[] fArray3, int n) throws NotPickableException {
        super.pickLineSegment(fArray, fArray2, bl, fArray3, n);
        float f = Float.POSITIVE_INFINITY;
        boolean bl2 = false;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = fArray2[0];
        float f6 = fArray2[1];
        float f7 = fArray2[2];
        float f8 = fArray2[0] - fArray[0];
        float f9 = fArray2[1] - fArray[1];
        float f10 = fArray2[2] - fArray[2];
        float f11 = (float)Math.sqrt(f8 * f8 + f9 * f9 + f10 * f10);
        fArray2[0] = f8;
        fArray2[1] = f9;
        fArray2[2] = f10;
        this.vertexBuffer.rewind();
        block0: for (int i = 0; i < this.numFans; ++i) {
            float f12;
            float f13;
            float f14;
            int n2 = this.fanCounts[i] - 2;
            this.vertexBuffer.get(this.wkPolygon, 0, 3);
            this.vertexBuffer.get(this.wkPolygon, 3, 6);
            if (this.ray3DTriangleChecked(fArray, fArray2, f11, fArray3)) {
                bl2 = true;
                if (bl) break;
                float f15 = fArray[0] - fArray3[0];
                f14 = fArray[1] - fArray3[1];
                f13 = fArray[2] - fArray3[2];
                f12 = f15 * f15 + f14 * f14 + f13 * f13;
                if (f12 < f) {
                    f = f12;
                    f2 = fArray3[0];
                    f3 = fArray3[1];
                    f4 = fArray3[2];
                }
            }
            for (int j = 0; j < n2; ++j) {
                this.wkPolygon[3] = this.wkPolygon[6];
                this.wkPolygon[4] = this.wkPolygon[7];
                this.wkPolygon[5] = this.wkPolygon[8];
                this.vertexBuffer.get(this.wkPolygon, 6, 3);
                if (!this.ray3DTriangleChecked(fArray, fArray2, f11, fArray3)) continue;
                bl2 = true;
                if (bl) continue block0;
                f14 = fArray[0] - fArray3[0];
                f13 = fArray[1] - fArray3[1];
                float f16 = fArray[2] - fArray3[2];
                f12 = f14 * f14 + f13 * f13 + f16 * f16;
                if (!(f12 < f)) continue;
                f = f12;
                f2 = fArray3[0];
                f3 = fArray3[1];
                f4 = fArray3[2];
            }
        }
        fArray3[0] = f2;
        fArray3[1] = f3;
        fArray3[2] = f4;
        fArray2[0] = f5;
        fArray2[1] = f6;
        fArray2[2] = f7;
        return bl2;
    }

    public boolean pickLineRay(float[] fArray, float[] fArray2, boolean bl, float[] fArray3, int n) throws NotPickableException {
        super.pickLineRay(fArray, fArray2, bl, fArray3, n);
        float f = Float.POSITIVE_INFINITY;
        boolean bl2 = false;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        this.vertexBuffer.rewind();
        block0: for (int i = 0; i < this.numFans; ++i) {
            float f5;
            float f6;
            float f7;
            int n2 = this.fanCounts[i] - 2;
            this.vertexBuffer.get(this.wkPolygon, 0, 3);
            this.vertexBuffer.get(this.wkPolygon, 3, 6);
            if (this.ray3DTriangleChecked(fArray, fArray2, 0.0f, fArray3)) {
                bl2 = true;
                if (bl) break;
                float f8 = fArray[0] - fArray3[0];
                f7 = fArray[1] - fArray3[1];
                f6 = fArray[2] - fArray3[2];
                f5 = f8 * f8 + f7 * f7 + f6 * f6;
                if (f5 < f) {
                    f = f5;
                    f2 = fArray3[0];
                    f3 = fArray3[1];
                    f4 = fArray3[2];
                }
            }
            for (int j = 1; j < n2; ++j) {
                this.wkPolygon[3] = this.wkPolygon[6];
                this.wkPolygon[4] = this.wkPolygon[7];
                this.wkPolygon[5] = this.wkPolygon[8];
                this.vertexBuffer.get(this.wkPolygon, 6, 3);
                if (!this.ray3DTriangleChecked(fArray, fArray2, 0.0f, fArray3)) continue;
                bl2 = true;
                if (bl) continue block0;
                f7 = fArray[0] - fArray3[0];
                f6 = fArray[1] - fArray3[1];
                float f9 = fArray[2] - fArray3[2];
                f5 = f7 * f7 + f6 * f6 + f9 * f9;
                if (!(f5 < f)) continue;
                f = f5;
                f2 = fArray3[0];
                f3 = fArray3[1];
                f4 = fArray3[2];
            }
        }
        fArray3[0] = f2;
        fArray3[1] = f3;
        fArray3[2] = f4;
        return bl2;
    }

    public int compareTo(Object object) throws ClassCastException {
        TriangleFanArray triangleFanArray = (TriangleFanArray)object;
        return this.compareTo(triangleFanArray);
    }

    public boolean equals(Object object) {
        if (!(object instanceof TriangleFanArray)) {
            return false;
        }
        return this.equals((TriangleFanArray)object);
    }

    public void setFanCount(int[] nArray, int n) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (nArray[i] < 3) {
                throw new IllegalArgumentException(MIN_COUNT_MSG + i);
            }
            n2 += nArray[i];
        }
        if (this.fanCounts == null || this.fanCounts.length < n) {
            this.fanCounts = new int[n];
        }
        if (n2 > this.numCoords) {
            throw new IllegalArgumentException(TOTAL_COUNT_MSG);
        }
        this.numFans = n;
        if (n > 0) {
            System.arraycopy(nArray, 0, this.fanCounts, 0, n);
        }
    }

    public int getValidFanCount() {
        return this.numFans;
    }

    public void getFanCount(int[] nArray) {
        System.arraycopy(this.fanCounts, 0, nArray, 0, this.numFans);
    }

    public int compareTo(TriangleFanArray triangleFanArray) {
        if (triangleFanArray == null) {
            return 1;
        }
        if (triangleFanArray == this) {
            return 0;
        }
        return 0;
    }

    public boolean equals(TriangleFanArray triangleFanArray) {
        return triangleFanArray == this;
    }
}

