/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.aviatrix3d.nodes;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import javax.media.opengl.GL;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.picking.NotPickableException;
import org.j3d.renderer.aviatrix3d.nodes.BufferGeometry;

public class TriangleArray
extends BufferGeometry {
    private ByteBuffer edgeBuffer;

    public TriangleArray() {
        this.initPolygonDetails(3);
    }

    public void render(GL gL) {
        if ((this.vertexFormat & 7) == 0) {
            return;
        }
        this.setVertexState(gL);
        if ((this.vertexFormat & 0x10000) != 0) {
            gL.glEnableClientState(32889);
            gL.glEdgeFlagPointer(0, (Buffer)this.edgeBuffer);
        }
        gL.glDrawArrays(4, 0, this.numCoords);
        if ((this.vertexFormat & 0x10000) != 0) {
            gL.glDisableClientState(32889);
            gL.glEdgeFlag(true);
        }
        this.clearVertexState(gL);
    }

    public boolean pickLineSegment(float[] fArray, float[] fArray2, boolean bl, float[] fArray3, int n) throws NotPickableException {
        super.pickLineSegment(fArray, fArray2, bl, fArray3, n);
        float f = Float.POSITIVE_INFINITY;
        boolean bl2 = false;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = fArray2[0];
        float f6 = fArray2[1];
        float f7 = fArray2[2];
        float f8 = fArray2[0] - fArray[0];
        float f9 = fArray2[1] - fArray[1];
        float f10 = fArray2[2] - fArray[2];
        float f11 = (float)Math.sqrt(f8 * f8 + f9 * f9 + f10 * f10);
        fArray2[0] = f8;
        fArray2[1] = f9;
        fArray2[2] = f10;
        int n2 = this.numCoords / 3;
        this.vertexBuffer.rewind();
        for (int i = 0; i < n2; ++i) {
            this.vertexBuffer.get(this.wkPolygon, 0, 9);
            if (!this.ray3DTriangleChecked(fArray, fArray2, f11, fArray3)) continue;
            bl2 = true;
            if (bl) break;
            float f12 = fArray[0] - fArray3[0];
            float f13 = fArray[1] - fArray3[1];
            float f14 = fArray[2] - fArray3[2];
            float f15 = f12 * f12 + f13 * f13 + f14 * f14;
            if (!(f15 < f)) continue;
            f = f15;
            f2 = fArray3[0];
            f3 = fArray3[1];
            f4 = fArray3[2];
        }
        fArray3[0] = f2;
        fArray3[1] = f3;
        fArray3[2] = f4;
        fArray2[0] = f5;
        fArray2[1] = f6;
        fArray2[2] = f7;
        return bl2;
    }

    public boolean pickLineRay(float[] fArray, float[] fArray2, boolean bl, float[] fArray3, int n) throws NotPickableException {
        super.pickLineRay(fArray, fArray2, bl, fArray3, n);
        float f = Float.POSITIVE_INFINITY;
        boolean bl2 = false;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        int n2 = this.numCoords / 3;
        this.vertexBuffer.rewind();
        for (int i = 0; i < n2; ++i) {
            this.vertexBuffer.get(this.wkPolygon, 0, 9);
            if (!this.ray3DTriangleChecked(fArray, fArray2, 0.0f, fArray3)) continue;
            bl2 = true;
            if (bl) break;
            float f5 = fArray[0] - fArray3[0];
            float f6 = fArray[1] - fArray3[1];
            float f7 = fArray[2] - fArray3[2];
            float f8 = f5 * f5 + f6 * f6 + f7 * f7;
            if (!(f8 < f)) continue;
            f = f8;
            f2 = fArray3[0];
            f3 = fArray3[1];
            f4 = fArray3[2];
        }
        fArray3[0] = f2;
        fArray3[1] = f3;
        fArray3[2] = f4;
        return bl2;
    }

    public int compareTo(Object object) throws ClassCastException {
        TriangleArray triangleArray = (TriangleArray)object;
        return this.compareTo(triangleArray);
    }

    public boolean equals(Object object) {
        if (!(object instanceof TriangleArray)) {
            return false;
        }
        return this.equals((TriangleArray)object);
    }

    public void setEdgeFlags(ByteBuffer byteBuffer) throws IllegalArgumentException, InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (byteBuffer != null && byteBuffer.limit() < this.numCoords) {
            throw new IllegalArgumentException("Edge flag array too short");
        }
        this.edgeBuffer = byteBuffer;
        this.vertexFormat = byteBuffer == null ? (this.vertexFormat &= 0xFFFEFFFF) : (this.vertexFormat |= 0x10000);
    }

    public int compareTo(TriangleArray triangleArray) {
        if (triangleArray == null) {
            return 1;
        }
        if (triangleArray == this) {
            return 0;
        }
        return 0;
    }

    public boolean equals(TriangleArray triangleArray) {
        return triangleArray == this;
    }
}

