/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.aviatrix3d.nodes;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.Arrays;
import javax.media.opengl.GL;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector4f;
import org.j3d.aviatrix3d.rendering.CustomGeometryRenderable;
import org.j3d.renderer.aviatrix3d.nodes.BufferGeometry;
import org.j3d.renderer.aviatrix3d.nodes.ObjectPlacer;
import org.j3d.util.MatrixUtils;

public class SortedPointArray
extends BufferGeometry
implements CustomGeometryRenderable {
    private IntBuffer sortedVertexIndices;
    private ObjectPlacer[] sortedVertices;
    private MatrixUtils matrixUtils;
    private Matrix4f cameraMatrix;
    private Point3f wkPoint = new Point3f();

    public SortedPointArray() {
        this.cameraMatrix = new Matrix4f();
        this.matrixUtils = new MatrixUtils();
    }

    public Object processCull(Matrix4f matrix4f, Matrix4f matrix4f2, Vector4f[] vector4fArray, float f) {
        int n;
        if (this.sortedVertexIndices == null || this.sortedVertexIndices.capacity() < this.numCoords) {
            this.sortedVertices = new ObjectPlacer[this.numCoords];
            for (n = 0; n < this.numCoords; ++n) {
                this.sortedVertices[n] = new ObjectPlacer();
            }
            this.sortedVertexIndices = this.createBuffer(this.numCoords);
        }
        this.matrixUtils.inverse(matrix4f2, this.cameraMatrix);
        for (n = 0; n < this.numCoords; ++n) {
            this.wkPoint.x = this.vertexBuffer.get(n * 3);
            this.wkPoint.y = this.vertexBuffer.get(n * 3 + 1);
            this.wkPoint.z = this.vertexBuffer.get(n * 3 + 2);
            matrix4f.transform(this.wkPoint);
            this.cameraMatrix.transform(this.wkPoint);
            this.sortedVertices[n].distance = this.wkPoint.x * this.wkPoint.x + this.wkPoint.y * this.wkPoint.y + this.wkPoint.z * this.wkPoint.z;
            this.sortedVertices[n].index = n;
        }
        Arrays.sort(this.sortedVertices, 0, this.numCoords);
        this.sortedVertexIndices.rewind();
        for (n = 0; n < this.numCoords; ++n) {
            this.sortedVertexIndices.put(this.sortedVertices[n].index);
        }
        this.sortedVertexIndices.rewind();
        return null;
    }

    public void render(GL gL, Object object) {
        if ((this.vertexFormat & 7) == 0) {
            return;
        }
        this.setVertexState(gL);
        if (this.sortedVertexIndices != null) {
            gL.glDrawElements(0, this.numCoords, 5125, (Buffer)this.sortedVertexIndices);
        } else {
            gL.glDrawArrays(0, 0, this.numCoords);
        }
        this.clearVertexState(gL);
    }

    public void render(GL gL) {
        if ((this.vertexFormat & 7) == 0) {
            return;
        }
        this.setVertexState(gL);
        gL.glDrawArrays(0, 0, this.numCoords);
        this.clearVertexState(gL);
    }

    public int compareTo(Object object) throws ClassCastException {
        SortedPointArray sortedPointArray = (SortedPointArray)object;
        return this.compareTo(sortedPointArray);
    }

    public boolean equals(Object object) {
        if (!(object instanceof SortedPointArray)) {
            return false;
        }
        return this.equals((SortedPointArray)object);
    }

    public int compareTo(SortedPointArray sortedPointArray) {
        if (sortedPointArray == null) {
            return 1;
        }
        if (sortedPointArray == this) {
            return 0;
        }
        return 0;
    }

    public boolean equals(SortedPointArray sortedPointArray) {
        return sortedPointArray == this;
    }

    private IntBuffer createBuffer(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n * 4);
        byteBuffer.order(ByteOrder.nativeOrder());
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        return intBuffer;
    }
}

