/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.aviatrix3d.nodes;

import java.util.ArrayList;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import org.j3d.aviatrix3d.BaseGroup;
import org.j3d.aviatrix3d.Node;
import org.j3d.aviatrix3d.SharedGroup;
import org.j3d.aviatrix3d.SharedNode;
import org.j3d.aviatrix3d.TransformGroup;
import org.j3d.aviatrix3d.rendering.CullInstructions;
import org.j3d.aviatrix3d.rendering.Cullable;
import org.j3d.aviatrix3d.rendering.CustomCullable;
import org.j3d.util.MatrixUtils;

public class MarkerGroup
extends BaseGroup
implements CustomCullable {
    private Node target;
    private Matrix4f pathMatrix;
    private ArrayList<TransformGroup> pathList;
    private Node[] pathNodes;
    private Matrix4f targetMatrix;
    private Vector3f targetPosition;
    private Vector3f viewPosition;
    private Matrix4f viewMatrix;
    private MatrixUtils matrixUtils = new MatrixUtils();
    private boolean matrixChanged;
    private Matrix4f markerMatrix;
    private Vector3f markerPosition = new Vector3f();
    private Matrix3f rotMatrix;
    private boolean enabled;

    public MarkerGroup() {
        this.markerMatrix = new Matrix4f();
        this.rotMatrix = new Matrix3f();
        this.viewPosition = new Vector3f();
        this.viewMatrix = new Matrix4f();
        this.targetPosition = new Vector3f();
        this.targetMatrix = new Matrix4f();
        this.pathList = new ArrayList();
        this.pathNodes = new Node[20];
        this.pathMatrix = new Matrix4f();
    }

    public void cullChildren(CullInstructions cullInstructions, Matrix4f matrix4f, Matrix4f matrix4f2, Vector4f[] vector4fArray, float f) {
        if (this.enabled && this.target != null) {
            this.getLocalToVworld(this.target, this.targetMatrix);
            this.targetMatrix.get(this.targetPosition);
            this.viewMatrix.set(matrix4f2);
            this.viewMatrix.get(this.viewPosition);
            this.viewMatrix.get(this.rotMatrix);
            this.markerPosition.set(this.targetPosition.x - this.viewPosition.x, this.targetPosition.y - this.viewPosition.y, this.targetPosition.z - this.viewPosition.z);
            this.markerPosition.normalize();
            this.markerPosition.scale(2.0f);
            this.markerPosition.add((Tuple3f)this.viewPosition);
            matrix4f.get(this.viewPosition);
            this.markerPosition.sub((Tuple3f)this.viewPosition);
            this.markerMatrix.setIdentity();
            this.markerMatrix.setRotation(this.rotMatrix);
            this.markerMatrix.setTranslation(this.markerPosition);
            if (0 == this.bounds.checkIntersectionFrustum(vector4fArray, this.markerMatrix)) {
                cullInstructions.hasTransform = false;
                cullInstructions.numChildren = 0;
            } else {
                cullInstructions.localTransform.set(this.markerMatrix);
                cullInstructions.hasTransform = true;
                if (cullInstructions.children.length < this.lastChild) {
                    cullInstructions.resizeChildren(this.lastChild);
                }
                cullInstructions.numChildren = 0;
                for (int i = 0; i < this.lastChild; ++i) {
                    if (!(this.childList[i] instanceof Cullable)) continue;
                    cullInstructions.children[cullInstructions.numChildren++] = (Cullable)((Object)this.childList[i]);
                }
            }
        } else {
            cullInstructions.hasTransform = false;
            cullInstructions.numChildren = 0;
        }
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public void setTarget(Node node) {
        this.target = node;
    }

    private void getLocalToVworld(Node node, Matrix4f matrix4f) {
        int n;
        Node node2;
        this.pathList.clear();
        if (node instanceof SharedNode && (node2 = ((SharedNode)node).getChild()) instanceof TransformGroup) {
            this.pathList.add((TransformGroup)node2);
        }
        node2 = node.getParent();
        while (node2 != null) {
            if (node2 instanceof SharedGroup) {
                SharedGroup sharedGroup = (SharedGroup)node2;
                n = sharedGroup.numParents();
                if (n == 0) break;
                if (n > this.pathNodes.length) {
                    this.pathNodes = new Node[n];
                }
                sharedGroup.getParents(this.pathNodes);
                node2 = this.pathNodes[0];
                continue;
            }
            if (node2 instanceof TransformGroup) {
                this.pathList.add((TransformGroup)node2);
            }
            node2 = node2.getParent();
        }
        int n2 = this.pathList.size();
        matrix4f.setIdentity();
        this.pathMatrix.setIdentity();
        for (n = n2 - 1; n >= 0; --n) {
            TransformGroup transformGroup = this.pathList.get(n);
            transformGroup.getTransform(this.pathMatrix);
            matrix4f.mul(this.pathMatrix);
        }
    }
}

