/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.aviatrix3d.nodes;

import javax.vecmath.Matrix4f;
import javax.vecmath.Vector4f;
import org.j3d.aviatrix3d.AlreadyParentedException;
import org.j3d.aviatrix3d.BaseGroup;
import org.j3d.aviatrix3d.BoundingSphere;
import org.j3d.aviatrix3d.BoundingVoid;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.Node;
import org.j3d.aviatrix3d.PickingUtils;
import org.j3d.aviatrix3d.picking.CustomPickTarget;
import org.j3d.aviatrix3d.picking.InvalidPickTimingException;
import org.j3d.aviatrix3d.picking.NotPickableException;
import org.j3d.aviatrix3d.picking.PickInstructions;
import org.j3d.aviatrix3d.picking.PickRequest;
import org.j3d.aviatrix3d.picking.PickTarget;
import org.j3d.aviatrix3d.picking.PickableObject;
import org.j3d.aviatrix3d.picking.PickingManager;
import org.j3d.aviatrix3d.rendering.BoundingVolume;
import org.j3d.aviatrix3d.rendering.CullInstructions;
import org.j3d.aviatrix3d.rendering.Cullable;
import org.j3d.aviatrix3d.rendering.CustomCullable;

public class LODGroup
extends BaseGroup
implements CustomCullable,
CustomPickTarget,
PickableObject {
    private static final String PICK_TIMING_MSG = "Picking not permitted right now. Picking is only permitted during the update observer callbacks.";
    private static final String PICKABLE_FALSE_MSG = "This node has been marked as not pickable by the user";
    private static final String CHILD_IDX_ERR = "Index provided > last valid index";
    private static final String VALUE_ORDER_ERR = "Range values are required to be monotonously increasing";
    private final boolean distanceMode;
    private float[] valueArr;
    private float[] rangeSquared;
    private float[] center;
    private float[] cTmp;
    private int pickFlags;
    private int activeChild;
    private PickingUtils pickUtils;

    public LODGroup() {
        this(true);
    }

    public LODGroup(boolean bl) {
        int n;
        this.distanceMode = bl;
        this.pickFlags = -1;
        this.valueArr = new float[this.childList.length];
        for (n = 0; n < this.childList.length; ++n) {
            this.valueArr[n] = Float.MAX_VALUE;
        }
        this.cTmp = new float[3];
        this.center = new float[3];
        if (bl) {
            this.rangeSquared = new float[this.childList.length];
            for (n = 0; n < this.childList.length; ++n) {
                this.rangeSquared[n] = Float.MAX_VALUE;
            }
        }
        this.pickUtils = new PickingUtils();
    }

    public void cullChildren(CullInstructions cullInstructions, Matrix4f matrix4f, Matrix4f matrix4f2, Vector4f[] vector4fArray, float f) {
        if (0 == this.bounds.checkIntersectionFrustum(vector4fArray, matrix4f)) {
            cullInstructions.hasTransform = false;
            cullInstructions.numChildren = 0;
            return;
        }
        double d = matrix4f2.m03 - matrix4f.m03 + this.center[0];
        double d2 = matrix4f2.m13 - matrix4f.m13 + this.center[1];
        double d3 = matrix4f2.m23 - matrix4f.m23 + this.center[2];
        int n = -1;
        if (this.distanceMode) {
            double d4 = d * d + d2 * d2 + d3 * d3;
            for (int i = 0; i < this.lastChild; ++i) {
                if (!(d4 <= (double)this.rangeSquared[i])) continue;
                n = i;
                break;
            }
        } else {
            f = (float)Math.toRadians(f);
            for (int i = 0; i < this.lastChild; ++i) {
                BoundingVolume boundingVolume = this.childList[i].getBounds();
                if (boundingVolume == null || boundingVolume instanceof BoundingVoid) continue;
                boundingVolume.getCenter(this.cTmp);
                float f2 = 0.0f;
                if (boundingVolume instanceof BoundingSphere) {
                    f2 = ((BoundingSphere)boundingVolume).getRadius();
                } else {
                    this.bounds.getExtents(this.wkVec1, this.wkVec2);
                    this.wkVec1[0] = this.cTmp[0] - this.wkVec1[0];
                    this.wkVec1[1] = this.cTmp[1] - this.wkVec1[1];
                    this.wkVec1[2] = this.cTmp[2] - this.wkVec1[2];
                    this.wkVec2[0] = this.wkVec2[0] - this.cTmp[0];
                    this.wkVec2[1] = this.wkVec2[1] - this.cTmp[1];
                    this.wkVec2[2] = this.wkVec2[2] - this.cTmp[2];
                    if (this.wkVec1[0] < this.wkVec2[0]) {
                        this.wkVec1[0] = this.wkVec2[0];
                    }
                    if (this.wkVec1[1] < this.wkVec2[1]) {
                        this.wkVec1[1] = this.wkVec2[1];
                    }
                    if (this.wkVec1[2] < this.wkVec2[2]) {
                        this.wkVec1[2] = this.wkVec2[2];
                    }
                    f2 = (float)Math.sqrt(this.wkVec1[0] * this.wkVec1[0] + this.wkVec1[1] * this.wkVec1[1] + this.wkVec1[2] * this.wkVec1[2]);
                }
                this.cTmp[0] = (float)((double)this.cTmp[0] - d);
                this.cTmp[1] = (float)((double)this.cTmp[1] - d2);
                this.cTmp[2] = (float)((double)this.cTmp[2] - d3);
                float f3 = (float)Math.sqrt(this.cTmp[0] * this.cTmp[0] + this.cTmp[1] * this.cTmp[1] + this.cTmp[2] * this.cTmp[2]) - f2;
                if (!(f3 * f <= this.valueArr[i])) continue;
                n = i;
                break;
            }
        }
        cullInstructions.hasTransform = false;
        if (n >= 0) {
            if (cullInstructions.children == null || cullInstructions.children.length < 1) {
                cullInstructions.resizeChildren(1);
            }
            cullInstructions.numChildren = 1;
            cullInstructions.children[0] = (Cullable)((Object)this.childList[n]);
        } else {
            cullInstructions.numChildren = 0;
        }
    }

    public void pickChildren(PickInstructions pickInstructions, Matrix4f matrix4f, PickRequest pickRequest) {
        pickInstructions.hasTransform = false;
        double d = pickRequest.origin[0] - matrix4f.m03 + this.center[0];
        double d2 = pickRequest.origin[1] - matrix4f.m13 + this.center[1];
        double d3 = pickRequest.origin[2] - matrix4f.m23 + this.center[2];
        if (this.distanceMode) {
            int n = -1;
            double d4 = d * d + d2 * d2 + d3 * d3;
            for (int i = 0; i < this.lastChild; ++i) {
                if (!(d4 <= (double)this.rangeSquared[i])) continue;
                n = i;
                break;
            }
            if (n != -1 && this.childList[n] instanceof PickTarget) {
                pickInstructions.resizeChildren(1);
                pickInstructions.numChildren = 1;
                pickInstructions.children[0] = (PickTarget)((Object)this.childList[n]);
            }
        } else {
            PickTarget pickTarget = null;
            for (int i = 0; pickTarget == null && i < this.lastChild; ++i) {
                if (!(this.childList[i] instanceof PickTarget)) continue;
                pickTarget = (PickTarget)((Object)this.childList[i]);
            }
            if (pickTarget != null) {
                pickInstructions.resizeChildren(1);
                pickInstructions.numChildren = 1;
                pickInstructions.children[0] = pickTarget;
            }
        }
    }

    public final int getPickTargetType() {
        return 4;
    }

    public boolean checkPickMask(int n) {
        return (this.pickFlags & n) != 0;
    }

    public BoundingVolume getPickableBounds() {
        return this.bounds;
    }

    public void setPickMask(int n) {
        this.pickFlags = n;
    }

    public int getPickMask() {
        return this.pickFlags;
    }

    public void pickBatch(PickRequest[] pickRequestArray, int n) throws NotPickableException, InvalidPickTimingException {
        if (this.updateHandler == null || !this.updateHandler.isPickingPermitted()) {
            throw new InvalidPickTimingException(PICK_TIMING_MSG);
        }
        if (this.pickFlags == 0) {
            throw new NotPickableException(PICKABLE_FALSE_MSG);
        }
        PickingManager pickingManager = this.updateHandler.getPickingManager();
        pickingManager.pickBatch(this, pickRequestArray, n);
    }

    public void pickSingle(PickRequest pickRequest) throws NotPickableException, InvalidPickTimingException {
        if (this.updateHandler == null || !this.updateHandler.isPickingPermitted()) {
            throw new InvalidPickTimingException(PICK_TIMING_MSG);
        }
        if (this.pickFlags == 0) {
            throw new NotPickableException(PICKABLE_FALSE_MSG);
        }
        PickingManager pickingManager = this.updateHandler.getPickingManager();
        pickingManager.pickSingle(this, pickRequest);
    }

    public void addChild(Node node) throws AlreadyParentedException, InvalidWriteTimingException {
        super.addChild(node);
        if (this.childList.length > this.valueArr.length) {
            int n;
            float[] fArray = new float[this.childList.length];
            for (n = 0; n < this.lastChild; ++n) {
                fArray[n] = this.valueArr[n];
            }
            for (n = this.lastChild; n < fArray.length; ++n) {
                fArray[n] = Float.MAX_VALUE;
            }
            this.valueArr = fArray;
            if (this.distanceMode) {
                fArray = new float[this.childList.length];
                System.arraycopy(this.rangeSquared, 0, fArray, 0, this.lastChild - 1);
                for (n = this.lastChild; n < fArray.length; ++n) {
                    fArray[n] = Float.MAX_VALUE;
                }
                this.rangeSquared = fArray;
            }
        }
    }

    public void removeChild(int n) throws InvalidWriteTimingException {
        int n2;
        super.removeChild(n);
        for (n2 = n; n2 < this.lastChild; ++n2) {
            this.valueArr[n2] = this.valueArr[n2 + 1];
        }
        if (this.distanceMode) {
            for (n2 = n; n2 < this.lastChild; ++n2) {
                this.rangeSquared[n2] = this.rangeSquared[n2 + 1];
            }
        }
        this.valueArr[this.lastChild] = Float.MAX_VALUE;
    }

    public void removeAllChildren() throws InvalidWriteTimingException {
        int n;
        super.removeAllChildren();
        for (n = this.lastChild; n < this.valueArr.length; ++n) {
            this.valueArr[n] = Float.MAX_VALUE;
        }
        if (this.distanceMode) {
            for (n = this.lastChild; n < this.valueArr.length; ++n) {
                this.rangeSquared[n] = Float.MAX_VALUE;
            }
        }
    }

    public float getRange(int n) {
        if (n < 0 || n > this.lastChild) {
            throw new IndexOutOfBoundsException(CHILD_IDX_ERR);
        }
        return this.valueArr[n];
    }

    public void setRange(int n, float f) throws InvalidWriteTimingException, IndexOutOfBoundsException, IllegalArgumentException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (n < 0 || n > this.lastChild) {
            throw new IndexOutOfBoundsException(CHILD_IDX_ERR);
        }
        if (n + 1 < this.lastChild && this.valueArr[n + 1] <= f || n - 1 >= 0 && this.valueArr[n - 1] >= f) {
            throw new IllegalArgumentException(VALUE_ORDER_ERR);
        }
        this.valueArr[n] = f;
        if (this.distanceMode) {
            this.rangeSquared[n] = f * f;
        }
    }

    public void getCenter(float[] fArray) {
        if (this.distanceMode) {
            fArray[0] = this.center[0];
            fArray[1] = this.center[1];
            fArray[2] = this.center[2];
        }
    }

    public void setCenter(float[] fArray) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (this.distanceMode) {
            this.center[0] = fArray[0];
            this.center[1] = fArray[1];
            this.center[2] = fArray[2];
        }
    }

    public boolean isDistanceMode() {
        return this.distanceMode;
    }
}

