/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.aviatrix3d.nodes;

import java.nio.Buffer;
import javax.media.opengl.GL;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.picking.NotPickableException;
import org.j3d.renderer.aviatrix3d.nodes.IndexedBufferGeometry;

public class IndexedTriangleStripArray
extends IndexedBufferGeometry {
    private static final String MIN_COUNT_MSG = "A strip with less than 3 vertices is specified at index ";
    private static final String TOTAL_COUNT_MSG = "The total requested indexes in the strip is greater than the number of valid vertices provided.";
    private int[] stripCounts;
    private int numStrips;

    public IndexedTriangleStripArray() {
        this.initPolygonDetails(3);
    }

    protected boolean isVisible() {
        return super.isVisible() && this.numStrips != 0;
    }

    public boolean pickLineSegment(float[] fArray, float[] fArray2, boolean bl, float[] fArray3, int n) throws NotPickableException {
        super.pickLineSegment(fArray, fArray2, bl, fArray3, n);
        System.out.println("IndexedTriangleStripArray.pickLineSegment() not implemented yet");
        return false;
    }

    public boolean pickLineRay(float[] fArray, float[] fArray2, boolean bl, float[] fArray3, int n) throws NotPickableException {
        super.pickLineRay(fArray, fArray2, bl, fArray3, n);
        System.out.println("IndexedTriangleStripArray.pickLineRay() not implemented yet");
        return false;
    }

    public void render(GL gL) {
        if (this.numStrips == 0 || this.numIndices == 0 || (this.vertexFormat & 7) == 0) {
            return;
        }
        this.setVertexState(gL);
        int n = 0;
        for (int i = 0; i < this.numStrips; ++i) {
            this.indexBuffer.position(n);
            gL.glDrawElements(5, this.stripCounts[i], 5125, (Buffer)this.indexBuffer);
            n += this.stripCounts[i];
        }
        this.clearVertexState(gL);
    }

    public int compareTo(Object object) throws ClassCastException {
        IndexedTriangleStripArray indexedTriangleStripArray = (IndexedTriangleStripArray)object;
        return this.compareTo(indexedTriangleStripArray);
    }

    public boolean equals(Object object) {
        if (!(object instanceof IndexedTriangleStripArray)) {
            return false;
        }
        return this.equals((IndexedTriangleStripArray)object);
    }

    public void setStripCount(int[] nArray, int n) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        for (int i = 0; i < n; ++i) {
            if (nArray[i] >= 3) continue;
            throw new IllegalArgumentException(MIN_COUNT_MSG + i);
        }
        if (this.stripCounts == null || this.stripCounts.length < n) {
            this.stripCounts = new int[n];
        }
        this.numStrips = n;
        if (n > 0) {
            System.arraycopy(nArray, 0, this.stripCounts, 0, n);
        }
    }

    public int getValidStripCount() {
        return this.numStrips;
    }

    public void getStripCount(int[] nArray) {
        System.arraycopy(this.stripCounts, 0, nArray, 0, this.numStrips);
    }

    public int compareTo(IndexedTriangleStripArray indexedTriangleStripArray) {
        if (indexedTriangleStripArray == null) {
            return 1;
        }
        if (indexedTriangleStripArray == this) {
            return 0;
        }
        return 0;
    }

    public boolean equals(IndexedTriangleStripArray indexedTriangleStripArray) {
        return indexedTriangleStripArray == this;
    }
}

