/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.aviatrix3d.nodes;

import java.nio.Buffer;
import javax.media.opengl.GL;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.picking.NotPickableException;
import org.j3d.renderer.aviatrix3d.nodes.IndexedBufferGeometry;
import org.j3d.renderer.aviatrix3d.nodes.TriangleArray;

public class IndexedTriangleFanArray
extends IndexedBufferGeometry {
    private static final String MIN_COUNT_MSG = "A fan with less than 3 vertices is specified at index ";
    private static final String TOTAL_COUNT_MSG = "The total requested indexes in the fan is greater than the number of valid vertices provided.";
    private int[] fanCounts;
    private int numFans;

    public IndexedTriangleFanArray() {
        this.initPolygonDetails(3);
    }

    protected boolean isVisible() {
        return super.isVisible() && this.numFans != 0;
    }

    public boolean pickLineSegment(float[] fArray, float[] fArray2, boolean bl, float[] fArray3, int n) throws NotPickableException {
        super.pickLineSegment(fArray, fArray2, bl, fArray3, n);
        System.out.println("IndexedTriangleFanArray.pickLineSegment() not implemented yet");
        return false;
    }

    public boolean pickLineRay(float[] fArray, float[] fArray2, boolean bl, float[] fArray3, int n) throws NotPickableException {
        super.pickLineRay(fArray, fArray2, bl, fArray3, n);
        System.out.println("IndexedTriangleFanArray.pickLineRay() not implemented yet");
        return false;
    }

    public void render(GL gL) {
        if (this.numFans == 0 || (this.vertexFormat & 7) == 0) {
            return;
        }
        this.setVertexState(gL);
        int n = 0;
        for (int i = 0; i < this.numFans; ++i) {
            this.indexBuffer.position(n);
            gL.glDrawElements(5, this.fanCounts[i], 5125, (Buffer)this.indexBuffer);
            n += this.fanCounts[i];
        }
        this.clearVertexState(gL);
    }

    public int compareTo(Object object) throws ClassCastException {
        TriangleArray triangleArray = (TriangleArray)object;
        return this.compareTo(triangleArray);
    }

    public boolean equals(Object object) {
        if (!(object instanceof TriangleArray)) {
            return false;
        }
        return this.equals((TriangleArray)object);
    }

    public void setFanCount(int[] nArray, int n) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        for (int i = 0; i < n; ++i) {
            if (nArray[i] >= 3) continue;
            throw new IllegalArgumentException(MIN_COUNT_MSG + i);
        }
        if (this.fanCounts == null || this.fanCounts.length < n) {
            this.fanCounts = new int[n];
        }
        this.numFans = n;
        if (n > 0) {
            System.arraycopy(nArray, 0, this.fanCounts, 0, n);
        }
    }

    public int getValidFanCount() {
        return this.numFans;
    }

    public void getFanCount(int[] nArray) {
        System.arraycopy(this.fanCounts, 0, nArray, 0, this.numFans);
    }
}

