/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.aviatrix3d.nodes;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import javax.media.opengl.GL;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.picking.NotPickableException;
import org.j3d.renderer.aviatrix3d.nodes.IndexedBufferGeometry;

public class IndexedTriangleArray
extends IndexedBufferGeometry {
    private ByteBuffer edgeBuffer = ByteBuffer.allocate(0);

    public IndexedTriangleArray() {
        this.initPolygonDetails(3);
    }

    public void render(GL gL) {
        if ((this.vertexFormat & 7) == 0 || this.numCoords == 0 || this.numIndices == 0) {
            return;
        }
        this.setVertexState(gL);
        if ((this.vertexFormat & 0x10000) != 0) {
            gL.glEnableClientState(32889);
            gL.glEdgeFlagPointer(0, (Buffer)this.edgeBuffer);
        }
        gL.glDrawElements(4, this.numIndices, 5125, (Buffer)this.indexBuffer);
        if ((this.vertexFormat & 0x10000) != 0) {
            gL.glDisableClientState(32889);
            gL.glEdgeFlag(true);
        }
        this.clearVertexState(gL);
    }

    public boolean pickLineSegment(float[] fArray, float[] fArray2, boolean bl, float[] fArray3, int n) throws NotPickableException {
        super.pickLineSegment(fArray, fArray2, bl, fArray3, n);
        System.out.println("IndexedTriangleArray.pickLineSegment() not implemented yet");
        return false;
    }

    public boolean pickLineRay(float[] fArray, float[] fArray2, boolean bl, float[] fArray3, int n) throws NotPickableException {
        super.pickLineRay(fArray, fArray2, bl, fArray3, n);
        System.out.println("IndexedTriangleArray.pickLineRay() not implemented yet");
        return false;
    }

    public int compareTo(Object object) throws ClassCastException {
        IndexedTriangleArray indexedTriangleArray = (IndexedTriangleArray)object;
        return this.compareTo(indexedTriangleArray);
    }

    public boolean equals(Object object) {
        if (!(object instanceof IndexedTriangleArray)) {
            return false;
        }
        return this.equals((IndexedTriangleArray)object);
    }

    public void setEdgeFlags(ByteBuffer byteBuffer) throws IllegalArgumentException, InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (byteBuffer != null && byteBuffer.limit() < this.numCoords) {
            throw new IllegalArgumentException("Edge flag array too short");
        }
        this.edgeBuffer = byteBuffer;
        this.vertexFormat = byteBuffer == null ? (this.vertexFormat &= 0xFFFEFFFF) : (this.vertexFormat |= 0x10000);
    }

    public int compareTo(IndexedTriangleArray indexedTriangleArray) {
        if (indexedTriangleArray == null) {
            return 1;
        }
        if (indexedTriangleArray == this) {
            return 0;
        }
        return 0;
    }

    public boolean equals(IndexedTriangleArray indexedTriangleArray) {
        return indexedTriangleArray == this;
    }
}

