/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.aviatrix3d.nodes;

import java.nio.Buffer;
import javax.media.opengl.GL;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.renderer.aviatrix3d.nodes.IndexedBufferGeometry;

public class IndexedLineStripArray
extends IndexedBufferGeometry {
    private static final String MIN_COUNT_MSG = "A strip with less than 3 vertices is specified at index ";
    private static final String TOTAL_COUNT_MSG = "The total requested indexes in the strip is greater than the number of valid vertices provided.";
    private int[] stripCounts;
    private int numStrips;

    protected boolean isVisible() {
        return super.isVisible() && this.numStrips != 0;
    }

    public void render(GL gL) {
        if (this.numStrips == 0 || (this.vertexFormat & 7) == 0) {
            return;
        }
        this.setVertexState(gL);
        int n = 0;
        for (int i = 0; i < this.numStrips; ++i) {
            this.indexBuffer.position(n);
            gL.glDrawElements(5, this.stripCounts[i], 5125, (Buffer)this.indexBuffer);
            n += this.stripCounts[i];
        }
        this.clearVertexState(gL);
    }

    public int compareTo(Object object) throws ClassCastException {
        IndexedLineStripArray indexedLineStripArray = (IndexedLineStripArray)object;
        return this.compareTo(indexedLineStripArray);
    }

    public boolean equals(Object object) {
        if (!(object instanceof IndexedLineStripArray)) {
            return false;
        }
        return this.equals((IndexedLineStripArray)object);
    }

    public void setStripCount(int[] nArray, int n) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        for (int i = 0; i < n; ++i) {
            if (nArray[i] >= 2) continue;
            throw new IllegalArgumentException(MIN_COUNT_MSG + i);
        }
        if (this.stripCounts == null || this.stripCounts.length < n) {
            this.stripCounts = new int[n];
        }
        this.numStrips = n;
        if (n > 0) {
            System.arraycopy(nArray, 0, this.stripCounts, 0, n);
        }
    }

    public int getValidStripCount() {
        return this.numStrips;
    }

    public void getStripCount(int[] nArray) {
        System.arraycopy(this.stripCounts, 0, nArray, 0, this.numStrips);
    }

    public int compareTo(IndexedLineStripArray indexedLineStripArray) {
        if (indexedLineStripArray == null) {
            return 1;
        }
        if (indexedLineStripArray == this) {
            return 0;
        }
        return 0;
    }

    public boolean equals(IndexedLineStripArray indexedLineStripArray) {
        return indexedLineStripArray == this;
    }
}

