/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.aviatrix3d.nodes;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import javax.media.opengl.GL;
import org.j3d.aviatrix3d.BoundingBox;
import org.j3d.aviatrix3d.Geometry;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.iutil.ShaderAttribValue;
import org.j3d.aviatrix3d.rendering.GeometryRenderable;
import org.j3d.util.IntHashMap;

public abstract class BufferGeometry
extends Geometry
implements GeometryRenderable {
    private static final String INVALID_ATTRIB_SIZE_MSG = "Invalid attribute size. Must be 0 < size < 4";
    public static final int COORDINATE_2 = 2;
    public static final int COORDINATE_3 = 3;
    public static final int COORDINATE_4 = 4;
    protected static final int COORDINATE_MASK = 7;
    protected static final int COORDINATE_CLEAR = -8;
    protected static final int NORMALS = 8;
    protected static final int NORMAL_CLEAR = -9;
    protected static final int TEXTURE_MASK = 240;
    protected static final int TEXTURE_CLEAR = -241;
    protected static final int TEXTURE_COORDINATE_SINGLE = 16;
    protected static final int TEXTURE_COORDINATE_MULTI = 32;
    protected static final int TEXTURE_SET_AVAILABLE = 256;
    protected static final int TEXTURE_SET_CLEAR = -3841;
    protected static final int COLOR_MASK = 61440;
    protected static final int COLOR_CLEAR = -61441;
    protected static final int COLOR_3 = 4096;
    protected static final int COLOR_4 = 8192;
    protected static final int EDGE_MASK = 65536;
    protected static final int EDGE_CLEAR = -65537;
    protected static final int EDGES = 65536;
    protected static final int COLOR2_MASK = 131072;
    protected static final int COLOR2_CLEAR = -131073;
    protected static final int COLOR2 = 131072;
    protected static final int FOG_MASK = 262144;
    protected static final int FOG_CLEAR = -262145;
    protected static final int FOG = 262144;
    protected static final int ATTRIB_MASK = 524288;
    protected static final int ATTRIB_CLEAR = -524289;
    protected static final int ATTRIBS = 524288;
    public static final int TEXTURE_COORDINATE_1 = 1;
    public static final int TEXTURE_COORDINATE_2 = 2;
    public static final int TEXTURE_COORDINATE_3 = 3;
    public static final int TEXTURE_COORDINATE_4 = 4;
    private float[] working2dCoords;
    protected float[] wkPolygon;
    protected FloatBuffer vertexBuffer = FloatBuffer.allocate(0);
    protected FloatBuffer colorBuffer;
    protected FloatBuffer normalBuffer = FloatBuffer.allocate(0);
    protected FloatBuffer fogBuffer;
    protected FloatBuffer color2Buffer;
    protected FloatBuffer[] textureBuffer;
    protected int numCoords;
    protected int numTextureArrays;
    protected int[] textureSets;
    protected int[] textureTypes;
    protected int numTextureSets;
    protected IntHashMap attributes;
    protected int[] attribIds;
    protected int vertexFormat;

    protected BufferGeometry() {
        this.colorBuffer = FloatBuffer.allocate(0);
        this.fogBuffer = FloatBuffer.allocate(0);
        this.color2Buffer = FloatBuffer.allocate(0);
        this.textureBuffer = new FloatBuffer[1];
        this.bounds = new BoundingBox();
    }

    protected void setLive(boolean bl) {
        boolean bl2 = this.alive;
        super.setLive(bl);
        if (!bl2 && bl) {
            this.recomputeBounds();
        }
    }

    protected boolean isVisible() {
        return this.numCoords != 0;
    }

    public boolean is2D() {
        return (this.vertexFormat & 2) != 0;
    }

    public int getVertexType() {
        return this.vertexFormat & 7;
    }

    public int getValidVertexCount() {
        return this.numCoords;
    }

    public void setValidVertexCount(int n) throws IllegalArgumentException, InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Vertex count is negative");
        }
        this.numCoords = n;
    }

    public void setVertices(int n, FloatBuffer floatBuffer) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        int n2 = floatBuffer == null ? 0 : floatBuffer.limit() / n;
        this.setVertices(n, floatBuffer, n2);
    }

    public void getVertices(FloatBuffer floatBuffer) {
        floatBuffer.put(this.vertexBuffer);
    }

    public void setVertices(int n, FloatBuffer floatBuffer, int n2) throws IllegalArgumentException, InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Vertex count is negative");
        }
        int n3 = n & 7;
        this.numCoords = n2;
        if (n2 == 0) {
            this.vertexFormat &= 0xFFFFFFF8;
            this.vertexBuffer.clear();
            return;
        }
        if (n2 * n3 > floatBuffer.limit()) {
            throw new IllegalArgumentException("Vertex array not long enough (" + floatBuffer.limit() + ") for " + "numValid * vertex_type " + n2 * n3);
        }
        this.vertexBuffer = floatBuffer;
        this.vertexFormat |= n;
    }

    public void setColors(boolean bl, FloatBuffer floatBuffer) throws IllegalArgumentException, InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        int n = 0;
        if (floatBuffer != null) {
            if (bl) {
                if (floatBuffer.limit() / 4 < this.numCoords) {
                    throw new IllegalArgumentException("Color array too short for 4 component colour");
                }
                this.vertexFormat |= 0x2000;
                n = this.numCoords * 4;
            } else {
                if (floatBuffer.limit() / 3 < this.numCoords) {
                    throw new IllegalArgumentException("Color array too short for 3 component colour");
                }
                this.vertexFormat |= 0x1000;
                n = this.numCoords * 3;
            }
        } else {
            this.vertexFormat &= 0xFFFF0FFF;
        }
        this.colorBuffer = floatBuffer;
        this.validAlpha = bl;
    }

    public void getColors(FloatBuffer floatBuffer) {
        if (this.colorBuffer != null) {
            floatBuffer.rewind();
            floatBuffer.put(this.colorBuffer);
        }
    }

    public void setNormals(FloatBuffer floatBuffer) throws IllegalArgumentException, InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (floatBuffer != null && floatBuffer.limit() < this.numCoords * 3) {
            throw new IllegalArgumentException("Normal array too short");
        }
        this.normalBuffer = floatBuffer;
        this.vertexFormat = floatBuffer == null ? (this.vertexFormat &= 0xFFFFFFF7) : (this.vertexFormat |= 8);
    }

    public void getNormals(FloatBuffer floatBuffer) {
        if (this.normalBuffer != null) {
            floatBuffer.rewind();
            floatBuffer.put(this.normalBuffer);
        }
    }

    public void setTextureSetMap(int[] nArray) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.setTextureSetMap(nArray, nArray == null ? 0 : nArray.length);
    }

    public void setTextureSetMap(int[] nArray, int n) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (nArray == null || n == 0) {
            this.vertexFormat &= 0xFFFFF0FF;
            this.numTextureSets = 0;
        } else {
            this.numTextureSets = n;
            this.vertexFormat |= 0x100;
        }
        this.textureSets = nArray;
    }

    public void setTextureCoordinates(int n, int n2, FloatBuffer floatBuffer) throws IllegalArgumentException, InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (n2 < 0 || n2 >= this.numTextureArrays) {
            throw new IllegalArgumentException("Invalid texture set specified: " + n2);
        }
        boolean bl = false;
        if (floatBuffer != null) {
            switch (n) {
                case 1: {
                    if (floatBuffer.limit() >= this.numCoords) break;
                    throw new IllegalArgumentException("texCoord array too short for 1D texture coordiantes");
                }
                case 2: {
                    if (floatBuffer.limit() / 2 >= this.numCoords) break;
                    throw new IllegalArgumentException("texCoord array too short for 2D texture coordiantes");
                }
                case 3: {
                    if (floatBuffer.limit() / 3 >= this.numCoords) break;
                    throw new IllegalArgumentException("texCoord array too short for 3D texture coordiantes");
                }
                case 4: {
                    if (floatBuffer.limit() / 4 >= this.numCoords) break;
                    throw new IllegalArgumentException("texCoord array too short for 4D texture coordiantes");
                }
                default: {
                    throw new IllegalArgumentException("Invalid texture type: " + n);
                }
            }
        }
        this.textureBuffer[n2] = floatBuffer;
    }

    public void setTextureCoordinates(int[] nArray, FloatBuffer[] floatBufferArray) throws IllegalArgumentException, InvalidWriteTimingException {
        this.setTextureCoordinates(nArray, floatBufferArray, floatBufferArray == null ? 0 : floatBufferArray.length);
    }

    public void setTextureCoordinates(int[] nArray, FloatBuffer[] floatBufferArray, int n) throws IllegalArgumentException, InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (floatBufferArray == null || n == 0) {
            this.vertexFormat &= 0xFFFFFF0F;
            this.numTextureArrays = 0;
        } else {
            int n2;
            if (n < 0 || floatBufferArray.length < n) {
                throw new IllegalArgumentException("Invalid set size");
            }
            if (nArray == null || nArray.length < n) {
                throw new IllegalArgumentException("Not enough types specified");
            }
            block6: for (n2 = 0; n2 < n; ++n2) {
                int n3 = 0;
                switch (nArray[n2]) {
                    case 1: {
                        if (floatBufferArray[n2].limit() >= this.numCoords) continue block6;
                        throw new IllegalArgumentException("Texture coordinate set " + n2 + " does not have " + "enough values for a 1D texture. It has " + floatBufferArray[n2].limit() + " but requires " + this.numCoords);
                    }
                    case 2: {
                        n3 = this.numCoords * 2;
                        if (floatBufferArray[n2].limit() >= n3) continue block6;
                        throw new IllegalArgumentException("Texture coordinate set " + n2 + " does not have " + "enough values for a 2D texture. It has " + floatBufferArray[n2].limit() + " but requires " + n3);
                    }
                    case 3: {
                        n3 = this.numCoords * 3;
                        if (floatBufferArray[n2].limit() >= n3) continue block6;
                        throw new IllegalArgumentException("Texture coordinate set " + n2 + " does not have " + "enough values for a 3D texture. It has " + floatBufferArray[n2].limit() + " but requires " + n3);
                    }
                    case 4: {
                        n3 = this.numCoords * 4;
                        if (floatBufferArray[n2].limit() >= n3) continue block6;
                        throw new IllegalArgumentException("Texture coordinate set " + n2 + " does not have " + "enough values for a 4D texture. It has " + floatBufferArray[n2].limit() + " but requires " + n3);
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid texture type");
                    }
                }
            }
            this.numTextureArrays = n;
            if (this.numTextureSets == 0) {
                this.textureSets = new int[n];
                for (n2 = 0; n2 < n; ++n2) {
                    this.textureSets[n2] = n2;
                }
                this.numTextureSets = n;
            }
            this.vertexFormat |= n > 1 ? 16 : 32;
        }
        this.textureBuffer = floatBufferArray;
        this.textureTypes = nArray;
    }

    public void getTextureCoordinates(FloatBuffer[] floatBufferArray) {
        if (this.textureBuffer == null) {
            return;
        }
        for (int i = 0; i < this.numTextureSets; ++i) {
            floatBufferArray[i].put(this.textureBuffer[i]);
        }
    }

    public void setFogCoordinates(FloatBuffer floatBuffer) throws IllegalArgumentException, InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (floatBuffer != null && floatBuffer.limit() < this.numCoords) {
            throw new IllegalArgumentException("Fog coord array too short");
        }
        this.fogBuffer = floatBuffer;
        this.vertexFormat = this.fogBuffer == null ? (this.vertexFormat &= 0xFFFBFFFF) : (this.vertexFormat |= 0x40000);
    }

    public void getFogCoordinates(FloatBuffer floatBuffer) {
        if (this.fogBuffer != null) {
            floatBuffer.put(this.fogBuffer);
        }
    }

    public void setSecondaryColors(FloatBuffer floatBuffer) throws IllegalArgumentException, InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (floatBuffer != null && floatBuffer.limit() < this.numCoords * 3) {
            throw new IllegalArgumentException("Secondary color array too short");
        }
        this.color2Buffer = floatBuffer;
        this.vertexFormat = floatBuffer == null ? (this.vertexFormat &= 0xFFFDFFFF) : (this.vertexFormat |= 0x20000);
    }

    public void getSecondaryColors(FloatBuffer floatBuffer) {
        if (this.color2Buffer != null) {
            floatBuffer.put(this.color2Buffer);
        }
    }

    public void setAttributes(int n, int n2, FloatBuffer floatBuffer, boolean bl) throws IllegalArgumentException, InvalidWriteTimingException {
        ShaderAttribValue shaderAttribValue;
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (n2 == -1) {
            if (this.attributes == null) {
                return;
            }
            this.attributes.remove(n);
            if (this.attributes.size() == 0) {
                this.vertexFormat &= 0xFFF7FFFF;
            }
            return;
        }
        if (floatBuffer != null && floatBuffer.limit() < this.numCoords * n2) {
            throw new IllegalArgumentException("Attrib array too short");
        }
        if (n2 < 1 || n2 > 4) {
            throw new IllegalArgumentException(INVALID_ATTRIB_SIZE_MSG);
        }
        if (this.attributes == null) {
            this.attributes = new IntHashMap();
        }
        if ((shaderAttribValue = (ShaderAttribValue)this.attributes.get(n)) == null) {
            shaderAttribValue = new ShaderAttribValue();
            this.attributes.put(n, (Object)shaderAttribValue);
        }
        shaderAttribValue.size = n2;
        shaderAttribValue.normalise = bl;
        shaderAttribValue.dataType = 5126;
        shaderAttribValue.data = floatBuffer;
        this.vertexFormat |= 0x80000;
    }

    public void setAttributes(int n, int n2, DoubleBuffer doubleBuffer, boolean bl) throws IllegalArgumentException, InvalidWriteTimingException {
        ShaderAttribValue shaderAttribValue;
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (n2 == -1) {
            if (this.attributes == null) {
                return;
            }
            this.attributes.remove(n);
            if (this.attributes.size() == 0) {
                this.vertexFormat &= 0xFFF7FFFF;
            }
            return;
        }
        if (doubleBuffer != null && doubleBuffer.limit() < this.numCoords * n2) {
            throw new IllegalArgumentException("Attrib array too short");
        }
        if (n2 < 1 || n2 > 4) {
            throw new IllegalArgumentException(INVALID_ATTRIB_SIZE_MSG);
        }
        if (this.attributes == null) {
            this.attributes = new IntHashMap();
        }
        if ((shaderAttribValue = (ShaderAttribValue)this.attributes.get(n)) == null) {
            shaderAttribValue = new ShaderAttribValue();
            this.attributes.put(n, (Object)shaderAttribValue);
        }
        shaderAttribValue.size = n2;
        shaderAttribValue.normalise = bl;
        shaderAttribValue.dataType = 5130;
        shaderAttribValue.data = doubleBuffer;
        this.vertexFormat |= 0x80000;
    }

    public void setAttributes(int n, int n2, IntBuffer intBuffer, boolean bl, boolean bl2) throws IllegalArgumentException, InvalidWriteTimingException {
        ShaderAttribValue shaderAttribValue;
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (n2 == -1) {
            if (this.attributes == null) {
                return;
            }
            this.attributes.remove(n);
            if (this.attributes.size() == 0) {
                this.vertexFormat &= 0xFFF7FFFF;
            }
            return;
        }
        if (intBuffer != null && intBuffer.limit() < this.numCoords * n2) {
            throw new IllegalArgumentException("Attrib array too short");
        }
        if (n2 < 1 || n2 > 4) {
            throw new IllegalArgumentException(INVALID_ATTRIB_SIZE_MSG);
        }
        if (this.attributes == null) {
            this.attributes = new IntHashMap();
        }
        if ((shaderAttribValue = (ShaderAttribValue)this.attributes.get(n)) == null) {
            shaderAttribValue = new ShaderAttribValue();
            this.attributes.put(n, (Object)shaderAttribValue);
        }
        shaderAttribValue.size = n2;
        shaderAttribValue.normalise = bl;
        shaderAttribValue.dataType = bl2 ? 5124 : 5125;
        shaderAttribValue.data = intBuffer;
        this.vertexFormat |= 0x80000;
    }

    public void setAttributes(int n, int n2, ShortBuffer shortBuffer, boolean bl, boolean bl2) throws IllegalArgumentException, InvalidWriteTimingException {
        ShaderAttribValue shaderAttribValue;
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (n2 == -1) {
            if (this.attributes == null) {
                return;
            }
            this.attributes.remove(n);
            if (this.attributes.size() == 0) {
                this.vertexFormat &= 0xFFF7FFFF;
            }
            return;
        }
        if (shortBuffer != null && shortBuffer.limit() < this.numCoords * n2) {
            throw new IllegalArgumentException("Attrib array too short");
        }
        if (n2 < 1 || n2 > 4) {
            throw new IllegalArgumentException(INVALID_ATTRIB_SIZE_MSG);
        }
        if (this.attributes == null) {
            this.attributes = new IntHashMap();
        }
        if ((shaderAttribValue = (ShaderAttribValue)this.attributes.get(n)) == null) {
            shaderAttribValue = new ShaderAttribValue();
            this.attributes.put(n, (Object)shaderAttribValue);
        }
        shaderAttribValue.size = n2;
        shaderAttribValue.normalise = bl;
        shaderAttribValue.dataType = bl2 ? 5122 : 5123;
        shaderAttribValue.data = shortBuffer;
        this.vertexFormat |= 0x80000;
    }

    public void setAttributes(int n, int n2, ByteBuffer byteBuffer, boolean bl, boolean bl2) throws IllegalArgumentException, InvalidWriteTimingException {
        ShaderAttribValue shaderAttribValue;
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (n2 == -1) {
            if (this.attributes == null) {
                return;
            }
            this.attributes.remove(n);
            if (this.attributes.size() == 0) {
                this.vertexFormat &= 0xFFF7FFFF;
            }
            return;
        }
        if (byteBuffer != null && byteBuffer.limit() < this.numCoords * n2) {
            throw new IllegalArgumentException("Attrib array too short");
        }
        if (n2 < 1 || n2 > 4) {
            throw new IllegalArgumentException(INVALID_ATTRIB_SIZE_MSG);
        }
        if (this.attributes == null) {
            this.attributes = new IntHashMap();
        }
        if ((shaderAttribValue = (ShaderAttribValue)this.attributes.get(n)) == null) {
            shaderAttribValue = new ShaderAttribValue();
            this.attributes.put(n, (Object)shaderAttribValue);
        }
        shaderAttribValue.size = n2;
        shaderAttribValue.normalise = bl;
        shaderAttribValue.dataType = bl2 ? 5120 : 5121;
        shaderAttribValue.data = byteBuffer;
        this.vertexFormat |= 0x80000;
    }

    protected void setVertexState(GL gL) {
        int n;
        int n2;
        int n3 = this.vertexFormat & 7;
        gL.glEnableClientState(32884);
        gL.glVertexPointer(n3, 5126, 0, (Buffer)this.vertexBuffer);
        if ((this.vertexFormat & 8) != 0) {
            gL.glEnableClientState(32885);
            gL.glNormalPointer(5126, 0, (Buffer)this.normalBuffer);
        }
        if ((this.vertexFormat & 0xF0) != 0) {
            if (this.numTextureSets == 1) {
                gL.glEnableClientState(32888);
                gL.glTexCoordPointer(this.textureTypes[0], 5126, 0, (Buffer)this.textureBuffer[0]);
            } else {
                for (n2 = 0; n2 < this.numTextureSets; ++n2) {
                    n = this.textureSets[n2];
                    gL.glClientActiveTexture(33984 + n2);
                    gL.glEnableClientState(32888);
                    gL.glTexCoordPointer(this.textureTypes[n], 5126, 0, (Buffer)this.textureBuffer[n]);
                }
            }
        }
        if ((this.vertexFormat & 0xF000) != 0) {
            gL.glEnableClientState(32886);
            n2 = (this.vertexFormat & 0x1000) != 0 ? 3 : 4;
            gL.glColorPointer(n2, 5126, 0, (Buffer)this.colorBuffer);
        }
        if ((this.vertexFormat & 0x20000) != 0) {
            gL.glEnableClientState(33886);
            gL.glSecondaryColorPointer(3, 5126, 0, (Buffer)this.color2Buffer);
        }
        if ((this.vertexFormat & 0x40000) != 0) {
            gL.glFogi(33872, 33873);
            gL.glEnableClientState(33879);
            gL.glFogCoordPointer(5126, 0, (Buffer)this.fogBuffer);
        }
        if ((this.vertexFormat & 0x80000) != 0) {
            n2 = this.attributes.size();
            this.attribIds = this.attributes.keySet(this.attribIds);
            for (n = 0; n < n2; ++n) {
                int n4 = this.attribIds[n];
                ShaderAttribValue shaderAttribValue = (ShaderAttribValue)this.attributes.get(n4);
                gL.glEnableVertexAttribArrayARB(n4);
                gL.glVertexAttribPointerARB(n4, shaderAttribValue.size, shaderAttribValue.dataType, shaderAttribValue.normalise, 0, shaderAttribValue.data);
            }
        }
    }

    protected void clearVertexState(GL gL) {
        int n;
        if ((this.vertexFormat & 0x80000) != 0) {
            n = this.attributes.size();
            for (int i = 0; i < n; ++i) {
                gL.glDisableVertexAttribArrayARB(this.attribIds[i]);
            }
        }
        if ((this.vertexFormat & 0x40000) != 0) {
            gL.glDisableClientState(33879);
            gL.glFogi(33872, 33874);
        }
        if ((this.vertexFormat & 0x20000) != 0) {
            gL.glDisableClientState(33886);
            gL.glSecondaryColor3f(1.0f, 1.0f, 1.0f);
        }
        if ((this.vertexFormat & 0xF000) != 0) {
            gL.glDisableClientState(32886);
            gL.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        }
        if ((this.vertexFormat & 0xF0) != 0) {
            if (this.numTextureSets == 1) {
                gL.glDisableClientState(32888);
            } else {
                for (n = this.numTextureSets - 1; n >= 0; --n) {
                    gL.glClientActiveTexture(33984 + n);
                    gL.glDisableClientState(32888);
                }
            }
        }
        if ((this.vertexFormat & 8) != 0) {
            gL.glDisableClientState(32885);
        }
        gL.glDisableClientState(32884);
    }

    protected void updateBounds() {
        if (this.numCoords != 0) {
            super.updateBounds();
        }
    }

    protected void recomputeBounds() {
        if (this.numCoords == 0) {
            return;
        }
        this.vertexBuffer.rewind();
        float f = this.vertexBuffer.get();
        float f2 = this.vertexBuffer.get();
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = f;
        float f6 = f2;
        float f7 = 0.0f;
        float f8 = 0.0f;
        switch (this.vertexFormat & 7) {
            case 2: {
                int n;
                for (n = 1; n < this.numCoords; ++n) {
                    float f9 = this.vertexBuffer.get();
                    float f10 = this.vertexBuffer.get();
                    if (f9 < f) {
                        f = f10;
                    } else if (f9 > f5) {
                        f5 = f9;
                    }
                    if (f10 < f2) {
                        f2 = f10;
                        continue;
                    }
                    if (!(f10 > f6)) continue;
                    f6 = f10;
                }
                break;
            }
            case 3: {
                int n;
                f7 = f3 = this.vertexBuffer.get();
                for (n = 1; n < this.numCoords; ++n) {
                    float f11 = this.vertexBuffer.get();
                    float f12 = this.vertexBuffer.get();
                    float f13 = this.vertexBuffer.get();
                    if (f11 < f) {
                        f = f12;
                    } else if (f11 > f5) {
                        f5 = f11;
                    }
                    if (f12 < f2) {
                        f2 = f12;
                    } else if (f12 > f6) {
                        f6 = f12;
                    }
                    if (f13 < f3) {
                        f3 = f13;
                        continue;
                    }
                    if (!(f13 > f7)) continue;
                    f7 = f13;
                }
                break;
            }
            case 4: {
                int n;
                f7 = f3 = this.vertexBuffer.get();
                f8 = f4 = this.vertexBuffer.get();
                int n2 = 4;
                for (n = 1; n < this.numCoords; ++n) {
                    float f14 = this.vertexBuffer.get();
                    float f15 = this.vertexBuffer.get();
                    float f16 = this.vertexBuffer.get();
                    if (f14 < f) {
                        f = f15;
                    } else if (f14 > f5) {
                        f5 = f14;
                    }
                    if (f15 < f2) {
                        f2 = f15;
                    } else if (f15 > f6) {
                        f6 = f15;
                    }
                    if (f16 < f3) {
                        f3 = f16;
                    } else if (f16 > f7) {
                        f7 = f16;
                    }
                    this.vertexBuffer.get();
                }
                break;
            }
        }
        BoundingBox boundingBox = (BoundingBox)this.bounds;
        boundingBox.setMinimum(f, f2, f3);
        boundingBox.setMaximum(f5, f6, f7);
        this.vertexBuffer.rewind();
    }

    protected void initPolygonDetails(int n) {
        if (this.working2dCoords == null) {
            this.working2dCoords = new float[n * 2];
            this.wkPolygon = new float[n * 3];
        }
    }

    protected boolean ray3DTriangleChecked(float[] fArray, float[] fArray2, float f, float[] fArray3) {
        int n;
        float f2;
        float f3;
        float f4;
        float f5 = this.wkPolygon[4] - this.wkPolygon[1];
        float f6 = this.wkPolygon[8] - this.wkPolygon[5];
        float f7 = this.wkPolygon[5] - this.wkPolygon[2];
        float f8 = this.wkPolygon[7] - this.wkPolygon[4];
        float f9 = f5 * f6 - f7 * f8;
        float f10 = this.wkPolygon[6] - this.wkPolygon[3];
        float f11 = this.wkPolygon[3] - this.wkPolygon[0];
        float f12 = f7 * f10 - f11 * f6;
        float f13 = f11 * f8 - f5 * f10;
        if (f9 * f9 + f12 * f12 + f13 * f13 == 0.0f) {
            return false;
        }
        float f14 = f9 * fArray2[0] + f12 * fArray2[1] + f13 * fArray2[2];
        if (f14 == 0.0f) {
            return false;
        }
        float f15 = f9 * this.wkPolygon[0] + f12 * this.wkPolygon[1] + f13 * this.wkPolygon[2];
        float f16 = f9 * fArray[0] + f12 * fArray[1] + f13 * fArray[2];
        float f17 = (f15 - f16) / f14;
        if (f17 < 0.0f) {
            return false;
        }
        fArray3[0] = fArray[0] + fArray2[0] * f17;
        fArray3[1] = fArray[1] + fArray2[1] * f17;
        fArray3[2] = fArray[2] + fArray2[2] * f17;
        if (f != 0.0f && (f4 = fArray[0] - fArray3[0]) * f4 + (f3 = fArray[1] - fArray3[1]) * f3 + (f2 = fArray[2] - fArray3[2]) * f2 > f * f) {
            return false;
        }
        f4 = f9 >= 0.0f ? f9 : -f9;
        f3 = f12 >= 0.0f ? f12 : -f12;
        f2 = f13 >= 0.0f ? f13 : -f13;
        int n2 = f4 > f3 ? 0 : 1;
        if (n2 == 0) {
            if (f4 < f2) {
                n2 = 2;
            }
        } else if (f3 < f2) {
            n2 = 2;
        }
        int n3 = 5;
        switch (n2) {
            case 0: {
                n = 3;
                while (--n >= 0) {
                    this.working2dCoords[n3--] = this.wkPolygon[n * 3 + 2] - fArray3[2];
                    this.working2dCoords[n3--] = this.wkPolygon[n * 3 + 1] - fArray3[1];
                }
                break;
            }
            case 1: {
                n = 3;
                while (--n >= 0) {
                    this.working2dCoords[n3--] = this.wkPolygon[n * 3 + 2] - fArray3[2];
                    this.working2dCoords[n3--] = this.wkPolygon[n * 3] - fArray3[0];
                }
                break;
            }
            case 2: {
                n = 3;
                while (--n >= 0) {
                    this.working2dCoords[n3--] = this.wkPolygon[n * 3 + 1] - fArray3[1];
                    this.working2dCoords[n3--] = this.wkPolygon[n * 3] - fArray3[0];
                }
                break;
            }
        }
        int n4 = 0;
        int n5 = (double)this.working2dCoords[1] < 0.0 ? -1 : 1;
        for (n = 0; n < 3; ++n) {
            float f18;
            n3 = (n + 1) % 3;
            int n6 = n * 2;
            int n7 = n3 * 2;
            int n8 = n * 2 + 1;
            int n9 = n3 * 2 + 1;
            int n10 = (double)this.working2dCoords[n9] < 0.0 ? -1 : 1;
            if (n5 == n10) continue;
            if ((double)this.working2dCoords[n6] > 0.0 && (double)this.working2dCoords[n7] > 0.0) {
                ++n4;
            } else if (((double)this.working2dCoords[n6] > 0.0 || (double)this.working2dCoords[n7] > 0.0) && (f18 = this.working2dCoords[n6] - this.working2dCoords[n8] * (this.working2dCoords[n7] - this.working2dCoords[n6]) / (this.working2dCoords[n9] - this.working2dCoords[n8])) > 0.0f) {
                ++n4;
            }
            n5 = n10;
        }
        return n4 % 2 == 1;
    }

    protected boolean ray3DQuadChecked(float[] fArray, float[] fArray2, float f, float[] fArray3) {
        int n;
        float f2;
        float f3;
        float f4;
        float f5 = this.wkPolygon[4] - this.wkPolygon[1];
        float f6 = this.wkPolygon[8] - this.wkPolygon[5];
        float f7 = this.wkPolygon[5] - this.wkPolygon[2];
        float f8 = this.wkPolygon[7] - this.wkPolygon[4];
        float f9 = f5 * f6 - f7 * f8;
        float f10 = this.wkPolygon[6] - this.wkPolygon[3];
        float f11 = this.wkPolygon[3] - this.wkPolygon[0];
        float f12 = f7 * f10 - f11 * f6;
        float f13 = f11 * f8 - f5 * f10;
        if (f9 * f9 + f12 * f12 + f13 * f13 == 0.0f) {
            return false;
        }
        float f14 = f9 * fArray2[0] + f12 * fArray2[1] + f13 * fArray2[2];
        if (f14 == 0.0f) {
            return false;
        }
        float f15 = f9 * this.wkPolygon[0] + f12 * this.wkPolygon[1] + f13 * this.wkPolygon[2];
        float f16 = f9 * fArray[0] + f12 * fArray[1] + f13 * fArray[2];
        float f17 = (f15 - f16) / f14;
        if (f17 < 0.0f) {
            return false;
        }
        fArray3[0] = fArray[0] + fArray2[0] * f17;
        fArray3[1] = fArray[1] + fArray2[1] * f17;
        fArray3[2] = fArray[2] + fArray2[2] * f17;
        if (f != 0.0f && (f4 = fArray[0] - fArray3[0]) * f4 + (f3 = fArray[1] - fArray3[1]) * f3 + (f2 = fArray[2] - fArray3[2]) * f2 > f * f) {
            return false;
        }
        f4 = f9 >= 0.0f ? f9 : -f9;
        f3 = f12 >= 0.0f ? f12 : -f12;
        f2 = f13 >= 0.0f ? f13 : -f13;
        int n2 = f4 > f3 ? 0 : 1;
        if (n2 == 0) {
            if (f4 < f2) {
                n2 = 2;
            }
        } else if (f3 < f2) {
            n2 = 2;
        }
        int n3 = 7;
        switch (n2) {
            case 0: {
                n = 4;
                while (--n >= 0) {
                    this.working2dCoords[n3--] = this.wkPolygon[n * 3 + 2] - fArray3[2];
                    this.working2dCoords[n3--] = this.wkPolygon[n * 3 + 1] - fArray3[1];
                }
                break;
            }
            case 1: {
                n = 4;
                while (--n >= 0) {
                    this.working2dCoords[n3--] = this.wkPolygon[n * 3 + 2] - fArray3[2];
                    this.working2dCoords[n3--] = this.wkPolygon[n * 3] - fArray3[0];
                }
                break;
            }
            case 2: {
                n = 4;
                while (--n >= 0) {
                    this.working2dCoords[n3--] = this.wkPolygon[n * 3 + 1] - fArray3[1];
                    this.working2dCoords[n3--] = this.wkPolygon[n * 3] - fArray3[0];
                }
                break;
            }
        }
        int n4 = 0;
        int n5 = (double)this.working2dCoords[1] < 0.0 ? -1 : 1;
        for (n = 0; n < 4; ++n) {
            float f18;
            n3 = (n + 1) % 4;
            int n6 = n * 2;
            int n7 = n3 * 2;
            int n8 = n * 2 + 1;
            int n9 = n3 * 2 + 1;
            int n10 = (double)this.working2dCoords[n9] < 0.0 ? -1 : 1;
            if (n5 == n10) continue;
            if ((double)this.working2dCoords[n6] > 0.0 && (double)this.working2dCoords[n7] > 0.0) {
                ++n4;
            } else if (((double)this.working2dCoords[n6] > 0.0 || (double)this.working2dCoords[n7] > 0.0) && (f18 = this.working2dCoords[n6] - this.working2dCoords[n8] * (this.working2dCoords[n7] - this.working2dCoords[n6]) / (this.working2dCoords[n9] - this.working2dCoords[n8])) > 0.0f) {
                ++n4;
            }
            n5 = n10;
        }
        return n4 % 2 == 1;
    }
}

