/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.aviatrix3d.nodes;

import javax.vecmath.Matrix4f;
import javax.vecmath.Vector4f;
import org.j3d.aviatrix3d.BaseGroup;
import org.j3d.aviatrix3d.BoundingBox;
import org.j3d.aviatrix3d.BoundingVoid;
import org.j3d.aviatrix3d.picking.CustomPickTarget;
import org.j3d.aviatrix3d.picking.InvalidPickTimingException;
import org.j3d.aviatrix3d.picking.NotPickableException;
import org.j3d.aviatrix3d.picking.PickInstructions;
import org.j3d.aviatrix3d.picking.PickRequest;
import org.j3d.aviatrix3d.picking.PickTarget;
import org.j3d.aviatrix3d.picking.PickableObject;
import org.j3d.aviatrix3d.picking.PickingManager;
import org.j3d.aviatrix3d.rendering.BoundingVolume;
import org.j3d.aviatrix3d.rendering.CullInstructions;
import org.j3d.aviatrix3d.rendering.Cullable;
import org.j3d.aviatrix3d.rendering.CustomCullable;

public class Billboard
extends BaseGroup
implements CustomCullable,
CustomPickTarget,
PickableObject {
    private static final String PICK_TIMING_MSG = "Picking not permitted right now. Picking is only permitted during the update observer callbacks.";
    private static final String PICKABLE_FALSE_MSG = "This node has been marked as not pickable by the user";
    private static final BoundingVoid INVALID_BOUNDS = new BoundingVoid();
    private final boolean pointMode;
    private int pickFlags;
    private float[] wkVec1;
    private float[] wkVec2;

    public Billboard() {
        this(true);
    }

    public Billboard(boolean bl) {
        this.pointMode = bl;
        this.pickFlags = -1;
        this.bounds = null;
        this.wkVec1 = new float[3];
        this.wkVec2 = new float[3];
    }

    public void cullChildren(CullInstructions cullInstructions, Matrix4f matrix4f, Matrix4f matrix4f2, Vector4f[] vector4fArray, float f) {
        if (0 == this.bounds.checkIntersectionFrustum(vector4fArray, matrix4f)) {
            cullInstructions.hasTransform = false;
            cullInstructions.numChildren = 0;
            return;
        }
        double d = matrix4f2.m03 - matrix4f.m03;
        double d2 = matrix4f2.m13 - matrix4f.m13;
        double d3 = matrix4f2.m23 - matrix4f.m23;
        double d4 = Math.sqrt(d * d + d2 * d2 + d3 * d3);
        d /= d4;
        d2 /= d4;
        d3 /= d4;
        double d5 = matrix4f.m01;
        double d6 = matrix4f.m11;
        double d7 = matrix4f.m21;
        d4 = Math.sqrt(d5 * d5 + d6 * d6 + d7 * d7);
        double d8 = d * (d5 /= d4) + d2 * (d6 /= d4) + d3 * (d7 /= d4);
        double d9 = 1.0 - d8 * d8;
        double d10 = 0.0;
        double d11 = 1.0;
        if (d9 < 1.0E-5) {
            d9 = 0.0;
            d8 = 1.0;
        } else {
            d9 = Math.sqrt(d9);
            double d12 = matrix4f.m02;
            double d13 = matrix4f.m12;
            double d14 = matrix4f.m22;
            d11 = (d -= d5 * d8) * d12 + (d2 -= d6 * d8) * d13 + (d3 -= d7 * d8) * d14;
            d11 /= d9 * Math.sqrt(d12 * d12 + d13 * d13 + d14 * d14);
            double d15 = matrix4f.m00;
            double d16 = matrix4f.m10;
            double d17 = matrix4f.m20;
            d10 = d * d15 + d2 * d16 + d3 * d17;
            d10 /= d9 * Math.sqrt(d15 * d15 + d16 * d16 + d17 * d17);
        }
        if (this.pointMode) {
            cullInstructions.localTransform.m00 = (float)d11;
            cullInstructions.localTransform.m01 = -((float)(d10 * d8));
            cullInstructions.localTransform.m02 = (float)(d10 * d9);
            cullInstructions.localTransform.m10 = 0.0f;
            cullInstructions.localTransform.m11 = (float)d9;
            cullInstructions.localTransform.m12 = (float)d8;
            cullInstructions.localTransform.m20 = -((float)d10);
            cullInstructions.localTransform.m21 = -((float)(d11 * d8));
            cullInstructions.localTransform.m22 = (float)(d11 * d9);
            cullInstructions.localTransform.m03 = 0.0f;
            cullInstructions.localTransform.m13 = 0.0f;
            cullInstructions.localTransform.m23 = 0.0f;
            cullInstructions.localTransform.m30 = 0.0f;
            cullInstructions.localTransform.m31 = 0.0f;
            cullInstructions.localTransform.m32 = 0.0f;
            cullInstructions.localTransform.m33 = 1.0f;
        } else {
            cullInstructions.localTransform.m00 = cullInstructions.localTransform.m22 = (float)d11;
            cullInstructions.localTransform.m02 = (float)d10;
            cullInstructions.localTransform.m20 = -((float)d10);
            cullInstructions.localTransform.m33 = 1.0f;
            cullInstructions.localTransform.m11 = 1.0f;
            cullInstructions.localTransform.m10 = 0.0f;
            cullInstructions.localTransform.m01 = 0.0f;
            cullInstructions.localTransform.m30 = 0.0f;
            cullInstructions.localTransform.m03 = 0.0f;
            cullInstructions.localTransform.m21 = 0.0f;
            cullInstructions.localTransform.m12 = 0.0f;
            cullInstructions.localTransform.m31 = 0.0f;
            cullInstructions.localTransform.m13 = 0.0f;
            cullInstructions.localTransform.m32 = 0.0f;
            cullInstructions.localTransform.m23 = 0.0f;
        }
        cullInstructions.hasTransform = true;
        if (cullInstructions.children.length < this.lastChild) {
            cullInstructions.resizeChildren(this.lastChild);
        }
        cullInstructions.numChildren = 0;
        for (int i = 0; i < this.lastChild; ++i) {
            if (!(this.childList[i] instanceof Cullable)) continue;
            cullInstructions.children[cullInstructions.numChildren++] = (Cullable)((Object)this.childList[i]);
        }
    }

    public void pickChildren(PickInstructions pickInstructions, Matrix4f matrix4f, PickRequest pickRequest) {
        this.computeBbTx(pickInstructions.localTransform, matrix4f, pickRequest.origin[0], pickRequest.origin[1], pickRequest.origin[2]);
        pickInstructions.hasTransform = true;
        pickInstructions.resizeChildren(this.lastChild);
        pickInstructions.numChildren = 0;
        for (int i = 0; i < this.lastChild; ++i) {
            if (!(this.childList[i] instanceof PickTarget)) continue;
            pickInstructions.children[pickInstructions.numChildren++] = (PickTarget)((Object)this.childList[i]);
        }
    }

    public boolean checkPickMask(int n) {
        return (this.pickFlags & n) != 0;
    }

    public BoundingVolume getPickableBounds() {
        return this.getBounds();
    }

    public int getPickTargetType() {
        return 4;
    }

    public void setPickMask(int n) {
        this.pickFlags = n;
    }

    public int getPickMask() {
        return this.pickFlags;
    }

    public void pickBatch(PickRequest[] pickRequestArray, int n) throws NotPickableException, InvalidPickTimingException {
        if (this.updateHandler == null || !this.updateHandler.isPickingPermitted()) {
            throw new InvalidPickTimingException(PICK_TIMING_MSG);
        }
        if (this.pickFlags == 0) {
            throw new NotPickableException(PICKABLE_FALSE_MSG);
        }
        PickingManager pickingManager = this.updateHandler.getPickingManager();
        pickingManager.pickBatch(this, pickRequestArray, n);
    }

    public void pickSingle(PickRequest pickRequest) throws NotPickableException, InvalidPickTimingException {
        if (this.updateHandler == null || !this.updateHandler.isPickingPermitted()) {
            throw new InvalidPickTimingException(PICK_TIMING_MSG);
        }
        if (this.pickFlags == 0) {
            throw new NotPickableException(PICKABLE_FALSE_MSG);
        }
        PickingManager pickingManager = this.updateHandler.getPickingManager();
        pickingManager.pickSingle(this, pickRequest);
    }

    protected void recomputeBounds() {
        if (!this.implicitBounds) {
            return;
        }
        super.recomputeBounds();
        if (this.bounds == INVALID_BOUNDS) {
            return;
        }
        this.bounds.getExtents(this.wkVec1, this.wkVec2);
        float f = (this.wkVec1[0] + this.wkVec2[0]) / 2.0f;
        float f2 = (this.wkVec1[1] + this.wkVec2[1]) / 2.0f;
        float f3 = (this.wkVec1[2] + this.wkVec2[2]) / 2.0f;
        float f4 = f - this.wkVec1[0];
        float f5 = f2 - this.wkVec1[1];
        float f6 = f3 - this.wkVec1[2];
        if (this.pointMode) {
            f5 = f6 = (float)Math.sqrt(f4 * f4 + f5 * f5 + f6 * f6);
            f4 = f6;
        } else {
            f4 = f6 = (float)Math.sqrt(f4 * f4 + f6 * f6);
        }
        BoundingBox boundingBox = (BoundingBox)this.bounds;
        boundingBox.setMinimum(f - f4, f2 - f5, f3 - f6);
        boundingBox.setMaximum(f + f4, f2 + f5, f3 + f6);
    }

    public boolean isPointMode() {
        return this.pointMode;
    }

    public void setAxisOfRotation(float[] fArray) {
    }

    public void getAxisOfRotation(float[] fArray) {
    }

    private void computeBbTx(Matrix4f matrix4f, Matrix4f matrix4f2, double d, double d2, double d3) {
        double d4 = d - (double)matrix4f2.m03;
        double d5 = d2 - (double)matrix4f2.m13;
        double d6 = d3 - (double)matrix4f2.m23;
        double d7 = Math.sqrt(d4 * d4 + d5 * d5 + d6 * d6);
        if (d7 != 0.0) {
            d /= d7;
            d2 /= d7;
            d3 /= d7;
        }
        double d8 = matrix4f2.m01;
        double d9 = matrix4f2.m11;
        double d10 = matrix4f2.m21;
        d7 = Math.sqrt(d8 * d8 + d9 * d9 + d10 * d10);
        double d11 = d4 * (d8 /= d7) + d5 * (d9 /= d7) + d6 * (d10 /= d7);
        double d12 = 1.0 - d11 * d11;
        double d13 = 0.0;
        double d14 = 1.0;
        if (d12 < 1.0E-5) {
            d12 = 0.0;
            d11 = 1.0;
        } else {
            d12 = Math.sqrt(d12);
            double d15 = matrix4f2.m02;
            double d16 = matrix4f2.m12;
            double d17 = matrix4f2.m22;
            d14 = (d4 -= d8 * d11) * d15 + (d5 -= d9 * d11) * d16 + (d6 -= d10 * d11) * d17;
            d14 /= d12 * Math.sqrt(d15 * d15 + d16 * d16 + d17 * d17);
            double d18 = matrix4f2.m00;
            double d19 = matrix4f2.m10;
            double d20 = matrix4f2.m20;
            d13 = d4 * d18 + d5 * d19 + d6 * d20;
            d13 /= d12 * Math.sqrt(d18 * d18 + d19 * d19 + d20 * d20);
        }
        if (this.pointMode) {
            matrix4f.m00 = (float)d14;
            matrix4f.m01 = -((float)(d13 * d11));
            matrix4f.m02 = (float)(d13 * d12);
            matrix4f.m10 = 0.0f;
            matrix4f.m11 = (float)d12;
            matrix4f.m12 = (float)d11;
            matrix4f.m20 = -((float)d13);
            matrix4f.m21 = -((float)(d14 * d11));
            matrix4f.m22 = (float)(d14 * d12);
            matrix4f.m03 = 0.0f;
            matrix4f.m13 = 0.0f;
            matrix4f.m23 = 0.0f;
            matrix4f.m30 = 0.0f;
            matrix4f.m31 = 0.0f;
            matrix4f.m32 = 0.0f;
            matrix4f.m33 = 1.0f;
        } else {
            matrix4f.m00 = matrix4f.m22 = (float)d14;
            matrix4f.m02 = (float)d13;
            matrix4f.m20 = -((float)d13);
            matrix4f.m33 = 1.0f;
            matrix4f.m11 = 1.0f;
            matrix4f.m10 = 0.0f;
            matrix4f.m01 = 0.0f;
            matrix4f.m30 = 0.0f;
            matrix4f.m03 = 0.0f;
            matrix4f.m21 = 0.0f;
            matrix4f.m12 = 0.0f;
            matrix4f.m31 = 0.0f;
            matrix4f.m13 = 0.0f;
            matrix4f.m32 = 0.0f;
            matrix4f.m23 = 0.0f;
        }
    }
}

