/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.aviatrix3d.navigation;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.j3d.aviatrix3d.TransformGroup;
import org.j3d.renderer.aviatrix3d.navigation.FrameUpdateListener;
import org.j3d.util.MatrixUtils;

public class ViewpointTransition
implements ActionListener {
    private TransformGroup viewTg;
    private Timer timer;
    private int totalTimeMS;
    private long epochEndTime;
    private float alfa;
    private int timerDelay = 0;
    private MatrixUtils matrixUtils;
    private Point3f eye = new Point3f();
    private Point3f eye1 = new Point3f();
    private Point3f eye2 = new Point3f();
    private Point3f center = new Point3f();
    private Point3f center1 = new Point3f();
    private Point3f center2 = new Point3f();
    private Vector3f up = new Vector3f();
    private Vector3f up1 = new Vector3f();
    private Vector3f up2 = new Vector3f();
    private Vector3f location1 = new Vector3f();
    private Vector3f location2 = new Vector3f();
    private Vector3f direction1 = new Vector3f();
    private Vector3f direction2 = new Vector3f();
    private Matrix4f previousFrameTx = new Matrix4f();
    private Matrix4f currentTx = new Matrix4f();
    private Matrix4f destinationTx = new Matrix4f();
    private FrameUpdateListener updateListener;

    public ViewpointTransition() {
        this.timer = new Timer(100, this);
        this.timer.setInitialDelay(0);
        this.timer.setRepeats(true);
        Timer.setLogTimers(false);
        this.timer.setCoalesce(true);
        this.timer.stop();
        this.matrixUtils = new MatrixUtils();
    }

    public void setFrameUpdateListener(FrameUpdateListener frameUpdateListener) {
        this.updateListener = frameUpdateListener;
    }

    public void transitionTo(TransformGroup transformGroup, Matrix4f matrix4f, int n) {
        this.viewTg = transformGroup;
        this.destinationTx = new Matrix4f(matrix4f);
        this.totalTimeMS = n;
        this.epochEndTime = System.currentTimeMillis() + (long)n;
        this.timer.start();
        transformGroup.getTransform(this.currentTx);
        this.currentTx.get(this.location1);
        this.eye1.set((Tuple3f)this.location1);
        this.direction1.set(0.0f, 0.0f, -1.0f);
        this.currentTx.transform(this.direction1);
        this.center1.add((Tuple3f)this.eye1, (Tuple3f)this.direction1);
        this.up1.set(0.0f, 1.0f, 0.0f);
        this.currentTx.transform(this.up1);
        this.destinationTx.get(this.location2);
        this.eye2.set((Tuple3f)this.location2);
        this.direction2.set(0.0f, 0.0f, -1.0f);
        this.destinationTx.transform(this.direction2);
        this.center2.add((Tuple3f)this.eye2, (Tuple3f)this.direction2);
        this.up2.set(0.0f, 1.0f, 0.0f);
        this.destinationTx.transform(this.up2);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.viewTg.getTransform(this.previousFrameTx);
        if (this.currentTx.equals(this.previousFrameTx)) {
            this.timer.setDelay(33);
            this.alfa = 1.0f - (float)(this.epochEndTime - System.currentTimeMillis()) / (float)this.totalTimeMS;
            if (this.alfa > 1.0f) {
                this.alfa = 1.0f;
            }
            this.eye.interpolate((Tuple3f)this.eye1, (Tuple3f)this.eye2, this.alfa);
            this.center.interpolate((Tuple3f)this.center1, (Tuple3f)this.center2, this.alfa);
            this.up.interpolate((Tuple3f)this.up1, (Tuple3f)this.up2, this.alfa);
            this.matrixUtils.lookAt(this.eye, this.center, this.up, this.currentTx);
            this.currentTx.invert();
            try {
                this.viewTg.setTransform(this.currentTx);
            }
            catch (Exception exception) {
                System.out.println("Transition stopping due to invalid value");
                this.currentTx.set(this.destinationTx);
                this.viewTg.setTransform(this.currentTx);
                this.alfa = 9.0f;
            }
            if (this.updateListener != null) {
                this.updateListener.viewerPositionUpdated(this.currentTx);
            }
        } else {
            this.alfa = 9.0f;
        }
        if (this.alfa >= 1.0f) {
            this.timer.stop();
            if (this.updateListener != null) {
                this.updateListener.transitionEnded(this.currentTx);
            }
        }
    }
}

