/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.aviatrix3d.loader.dem;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import org.j3d.aviatrix3d.Group;
import org.j3d.aviatrix3d.IndexedTriangleStripArray;
import org.j3d.aviatrix3d.Shape3D;
import org.j3d.geom.GeometryData;
import org.j3d.geom.terrain.ElevationGridGenerator;
import org.j3d.loaders.HeightMapSource;
import org.j3d.loaders.dem.DEMParser;
import org.j3d.loaders.dem.DEMTypeARecord;
import org.j3d.loaders.dem.DEMTypeBRecord;
import org.j3d.loaders.dem.DEMTypeCRecord;
import org.j3d.renderer.aviatrix3d.loader.AVLoader;
import org.j3d.renderer.aviatrix3d.loader.AVModel;
import org.j3d.renderer.aviatrix3d.loader.dem.DEMModel;

public class DEMLoader
implements AVLoader,
HeightMapSource {
    private static final int[] TEX_COORD_TYPES = new int[]{2};
    private int loadFlags = -1;
    private boolean keepModel = false;
    private DEMParser parser;
    private ElevationGridGenerator generator;

    public AVModel load(URL uRL) throws IOException {
        BufferedInputStream bufferedInputStream = null;
        try {
            URLConnection uRLConnection = uRL.openConnection();
            InputStream inputStream = uRLConnection.getInputStream();
            bufferedInputStream = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
        }
        catch (IOException iOException) {
            throw new FileNotFoundException(iOException.getMessage());
        }
        return this.loadInternal(bufferedInputStream);
    }

    public AVModel load(InputStream inputStream) throws IOException {
        return this.loadInternal(inputStream);
    }

    public AVModel load(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        return this.loadInternal(bufferedInputStream);
    }

    public void setLoadFlags(int n) {
        this.loadFlags = n;
    }

    public int getLoadFlags() {
        return this.loadFlags;
    }

    public void keepInternalModel(boolean bl) {
        this.keepModel = bl;
    }

    public boolean isInternalModelKept() {
        return this.keepModel;
    }

    public float[][] getHeights() {
        if (this.keepModel) {
            return this.parser.getHeights();
        }
        return null;
    }

    public float[] getGridStep() {
        if (this.keepModel) {
            return this.parser.getGridStep();
        }
        return null;
    }

    public DEMTypeARecord getTypeARecord() {
        if (this.keepModel) {
            return this.parser.getTypeARecord();
        }
        return null;
    }

    public DEMTypeBRecord[] getTypeBRecords() {
        if (this.keepModel) {
            return this.parser.getTypeBRecords();
        }
        return null;
    }

    public DEMTypeCRecord getTypeCRecord() {
        if (this.keepModel) {
            return this.parser.getTypeCRecord();
        }
        return null;
    }

    private AVModel loadInternal(InputStream inputStream) throws IOException {
        if (this.parser == null) {
            this.parser = new DEMParser(inputStream);
        } else {
            this.parser.reset(inputStream);
        }
        return this.load();
    }

    private AVModel loadInternal(Reader reader) throws IOException {
        if (this.parser == null) {
            this.parser = new DEMParser(reader);
        } else {
            this.parser.reset(reader);
        }
        return this.load();
    }

    private AVModel load() throws IOException {
        float[][] fArray = this.parser.parse(true);
        DEMTypeARecord dEMTypeARecord = this.parser.getTypeARecord();
        float f = (float)fArray[0].length * dEMTypeARecord.spatialResolution[0];
        float f2 = (float)fArray.length * dEMTypeARecord.spatialResolution[1];
        if (this.generator == null) {
            this.generator = new ElevationGridGenerator(f, f2, fArray[0].length, fArray.length, fArray, 0.0f);
        } else {
            this.generator.setDimensions(f, f2, fArray[0].length, fArray.length);
            this.generator.setTerrainDetail(fArray, 0.0f);
        }
        GeometryData geometryData = new GeometryData();
        geometryData.geometryType = 7;
        geometryData.geometryComponents = 6;
        this.generator.generate(geometryData);
        if (!this.keepModel) {
            this.parser.clear();
            this.generator = null;
        }
        Group group = new Group();
        DEMModel dEMModel = new DEMModel(group, dEMTypeARecord);
        IndexedTriangleStripArray indexedTriangleStripArray = new IndexedTriangleStripArray();
        indexedTriangleStripArray.setVertices(3, geometryData.coordinates, geometryData.vertexCount);
        indexedTriangleStripArray.setIndices(geometryData.indexes, geometryData.indexesCount);
        indexedTriangleStripArray.setStripCount(geometryData.stripCounts, geometryData.stripCounts.length);
        indexedTriangleStripArray.setNormals(geometryData.normals);
        float[][] fArrayArray = new float[][]{geometryData.textureCoordinates};
        indexedTriangleStripArray.setTextureCoordinates(TEX_COORD_TYPES, fArrayArray, 1);
        Shape3D shape3D = new Shape3D();
        shape3D.setGeometry(indexedTriangleStripArray);
        group.addChild(shape3D);
        return dEMModel;
    }
}

