/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.aviatrix3d.geom.volume;

import javax.vecmath.Matrix4f;
import javax.vecmath.Vector4f;
import org.j3d.aviatrix3d.BaseNode;
import org.j3d.aviatrix3d.CyclicSceneGraphStructureException;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.Node;
import org.j3d.aviatrix3d.NodeUpdateHandler;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.j3d.aviatrix3d.TransformHierarchy;
import org.j3d.aviatrix3d.rendering.CullInstructions;
import org.j3d.aviatrix3d.rendering.Cullable;
import org.j3d.aviatrix3d.rendering.CustomCullable;

public class OctTree
extends BaseNode
implements CustomCullable,
TransformHierarchy {
    private static final String HIGH_DETAIL_NUM_ERR = "numValid is out of range. It should be [0,8]";
    private static final String NEG_RANGE_MSG = "The range value provided was negative. It should be >= 0";
    private float range;
    private Node lowDetailGeom;
    private Node[] highDetailGeom = new Node[8];
    private Cullable lowDetailOutput;
    private Cullable[] highDetailOutput = new Cullable[8];
    private int numHighDetailGeom;

    public void cullChildren(CullInstructions cullInstructions, Matrix4f matrix4f, Matrix4f matrix4f2, Vector4f[] vector4fArray, float f) {
        float f2 = matrix4f.m03 - matrix4f2.m03;
        float f3 = matrix4f.m13 - matrix4f2.m13;
        float f4 = matrix4f.m23 - matrix4f2.m23;
        cullInstructions.hasTransform = false;
        if (f2 * f2 + f3 * f3 + f4 * f4 < this.range) {
            cullInstructions.numChildren = this.numHighDetailGeom;
            if (cullInstructions.children.length < 8) {
                cullInstructions.resizeChildren(8);
            }
            System.arraycopy(this.highDetailOutput, 0, cullInstructions.children, 0, this.numHighDetailGeom);
        } else if (this.lowDetailGeom != null) {
            cullInstructions.numChildren = 1;
            cullInstructions.children[0] = this.lowDetailOutput;
        } else {
            cullInstructions.numChildren = 0;
        }
    }

    protected void recomputeBounds() {
        if (!this.implicitBounds) {
            return;
        }
        if (this.lowDetailGeom == null) {
            this.bounds = INVALID_BOUNDS;
            return;
        }
        this.bounds = this.lowDetailGeom.getBounds();
    }

    public void requestBoundsUpdate() {
        if (this.alive || this.lowDetailGeom == null || !this.implicitBounds) {
            return;
        }
        this.lowDetailGeom.requestBoundsUpdate();
        for (int i = 0; i < 8; ++i) {
            this.highDetailGeom[i].requestBoundsUpdate();
        }
        this.recomputeBounds();
    }

    protected void checkForCyclicChild(SceneGraphObject sceneGraphObject) throws CyclicSceneGraphStructureException {
        if (sceneGraphObject == this) {
            throw new CyclicSceneGraphStructureException();
        }
        if (this.lowDetailGeom != null) {
            this.checkForCyclicChild(this.lowDetailGeom, sceneGraphObject);
        }
        for (int i = 0; i < 8; ++i) {
            if (this.highDetailGeom[i] == null) continue;
            this.checkForCyclicChild(this.highDetailGeom[i], sceneGraphObject);
        }
    }

    protected void setUpdateHandler(NodeUpdateHandler nodeUpdateHandler) {
        super.setUpdateHandler(nodeUpdateHandler);
        if (this.lowDetailGeom != null) {
            this.setUpdateHandler(this.lowDetailGeom);
        }
        for (int i = 0; i < 8; ++i) {
            if (this.highDetailGeom[i] == null) continue;
            this.setUpdateHandler(this.highDetailGeom[i]);
        }
    }

    protected void setLive(boolean bl) {
        if (this.lowDetailGeom != null) {
            this.setLive(this.lowDetailGeom, bl);
        }
        for (int i = 0; i < 8; ++i) {
            if (this.highDetailGeom[i] == null) continue;
            this.setLive(this.highDetailGeom[i], bl);
        }
        super.setLive(bl);
    }

    public void setRange(float f) throws IllegalArgumentException, InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (f < 0.0f) {
            throw new IllegalArgumentException(NEG_RANGE_MSG);
        }
        this.range = f * f;
    }

    public float getRange() {
        return (float)Math.sqrt(this.range);
    }

    public void setLowDetail(Node node) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (this.lowDetailGeom != null) {
            this.setParent(this.lowDetailGeom, null);
            this.setLive(this.lowDetailGeom, false);
            this.clearUpdateHandler(this.lowDetailGeom);
        }
        this.lowDetailGeom = node;
        this.lowDetailOutput = node instanceof Cullable ? (Cullable)((Object)node) : null;
        if (this.lowDetailGeom != null) {
            this.setParent(this.lowDetailGeom, this);
            this.setLive(this.lowDetailGeom, this.alive);
            this.setUpdateHandler(this.lowDetailGeom);
        }
        this.markBoundsDirty();
    }

    public Node getLowDetail() {
        return this.lowDetailGeom;
    }

    public void setHighDetail(Node[] nodeArray, int n) throws InvalidWriteTimingException {
        int n2;
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (n < 0 || n > 8) {
            throw new IllegalArgumentException(HIGH_DETAIL_NUM_ERR);
        }
        for (n2 = 0; n2 < this.numHighDetailGeom; ++n2) {
            this.setParent(this.highDetailGeom[n2], null);
            this.setLive(this.highDetailGeom[n2], false);
            this.clearUpdateHandler(this.highDetailGeom[n2]);
        }
        for (n2 = 0; n2 < n; ++n2) {
            this.setParent(nodeArray[n2], this);
            this.setLive(nodeArray[n2], this.alive);
            this.setUpdateHandler(nodeArray[n2]);
        }
        System.arraycopy(nodeArray, 0, this.highDetailGeom, 0, n);
        this.numHighDetailGeom = n;
        for (n2 = 0; n2 < n; ++n2) {
            this.highDetailOutput[n2] = nodeArray[n2] instanceof Cullable ? (Cullable)((Object)nodeArray[n2]) : null;
        }
    }

    public int numHighDetailGeom() {
        return this.numHighDetailGeom;
    }

    public void getHighDetail(Node[] nodeArray) {
        System.arraycopy(this.highDetailGeom, 0, nodeArray, 0, this.numHighDetailGeom);
    }
}

