/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.aviatrix3d.geom.particle;

import org.j3d.aviatrix3d.PointArray;
import org.j3d.aviatrix3d.PointAttributes;
import org.j3d.geom.particle.Particle;
import org.j3d.renderer.aviatrix3d.geom.particle.AVParticleSystem;
import org.j3d.renderer.aviatrix3d.geom.particle.PointParticle;

public class PointParticleSystem
extends AVParticleSystem {
    private static final String COLOR_COMP_MSG = "The number of olor components is only allowed to be 0, 3 or 4";
    private final int numColors;
    private PointAttributes attributes;
    private int createdParticleCount;

    public PointParticleSystem(String string, int n, int n2) {
        super(string, n);
        if (n2 != 0 && n2 != 3 && n2 != 4) {
            throw new IllegalArgumentException(COLOR_COMP_MSG);
        }
        this.numColors = n2;
        this.particleGeometry = new PointArray();
        this.createdParticleCount = 0;
        this.initializeArrays();
    }

    public final int coordinatesPerParticle() {
        return 1;
    }

    public final int numColorComponents() {
        return 4;
    }

    public final int numTexCoordComponents() {
        return 0;
    }

    public Particle createParticle() {
        ++this.createdParticleCount;
        return new PointParticle(this.vertices, this.colors, this.numColors == 4);
    }

    public void onRemove() {
    }

    public void updateNodeBoundsChanges(Object object) {
        ((PointArray)this.particleGeometry).setVertices(3, this.vertices, this.particleCount);
    }

    public void updateNodeDataChanges(Object object) {
        switch (this.numColors) {
            case 3: {
                ((PointArray)this.particleGeometry).setColors(false, this.colors);
                break;
            }
            case 4: {
                ((PointArray)this.particleGeometry).setColors(true, this.colors);
            }
        }
    }

    public PointAttributes getRecommendedAttributes() {
        if (this.attributes == null) {
            this.attributes = new PointAttributes();
            this.attributes.setPointSize(10.0f);
            this.attributes.setAntiAliased(true);
        }
        return this.attributes;
    }
}

