/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.aviatrix3d.geom.hanim;

import org.j3d.renderer.aviatrix3d.geom.hanim.SoftwareHumanoid;

class SoftwareSpaceHumanoid
extends SoftwareHumanoid {
    SoftwareSpaceHumanoid() {
    }

    public void setSkinCoord(float[] fArray, int n) {
        super.setSkinCoord(fArray, n);
        this.outputCoords = this.coordsBuffer;
    }

    public void setSkinNormal(float[] fArray, int n) {
        super.setSkinNormal(fArray, n);
        this.outputNormals = this.normalsBuffer;
    }

    public void updateSkeleton() {
        if (this.outputCoords == null) {
            return;
        }
        boolean bl = this.skeletonChanged;
        if (bl) {
            int n;
            int n2;
            if (this.numSkinCoords != 0) {
                n2 = this.numSkinCoords / 3;
                for (n = 0; n < n2; ++n) {
                    if (!this.dirtyCoordinates[n]) continue;
                    this.coordsBuffer.put(n * 3, 0.0f);
                    this.coordsBuffer.put(n * 3 + 1, 0.0f);
                    this.coordsBuffer.put(n * 3 + 2, 0.0f);
                }
            }
            if (this.numSkinNormals != 0) {
                n2 = this.numSkinNormals / 3;
                for (n = 0; n < n2; ++n) {
                    if (!this.dirtyCoordinates[n]) continue;
                    this.normalsBuffer.put(n * 3, 0.0f);
                    this.normalsBuffer.put(n * 3 + 1, 0.0f);
                    this.normalsBuffer.put(n * 3 + 2, 0.0f);
                }
            }
        }
        super.updateSkeleton();
        if (bl) {
            if (this.numSkinCoords != 0 && this.vertexGeometry.size() != 0) {
                if (this.coordsArray == null || this.coordsArray.length < this.numSkinCoords) {
                    this.coordsArray = new float[this.numSkinCoords];
                }
                this.coordsBuffer.rewind();
                this.coordsBuffer.get(this.coordsArray, 0, this.numSkinCoords);
            }
            if (this.numSkinNormals != 0 && this.vertexGeometry.size() != 0) {
                if (this.normalsArray == null || this.normalsArray.length < this.numSkinNormals) {
                    this.normalsArray = new float[this.numSkinNormals];
                }
                this.normalsBuffer.rewind();
                this.normalsBuffer.get(this.normalsArray, 0, this.numSkinNormals);
            }
        }
    }

    public Object getUpdatedSkinCoords() {
        return this.coordsBuffer;
    }

    public Object getUpdatedSkinNormals() {
        return this.normalsBuffer;
    }
}

