/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.aviatrix3d.geom.hanim;

import java.util.ArrayList;
import org.j3d.aviatrix3d.Appearance;
import org.j3d.aviatrix3d.Geometry;
import org.j3d.aviatrix3d.Group;
import org.j3d.aviatrix3d.Node;
import org.j3d.aviatrix3d.NodeUpdateListener;
import org.j3d.aviatrix3d.ShaderArguments;
import org.j3d.aviatrix3d.Shape3D;
import org.j3d.aviatrix3d.SharedNode;
import org.j3d.aviatrix3d.VertexGeometry;
import org.j3d.geom.hanim.HAnimObject;
import org.j3d.renderer.aviatrix3d.geom.hanim.AVHumanoid;
import org.j3d.renderer.aviatrix3d.geom.hanim.HAnimShader;
import org.j3d.renderer.aviatrix3d.geom.hanim.ShaderJoint;
import org.j3d.renderer.aviatrix3d.geom.hanim.ShaderObjectParent;
import org.j3d.renderer.aviatrix3d.nodes.BufferGeometry;
import org.j3d.util.ErrorReporter;

class ShaderHumanoid
extends AVHumanoid
implements NodeUpdateListener,
ShaderObjectParent {
    private ShaderArguments shaderArgs;
    private HAnimShader completeShader;
    private float[] vertexWeights;
    private float[] vertexMatrixIndices;
    private float[] vertexBoneCount;
    private float[] boneMatrices;
    private Group skinGroup;
    private ArrayList bufferGeometry = new ArrayList();
    private ArrayList vertexGeometry = new ArrayList();
    private Node[] skin;
    private int numSkin;
    private ArrayList updatedChildAttribList = new ArrayList();

    ShaderHumanoid() {
        this.skinGroup = new Group();
        this.addNode(this.skinGroup);
        this.completeShader = new HAnimShader();
        this.shaderArgs = this.completeShader.getShaderArguments();
    }

    public void updateNodeBoundsChanges(Object object) {
        if (object == this.skinGroup) {
            this.skinGroup.removeAllChildren();
            for (int i = 0; i < this.numSkin; ++i) {
                this.skinGroup.addChild(this.skin[i]);
            }
        } else {
            super.updateNodeBoundsChanges(object);
        }
    }

    public void updateNodeDataChanges(Object object) {
        if (object instanceof VertexGeometry) {
            this.setAttributes((VertexGeometry)object);
        } else if (object instanceof BufferGeometry) {
            this.setAttributes((BufferGeometry)object);
        } else {
            super.updateNodeDataChanges(object);
        }
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        super.setErrorReporter(errorReporter);
        this.completeShader.setErrorReporter(errorReporter);
    }

    public void setSkinCoord(float[] fArray, int n) {
        super.setSkinCoord(fArray, n);
        if (this.vertexWeights == null || this.vertexWeights.length < n * 4) {
            this.vertexWeights = new float[n * 4];
            this.vertexMatrixIndices = new float[n * 4];
            this.vertexBoneCount = new float[n];
        }
        this.updateAttributes();
    }

    public void setSkeleton(HAnimObject[] hAnimObjectArray, int n) {
        super.setSkeleton(hAnimObjectArray, n);
        this.updateAttributes();
    }

    public void updateSkeleton() {
        int n;
        boolean bl;
        boolean bl2 = bl = this.skeletonChanged || this.matrixChanged;
        if (this.boneMatrices == null || this.boneMatrices.length < this.objectCount * 16) {
            this.boneMatrices = new float[this.objectCount * 16];
            bl = true;
        }
        super.updateSkeleton();
        if (bl) {
            for (n = 0; n < this.numSkeleton; ++n) {
                if (!(this.skeleton[n] instanceof ShaderJoint)) continue;
                ((ShaderJoint)this.skeleton[n]).updateMatrices(this.boneMatrices);
            }
            this.shaderArgs.setUniformMatrix("boneMatrix", 4, this.boneMatrices, this.objectCount, true);
        }
        if ((n = this.updatedChildAttribList.size()) != 0) {
            int n2;
            for (n2 = 0; n2 < n; ++n2) {
                ShaderJoint shaderJoint = (ShaderJoint)this.updatedChildAttribList.get(n2);
                shaderJoint.updateAttributes(this.vertexWeights, this.vertexMatrixIndices, this.vertexBoneCount, false);
            }
            this.updatedChildAttribList.clear();
            n = this.vertexGeometry.size();
            for (n2 = 0; n2 < n; ++n2) {
                ((VertexGeometry)this.vertexGeometry.get(n2)).dataChanged(this);
            }
            n = this.bufferGeometry.size();
            for (n2 = 0; n2 < n; ++n2) {
                ((BufferGeometry)this.bufferGeometry.get(n2)).dataChanged(this);
            }
        }
    }

    public void setSkin(Node[] nodeArray, int n) {
        int n2;
        this.bufferGeometry.clear();
        this.vertexGeometry.clear();
        int n3 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            int n4 = 0;
            if (nodeArray[n2] instanceof Shape3D) {
                n4 = this.updateShader((Shape3D)nodeArray[n2]);
            } else if (nodeArray[n2] instanceof Group) {
                n4 = this.descendGroup((Group)nodeArray[n2]);
            } else if (nodeArray[n2] instanceof SharedNode) {
                Node node = ((SharedNode)nodeArray[n2]).getChild();
                while (node instanceof SharedNode) {
                    node = ((SharedNode)node).getChild();
                }
                if (node instanceof Shape3D) {
                    n4 = this.updateShader((Shape3D)node);
                } else if (node instanceof Group) {
                    n4 = this.descendGroup((Group)node);
                }
            }
            if (n3 >= n4) continue;
            n3 = n4;
        }
        this.completeShader.setMaxTextureUnits(n3);
        if (this.skinGroup.isLive()) {
            this.skinGroup.boundsChanged(this);
        } else {
            for (n2 = 0; n2 < n; ++n2) {
                this.skinGroup.addChild(nodeArray[n2]);
            }
        }
    }

    public void childAttributesChanged(HAnimObject hAnimObject) {
        if (!this.updatedChildAttribList.contains(hAnimObject)) {
            this.updatedChildAttribList.add(hAnimObject);
        }
    }

    private void updateAttributes() {
        int n;
        for (n = 0; n < this.numSkinCoords / 3; ++n) {
            this.vertexBoneCount[n] = 0.0f;
        }
        for (n = 0; n < this.numSkeleton; ++n) {
            if (!(this.skeleton[n] instanceof ShaderJoint)) continue;
            ((ShaderJoint)this.skeleton[n]).updateAttributes(this.vertexWeights, this.vertexMatrixIndices, this.vertexBoneCount, true);
        }
        this.updatedChildAttribList.clear();
        n = this.vertexGeometry.size();
        for (int i = 0; i < n; ++i) {
            VertexGeometry vertexGeometry = (VertexGeometry)this.vertexGeometry.get(i);
            if (vertexGeometry.isLive()) {
                vertexGeometry.dataChanged(this);
                continue;
            }
            this.setAttributes(vertexGeometry);
        }
    }

    private int descendGroup(Group group) {
        int n = group.numChildren();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Node node = group.getChild(i);
            int n3 = 0;
            if (node instanceof Shape3D) {
                n3 = this.updateShader((Shape3D)node);
            } else if (node instanceof Group) {
                n3 = this.descendGroup((Group)node);
            } else if (node instanceof SharedNode) {
                Node node2 = ((SharedNode)node).getChild();
                while (node2 instanceof SharedNode) {
                    node2 = ((SharedNode)node2).getChild();
                }
                if (node2 instanceof Shape3D) {
                    n3 = this.updateShader((Shape3D)node2);
                } else if (node2 instanceof Group) {
                    n3 = this.descendGroup((Group)node2);
                }
            }
            if (n2 >= n3) continue;
            n2 = n3;
        }
        return n2;
    }

    private int updateShader(Shape3D shape3D) {
        int n = 0;
        Appearance appearance = shape3D.getAppearance();
        Geometry geometry = shape3D.getGeometry();
        if (geometry instanceof BufferGeometry) {
            this.bufferGeometry.add(geometry);
        } else if (geometry instanceof VertexGeometry) {
            this.vertexGeometry.add(geometry);
        }
        if (appearance == null) {
            appearance = new Appearance();
            shape3D.setAppearance(appearance);
        } else {
            n = appearance.numTextureUnits();
        }
        appearance.setShader(this.completeShader);
        if (geometry != null) {
            if (geometry.isLive()) {
                geometry.dataChanged(this);
            } else {
                this.setAttributes(geometry);
            }
        }
        return n;
    }

    private void setAttributes(Geometry geometry) {
        if (geometry instanceof VertexGeometry) {
            System.out.println("Setting attributes");
            VertexGeometry vertexGeometry = (VertexGeometry)geometry;
            vertexGeometry.setAttributes(6, 4, this.vertexWeights, false);
            vertexGeometry.setAttributes(7, 4, this.vertexMatrixIndices, false);
        }
    }
}

