/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.aviatrix3d.geom.hanim;

import java.util.ArrayList;
import javax.vecmath.Matrix4f;
import org.j3d.aviatrix3d.Node;
import org.j3d.aviatrix3d.NodeUpdateListener;
import org.j3d.aviatrix3d.TransformGroup;
import org.j3d.geom.hanim.HAnimSite;
import org.j3d.renderer.aviatrix3d.geom.hanim.AVHumanoidPart;

class AVSite
extends HAnimSite
implements AVHumanoidPart,
NodeUpdateListener {
    private static final String NODE_CHILD_ERR = "Child must be an Aviatrix3D Node instance";
    private TransformGroup transform = new TransformGroup();
    private ArrayList removedChildren;
    private ArrayList addedChildren;

    AVSite() {
    }

    public Node getSceneGraphObject() {
        return this.transform;
    }

    public void updateNodeBoundsChanges(Object object) {
        int n;
        this.transform.setTransform(this.localMatrix);
        if (this.removedChildren != null) {
            for (n = 0; n < this.removedChildren.size(); ++n) {
                this.transform.removeChild((Node)this.removedChildren.get(n));
            }
            this.removedChildren.clear();
            this.removedChildren = null;
        }
        if (this.addedChildren != null) {
            for (n = 0; n < this.addedChildren.size(); ++n) {
                this.transform.addChild((Node)this.addedChildren.get(n));
            }
            this.addedChildren.clear();
            this.addedChildren = null;
        }
    }

    public void updateNodeDataChanges(Object object) {
    }

    public void setChildren(Object[] objectArray, int n) {
        if (this.transform.isLive()) {
            int n2;
            if (this.addedChildren == null) {
                this.addedChildren = new ArrayList();
            }
            for (n2 = 0; n2 < n; ++n2) {
                if (!(objectArray[n2] instanceof Node)) {
                    throw new IllegalArgumentException(NODE_CHILD_ERR);
                }
                this.addedChildren.add(objectArray[n2]);
            }
            if (this.removedChildren == null) {
                this.removedChildren = new ArrayList();
            }
            for (n2 = 0; n2 < this.numChildren; ++n2) {
                this.removedChildren.add(this.children[n2]);
            }
            this.transform.boundsChanged(this);
        } else {
            this.transform.removeAllChildren();
            for (int i = 0; i < n; ++i) {
                if (!(objectArray[i] instanceof Node)) {
                    throw new IllegalArgumentException(NODE_CHILD_ERR);
                }
                this.transform.addChild((Node)objectArray[i]);
            }
        }
        super.setChildren(objectArray, n);
    }

    public void addChild(Object object) {
        if (!(object instanceof Node)) {
            throw new IllegalArgumentException(NODE_CHILD_ERR);
        }
        super.addChild(object);
        if (this.transform.isLive()) {
            if (this.addedChildren == null) {
                this.addedChildren = new ArrayList();
            }
            this.addedChildren.add(object);
            this.transform.boundsChanged(this);
        } else {
            this.transform.addChild((Node)object);
        }
    }

    public void removeChild(Object object) {
        for (int i = 0; i < this.numChildren; ++i) {
            if (this.children[i] != object) continue;
            if (this.transform.isLive()) {
                if (this.removedChildren == null) {
                    this.removedChildren = new ArrayList();
                }
                this.removedChildren.add(object);
                this.transform.boundsChanged(this);
                break;
            }
            this.transform.removeChild((Node)object);
            break;
        }
        super.removeChild(object);
    }

    protected void updateLocation(Matrix4f matrix4f, boolean bl) {
        if (this.matrixChanged) {
            this.transform.boundsChanged(this);
        }
        super.updateLocation(matrix4f, bl);
    }
}

